/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.tags;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.guava.GuavaModule;
import com.fasterxml.jackson.datatype.joda.JodaModule;
import com.urbanairship.api.client.Request;
import com.urbanairship.api.client.RequestUtils;
import com.urbanairship.api.client.ResponseParser;
import com.urbanairship.api.tags.model.TagListListingResponse;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.entity.ContentType;

public class TagListListingRequest
implements Request<TagListListingResponse> {
    private static final String TAG_LISTS_PATH = "/api/tag-lists";
    private static final ObjectMapper mapper = new ObjectMapper();

    private TagListListingRequest() {
    }

    public static TagListListingRequest newRequest() {
        return new TagListListingRequest();
    }

    @Override
    public ContentType getContentType() {
        return null;
    }

    @Override
    public Map<String, String> getRequestHeaders() {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/vnd.urbanairship+json; version=3");
        return headers;
    }

    @Override
    public Request.HttpMethod getHttpMethod() {
        return Request.HttpMethod.GET;
    }

    @Override
    public String getRequestBody() {
        return null;
    }

    @Override
    public URI getUri(URI baseUri) {
        return RequestUtils.resolveURI(baseUri, TAG_LISTS_PATH);
    }

    @Override
    public ResponseParser<TagListListingResponse> getResponseParser() {
        return response -> (TagListListingResponse)mapper.readValue(response, TagListListingResponse.class);
    }

    @Override
    public boolean bearerTokenAuthRequired() {
        return false;
    }

    @Override
    public boolean canUseBearerTokenAuth() {
        return true;
    }

    static {
        mapper.registerModule((Module)new JodaModule());
        mapper.registerModule((Module)new GuavaModule());
    }
}

