/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.subscriptionlists;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.guava.GuavaModule;
import com.urbanairship.api.client.Request;
import com.urbanairship.api.client.RequestUtils;
import com.urbanairship.api.client.ResponseParser;
import com.urbanairship.api.subscriptionlists.model.SubscriptionListListingResponse;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.entity.ContentType;

public class SubscriptionListListingRequest
implements Request<SubscriptionListListingResponse> {
    private static final String API_SUBSCRIPTION_LISTS_PATH = "/api/subscription_lists/";
    private final String path;
    private static final ObjectMapper MAPPER = new ObjectMapper();

    private SubscriptionListListingRequest(String path) {
        this.path = path;
    }

    public static SubscriptionListListingRequest newRequest() {
        return new SubscriptionListListingRequest(API_SUBSCRIPTION_LISTS_PATH);
    }

    @Override
    public ContentType getContentType() {
        return ContentType.APPLICATION_JSON;
    }

    @Override
    public Map<String, String> getRequestHeaders() {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/json");
        headers.put("Accept", "application/vnd.urbanairship+json; version=3");
        return headers;
    }

    @Override
    public Request.HttpMethod getHttpMethod() {
        return Request.HttpMethod.GET;
    }

    @Override
    public String getRequestBody() {
        return null;
    }

    @Override
    public URI getUri(URI baseUri) {
        return RequestUtils.resolveURI(baseUri, this.path);
    }

    @Override
    public ResponseParser<SubscriptionListListingResponse> getResponseParser() {
        return response -> (SubscriptionListListingResponse)MAPPER.readValue(response, SubscriptionListListingResponse.class);
    }

    @Override
    public boolean bearerTokenAuthRequired() {
        return false;
    }

    @Override
    public boolean canUseBearerTokenAuth() {
        return true;
    }

    static {
        MAPPER.registerModule((Module)new GuavaModule());
    }
}

