/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.staticlists;

import com.google.common.base.Preconditions;
import com.opencsv.CSVWriter;
import com.urbanairship.api.client.Request;
import com.urbanairship.api.client.RequestUtils;
import com.urbanairship.api.client.ResponseParser;
import com.urbanairship.api.staticlists.LifecycleListType;
import java.io.FileOutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang.StringUtils;
import org.apache.http.entity.ContentType;

public class StaticListDownloadRequest
implements Request<String> {
    private static final String API_LISTS_PATH = "/api/lists/";
    private final String path;
    private Optional<FileOutputStream> fileOutputStream = Optional.empty();

    private StaticListDownloadRequest(String name) {
        this.path = API_LISTS_PATH + name + "/csv";
    }

    public static StaticListDownloadRequest newRequest(String name) {
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((String)name), (Object)"List name cannot be empty.");
        return new StaticListDownloadRequest(name);
    }

    public static StaticListDownloadRequest newRequest(LifecycleListType type) {
        return new StaticListDownloadRequest(type.getType());
    }

    public StaticListDownloadRequest setOutputStream(FileOutputStream fileOutputStream) {
        this.fileOutputStream = Optional.of(fileOutputStream);
        return this;
    }

    @Override
    public ContentType getContentType() {
        return null;
    }

    @Override
    public Map<String, String> getRequestHeaders() {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/vnd.urbanairship+csv; version=3");
        return headers;
    }

    @Override
    public Request.HttpMethod getHttpMethod() {
        return Request.HttpMethod.GET;
    }

    @Override
    public String getRequestBody() {
        return null;
    }

    @Override
    public URI getUri(URI baseUri) {
        return RequestUtils.resolveURI(baseUri, this.path);
    }

    @Override
    public ResponseParser<String> getResponseParser() {
        return response -> {
            if (this.fileOutputStream.isPresent()) {
                try (OutputStreamWriter stream = new OutputStreamWriter(this.fileOutputStream.get());
                     CSVWriter writer = new CSVWriter((Writer)stream, ',', '\u0000', '\u0000', "\n");){
                    String[] rows;
                    for (String row : rows = response.split("\n")) {
                        writer.writeNext(row.split(","));
                    }
                }
                finally {
                    this.fileOutputStream.get().close();
                }
            }
            return response;
        };
    }

    @Override
    public boolean bearerTokenAuthRequired() {
        return false;
    }

    @Override
    public boolean canUseBearerTokenAuth() {
        return true;
    }
}

