/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.segments.model;

import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import com.urbanairship.api.common.model.ErrorDetails;
import com.urbanairship.api.segments.model.SegmentListingView;
import java.util.Optional;

public class SegmentListingResponse {
    private final Optional<String> nextPage;
    private final ImmutableList<SegmentListingView> segmentListingViews;
    private final Optional<Boolean> ok;
    private final Optional<String> error;
    private final Optional<ErrorDetails> errorDetails;

    private SegmentListingResponse(String nextPage, ImmutableList<SegmentListingView> segmentListingViews, Boolean ok, String error, ErrorDetails errorDetails) {
        this.nextPage = Optional.ofNullable(nextPage);
        this.segmentListingViews = segmentListingViews;
        this.ok = Optional.ofNullable(ok);
        this.error = Optional.ofNullable(error);
        this.errorDetails = Optional.ofNullable(errorDetails);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Optional<String> getNextPage() {
        return this.nextPage;
    }

    public ImmutableList<SegmentListingView> getSegmentListingViews() {
        return this.segmentListingViews;
    }

    public Optional<Boolean> getOk() {
        return this.ok;
    }

    public Optional<String> getError() {
        return this.error;
    }

    public Optional<ErrorDetails> getErrorDetails() {
        return this.errorDetails;
    }

    public String toString() {
        return "SegmentListingResponse{nextPage=" + this.nextPage + ", segments=" + this.segmentListingViews + ", ok=" + this.ok + ", error=" + this.error + ", errorDetails=" + this.errorDetails + "}";
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.nextPage, this.segmentListingViews, this.ok, this.error, this.errorDetails});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        SegmentListingResponse other = (SegmentListingResponse)obj;
        return Objects.equal(this.nextPage, other.nextPage) && Objects.equal(this.segmentListingViews, other.segmentListingViews) && Objects.equal(this.ok, other.ok) && Objects.equal(this.error, other.error) && Objects.equal(this.errorDetails, other.errorDetails);
    }

    public static final class Builder {
        private String nextPage = null;
        private ImmutableList.Builder<SegmentListingView> segmentObjects = ImmutableList.builder();
        private boolean ok = true;
        private String error;
        private ErrorDetails errorDetails;

        private Builder() {
        }

        public Builder setNextPage(String nextPage) {
            this.nextPage = nextPage;
            return this;
        }

        public Builder addSegmentObject(SegmentListingView value) {
            this.segmentObjects.add((Object)value);
            return this;
        }

        public Builder addAllSegmentObjects(Iterable<? extends SegmentListingView> value) {
            this.segmentObjects.addAll(value);
            return this;
        }

        public Builder setOk(boolean value) {
            this.ok = value;
            return this;
        }

        public Builder setError(String error) {
            this.error = error;
            return this;
        }

        public Builder setErrorDetails(ErrorDetails errorDetails) {
            this.errorDetails = errorDetails;
            return this;
        }

        public SegmentListingResponse build() {
            return new SegmentListingResponse(this.nextPage, this.segmentObjects.build(), this.ok, this.error, this.errorDetails);
        }
    }
}

