/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.schedule.model;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.urbanairship.api.common.model.ErrorDetails;
import com.urbanairship.api.schedule.model.SchedulePayloadResponse;
import java.util.Optional;

public final class ScheduleResponse {
    private final boolean ok;
    private final String operationId;
    private final ImmutableList<String> scheduleUrls;
    private final ImmutableList<String> scheduleIds;
    private final ImmutableList<SchedulePayloadResponse> schedulePayloadResponses;
    private final Optional<String> error;
    private final Optional<ErrorDetails> errorDetails;

    private ScheduleResponse(boolean ok, String operationId, ImmutableList<String> scheduleUrls, ImmutableList<String> scheduleIds, ImmutableList<SchedulePayloadResponse> schedulePayloadResponses, String error, ErrorDetails errorDetails) {
        this.ok = ok;
        this.operationId = operationId;
        this.scheduleUrls = scheduleUrls;
        this.scheduleIds = scheduleIds;
        this.schedulePayloadResponses = schedulePayloadResponses;
        this.error = Optional.ofNullable(error);
        this.errorDetails = Optional.ofNullable(errorDetails);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public boolean getOk() {
        return this.ok;
    }

    public String getOperationId() {
        return this.operationId;
    }

    public ImmutableList<String> getScheduleUrls() {
        return this.scheduleUrls;
    }

    public ImmutableList<String> getScheduleIds() {
        return this.scheduleIds;
    }

    public ImmutableList<SchedulePayloadResponse> getSchedulePayloadResponses() {
        return this.schedulePayloadResponses;
    }

    public Optional<String> getError() {
        return this.error;
    }

    public Optional<ErrorDetails> getErrorDetails() {
        return this.errorDetails;
    }

    public String toString() {
        return "ScheduleResponse{ok=" + this.ok + ", operationId='" + this.operationId + '\'' + ", scheduleUrls=" + this.scheduleUrls + ", scheduleIds=" + this.scheduleIds + ", schedulePayloadResponses=" + this.schedulePayloadResponses + ", error=" + this.error + ", errorDetails=" + this.errorDetails + '}';
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.ok, this.operationId, this.scheduleUrls, this.scheduleIds, this.schedulePayloadResponses, this.error, this.errorDetails});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ScheduleResponse other = (ScheduleResponse)obj;
        return Objects.equal((Object)this.ok, (Object)other.ok) && Objects.equal((Object)this.operationId, (Object)other.operationId) && Objects.equal(this.scheduleUrls, other.scheduleUrls) && Objects.equal(this.scheduleIds, other.scheduleIds) && Objects.equal(this.schedulePayloadResponses, other.schedulePayloadResponses) && Objects.equal(this.error, other.error) && Objects.equal(this.errorDetails, other.errorDetails);
    }

    public static class Builder {
        private boolean ok;
        private String operationId;
        private ImmutableList.Builder<String> scheduleUrls = ImmutableList.builder();
        private ImmutableList.Builder<String> scheduleIds = ImmutableList.builder();
        private ImmutableList.Builder<SchedulePayloadResponse> schedulePayloads = ImmutableList.builder();
        private String error;
        private ErrorDetails errorDetails;

        private Builder() {
        }

        public Builder setOk(boolean ok) {
            this.ok = ok;
            return this;
        }

        public Builder setOperationId(String operationId) {
            this.operationId = operationId;
            return this;
        }

        public Builder addScheduleUrl(String scheduleurl) {
            this.scheduleUrls.add((Object)scheduleurl);
            return this;
        }

        public Builder addAllScheduleUrls(Iterable<? extends String> scheduleUrls) {
            this.scheduleUrls.addAll(scheduleUrls);
            return this;
        }

        public Builder addScheduleId(String scheduleId) {
            this.scheduleIds.add((Object)scheduleId);
            return this;
        }

        public Builder addAllScheduleIds(Iterable<? extends String> scheduleIds) {
            this.scheduleIds.addAll(scheduleIds);
            return this;
        }

        public Builder addSchedulePayload(SchedulePayloadResponse schedulePayloadResponse) {
            this.schedulePayloads.add((Object)schedulePayloadResponse);
            return this;
        }

        public Builder addAllSchedulePayload(Iterable<? extends SchedulePayloadResponse> schedulePayloads) {
            this.schedulePayloads.addAll(schedulePayloads);
            return this;
        }

        public Builder setError(String error) {
            this.error = error;
            return this;
        }

        public Builder setErrorDetails(ErrorDetails errorDetails) {
            this.errorDetails = errorDetails;
            return this;
        }

        public ScheduleResponse build() {
            Preconditions.checkNotNull((Object)this.ok, (Object)"The ok attribute must be set in order to build ScheduleResponse");
            Preconditions.checkNotNull((Object)this.operationId, (Object)"Operation ID must be set in order to build ScheduleResponse");
            return new ScheduleResponse(this.ok, this.operationId, this.scheduleUrls.build(), this.scheduleIds.build(), this.schedulePayloads.build(), this.error, this.errorDetails);
        }
    }
}

