/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.reports.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import com.urbanairship.api.common.parse.DateFormats;
import com.urbanairship.api.reports.model.Precision;
import com.urbanairship.api.reports.model.WebCounts;
import java.util.Objects;
import org.joda.time.DateTime;

public class WebResponseReportResponse {
    private final boolean ok;
    private final String appKey;
    private final DateTime end;
    private final Precision precision;
    private final DateTime start;
    private final ImmutableList<WebCounts> webTotalCounts;
    private final String error;
    private final Integer errorCode;

    public WebResponseReportResponse(@JsonProperty(value="ok") boolean ok, @JsonProperty(value="app_key") String appKey, @JsonProperty(value="end") String endString, @JsonProperty(value="precision") Precision precision, @JsonProperty(value="start") String startString, @JsonProperty(value="total_counts") ImmutableList<WebCounts> webTotalCounts, @JsonProperty(value="error") String error, @JsonProperty(value="error_code") Integer errorCode) {
        this.ok = ok;
        this.appKey = appKey;
        this.end = DateFormats.DATE_PARSER.parseDateTime(endString);
        this.precision = precision;
        this.start = DateFormats.DATE_PARSER.parseDateTime(startString);
        this.webTotalCounts = webTotalCounts;
        this.error = error;
        this.errorCode = errorCode;
    }

    public boolean isOk() {
        return this.ok;
    }

    public String getAppKey() {
        return this.appKey;
    }

    public DateTime getEnd() {
        return this.end;
    }

    public Precision getPrecision() {
        return this.precision;
    }

    public DateTime getStart() {
        return this.start;
    }

    public ImmutableList<WebCounts> getWebTotalCounts() {
        return this.webTotalCounts;
    }

    public String getError() {
        return this.error;
    }

    public Integer getErrorCode() {
        return this.errorCode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WebResponseReportResponse that = (WebResponseReportResponse)o;
        return this.ok == that.ok && Objects.equals(this.appKey, that.appKey) && Objects.equals(this.end, that.end) && this.precision == that.precision && Objects.equals(this.start, that.start) && Objects.equals(this.webTotalCounts, that.webTotalCounts) && Objects.equals(this.error, that.error) && Objects.equals(this.errorCode, that.errorCode);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.ok, this.appKey, this.end, this.precision, this.start, this.webTotalCounts, this.error, this.errorCode});
    }

    public String toString() {
        return "WebResponseReportResponse{ok=" + this.ok + ", appKey='" + this.appKey + '\'' + ", end='" + this.end + '\'' + ", precision=" + (Object)((Object)this.precision) + ", start='" + this.start + '\'' + ", webTotalCounts=" + this.webTotalCounts + ", error='" + this.error + '\'' + ", errorCode=" + this.errorCode + '}';
    }
}

