/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.reports.model;

import com.google.common.collect.ImmutableMap;
import com.urbanairship.api.reports.model.DeviceStats;
import java.util.Objects;
import java.util.Optional;
import org.joda.time.DateTime;

public final class ResponseReportResponse {
    private Optional<DateTime> date;
    private Optional<ImmutableMap<String, DeviceStats>> deviceStatsMap;

    private ResponseReportResponse() {
        this(null, null);
    }

    private ResponseReportResponse(Optional<DateTime> date, Optional<ImmutableMap<String, DeviceStats>> deviceStatsMap) {
        this.date = date;
        this.deviceStatsMap = deviceStatsMap;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResponseReportResponse that = (ResponseReportResponse)o;
        return Objects.equals(this.date, that.date) && Objects.equals(this.deviceStatsMap, that.deviceStatsMap);
    }

    public int hashCode() {
        return Objects.hash(this.date, this.deviceStatsMap);
    }

    public String toString() {
        return "ResponseReportResponse{date=" + this.date + ", deviceStatsMap=" + this.deviceStatsMap + '}';
    }

    public Optional<DateTime> getDate() {
        return this.date;
    }

    public Optional<ImmutableMap<String, DeviceStats>> getDeviceStatsMap() {
        return this.deviceStatsMap;
    }

    public static class Builder {
        private DateTime date = null;
        private ImmutableMap.Builder<String, DeviceStats> deviceStatsMap = ImmutableMap.builder();

        private Builder() {
        }

        public Builder setDate(DateTime date) {
            this.date = date;
            return this;
        }

        public Builder addDeviceStatsMapping(String value, DeviceStats object) {
            this.deviceStatsMap.put((Object)value, (Object)object);
            return this;
        }

        public ResponseReportResponse build() {
            return new ResponseReportResponse(Optional.ofNullable(this.date), Optional.ofNullable(this.deviceStatsMap.build()));
        }
    }
}

