/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.reports.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableMap;
import com.urbanairship.api.common.parse.DateFormats;
import com.urbanairship.api.reports.model.ExperimentVariantStats;
import java.util.Objects;
import org.joda.time.DateTime;

public class ExperimentVariantReportResponse {
    private final boolean ok;
    private final String appKey;
    private final String experimentId;
    private final String pushId;
    private final DateTime created;
    private final Integer variant;
    private final String variantName;
    private final Integer sends;
    private final Integer directResponses;
    private final Integer influencedResponses;
    private final ImmutableMap<String, ExperimentVariantStats> experimentVariantStats;
    private final String error;
    private final Integer errorCode;

    public ExperimentVariantReportResponse(@JsonProperty(value="ok") boolean ok, @JsonProperty(value="app_key") String appKey, @JsonProperty(value="experiment_id") String experimentId, @JsonProperty(value="push_id") String pushId, @JsonProperty(value="created") String createdString, @JsonProperty(value="variant") Integer variant, @JsonProperty(value="variant_name") String variantName, @JsonProperty(value="sends") Integer sends, @JsonProperty(value="direct_responses") Integer directResponses, @JsonProperty(value="influenced_responses") Integer influencedResponses, @JsonProperty(value="platforms") ImmutableMap<String, ExperimentVariantStats> experimentVariantStats, @JsonProperty(value="error") String error, @JsonProperty(value="error_code") Integer errorCode) {
        this.ok = ok;
        this.appKey = appKey;
        this.experimentId = experimentId;
        this.pushId = pushId;
        this.created = DateFormats.DATE_PARSER.parseDateTime(createdString);
        this.variant = variant;
        this.variantName = variantName;
        this.sends = sends;
        this.directResponses = directResponses;
        this.influencedResponses = influencedResponses;
        this.experimentVariantStats = experimentVariantStats;
        this.error = error;
        this.errorCode = errorCode;
    }

    public boolean getOk() {
        return this.ok;
    }

    public String getAppKey() {
        return this.appKey;
    }

    public String getExperimentId() {
        return this.experimentId;
    }

    public String getPushId() {
        return this.pushId;
    }

    public DateTime getCreated() {
        return this.created;
    }

    public Integer getVariant() {
        return this.variant;
    }

    public String getVariantName() {
        return this.variantName;
    }

    public Integer getSends() {
        return this.sends;
    }

    public Integer getDirectResponses() {
        return this.directResponses;
    }

    public Integer getInfluencedResponses() {
        return this.influencedResponses;
    }

    public ImmutableMap<String, ExperimentVariantStats> getVariantPlatforms() {
        return this.experimentVariantStats;
    }

    public String getError() {
        return this.error;
    }

    public Integer getErrorCode() {
        return this.errorCode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExperimentVariantReportResponse that = (ExperimentVariantReportResponse)o;
        return this.ok == that.ok && Objects.equals(this.appKey, that.appKey) && Objects.equals(this.experimentId, that.experimentId) && Objects.equals(this.pushId, that.pushId) && Objects.equals(this.created, that.created) && Objects.equals(this.variant, that.variant) && Objects.equals(this.variantName, that.variantName) && Objects.equals(this.sends, that.sends) && Objects.equals(this.directResponses, that.directResponses) && Objects.equals(this.influencedResponses, that.influencedResponses) && Objects.equals(this.experimentVariantStats, that.experimentVariantStats) && Objects.equals(this.error, that.error) && Objects.equals(this.errorCode, that.errorCode);
    }

    public int hashCode() {
        return Objects.hash(this.ok, this.appKey, this.experimentId, this.pushId, this.created, this.variant, this.variantName, this.sends, this.directResponses, this.influencedResponses, this.experimentVariantStats, this.error, this.errorCode);
    }

    public String toString() {
        return "ExperimentVariantReportResponse{appKey=" + this.appKey + ", experimentId=" + this.experimentId + ", pushId=" + this.pushId + ", created=" + this.created + ", variant=" + this.variant + ", variantName=" + this.variantName + ", sends=" + this.sends + ", directResponses=" + this.directResponses + ", influencedResponses=" + this.influencedResponses + ", experimentVariantStats=" + this.experimentVariantStats + ", error=" + this.error + ", errorCode=" + this.errorCode + '}';
    }
}

