/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.push.model.notification.richpush;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.google.common.base.Objects;
import com.urbanairship.api.push.model.PushModelObject;
import java.util.Optional;

@JsonDeserialize(builder=Builder.class)
public class RichPushFields
extends PushModelObject {
    private final Optional<String> body;
    private final Optional<String> title;

    private RichPushFields(Builder builder) {
        this.body = Optional.ofNullable(builder.body);
        this.title = Optional.ofNullable(builder.title);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @JsonProperty(value="body")
    public Optional<String> getBody() {
        return this.body;
    }

    @JsonProperty(value="title")
    public Optional<String> getTitle() {
        return this.title;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RichPushFields that = (RichPushFields)o;
        return Objects.equal(this.body, that.body) && Objects.equal(this.title, that.title);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.body, this.title});
    }

    public String toString() {
        return "RichPushFields{body=" + this.body + ", title=" + this.title + '}';
    }

    @JsonPOJOBuilder(withPrefix="set")
    public static class Builder {
        String body = null;
        String title = null;

        public Builder setBody(String body) {
            this.body = body;
            return this;
        }

        public Builder setTitle(String title) {
            this.title = title;
            return this;
        }

        public RichPushFields build() {
            return new RichPushFields(this);
        }
    }
}

