/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.nameduser.model;

import com.google.common.base.Objects;
import com.urbanairship.api.common.model.ErrorDetails;
import java.util.Optional;

public class NamedUserAttributeResponse {
    private final boolean ok;
    private final Optional<String> error;
    private final Optional<ErrorDetails> errorDetails;
    private final Optional<String> warning;

    private NamedUserAttributeResponse(Builder builder) {
        this.ok = builder.ok;
        this.error = Optional.ofNullable(builder.error);
        this.errorDetails = Optional.ofNullable(builder.errorDetails);
        this.warning = Optional.ofNullable(builder.warning);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public boolean isOk() {
        return this.ok;
    }

    public Optional<String> getError() {
        return this.error;
    }

    public Optional<ErrorDetails> getErrorDetails() {
        return this.errorDetails;
    }

    public Optional<String> getWarning() {
        return this.warning;
    }

    public String toString() {
        return "NamedUserAttributeResponse{ok=" + this.ok + ", error=" + this.error + ", errorDetails=" + this.errorDetails + ", warning=" + this.warning + '}';
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.ok, this.error, this.errorDetails, this.warning});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        NamedUserAttributeResponse other = (NamedUserAttributeResponse)obj;
        return Objects.equal((Object)this.ok, (Object)other.ok) && Objects.equal(this.error, other.error) && Objects.equal(this.errorDetails, other.errorDetails) && Objects.equal(this.warning, other.warning);
    }

    public static class Builder {
        boolean ok;
        private String error;
        private ErrorDetails errorDetails;
        private String warning;

        public Builder setOk(boolean ok) {
            this.ok = ok;
            return this;
        }

        public Builder setError(String error) {
            this.error = error;
            return this;
        }

        public Builder setErrorDetails(ErrorDetails errorDetails) {
            this.errorDetails = errorDetails;
            return this;
        }

        public Builder setWarning(String warning) {
            this.warning = warning;
            return this;
        }

        public NamedUserAttributeResponse build() {
            return new NamedUserAttributeResponse(this);
        }
    }
}

