/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.experiments.model;

import com.google.common.base.Objects;
import com.urbanairship.api.common.model.ErrorDetails;
import java.util.Optional;

public final class ExperimentResponse {
    private final boolean ok;
    private final Optional<String> operationId;
    private final Optional<String> experimentId;
    private final Optional<String> pushId;
    private final Optional<String> error;
    private final Optional<ErrorDetails> errorDetails;

    private ExperimentResponse(boolean ok, String operationId, String experimentId, String pushId, String error, ErrorDetails errorDetails) {
        this.ok = ok;
        this.operationId = Optional.ofNullable(operationId);
        this.experimentId = Optional.ofNullable(experimentId);
        this.pushId = Optional.ofNullable(pushId);
        this.error = Optional.ofNullable(error);
        this.errorDetails = Optional.ofNullable(errorDetails);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public boolean getOk() {
        return this.ok;
    }

    public Optional<String> getOperationId() {
        return this.operationId;
    }

    public Optional<String> getExperimentId() {
        return this.experimentId;
    }

    public Optional<String> getPushId() {
        return this.pushId;
    }

    public Optional<String> getError() {
        return this.error;
    }

    public Optional<ErrorDetails> getErrorDetails() {
        return this.errorDetails;
    }

    public String toString() {
        return "ExperimentResponse{ok=" + this.ok + ", operationId=" + this.operationId + ", experimentId=" + this.experimentId + ", pushId=" + this.pushId + ", error=" + this.error + ", errorDetails=" + this.errorDetails + '}';
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.operationId, this.pushId, this.ok, this.experimentId, this.error, this.errorDetails});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ExperimentResponse other = (ExperimentResponse)obj;
        return Objects.equal(this.operationId, other.operationId) && Objects.equal(this.pushId, other.pushId) && Objects.equal((Object)this.ok, (Object)other.ok) && Objects.equal(this.experimentId, other.experimentId) && Objects.equal(this.error, other.error) && Objects.equal(this.errorDetails, other.errorDetails);
    }

    public static class Builder {
        private String operationId = null;
        private String pushId = null;
        private boolean ok = false;
        private String experimentId = null;
        private String error = null;
        private ErrorDetails errorDetails = null;

        private Builder() {
        }

        public Builder setOk(boolean ok) {
            this.ok = ok;
            return this;
        }

        public Builder setOperationId(String operationId) {
            this.operationId = operationId;
            return this;
        }

        public Builder setExperimentId(String experimentId) {
            this.experimentId = experimentId;
            return this;
        }

        public Builder setPushId(String pushId) {
            this.pushId = pushId;
            return this;
        }

        public Builder setError(String error) {
            this.error = error;
            return this;
        }

        public Builder setErrorDetails(ErrorDetails errorDetails) {
            this.errorDetails = errorDetails;
            return this;
        }

        public ExperimentResponse build() {
            return new ExperimentResponse(this.ok, this.operationId, this.experimentId, this.pushId, this.error, this.errorDetails);
        }
    }
}

