/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.createandsend.model.notification.email;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.urbanairship.api.createandsend.model.notification.email.EmailTemplate;
import com.urbanairship.api.push.model.DeviceType;
import com.urbanairship.api.push.model.PushModelObject;
import com.urbanairship.api.push.model.notification.DevicePayloadOverride;
import com.urbanairship.api.push.model.notification.email.Attachment;
import com.urbanairship.api.push.model.notification.email.MessageType;
import java.util.Optional;
import org.apache.commons.lang.StringUtils;

public class CreateAndSendEmailPayload
extends PushModelObject
implements DevicePayloadOverride {
    private final Optional<Boolean> bypassOptInLevel;
    private final Optional<String> alert;
    private final Optional<String> subject;
    private final Optional<String> htmlBody;
    private final Optional<String> plaintextBody;
    private final Optional<MessageType> messageType;
    private final Optional<String> senderName;
    private final Optional<String> senderAddress;
    private final Optional<String> replyTo;
    private final Optional<EmailTemplate> emailTemplate;
    private final Optional<ImmutableList<Attachment>> attachments;
    private final Optional<Boolean> clickTracking;
    private final Optional<Boolean> openTracking;

    private CreateAndSendEmailPayload(Builder builder) {
        this.alert = Optional.ofNullable(builder.alert);
        this.subject = Optional.ofNullable(builder.subject);
        this.htmlBody = Optional.ofNullable(builder.htmlBody);
        this.plaintextBody = Optional.ofNullable(builder.plaintextBody);
        this.messageType = Optional.ofNullable(builder.messageType);
        this.senderName = Optional.ofNullable(builder.senderName);
        this.senderAddress = Optional.ofNullable(builder.senderAddress);
        this.replyTo = Optional.ofNullable(builder.replyTo);
        this.bypassOptInLevel = Optional.ofNullable(builder.byPassOptInLevel);
        this.emailTemplate = Optional.ofNullable(builder.emailTemplate);
        this.clickTracking = Optional.ofNullable(builder.clickTracking);
        this.openTracking = Optional.ofNullable(builder.openTracking);
        this.attachments = builder.attachments.build().isEmpty() ? Optional.empty() : Optional.ofNullable(builder.attachments.build());
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @Override
    public DeviceType getDeviceType() {
        return DeviceType.EMAIL;
    }

    public Optional<EmailTemplate> getEmailTemplate() {
        return this.emailTemplate;
    }

    @Override
    public Optional<String> getAlert() {
        return this.alert;
    }

    public Optional<String> getSubject() {
        return this.subject;
    }

    public Optional<String> getHtmlBody() {
        return this.htmlBody;
    }

    public Optional<String> getPlaintextBody() {
        return this.plaintextBody;
    }

    public Optional<MessageType> getMessageType() {
        return this.messageType;
    }

    public Optional<String> getSenderName() {
        return this.senderName;
    }

    public Optional<String> getSenderAddress() {
        return this.senderAddress;
    }

    public Optional<String> getReplyTo() {
        return this.replyTo;
    }

    public Optional<Boolean> getBypassOptInLevel() {
        return this.bypassOptInLevel;
    }

    public Optional<ImmutableList<Attachment>> getAttachments() {
        return this.attachments;
    }

    public Optional<Boolean> getClickTracking() {
        return this.clickTracking;
    }

    public Optional<Boolean> getOpenTracking() {
        return this.openTracking;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateAndSendEmailPayload that = (CreateAndSendEmailPayload)o;
        return Objects.equal(this.bypassOptInLevel, that.bypassOptInLevel) && Objects.equal(this.alert, that.alert) && Objects.equal(this.subject, that.subject) && Objects.equal(this.htmlBody, that.htmlBody) && Objects.equal(this.plaintextBody, that.plaintextBody) && Objects.equal(this.messageType, that.messageType) && Objects.equal(this.senderName, that.senderName) && Objects.equal(this.senderAddress, that.senderAddress) && Objects.equal(this.replyTo, that.replyTo) && Objects.equal(this.emailTemplate, that.emailTemplate) && Objects.equal(this.attachments, that.attachments) && Objects.equal(this.clickTracking, that.clickTracking) && Objects.equal(this.openTracking, that.openTracking);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.bypassOptInLevel, this.alert, this.subject, this.htmlBody, this.plaintextBody, this.messageType, this.senderName, this.senderAddress, this.replyTo, this.emailTemplate, this.attachments, this.clickTracking, this.openTracking});
    }

    public String toString() {
        return "CreateAndSendEmailPayload{bypassOptInLevel=" + this.bypassOptInLevel + ", alert=" + this.alert + ", subject=" + this.subject + ", htmlBody=" + this.htmlBody + ", plaintextBody=" + this.plaintextBody + ", messageType=" + this.messageType + ", senderName=" + this.senderName + ", senderAddress=" + this.senderAddress + ", replyTo=" + this.replyTo + ", emailTemplate=" + this.emailTemplate + ", attachments=" + this.attachments + ", clickTracking=" + this.clickTracking + ", openTracking=" + this.openTracking + '}';
    }

    public static class Builder {
        private String alert = null;
        private String subject = null;
        private String htmlBody = null;
        private String plaintextBody = null;
        private MessageType messageType = null;
        private String senderName = null;
        private String senderAddress = null;
        private String replyTo = null;
        private DeviceType deviceType = null;
        private Boolean byPassOptInLevel = null;
        private EmailTemplate emailTemplate = null;
        private ImmutableList.Builder<Attachment> attachments = ImmutableList.builder();
        private Boolean clickTracking = null;
        private Boolean openTracking = null;

        private Builder() {
        }

        public Builder setSubject(String subject) {
            this.subject = subject;
            return this;
        }

        public Builder setByPassOptInLevel(Boolean byPassOptInLevel) {
            this.byPassOptInLevel = byPassOptInLevel;
            return this;
        }

        public Builder setHtmlBody(String htmlBody) {
            this.htmlBody = htmlBody;
            return this;
        }

        public Builder setPlaintextBody(String plaintextBody) {
            this.plaintextBody = plaintextBody;
            return this;
        }

        public Builder setMessageType(MessageType value) {
            this.messageType = value;
            return this;
        }

        public Builder setSenderAddress(String senderAddress) {
            this.senderAddress = senderAddress;
            return this;
        }

        public Builder setReplyTo(String replyTo) {
            this.replyTo = replyTo;
            return this;
        }

        public Builder setSenderName(String senderName) {
            this.senderName = senderName;
            return this;
        }

        public Builder setEmailTemplate(EmailTemplate emailTemplate) {
            this.emailTemplate = emailTemplate;
            return this;
        }

        public Builder addAttachment(Attachment attachment) {
            this.attachments.add((Object)attachment);
            return this;
        }

        public Builder setClickTracking(Boolean clickTracking) {
            this.clickTracking = clickTracking;
            return this;
        }

        public Builder setOpenTracking(Boolean openTracking) {
            this.openTracking = openTracking;
            return this;
        }

        public CreateAndSendEmailPayload build() {
            Preconditions.checkArgument((this.emailTemplate == null || this.subject == null ? 1 : 0) != 0, (Object)"subject cannot be used if email template is also set.");
            Preconditions.checkArgument((this.subject != null || this.emailTemplate != null ? 1 : 0) != 0, (Object)"subject or email template must be set.");
            Preconditions.checkArgument((this.plaintextBody == null || this.emailTemplate == null ? 1 : 0) != 0, (Object)"email plaintext_body must not be specified if email payload is templated");
            Preconditions.checkArgument((this.plaintextBody != null || this.emailTemplate != null ? 1 : 0) != 0, (Object)"plaintext body or email template must be set");
            Preconditions.checkArgument((this.htmlBody == null || this.emailTemplate == null ? 1 : 0) != 0, (Object)"email htmlBody must not be specified if email payload is templated");
            Preconditions.checkNotNull((Object)((Object)this.messageType), (Object)"MessageType must be set.");
            Preconditions.checkNotNull((Object)this.senderName, (Object)"SenderName must be set.");
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)this.senderName), (Object)"SenderName must not be blank");
            Preconditions.checkNotNull((Object)this.senderAddress, (Object)"SenderAddress must be set.");
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)this.senderAddress), (Object)"SenderAddress must not be blank");
            Preconditions.checkNotNull((Object)this.replyTo, (Object)"ReplyTo must be set.");
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)this.replyTo), (Object)"ReplyTo must not be blank");
            return new CreateAndSendEmailPayload(this);
        }
    }
}

