/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.channel.parse;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.type.TypeReference;
import com.urbanairship.api.channel.model.ChannelResponse;
import com.urbanairship.api.channel.model.ChannelView;
import com.urbanairship.api.common.model.ErrorDetails;
import com.urbanairship.api.common.parse.APIParsingException;
import com.urbanairship.api.common.parse.JsonObjectReader;
import java.io.IOException;
import java.util.List;

public final class ChannelsResponseReader
implements JsonObjectReader<ChannelResponse> {
    private final ChannelResponse.Builder builder = ChannelResponse.newBuilder();

    public void readOk(JsonParser jsonParser) throws IOException {
        this.builder.setOk(jsonParser.getBooleanValue());
    }

    public void readNextPage(JsonParser jsonParser) throws IOException {
        this.builder.setNextPage((String)jsonParser.readValueAs(String.class));
    }

    public void readChannelObject(JsonParser jsonParser) throws IOException {
        this.builder.setChannelObject((ChannelView)jsonParser.readValueAs(ChannelView.class));
    }

    public void readChannelObjects(JsonParser jsonParser) throws IOException {
        this.builder.addAllChannels((List)jsonParser.readValueAs((TypeReference)new TypeReference<List<ChannelView>>(){}));
    }

    public void readError(JsonParser jsonParser) throws IOException {
        this.builder.setError((String)jsonParser.readValueAs(String.class));
    }

    public void readErrorDetails(JsonParser jsonParser) throws IOException {
        this.builder.setErrorDetails((ErrorDetails)jsonParser.readValueAs(ErrorDetails.class));
    }

    @Override
    public ChannelResponse validateAndBuild() throws IOException {
        try {
            return this.builder.build();
        }
        catch (Exception ex) {
            throw new APIParsingException(ex.getMessage());
        }
    }
}

