/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.channel.model.sms;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.urbanairship.api.channel.model.ChannelModelObject;
import java.util.Optional;
import org.joda.time.DateTime;

public class UpdateSmsChannel
extends ChannelModelObject {
    private final String msisdn;
    private final String sender;
    private final Optional<DateTime> optedIn;
    private final Optional<String> timezone;
    private final Optional<String> localeCountry;
    private final Optional<String> localeLanguage;

    protected UpdateSmsChannel(Builder builder) {
        this.msisdn = builder.msisdn;
        this.sender = builder.sender;
        this.optedIn = Optional.ofNullable(builder.optedIn);
        this.timezone = Optional.ofNullable(builder.timezone);
        this.localeCountry = Optional.ofNullable(builder.localeCountry);
        this.localeLanguage = Optional.ofNullable(builder.localeLanguage);
    }

    public String getMsisdn() {
        return this.msisdn;
    }

    public String getSender() {
        return this.sender;
    }

    public Optional<DateTime> getOptedIn() {
        return this.optedIn;
    }

    public Optional<String> getTimezone() {
        return this.timezone;
    }

    public Optional<String> getLocaleCountry() {
        return this.localeCountry;
    }

    public Optional<String> getLocaleLanguage() {
        return this.localeLanguage;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UpdateSmsChannel that = (UpdateSmsChannel)o;
        return this.msisdn == that.msisdn && Objects.equal((Object)this.sender, (Object)that.sender) && Objects.equal(this.optedIn, that.optedIn) && Objects.equal(this.timezone, that.timezone) && Objects.equal(this.localeCountry, that.localeCountry) && Objects.equal(this.localeLanguage, that.localeLanguage);
    }

    public String toString() {
        return "UpdateSmsChannel{msisdn=" + this.msisdn + ", sender=" + this.sender + ", optedIn=" + this.optedIn + ", timezone=" + this.timezone + ", localeCountry=" + this.localeCountry + ", localeLanguage=" + this.localeLanguage + '}';
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.msisdn, this.sender, this.optedIn, this.timezone, this.localeCountry, this.localeLanguage});
    }

    public static final class Builder {
        private String msisdn;
        private String sender;
        private DateTime optedIn;
        private String timezone;
        private String localeCountry;
        private String localeLanguage;

        protected Builder() {
        }

        public Builder setMsisdn(String msisdn) {
            this.msisdn = msisdn;
            return this;
        }

        public Builder setSender(String sender) {
            this.sender = sender;
            return this;
        }

        public Builder setOptedIn(DateTime optedIn) {
            this.optedIn = optedIn;
            return this;
        }

        public Builder setTimeZone(String timezone) {
            this.timezone = timezone;
            return this;
        }

        public Builder setLocaleCountry(String locale_country) {
            this.localeCountry = locale_country;
            return this;
        }

        public Builder setLocaleLanguage(String locale_language) {
            this.localeLanguage = locale_language;
            return this;
        }

        public UpdateSmsChannel build() {
            Preconditions.checkNotNull((Object)this.msisdn, (Object)"msisdn cannot be null.");
            Preconditions.checkNotNull((Object)this.sender, (Object)"sender cannot be null.");
            return new UpdateSmsChannel(this);
        }
    }
}

