/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.channel.model.attributes.audience;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.urbanairship.api.channel.model.attributes.audience.AttributeAudienceType;
import com.urbanairship.api.push.model.audience.sms.SmsSelector;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class AttributeAudience {
    private final ImmutableSet<SmsSelector> smsSelectors;
    private final ImmutableMap<AttributeAudienceType, Set<String>> attributeDevices;

    public AttributeAudience(Builder builder) {
        this.smsSelectors = builder.smsSelectors;
        this.attributeDevices = ImmutableMap.copyOf(builder.audienceTypeMap);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public ImmutableSet<SmsSelector> getSmsSelectors() {
        return this.smsSelectors;
    }

    public ImmutableMap<AttributeAudienceType, Set<String>> getAttributeDevices() {
        return this.attributeDevices;
    }

    public static class Builder {
        ImmutableSet.Builder<SmsSelector> smsSelectorsBuilder = ImmutableSet.builder();
        ImmutableSet<SmsSelector> smsSelectors;
        Map<AttributeAudienceType, Set<String>> audienceTypeMap = new HashMap<AttributeAudienceType, Set<String>>();

        public Builder addDeviceId(AttributeAudienceType audienceType, String deviceId) {
            if (this.audienceTypeMap.containsKey((Object)audienceType)) {
                this.audienceTypeMap.get((Object)audienceType).add(deviceId);
            } else {
                HashSet<String> deviceIds = new HashSet<String>();
                deviceIds.add(deviceId);
                this.audienceTypeMap.put(audienceType, deviceIds);
            }
            return this;
        }

        public Builder addSmsSelector(SmsSelector smsSelector) {
            this.smsSelectorsBuilder.add((Object)smsSelector);
            return this;
        }

        public AttributeAudience build() {
            this.smsSelectors = this.smsSelectorsBuilder.build();
            Preconditions.checkArgument((this.smsSelectors.size() != 0 || this.audienceTypeMap.size() != 0 ? 1 : 0) != 0, (Object)"Device types or SmsSelectors must be added.");
            return new AttributeAudience(this);
        }
    }
}

