/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.channel.model;

import com.google.common.base.Objects;
import com.urbanairship.api.common.model.ErrorDetails;
import java.util.Optional;

public class SmsRegistrationResponse {
    private final boolean ok;
    private final Optional<String> channelId;
    private final Optional<String> status;
    private final Optional<String> error;
    private final Optional<ErrorDetails> errorDetails;

    private SmsRegistrationResponse(Builder builder) {
        this.ok = builder.ok;
        this.channelId = Optional.ofNullable(builder.channelId);
        this.status = Optional.ofNullable(builder.status);
        this.error = Optional.ofNullable(builder.error);
        this.errorDetails = Optional.ofNullable(builder.errorDetails);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public boolean isOk() {
        return this.ok;
    }

    public Optional<String> getChannelId() {
        return this.channelId;
    }

    public Optional<String> getStatus() {
        return this.status;
    }

    public Optional<String> getError() {
        return this.error;
    }

    public Optional<ErrorDetails> getErrorDetails() {
        return this.errorDetails;
    }

    public String toString() {
        return "SmsRegistrationResponse{ok=" + this.ok + ", channelId='" + this.channelId + ", status='" + this.status + ", error='" + this.error + ", errorDetails=" + this.errorDetails + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SmsRegistrationResponse that = (SmsRegistrationResponse)o;
        return this.ok == that.ok && Objects.equal(this.channelId, that.channelId) && Objects.equal(this.status, that.status) && Objects.equal(this.error, that.error) && Objects.equal(this.errorDetails, that.errorDetails);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.ok, this.channelId, this.status, this.error, this.errorDetails});
    }

    public static class Builder {
        private boolean ok;
        private String channelId = null;
        private String status = null;
        private String error = null;
        private ErrorDetails errorDetails = null;

        public Builder setOk(boolean value) {
            this.ok = value;
            return this;
        }

        public Builder setChannelId(String channelId) {
            this.channelId = channelId;
            return this;
        }

        public Builder setStatus(String status) {
            this.status = status;
            return this;
        }

        public Builder setError(String error) {
            this.error = error;
            return this;
        }

        public Builder setErrorDetails(ErrorDetails errorDetails) {
            this.errorDetails = errorDetails;
            return this;
        }

        public SmsRegistrationResponse build() {
            return new SmsRegistrationResponse(this);
        }
    }
}

