/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.channel;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Preconditions;
import com.urbanairship.api.channel.parse.ChannelObjectMapper;
import com.urbanairship.api.client.Request;
import com.urbanairship.api.client.RequestUtils;
import com.urbanairship.api.client.ResponseParser;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.http.entity.ContentType;

public class OpenChannelTagRequest
implements Request<String> {
    private static final String OPEN_CHANNELS_TAGS_PATH = "/api/channels/open/tags";
    private static final String AUDIENCE_KEY = "audience";
    private static final String ADD_KEY = "add";
    private static final String REMOVE_KEY = "remove";
    private static final String SET_KEY = "set";
    private static final String ADDRESS_KEY = "address";
    private static final String OPEN_PLATFORM_NAME_KEY = "open_platform_name";
    private final Map<String, Set<String>> addTags = new HashMap<String, Set<String>>();
    private final Map<String, Set<String>> removeTags = new HashMap<String, Set<String>>();
    private final Map<String, Set<String>> setTags = new HashMap<String, Set<String>>();
    private ObjectNode payloadNode = JsonNodeFactory.instance.objectNode();
    private ObjectNode openNode = JsonNodeFactory.instance.objectNode();
    private String address;
    private String openPlatformName;

    public static OpenChannelTagRequest newRequest() {
        return new OpenChannelTagRequest();
    }

    public OpenChannelTagRequest addOpenChannel(String address, String openPlatformName) {
        this.address = address;
        this.openPlatformName = openPlatformName;
        return this;
    }

    public OpenChannelTagRequest addTags(String tagGroup, Set<String> tags) {
        this.addTags.put(tagGroup, tags);
        return this;
    }

    public OpenChannelTagRequest removeTags(String tagGroup, Set<String> tags) {
        this.removeTags.put(tagGroup, tags);
        return this;
    }

    public OpenChannelTagRequest setTags(String tagGroup, Set<String> tags) {
        this.setTags.put(tagGroup, tags);
        return this;
    }

    @Override
    public Request.HttpMethod getHttpMethod() {
        return Request.HttpMethod.POST;
    }

    @Override
    public String getRequestBody() {
        this.openNode.put(ADDRESS_KEY, this.address);
        this.openNode.put(OPEN_PLATFORM_NAME_KEY, this.openPlatformName);
        this.payloadNode.set(AUDIENCE_KEY, (JsonNode)this.openNode);
        if (!this.addTags.isEmpty()) {
            this.payloadNode.putPOJO(ADD_KEY, this.addTags);
        }
        if (!this.removeTags.isEmpty()) {
            this.payloadNode.putPOJO(REMOVE_KEY, this.removeTags);
        }
        if (!this.setTags.isEmpty()) {
            this.payloadNode.putPOJO(SET_KEY, this.setTags);
        }
        Preconditions.checkArgument((this.payloadNode.has(ADD_KEY) || this.payloadNode.has(REMOVE_KEY) || this.payloadNode.has(SET_KEY) ? 1 : 0) != 0, (Object)"Audience required when executing a channel tag operation");
        if (this.payloadNode.has(SET_KEY)) {
            Preconditions.checkArgument((!this.payloadNode.has(REMOVE_KEY) && !this.payloadNode.has(ADD_KEY) ? 1 : 0) != 0);
        }
        try {
            return ChannelObjectMapper.getInstance().writeValueAsString((Object)this.payloadNode);
        }
        catch (Exception ex) {
            return "{ \"exception\" : \"" + ex.getClass().getName() + "\", \"message\" : \"" + ex.getMessage() + "\" }";
        }
    }

    @Override
    public ContentType getContentType() {
        return ContentType.APPLICATION_JSON;
    }

    @Override
    public Map<String, String> getRequestHeaders() {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/json");
        headers.put("Accept", "application/vnd.urbanairship+json; version=3");
        return headers;
    }

    @Override
    public URI getUri(URI baseUri) {
        return RequestUtils.resolveURI(baseUri, OPEN_CHANNELS_TAGS_PATH);
    }

    @Override
    public ResponseParser<String> getResponseParser() {
        return response -> response;
    }

    @Override
    public boolean bearerTokenAuthRequired() {
        return false;
    }

    @Override
    public boolean canUseBearerTokenAuth() {
        return true;
    }
}

