/*
 * Decompiled with CFR 0.152.
 */
package com.upplication.s3fs;

import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.S3Object;
import com.upplication.s3fs.S3Path;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.tika.Tika;

public class S3SeekableByteChannel
implements SeekableByteChannel {
    private S3Path path;
    private Set<? extends OpenOption> options;
    private SeekableByteChannel seekable;
    private Path tempFile;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public S3SeekableByteChannel(S3Path path, Set<? extends OpenOption> options) throws IOException {
        this.path = path;
        this.options = Collections.unmodifiableSet(new HashSet<OpenOption>(options));
        String key = path.getKey();
        boolean existed = path.getFileSystem().provider().exists(path);
        if (existed && this.options.contains(StandardOpenOption.CREATE_NEW)) {
            throw new FileAlreadyExistsException(String.format("target already exists: %s", path));
        }
        if (!(existed || this.options.contains(StandardOpenOption.CREATE_NEW) || this.options.contains(StandardOpenOption.CREATE))) {
            throw new NoSuchFileException(String.format("target not exists: %s", path));
        }
        this.tempFile = Files.createTempFile("temp-s3-", key.replaceAll("/", "_"), new FileAttribute[0]);
        boolean removeTempFile = true;
        try {
            if (existed) {
                try (S3Object object = path.getFileSystem().getClient().getObject(path.getFileStore().getBucket().getName(), key);){
                    Files.copy((InputStream)object.getObjectContent(), this.tempFile, StandardCopyOption.REPLACE_EXISTING);
                }
            }
            HashSet<? extends OpenOption> seekOptions = new HashSet<OpenOption>(this.options);
            seekOptions.remove(StandardOpenOption.CREATE_NEW);
            this.seekable = Files.newByteChannel(this.tempFile, seekOptions, new FileAttribute[0]);
            removeTempFile = false;
        }
        finally {
            if (removeTempFile) {
                Files.deleteIfExists(this.tempFile);
            }
        }
    }

    @Override
    public boolean isOpen() {
        return this.seekable.isOpen();
    }

    @Override
    public void close() throws IOException {
        try {
            if (!this.seekable.isOpen()) {
                return;
            }
            this.seekable.close();
            if (this.options.contains(StandardOpenOption.DELETE_ON_CLOSE)) {
                this.path.getFileSystem().provider().delete(this.path);
                return;
            }
            if (this.options.contains(StandardOpenOption.READ) && this.options.size() == 1) {
                return;
            }
            this.sync();
        }
        finally {
            Files.deleteIfExists(this.tempFile);
        }
    }

    protected void sync() throws IOException {
        try (BufferedInputStream stream = new BufferedInputStream(Files.newInputStream(this.tempFile, new OpenOption[0]));){
            ObjectMetadata metadata = new ObjectMetadata();
            metadata.setContentLength(Files.size(this.tempFile));
            metadata.setContentType(new Tika().detect((InputStream)stream, this.path.getFileName().toString()));
            String bucket = this.path.getFileStore().name();
            String key = this.path.getKey();
            this.path.getFileSystem().getClient().putObject(bucket, key, (InputStream)stream, metadata);
        }
    }

    @Override
    public int write(ByteBuffer src) throws IOException {
        return this.seekable.write(src);
    }

    @Override
    public SeekableByteChannel truncate(long size) throws IOException {
        return this.seekable.truncate(size);
    }

    @Override
    public long size() throws IOException {
        return this.seekable.size();
    }

    @Override
    public int read(ByteBuffer dst) throws IOException {
        return this.seekable.read(dst);
    }

    @Override
    public SeekableByteChannel position(long newPosition) throws IOException {
        return this.seekable.position(newPosition);
    }

    @Override
    public long position() throws IOException {
        return this.seekable.position();
    }
}

