/*
 * Decompiled with CFR 0.152.
 */
package com.upplication.s3fs;

import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.model.Bucket;
import com.amazonaws.services.s3.model.Owner;
import com.google.common.collect.ImmutableList;
import com.upplication.s3fs.S3FileStoreAttributeView;
import com.upplication.s3fs.S3FileSystem;
import com.upplication.s3fs.S3Path;
import java.io.IOException;
import java.nio.file.FileStore;
import java.nio.file.attribute.FileAttributeView;
import java.nio.file.attribute.FileStoreAttributeView;

public class S3FileStore
extends FileStore
implements Comparable<S3FileStore> {
    private S3FileSystem fileSystem;
    private String name;

    public S3FileStore(S3FileSystem s3FileSystem, String name) {
        this.fileSystem = s3FileSystem;
        this.name = name;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String type() {
        return "S3Bucket";
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public long getTotalSpace() throws IOException {
        return Long.MAX_VALUE;
    }

    @Override
    public long getUsableSpace() throws IOException {
        return Long.MAX_VALUE;
    }

    @Override
    public long getUnallocatedSpace() throws IOException {
        return Long.MAX_VALUE;
    }

    @Override
    public boolean supportsFileAttributeView(Class<? extends FileAttributeView> type) {
        return false;
    }

    @Override
    public boolean supportsFileAttributeView(String attributeViewName) {
        return false;
    }

    @Override
    public <V extends FileStoreAttributeView> V getFileStoreAttributeView(Class<V> type) {
        if (type != S3FileStoreAttributeView.class) {
            throw new IllegalArgumentException("FileStoreAttributeView of type '" + type.getName() + "' is not supported.");
        }
        Bucket buck = this.getBucket();
        Owner owner = buck.getOwner();
        return (V)new S3FileStoreAttributeView(buck.getCreationDate(), buck.getName(), owner.getId(), owner.getDisplayName());
    }

    @Override
    public Object getAttribute(String attribute) throws IOException {
        return this.getFileStoreAttributeView(S3FileStoreAttributeView.class).getAttribute(attribute);
    }

    public S3FileSystem getFileSystem() {
        return this.fileSystem;
    }

    public Bucket getBucket() {
        return this.getBucket(this.name);
    }

    private Bucket getBucket(String bucketName) {
        for (Bucket buck : this.getClient().listBuckets()) {
            if (!buck.getName().equals(bucketName)) continue;
            return buck;
        }
        return null;
    }

    public S3Path getRootDirectory() {
        return new S3Path(this.fileSystem, this, (Iterable<String>)ImmutableList.of());
    }

    private AmazonS3 getClient() {
        return this.fileSystem.getClient();
    }

    public Owner getOwner() {
        Bucket buck = this.getBucket();
        if (buck != null) {
            return buck.getOwner();
        }
        return this.fileSystem.getClient().getS3AccountOwner();
    }

    @Override
    public int compareTo(S3FileStore o) {
        if (this == o) {
            return 0;
        }
        return o.name().compareTo(this.name);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.fileSystem == null ? 0 : this.fileSystem.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3FileStore)) {
            return false;
        }
        S3FileStore other = (S3FileStore)obj;
        if (this.fileSystem == null ? other.fileSystem != null : !this.fileSystem.equals(other.fileSystem)) {
            return false;
        }
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }
}

