/*
 * Decompiled with CFR 0.152.
 */
package com.upplication.s3fs.util;

import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.model.AccessControlList;
import com.amazonaws.services.s3.model.AmazonS3Exception;
import com.amazonaws.services.s3.model.ListObjectsRequest;
import com.amazonaws.services.s3.model.ObjectListing;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.S3ObjectSummary;
import com.upplication.s3fs.S3FileAttributes;
import com.upplication.s3fs.S3Path;
import java.nio.file.NoSuchFileException;
import java.nio.file.attribute.FileTime;
import java.util.concurrent.TimeUnit;

public class S3Utils {
    public S3ObjectSummary getS3ObjectSummary(S3Path s3Path) throws NoSuchFileException {
        String key = s3Path.getKey();
        String bucketName = s3Path.getFileStore().name();
        AmazonS3 client = s3Path.getFileSystem().getClient();
        try {
            ObjectMetadata metadata = client.getObjectMetadata(bucketName, key);
            S3ObjectSummary result = new S3ObjectSummary();
            result.setBucketName(bucketName);
            result.setETag(metadata.getETag());
            result.setKey(key);
            result.setLastModified(metadata.getLastModified());
            result.setSize(metadata.getContentLength());
            AccessControlList objectAcl = client.getObjectAcl(bucketName, key);
            result.setOwner(objectAcl.getOwner());
            return result;
        }
        catch (AmazonS3Exception e) {
            if (e.getStatusCode() != 404) {
                throw e;
            }
            try {
                ListObjectsRequest request = new ListObjectsRequest();
                request.setBucketName(bucketName);
                request.setPrefix(key + "/");
                request.setMaxKeys(Integer.valueOf(1));
                ObjectListing current = client.listObjects(request);
                if (!current.getObjectSummaries().isEmpty()) {
                    return (S3ObjectSummary)current.getObjectSummaries().get(0);
                }
            }
            catch (Exception e2) {
                // empty catch block
            }
            throw new NoSuchFileException(bucketName + "/" + key);
        }
    }

    public S3FileAttributes getS3FileAttributes(S3Path s3Path) throws NoSuchFileException {
        S3ObjectSummary objectSummary = this.getS3ObjectSummary(s3Path);
        return this.toS3FileAttributes(objectSummary, s3Path.getKey());
    }

    public S3FileAttributes toS3FileAttributes(S3ObjectSummary objectSummary, String key) {
        FileTime lastModifiedTime = null;
        if (objectSummary.getLastModified() != null) {
            lastModifiedTime = FileTime.from(objectSummary.getLastModified().getTime(), TimeUnit.MILLISECONDS);
        }
        long size = objectSummary.getSize();
        boolean directory = false;
        boolean regularFile = false;
        String resolvedKey = objectSummary.getKey();
        if (key.endsWith("/") && resolvedKey.equals(key) || resolvedKey.equals(key + "/")) {
            directory = true;
        } else if (key.isEmpty()) {
            directory = true;
            resolvedKey = "/";
        } else if (!resolvedKey.equals(key) && resolvedKey.startsWith(key)) {
            directory = true;
            size = 0L;
            resolvedKey = key + "/";
        } else {
            regularFile = true;
        }
        return new S3FileAttributes(resolvedKey, lastModifiedTime, size, directory, regularFile);
    }
}

