/*
 * Decompiled with CFR 0.152.
 */
package com.upplication.s3fs;

import com.amazonaws.services.s3.model.AccessControlList;
import com.amazonaws.services.s3.model.Grant;
import com.amazonaws.services.s3.model.Owner;
import com.amazonaws.services.s3.model.Permission;
import java.nio.file.AccessDeniedException;
import java.nio.file.AccessMode;
import java.util.EnumSet;

public class S3AccessControlList {
    private String fileStoreName;
    private String key;
    private AccessControlList acl;
    private Owner owner;

    public S3AccessControlList(String fileStoreName, String key, AccessControlList acl, Owner owner) {
        this.fileStoreName = fileStoreName;
        this.acl = acl;
        this.key = key;
        this.owner = owner;
    }

    public String getKey() {
        return this.key;
    }

    private boolean hasPermission(EnumSet<Permission> permissions) {
        for (Grant grant : this.acl.getGrants()) {
            if (!grant.getGrantee().getIdentifier().equals(this.owner.getId()) || !permissions.contains(grant.getPermission())) continue;
            return true;
        }
        return false;
    }

    public void checkAccess(AccessMode[] modes) throws AccessDeniedException {
        block5: for (AccessMode accessMode : modes) {
            switch (accessMode) {
                case EXECUTE: {
                    throw new AccessDeniedException(this.fileName(), null, "file is not executable");
                }
                case READ: {
                    if (this.hasPermission(EnumSet.of(Permission.FullControl, Permission.Read))) continue block5;
                    throw new AccessDeniedException(this.fileName(), null, "file is not readable");
                }
                case WRITE: {
                    if (this.hasPermission(EnumSet.of(Permission.FullControl, Permission.Write))) continue block5;
                    throw new AccessDeniedException(this.fileName(), null, String.format("bucket '%s' is not writable", this.fileStoreName));
                }
            }
        }
    }

    private String fileName() {
        return this.fileStoreName + "/" + this.key;
    }
}

