/*
 * Decompiled with CFR 0.152.
 */
package com.upplication.s3fs;

import com.amazonaws.services.s3.model.ListObjectsRequest;
import com.amazonaws.services.s3.model.ObjectListing;
import com.amazonaws.services.s3.model.S3ObjectSummary;
import com.google.common.base.Preconditions;
import com.upplication.s3fs.S3FileSystem;
import com.upplication.s3fs.S3Path;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class S3Iterator
implements Iterator<Path> {
    private S3FileSystem s3FileSystem;
    private String bucket;
    private String key;
    private Iterator<S3Path> it;

    public S3Iterator(S3FileSystem s3FileSystem, String bucket, String key) {
        Preconditions.checkArgument((key != null && key.endsWith("/") ? 1 : 0) != 0, (String)"key %s should be ended with slash '/'", (Object[])new Object[]{key});
        this.bucket = bucket;
        this.key = key.length() == 1 ? "" : key;
        this.s3FileSystem = s3FileSystem;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public S3Path next() {
        return this.getIterator().next();
    }

    @Override
    public boolean hasNext() {
        return this.getIterator().hasNext();
    }

    private Iterator<S3Path> getIterator() {
        if (this.it == null) {
            ArrayList<S3Path> listPath = new ArrayList<S3Path>();
            ObjectListing current = this.s3FileSystem.getClient().listObjects(this.buildRequest());
            while (current.isTruncated()) {
                this.parseObjectListing(listPath, current);
                current = this.s3FileSystem.getClient().listNextBatchOfObjects(current);
            }
            this.parseObjectListing(listPath, current);
            this.it = listPath.iterator();
        }
        return this.it;
    }

    private ListObjectsRequest buildRequest() {
        ListObjectsRequest request = new ListObjectsRequest();
        request.setBucketName(this.bucket);
        request.setPrefix(this.key);
        request.setMarker(this.key);
        return request;
    }

    private void parseObjectListing(List<S3Path> listPath, ObjectListing current) {
        for (S3ObjectSummary objectSummary : current.getObjectSummaries()) {
            S3Path descendentPart;
            String objectSummaryKey = objectSummary.getKey();
            String key = this.getInmediateDescendent(this.key, objectSummaryKey);
            if (key == null || listPath.contains(descendentPart = new S3Path(this.s3FileSystem, "/" + objectSummary.getBucketName(), key.split("/")))) continue;
            listPath.add(descendentPart);
        }
    }

    private String getInmediateDescendent(String keyParent, String keyChild) {
        int parentLen;
        keyParent = this.deleteExtraPath(keyParent);
        String childWithoutParent = this.deleteExtraPath((keyChild = this.deleteExtraPath(keyChild)).substring(parentLen = keyParent.length()));
        String[] parts = childWithoutParent.split("/");
        if (parts.length > 0 && !parts[0].isEmpty()) {
            return keyParent + "/" + parts[0];
        }
        return null;
    }

    private String deleteExtraPath(String keyChild) {
        if (keyChild.startsWith("/")) {
            keyChild = keyChild.substring(1);
        }
        if (keyChild.endsWith("/")) {
            keyChild = keyChild.substring(0, keyChild.length() - 1);
        }
        return keyChild;
    }
}

