/*
 * Decompiled with CFR 0.152.
 */
package com.upplication.s3fs;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.model.AccessControlList;
import com.amazonaws.services.s3.model.Grant;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.Owner;
import com.amazonaws.services.s3.model.Permission;
import com.amazonaws.services.s3.model.S3ObjectInputStream;
import com.amazonaws.services.s3.model.S3ObjectSummary;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.upplication.s3fs.AmazonS3Client;
import com.upplication.s3fs.S3FileAttributes;
import com.upplication.s3fs.S3FileSystem;
import com.upplication.s3fs.S3Iterator;
import com.upplication.s3fs.S3Path;
import com.upplication.s3fs.util.FileTypeDetector;
import com.upplication.s3fs.util.IOUtils;
import com.upplication.s3fs.util.S3ObjectSummaryLookup;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.AccessDeniedException;
import java.nio.file.AccessMode;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryNotEmptyException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileStore;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemAlreadyExistsException;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileAttributeView;
import java.nio.file.attribute.FileTime;
import java.nio.file.spi.FileSystemProvider;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;

public class S3FileSystemProvider
extends FileSystemProvider {
    public static final String ACCESS_KEY = "access_key";
    public static final String SECRET_KEY = "secret_key";
    final AtomicReference<S3FileSystem> fileSystem = new AtomicReference();
    private final FileTypeDetector fileTypeDetector = new FileTypeDetector();
    private final S3ObjectSummaryLookup s3ObjectSummaryLookup = new S3ObjectSummaryLookup();

    @Override
    public String getScheme() {
        return "s3";
    }

    @Override
    public FileSystem newFileSystem(URI uri, Map<String, ?> env) throws IOException {
        Preconditions.checkNotNull((Object)uri, (Object)"uri is null");
        Preconditions.checkArgument((boolean)uri.getScheme().equals("s3"), (String)"uri scheme must be 's3': '%s'", (Object[])new Object[]{uri});
        Properties props = this.loadAmazonProperties();
        String accessKey = props.getProperty(ACCESS_KEY);
        String secretKey = props.getProperty(SECRET_KEY);
        if (env.get(ACCESS_KEY) != null) {
            accessKey = env.get(ACCESS_KEY);
        }
        if (env.get(SECRET_KEY) != null) {
            secretKey = env.get(SECRET_KEY);
        }
        Preconditions.checkArgument((accessKey == null && secretKey == null || accessKey != null && secretKey != null ? 1 : 0) != 0, (String)"%s and %s should both be provided or should both be omitted", (Object[])new Object[]{ACCESS_KEY, SECRET_KEY});
        S3FileSystem result = this.createFileSystem(uri, accessKey, secretKey);
        if (!this.fileSystem.compareAndSet(null, result)) {
            throw new FileSystemAlreadyExistsException("S3 filesystem already exists. Use getFileSystem() instead");
        }
        return result;
    }

    @Override
    public FileSystem getFileSystem(URI uri) {
        FileSystem fileSystem = this.fileSystem.get();
        if (fileSystem == null) {
            throw new FileSystemNotFoundException(String.format("S3 filesystem not yet created. Use newFileSystem() instead", new Object[0]));
        }
        return fileSystem;
    }

    @Override
    public Path getPath(URI uri) {
        Preconditions.checkArgument((boolean)uri.getScheme().equals(this.getScheme()), (String)"URI scheme must be %s", (Object[])new Object[]{this.getScheme()});
        if (uri.getHost() != null && !uri.getHost().isEmpty() && !uri.getHost().equals(this.fileSystem.get().getEndpoint())) {
            throw new IllegalArgumentException(String.format("only empty URI host or URI host that matching the current fileSystem: %s", this.fileSystem.get().getEndpoint()));
        }
        return this.getFileSystem(uri).getPath(uri.getPath(), new String[0]);
    }

    @Override
    public DirectoryStream<Path> newDirectoryStream(Path dir, DirectoryStream.Filter<? super Path> filter) throws IOException {
        Preconditions.checkArgument((boolean)(dir instanceof S3Path), (String)"path must be an instance of %s", (Object[])new Object[]{S3Path.class.getName()});
        final S3Path s3Path = (S3Path)dir;
        return new DirectoryStream<Path>(){

            @Override
            public void close() throws IOException {
            }

            @Override
            public Iterator<Path> iterator() {
                return new S3Iterator(s3Path.getFileSystem(), s3Path.getBucket(), s3Path.getKey() + "/");
            }
        };
    }

    @Override
    public InputStream newInputStream(Path path, OpenOption ... options) throws IOException {
        Preconditions.checkArgument((options.length == 0 ? 1 : 0) != 0, (String)"OpenOptions not yet supported: %s", (Object[])new Object[]{ImmutableList.copyOf((Object[])options)});
        Preconditions.checkArgument((boolean)(path instanceof S3Path), (String)"path must be an instance of %s", (Object[])new Object[]{S3Path.class.getName()});
        S3Path s3Path = (S3Path)path;
        Preconditions.checkArgument((!s3Path.getKey().equals("") ? 1 : 0) != 0, (String)"cannot create InputStream for root directory: %s", (Object[])new Object[]{s3Path});
        S3ObjectInputStream res = s3Path.getFileSystem().getClient().getObject(s3Path.getBucket(), s3Path.getKey()).getObjectContent();
        if (res == null) {
            throw new IOException("path is a directory");
        }
        return res;
    }

    @Override
    public OutputStream newOutputStream(Path path, OpenOption ... options) throws IOException {
        Preconditions.checkArgument((boolean)(path instanceof S3Path), (String)"path must be an instance of %s", (Object[])new Object[]{S3Path.class.getName()});
        return super.newOutputStream(path, options);
    }

    @Override
    public SeekableByteChannel newByteChannel(Path path, Set<? extends OpenOption> options, FileAttribute<?> ... attrs) throws IOException {
        Preconditions.checkArgument((boolean)(path instanceof S3Path), (String)"path must be an instance of %s", (Object[])new Object[]{S3Path.class.getName()});
        final S3Path s3Path = (S3Path)path;
        final Path tempFile = this.createTempDir().resolve(path.getFileName().toString());
        if (Files.exists(path, new LinkOption[0])) {
            S3ObjectInputStream is = s3Path.getFileSystem().getClient().getObject(s3Path.getBucket(), s3Path.getKey()).getObjectContent();
            Files.write(tempFile, IOUtils.toByteArray((InputStream)is), new OpenOption[0]);
        }
        final SeekableByteChannel seekable = Files.newByteChannel(tempFile, options, new FileAttribute[0]);
        return new SeekableByteChannel(){

            @Override
            public boolean isOpen() {
                return seekable.isOpen();
            }

            @Override
            public void close() throws IOException {
                seekable.close();
                if (Files.exists(tempFile, new LinkOption[0])) {
                    ObjectMetadata metadata = new ObjectMetadata();
                    metadata.setContentLength(Files.size(tempFile));
                    metadata.setContentType(S3FileSystemProvider.this.fileTypeDetector.probeContentType(tempFile));
                    try (InputStream stream = Files.newInputStream(tempFile, new OpenOption[0]);){
                        s3Path.getFileSystem().getClient().putObject(s3Path.getBucket(), s3Path.getKey(), stream, metadata);
                    }
                } else {
                    s3Path.getFileSystem().getClient().deleteObject(s3Path.getBucket(), s3Path.getKey());
                }
                Files.deleteIfExists(tempFile);
                Files.deleteIfExists(tempFile.getParent());
            }

            @Override
            public int write(ByteBuffer src) throws IOException {
                return seekable.write(src);
            }

            @Override
            public SeekableByteChannel truncate(long size) throws IOException {
                return seekable.truncate(size);
            }

            @Override
            public long size() throws IOException {
                return seekable.size();
            }

            @Override
            public int read(ByteBuffer dst) throws IOException {
                return seekable.read(dst);
            }

            @Override
            public SeekableByteChannel position(long newPosition) throws IOException {
                return seekable.position(newPosition);
            }

            @Override
            public long position() throws IOException {
                return seekable.position();
            }
        };
    }

    @Override
    public void createDirectory(Path dir, FileAttribute<?> ... attrs) throws IOException {
        S3Path s3Path = (S3Path)dir;
        Preconditions.checkArgument((attrs.length == 0 ? 1 : 0) != 0, (String)"attrs not yet supported: %s", (Object[])new Object[]{ImmutableList.copyOf((Object[])attrs)});
        ObjectMetadata metadata = new ObjectMetadata();
        metadata.setContentLength(0L);
        String keyName = s3Path.getKey() + (s3Path.getKey().endsWith("/") ? "" : "/");
        s3Path.getFileSystem().getClient().putObject(s3Path.getBucket(), keyName, new ByteArrayInputStream(new byte[0]), metadata);
    }

    @Override
    public void delete(Path path) throws IOException {
        Preconditions.checkArgument((boolean)(path instanceof S3Path), (String)"path must be an instance of %s", (Object[])new Object[]{S3Path.class.getName()});
        S3Path s3Path = (S3Path)path;
        if (Files.notExists(path, new LinkOption[0])) {
            throw new NoSuchFileException("the path: " + path + " not exists");
        }
        if (Files.isDirectory(path, new LinkOption[0])) {
            try (DirectoryStream<Path> stream = Files.newDirectoryStream(path);){
                if (stream.iterator().hasNext()) {
                    throw new DirectoryNotEmptyException("the path: " + path + " is a directory and is not empty");
                }
            }
        }
        s3Path.getFileSystem().getClient().deleteObject(s3Path.getBucket(), s3Path.getKey());
        s3Path.getFileSystem().getClient().deleteObject(s3Path.getBucket(), s3Path.getKey() + "/");
    }

    @Override
    public void copy(Path source, Path target, CopyOption ... options) throws IOException {
        Preconditions.checkArgument((boolean)(source instanceof S3Path), (String)"source must be an instance of %s", (Object[])new Object[]{S3Path.class.getName()});
        Preconditions.checkArgument((boolean)(target instanceof S3Path), (String)"target must be an instance of %s", (Object[])new Object[]{S3Path.class.getName()});
        if (this.isSameFile(source, target)) {
            return;
        }
        S3Path s3Source = (S3Path)source;
        S3Path s3Target = (S3Path)target;
        ImmutableSet actualOptions = ImmutableSet.copyOf((Object[])options);
        this.verifySupportedOptions((Set)EnumSet.of(StandardCopyOption.REPLACE_EXISTING), (Set)actualOptions);
        if (!actualOptions.contains((Object)StandardCopyOption.REPLACE_EXISTING) && this.exists(s3Target)) {
            throw new FileAlreadyExistsException(String.format("target already exists: %s", target));
        }
        s3Source.getFileSystem().getClient().copyObject(s3Source.getBucket(), s3Source.getKey(), s3Target.getBucket(), s3Target.getKey());
    }

    @Override
    public void move(Path source, Path target, CopyOption ... options) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isSameFile(Path path1, Path path2) throws IOException {
        return path1.isAbsolute() && path2.isAbsolute() && path1.equals(path2);
    }

    @Override
    public boolean isHidden(Path path) throws IOException {
        return false;
    }

    @Override
    public FileStore getFileStore(Path path) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void checkAccess(Path path, AccessMode ... modes) throws IOException {
        S3Path s3Path = (S3Path)path;
        Preconditions.checkArgument((boolean)s3Path.isAbsolute(), (String)"path must be absolute: %s", (Object[])new Object[]{s3Path});
        AmazonS3Client client = s3Path.getFileSystem().getClient();
        AccessControlList acl = this.getAccessControl(s3Path);
        block5: for (AccessMode accessMode : modes) {
            switch (accessMode) {
                case EXECUTE: {
                    throw new AccessDeniedException(s3Path.toString(), null, "file is not executable");
                }
                case READ: {
                    if (this.hasPermissions(acl, client.getS3AccountOwner(), EnumSet.of(Permission.FullControl, Permission.Read))) continue block5;
                    throw new AccessDeniedException(s3Path.toString(), null, "file is not readable");
                }
                case WRITE: {
                    if (this.hasPermissions(acl, client.getS3AccountOwner(), EnumSet.of(Permission.FullControl, Permission.Write))) continue block5;
                    throw new AccessDeniedException(s3Path.toString(), null, String.format("bucket '%s' is not writable", s3Path.getBucket()));
                }
            }
        }
    }

    private boolean hasPermissions(AccessControlList acl, Owner owner, EnumSet<Permission> permissions) {
        boolean result = false;
        for (Grant grant : acl.getGrants()) {
            if (!grant.getGrantee().getIdentifier().equals(owner.getId()) || !permissions.contains(grant.getPermission())) continue;
            result = true;
            break;
        }
        return result;
    }

    @Override
    public <V extends FileAttributeView> V getFileAttributeView(Path path, Class<V> type, LinkOption ... options) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <A extends BasicFileAttributes> A readAttributes(Path path, Class<A> type, LinkOption ... options) throws IOException {
        Preconditions.checkArgument((boolean)(path instanceof S3Path), (String)"path must be an instance of %s", (Object[])new Object[]{S3Path.class.getName()});
        S3Path s3Path = (S3Path)path;
        if (type == BasicFileAttributes.class) {
            S3ObjectSummary objectSummary = this.s3ObjectSummaryLookup.lookup(s3Path);
            FileTime lastModifiedTime = FileTime.from(objectSummary.getLastModified().getTime(), TimeUnit.MILLISECONDS);
            long size = objectSummary.getSize();
            boolean directory = false;
            boolean regularFile = false;
            String key = objectSummary.getKey();
            if (objectSummary.getKey().equals(s3Path.getKey() + "/") && objectSummary.getKey().endsWith("/")) {
                directory = true;
            } else if (!objectSummary.getKey().equals(s3Path.getKey()) && objectSummary.getKey().startsWith(s3Path.getKey())) {
                directory = true;
                size = 0L;
                key = s3Path.getKey() + "/";
            } else {
                regularFile = true;
            }
            return (A)((BasicFileAttributes)type.cast(new S3FileAttributes(key, lastModifiedTime, size, directory, regularFile)));
        }
        throw new UnsupportedOperationException(String.format("only %s supported", BasicFileAttributes.class));
    }

    @Override
    public Map<String, Object> readAttributes(Path path, String attributes, LinkOption ... options) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setAttribute(Path path, String attribute, Object value, LinkOption ... options) throws IOException {
        throw new UnsupportedOperationException();
    }

    protected S3FileSystem createFileSystem(URI uri, Object accessKey, Object secretKey) {
        AmazonS3Client client = accessKey == null && secretKey == null ? new AmazonS3Client((AmazonS3)new com.amazonaws.services.s3.AmazonS3Client()) : new AmazonS3Client((AmazonS3)new com.amazonaws.services.s3.AmazonS3Client((AWSCredentials)new BasicAWSCredentials(accessKey.toString(), secretKey.toString())));
        if (uri.getHost() != null) {
            client.setEndpoint(uri.getHost());
        }
        S3FileSystem result = new S3FileSystem(this, client, uri.getHost());
        return result;
    }

    protected Properties loadAmazonProperties() {
        Properties props = new Properties();
        try (InputStream in = Thread.currentThread().getContextClassLoader().getResourceAsStream("amazon.properties");){
            if (in != null) {
                props.load(in);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return props;
    }

    private <T> void verifySupportedOptions(Set<? extends T> allowedOptions, Set<? extends T> actualOptions) {
        Sets.SetView unsupported = Sets.difference(actualOptions, allowedOptions);
        Preconditions.checkArgument((boolean)unsupported.isEmpty(), (String)"the following options are not supported: %s", (Object[])new Object[]{unsupported});
    }

    private boolean exists(S3Path path) {
        try {
            this.s3ObjectSummaryLookup.lookup(path);
            return true;
        }
        catch (NoSuchFileException e) {
            return false;
        }
    }

    private AccessControlList getAccessControl(S3Path path) throws NoSuchFileException {
        S3ObjectSummary obj = this.s3ObjectSummaryLookup.lookup(path);
        return path.getFileSystem().getClient().getObjectAcl(obj.getBucketName(), obj.getKey());
    }

    protected Path createTempDir() throws IOException {
        return Files.createTempDirectory("temp-s3-", new FileAttribute[0]);
    }
}

