/*
 * Decompiled with CFR 0.152.
 */
package com.upplication.s3fs;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.upplication.s3fs.S3FileSystem;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;

public class S3Path
implements Path {
    public static final String PATH_SEPARATOR = "/";
    private final String bucket;
    private final List<String> parts;
    private S3FileSystem fileSystem;

    public S3Path(S3FileSystem fileSystem, String path) {
        this(fileSystem, path, "");
    }

    public S3Path(S3FileSystem fileSystem, String first, String ... more) {
        String bucket = null;
        List parts = Lists.newArrayList((Iterable)Splitter.on((String)PATH_SEPARATOR).split((CharSequence)first));
        if (first.endsWith(PATH_SEPARATOR)) {
            parts.remove(parts.size() - 1);
        }
        if (first.startsWith(PATH_SEPARATOR)) {
            Preconditions.checkArgument((parts.size() >= 1 ? 1 : 0) != 0, (Object)"path must start with bucket name");
            Preconditions.checkArgument((!((String)parts.get(1)).isEmpty() ? 1 : 0) != 0, (Object)"bucket name must be not empty");
            bucket = (String)parts.get(1);
            if (!parts.isEmpty()) {
                parts = parts.subList(2, parts.size());
            }
        }
        if (bucket != null) {
            bucket = bucket.replace(PATH_SEPARATOR, "");
        }
        ArrayList moreSplitted = Lists.newArrayList();
        for (String part : more) {
            moreSplitted.addAll(Lists.newArrayList((Iterable)Splitter.on((String)PATH_SEPARATOR).split((CharSequence)part)));
        }
        parts.addAll(moreSplitted);
        this.bucket = bucket;
        this.parts = KeyParts.parse(parts);
        this.fileSystem = fileSystem;
    }

    private S3Path(S3FileSystem fileSystem, String bucket, Iterable<String> keys) {
        this.bucket = bucket;
        this.parts = KeyParts.parse(keys);
        this.fileSystem = fileSystem;
    }

    public String getBucket() {
        return this.bucket;
    }

    public String getKey() {
        if (this.parts.isEmpty()) {
            return "";
        }
        ImmutableList.Builder builder = ImmutableList.builder().addAll(this.parts);
        return Joiner.on((String)PATH_SEPARATOR).join((Iterable)builder.build());
    }

    @Override
    public S3FileSystem getFileSystem() {
        return this.fileSystem;
    }

    @Override
    public boolean isAbsolute() {
        return this.bucket != null;
    }

    @Override
    public Path getRoot() {
        if (this.isAbsolute()) {
            return new S3Path(this.fileSystem, this.bucket, (Iterable<String>)ImmutableList.of());
        }
        return null;
    }

    @Override
    public Path getFileName() {
        if (!this.parts.isEmpty()) {
            return new S3Path(this.fileSystem, null, this.parts.subList(this.parts.size() - 1, this.parts.size()));
        }
        return null;
    }

    @Override
    public Path getParent() {
        if (this.parts.isEmpty()) {
            return null;
        }
        if (this.parts.size() == 1 && (this.bucket == null || this.bucket.isEmpty())) {
            return null;
        }
        return new S3Path(this.fileSystem, this.bucket, this.parts.subList(0, this.parts.size() - 1));
    }

    @Override
    public int getNameCount() {
        return this.parts.size();
    }

    @Override
    public Path getName(int index) {
        return new S3Path(this.fileSystem, null, this.parts.subList(index, index + 1));
    }

    @Override
    public Path subpath(int beginIndex, int endIndex) {
        return new S3Path(this.fileSystem, null, this.parts.subList(beginIndex, endIndex));
    }

    @Override
    public boolean startsWith(Path other) {
        if (other.getNameCount() > this.getNameCount()) {
            return false;
        }
        if (!(other instanceof S3Path)) {
            return false;
        }
        S3Path path = (S3Path)other;
        if (path.parts.size() == 0 && path.bucket == null && (this.parts.size() != 0 || this.bucket != null)) {
            return false;
        }
        if (path.getBucket() != null && !path.getBucket().equals(this.getBucket()) || path.getBucket() == null && this.getBucket() != null) {
            return false;
        }
        for (int i = 0; i < path.parts.size(); ++i) {
            if (path.parts.get(i).equals(this.parts.get(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean startsWith(String path) {
        S3Path other = new S3Path(this.fileSystem, path);
        return this.startsWith(other);
    }

    @Override
    public boolean endsWith(Path other) {
        if (other.getNameCount() > this.getNameCount()) {
            return false;
        }
        if (other.getNameCount() == 0 && this.getNameCount() != 0) {
            return false;
        }
        if (!(other instanceof S3Path)) {
            return false;
        }
        S3Path path = (S3Path)other;
        if (path.getBucket() != null && !path.getBucket().equals(this.getBucket()) || path.getBucket() != null && this.getBucket() == null) {
            return false;
        }
        int i = path.parts.size() - 1;
        for (int j = this.parts.size() - 1; i >= 0 && j >= 0; --i, --j) {
            if (path.parts.get(i).equals(this.parts.get(j))) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean endsWith(String other) {
        return this.endsWith(new S3Path(this.fileSystem, other));
    }

    @Override
    public Path normalize() {
        return this;
    }

    @Override
    public Path resolve(Path other) {
        Preconditions.checkArgument((boolean)(other instanceof S3Path), (String)"other must be an instance of %s", (Object[])new Object[]{S3Path.class.getName()});
        S3Path s3Path = (S3Path)other;
        if (s3Path.isAbsolute()) {
            return s3Path;
        }
        if (s3Path.parts.isEmpty()) {
            return this;
        }
        return new S3Path(this.fileSystem, this.bucket, Iterables.concat(this.parts, s3Path.parts));
    }

    @Override
    public Path resolve(String other) {
        return this.resolve(new S3Path(this.getFileSystem(), other));
    }

    @Override
    public Path resolveSibling(Path other) {
        Preconditions.checkArgument((boolean)(other instanceof S3Path), (String)"other must be an instance of %s", (Object[])new Object[]{S3Path.class.getName()});
        S3Path s3Path = (S3Path)other;
        Path parent = this.getParent();
        if (parent == null || s3Path.isAbsolute()) {
            return s3Path;
        }
        if (s3Path.parts.isEmpty()) {
            return parent;
        }
        return new S3Path(this.fileSystem, this.bucket, Iterables.concat(this.parts.subList(0, this.parts.size() - 1), s3Path.parts));
    }

    @Override
    public Path resolveSibling(String other) {
        return this.resolveSibling(new S3Path(this.getFileSystem(), other));
    }

    @Override
    public Path relativize(Path other) {
        Preconditions.checkArgument((boolean)(other instanceof S3Path), (String)"other must be an instance of %s", (Object[])new Object[]{S3Path.class.getName()});
        S3Path s3Path = (S3Path)other;
        if (this.equals(other)) {
            return new S3Path(this.getFileSystem(), "");
        }
        Preconditions.checkArgument((boolean)this.isAbsolute(), (String)"Path is already relative: %s", (Object[])new Object[]{this});
        Preconditions.checkArgument((boolean)s3Path.isAbsolute(), (String)"Cannot relativize against a relative path: %s", (Object[])new Object[]{s3Path});
        Preconditions.checkArgument((boolean)this.bucket.equals(s3Path.getBucket()), (String)"Cannot relativize paths with different buckets: '%s', '%s'", (Object[])new Object[]{this, other});
        Preconditions.checkArgument((this.parts.size() <= s3Path.parts.size() ? 1 : 0) != 0, (String)"Cannot relativize against a parent path: '%s', '%s'", (Object[])new Object[]{this, other});
        int startPart = 0;
        for (int i = 0; i < this.parts.size(); ++i) {
            if (!this.parts.get(i).equals(s3Path.parts.get(i))) continue;
            ++startPart;
        }
        ArrayList<String> resultParts = new ArrayList<String>();
        for (int i = startPart; i < s3Path.parts.size(); ++i) {
            resultParts.add(s3Path.parts.get(i));
        }
        return new S3Path(this.fileSystem, null, resultParts);
    }

    @Override
    public URI toUri() {
        StringBuilder builder = new StringBuilder();
        builder.append("s3://");
        if (this.fileSystem.getEndpoint() != null) {
            builder.append(this.fileSystem.getEndpoint());
        }
        builder.append(PATH_SEPARATOR);
        builder.append(this.bucket);
        builder.append(PATH_SEPARATOR);
        builder.append(Joiner.on((String)PATH_SEPARATOR).join(this.parts));
        return URI.create(builder.toString());
    }

    @Override
    public Path toAbsolutePath() {
        if (this.isAbsolute()) {
            return this;
        }
        throw new IllegalStateException(String.format("Relative path cannot be made absolute: %s", this));
    }

    @Override
    public Path toRealPath(LinkOption ... options) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public File toFile() {
        throw new UnsupportedOperationException();
    }

    @Override
    public WatchKey register(WatchService watcher, WatchEvent.Kind<?>[] events, WatchEvent.Modifier ... modifiers) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public WatchKey register(WatchService watcher, WatchEvent.Kind<?> ... events) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterator<Path> iterator() {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (String part : this.parts) {
            builder.add((Object)new S3Path(this.fileSystem, null, (Iterable<String>)ImmutableList.of((Object)part)));
        }
        return builder.build().iterator();
    }

    @Override
    public int compareTo(Path other) {
        return this.toString().compareTo(other.toString());
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        if (this.isAbsolute()) {
            builder.append(PATH_SEPARATOR);
            builder.append(this.bucket);
            builder.append(PATH_SEPARATOR);
        }
        builder.append(Joiner.on((String)PATH_SEPARATOR).join(this.parts));
        return builder.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        S3Path paths = (S3Path)o;
        if (this.bucket != null ? !this.bucket.equals(paths.bucket) : paths.bucket != null) {
            return false;
        }
        return this.parts.equals(paths.parts);
    }

    @Override
    public int hashCode() {
        int result = this.bucket != null ? this.bucket.hashCode() : 0;
        result = 31 * result + this.parts.hashCode();
        return result;
    }

    private static Function<String, String> strip(final String ... strs) {
        return new Function<String, String>(){

            public String apply(String input) {
                String res = input;
                for (String str : strs) {
                    res = res.replace(str, "");
                }
                return res;
            }
        };
    }

    private static Predicate<String> notEmpty() {
        return new Predicate<String>(){

            public boolean apply(@Nullable String input) {
                return input != null && !input.isEmpty();
            }
        };
    }

    private static abstract class KeyParts {
        private KeyParts() {
        }

        private static ImmutableList<String> parse(List<String> parts) {
            return ImmutableList.copyOf((Iterable)Iterables.filter((Iterable)Iterables.transform(parts, (Function)S3Path.strip(new String[]{S3Path.PATH_SEPARATOR})), (Predicate)S3Path.notEmpty()));
        }

        private static ImmutableList<String> parse(Iterable<String> parts) {
            return ImmutableList.copyOf((Iterable)Iterables.filter((Iterable)Iterables.transform(parts, (Function)S3Path.strip(new String[]{S3Path.PATH_SEPARATOR})), (Predicate)S3Path.notEmpty()));
        }
    }
}

