/*
 * Decompiled with CFR 0.152.
 */
package com.upplication.s3fs;

import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.model.AccessControlList;
import com.amazonaws.services.s3.model.Bucket;
import com.amazonaws.services.s3.model.CopyObjectResult;
import com.amazonaws.services.s3.model.ListObjectsRequest;
import com.amazonaws.services.s3.model.ObjectListing;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.Owner;
import com.amazonaws.services.s3.model.PutObjectResult;
import com.amazonaws.services.s3.model.S3Object;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.util.List;

public class AmazonS3Client {
    private AmazonS3 client;

    public AmazonS3Client(AmazonS3 client) {
        this.client = client;
    }

    public List<Bucket> listBuckets() {
        return this.client.listBuckets();
    }

    public ObjectListing listObjects(ListObjectsRequest request) {
        return this.client.listObjects(request);
    }

    public S3Object getObject(String bucketName, String key) {
        return this.client.getObject(bucketName, key);
    }

    public PutObjectResult putObject(String bucket, String key, File file) {
        return this.client.putObject(bucket, key, file);
    }

    public PutObjectResult putObject(String bucket, String keyName, ByteArrayInputStream byteArrayInputStream, ObjectMetadata metadata) {
        return this.client.putObject(bucket, keyName, (InputStream)byteArrayInputStream, metadata);
    }

    public void deleteObject(String bucket, String key) {
        this.client.deleteObject(bucket, key);
    }

    public CopyObjectResult copyObject(String sourceBucketName, String sourceKey, String destinationBucketName, String destinationKey) {
        return this.client.copyObject(sourceBucketName, sourceKey, destinationBucketName, destinationKey);
    }

    public AccessControlList getBucketAcl(String bucket) {
        return this.client.getBucketAcl(bucket);
    }

    public Owner getS3AccountOwner() {
        return this.client.getS3AccountOwner();
    }

    public void setEndpoint(String endpoint) {
        this.client.setEndpoint(endpoint);
    }

    public AccessControlList getObjectAcl(String bucketName, String key) {
        return this.client.getObjectAcl(bucketName, key);
    }

    public ObjectMetadata getObjectMetadata(String bucketName, String key) {
        return this.client.getObjectMetadata(bucketName, key);
    }

    public ObjectListing listNextBatchOfObjects(ObjectListing objectListing) {
        return this.client.listNextBatchOfObjects(objectListing);
    }
}

