/*
 * Decompiled with CFR 0.152.
 */
package com.upokecenter.cbor;

import com.upokecenter.cbor.ICBORNumber;
import com.upokecenter.numbers.EDecimal;
import com.upokecenter.numbers.EFloat;
import com.upokecenter.numbers.EInteger;
import com.upokecenter.numbers.ERational;

class CBOREInteger
implements ICBORNumber {
    CBOREInteger() {
    }

    @Override
    public boolean IsPositiveInfinity(Object obj) {
        return false;
    }

    @Override
    public boolean IsInfinity(Object obj) {
        return false;
    }

    @Override
    public boolean IsNegativeInfinity(Object obj) {
        return false;
    }

    @Override
    public boolean IsNaN(Object obj) {
        return false;
    }

    @Override
    public double AsDouble(Object obj) {
        return EFloat.FromEInteger((EInteger)((EInteger)obj)).ToDouble();
    }

    @Override
    public EDecimal AsEDecimal(Object obj) {
        return EDecimal.FromEInteger((EInteger)((EInteger)obj));
    }

    @Override
    public EFloat AsEFloat(Object obj) {
        return EFloat.FromEInteger((EInteger)((EInteger)obj));
    }

    @Override
    public float AsSingle(Object obj) {
        return EFloat.FromEInteger((EInteger)((EInteger)obj)).ToSingle();
    }

    @Override
    public EInteger AsEInteger(Object obj) {
        return (EInteger)obj;
    }

    @Override
    public long AsInt64(Object obj) {
        EInteger bi = (EInteger)obj;
        if (!bi.CanFitInInt64()) {
            throw new ArithmeticException("This object's value is out of range");
        }
        return bi.ToInt64Checked();
    }

    @Override
    public boolean CanFitInSingle(Object obj) {
        EFloat ef2;
        EInteger bigintItem = (EInteger)obj;
        EFloat ef = EFloat.FromEInteger((EInteger)bigintItem);
        return ef.compareTo(ef2 = EFloat.FromSingle((float)ef.ToSingle())) == 0;
    }

    @Override
    public boolean CanFitInDouble(Object obj) {
        EFloat ef2;
        EInteger bigintItem = (EInteger)obj;
        EFloat ef = EFloat.FromEInteger((EInteger)bigintItem);
        return ef.compareTo(ef2 = EFloat.FromDouble((double)ef.ToDouble())) == 0;
    }

    @Override
    public boolean CanFitInInt32(Object obj) {
        EInteger bi = (EInteger)obj;
        return bi.CanFitInInt32();
    }

    @Override
    public boolean CanFitInInt64(Object obj) {
        EInteger bi = (EInteger)obj;
        return bi.CanFitInInt64();
    }

    @Override
    public boolean CanFitInUInt64(Object obj) {
        EInteger bi = (EInteger)obj;
        return bi.signum() >= 0 && bi.GetUnsignedBitLengthAsInt64() <= 64L;
    }

    @Override
    public boolean CanTruncatedIntFitInInt64(Object obj) {
        return this.CanFitInInt64(obj);
    }

    @Override
    public boolean CanTruncatedIntFitInUInt64(Object obj) {
        return this.CanFitInUInt64(obj);
    }

    @Override
    public boolean CanTruncatedIntFitInInt32(Object obj) {
        return this.CanFitInInt32(obj);
    }

    @Override
    public boolean IsNumberZero(Object obj) {
        return ((EInteger)obj).isZero();
    }

    @Override
    public int Sign(Object obj) {
        return ((EInteger)obj).signum();
    }

    @Override
    public boolean IsIntegral(Object obj) {
        return true;
    }

    @Override
    public int AsInt32(Object obj, int minValue, int maxValue) {
        int ret;
        EInteger bi = (EInteger)obj;
        if (bi.CanFitInInt32() && (ret = bi.ToInt32Checked()) >= minValue && ret <= maxValue) {
            return ret;
        }
        throw new ArithmeticException("This Object's value is out of range");
    }

    @Override
    public Object Negate(Object obj) {
        EInteger bigobj = (EInteger)obj;
        bigobj = bigobj.Negate();
        return bigobj;
    }

    @Override
    public Object Abs(Object obj) {
        return ((EInteger)obj).Abs();
    }

    @Override
    public ERational AsERational(Object obj) {
        return ERational.FromEInteger((EInteger)((EInteger)obj));
    }

    @Override
    public boolean IsNegative(Object obj) {
        return ((EInteger)obj).signum() < 0;
    }
}

