/*
 * Decompiled with CFR 0.152.
 */
package com.upokecenter.cbor;

import com.upokecenter.util.DataUtilities;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

final class OptionsParser {
    private final Map<String, String> dict = new HashMap<String, String>();

    private static String[] SplitAt(String str, String delimiter) {
        if (delimiter == null) {
            throw new NullPointerException("delimiter");
        }
        if (delimiter.length() == 0) {
            throw new IllegalArgumentException("delimiter is empty.");
        }
        if (str == null || str.length() == 0) {
            return new String[]{""};
        }
        int index = 0;
        boolean first = true;
        ArrayList<String> strings = null;
        int delimLength = delimiter.length();
        while (true) {
            int index2;
            if ((index2 = str.indexOf(delimiter, index)) < 0) {
                if (first) {
                    String[] strret = new String[]{str};
                    return strret;
                }
                break;
            }
            first = false;
            String newstr = str.substring(index, index + (index2 - index));
            strings = strings == null ? new ArrayList<String>() : strings;
            strings.add(newstr);
            index = index2 + delimLength;
        }
        strings = strings == null ? new ArrayList<String>() : strings;
        strings.add(str.substring(index));
        return strings.toArray(new String[0]);
    }

    public OptionsParser(String options) {
        if (options == null) {
            throw new NullPointerException("options");
        }
        if (options.length() > 0) {
            String[] optionsArray;
            for (String opt : optionsArray = OptionsParser.SplitAt(options, ";")) {
                int index = opt.indexOf(61);
                if (index < 0) {
                    throw new IllegalArgumentException("Invalid options String: " + options);
                }
                String key = DataUtilities.ToLowerCaseAscii((String)opt.substring(0, index));
                String value = opt.substring(index + 1);
                this.dict.put(key, value);
            }
        }
    }

    public String GetLCString(String key, String defaultValue) {
        String lckey = DataUtilities.ToLowerCaseAscii((String)key);
        if (this.dict.containsKey(lckey)) {
            String lcvalue = DataUtilities.ToLowerCaseAscii((String)this.dict.get(lckey));
            return lcvalue;
        }
        return defaultValue;
    }

    public boolean GetBoolean(String key, boolean defaultValue) {
        String lckey = DataUtilities.ToLowerCaseAscii((String)key);
        if (this.dict.containsKey(lckey)) {
            String lcvalue = DataUtilities.ToLowerCaseAscii((String)this.dict.get(lckey));
            return lcvalue.equals("1") || lcvalue.equals("yes") || lcvalue.equals("on") || lcvalue.equals("true");
        }
        return defaultValue;
    }
}

