/*
 * Decompiled with CFR 0.152.
 */
package com.upokecenter.cbor;

import com.upokecenter.cbor.CBORDataUtilities;
import com.upokecenter.cbor.CBORException;
import com.upokecenter.cbor.CBORObject;
import com.upokecenter.cbor.CharacterInputWithCount;
import com.upokecenter.cbor.JSONOptions;
import java.util.ArrayList;
import java.util.TreeMap;

final class CBORJson {
    private final JSONOptions options;
    private CharacterInputWithCount reader;
    private StringBuilder sb;
    private boolean jsonSequenceMode;
    private boolean recordSeparatorSeen;

    private int SkipWhitespaceJSON() {
        int c;
        while ((c = this.ReadChar()) != -1 && (c == 32 || c == 10 || c == 13 || c == 9)) {
        }
        return c;
    }

    private int SkipWhitespaceJSON(int lastChar) {
        while (lastChar == 32 || lastChar == 10 || lastChar == 13 || lastChar == 9) {
            lastChar = this.ReadChar();
        }
        return lastChar;
    }

    public void SkipToEnd() {
        if (this.jsonSequenceMode) {
            while (this.ReadChar() >= 0) {
            }
        }
    }

    public int ReadChar() {
        if (this.jsonSequenceMode) {
            if (this.recordSeparatorSeen) {
                return -1;
            }
            int rc = this.reader.ReadChar();
            if (rc == 30) {
                this.recordSeparatorSeen = true;
                return -1;
            }
            return rc;
        }
        return this.reader.ReadChar();
    }

    private void RaiseError(String str) {
        this.reader.RaiseError(str);
    }

    private String NextJSONString() {
        this.sb = this.sb == null ? new StringBuilder() : this.sb;
        this.sb.delete(0, this.sb.length());
        block13: while (true) {
            int c;
            if ((c = this.ReadChar()) == -1 || c < 32) {
                this.RaiseError("Unterminated String");
            }
            switch (c) {
                case 92: {
                    c = this.ReadChar();
                    switch (c) {
                        case 34: 
                        case 47: 
                        case 92: {
                            this.sb.append((char)c);
                            continue block13;
                        }
                        case 98: {
                            this.sb.append('\b');
                            continue block13;
                        }
                        case 102: {
                            this.sb.append('\f');
                            continue block13;
                        }
                        case 110: {
                            this.sb.append('\n');
                            continue block13;
                        }
                        case 114: {
                            this.sb.append('\r');
                            continue block13;
                        }
                        case 116: {
                            this.sb.append('\t');
                            continue block13;
                        }
                        case 117: {
                            c = 0;
                            for (int i = 0; i < 4; ++i) {
                                int ch = this.ReadChar();
                                if (ch >= 48 && ch <= 57) {
                                    c <<= 4;
                                    c |= ch - 48;
                                    continue;
                                }
                                if (ch >= 65 && ch <= 70) {
                                    c <<= 4;
                                    c |= ch + 10 - 65;
                                    continue;
                                }
                                if (ch >= 97 && ch <= 102) {
                                    c <<= 4;
                                    c |= ch + 10 - 97;
                                    continue;
                                }
                                this.RaiseError("Invalid Unicode escaped character");
                            }
                            if ((c & 0xF800) != 55296) {
                                this.sb.append((char)c);
                                continue block13;
                            }
                            if ((c & 0xFC00) == 55296) {
                                int ch = this.ReadChar();
                                if (ch != 92 || this.ReadChar() != 117) {
                                    this.RaiseError("Invalid escaped character");
                                }
                                int c2 = 0;
                                for (int i = 0; i < 4; ++i) {
                                    ch = this.ReadChar();
                                    if (ch >= 48 && ch <= 57) {
                                        c2 <<= 4;
                                        c2 |= ch - 48;
                                        continue;
                                    }
                                    if (ch >= 65 && ch <= 70) {
                                        c2 <<= 4;
                                        c2 |= ch + 10 - 65;
                                        continue;
                                    }
                                    if (ch >= 97 && ch <= 102) {
                                        c2 <<= 4;
                                        c2 |= ch + 10 - 97;
                                        continue;
                                    }
                                    this.RaiseError("Invalid Unicode escaped character");
                                }
                                if ((c2 & 0xFC00) != 56320) {
                                    this.RaiseError("Unpaired surrogate code point");
                                    continue block13;
                                }
                                this.sb.append((char)c);
                                this.sb.append((char)c2);
                                continue block13;
                            }
                            this.RaiseError("Unpaired surrogate code point");
                            continue block13;
                        }
                    }
                    this.RaiseError("Invalid escaped character");
                    continue block13;
                }
                case 34: {
                    return this.sb.toString();
                }
            }
            if (c >> 16 == 0) {
                this.sb.append((char)c);
                continue;
            }
            this.sb.append((char)(c - 65536 >> 10 & 0x3FF | 0xD800));
            this.sb.append((char)(c - 65536 & 0x3FF | 0xDC00));
        }
    }

    private CBORObject NextJSONNegativeNumber(int[] nextChar, int depth) {
        String str;
        CBORObject obj;
        int c = this.ReadChar();
        if (c < 48 || c > 57) {
            this.RaiseError("JSON number can't be parsed.");
        }
        int cval = -(c - 48);
        int cstart = c;
        c = this.ReadChar();
        this.sb = this.sb == null ? new StringBuilder() : this.sb;
        this.sb.delete(0, this.sb.length());
        this.sb.append('-');
        this.sb.append((char)cstart);
        char[] charbuf = new char[32];
        int charbufptr = 0;
        while (c == 45 || c == 43 || c == 46 || c >= 48 && c <= 57 || c == 101 || c == 69) {
            charbuf[charbufptr++] = (char)c;
            if (charbufptr >= 32) {
                this.sb.append(charbuf, 0, 32);
                charbufptr = 0;
            }
            c = this.ReadChar();
        }
        if (charbufptr > 0) {
            this.sb.append(charbuf, 0, charbufptr);
        }
        if (c != 44 && c != 93 && c != 125 && c != -1 && c != 32 && c != 10 && c != 13 && c != 9) {
            this.RaiseError("Invalid character after JSON number");
        }
        if ((obj = CBORDataUtilities.ParseJSONNumber(str = this.sb.toString(), this.options)) == null) {
            String errstr = str.length() <= 100 ? str : str.substring(0, 100) + "...";
            this.RaiseError("JSON number can't be parsed. " + errstr);
        }
        if (c == 32 || c == 10 || c == 13 || c == 9) {
            nextChar[0] = this.SkipWhitespaceJSON();
        } else if (this.jsonSequenceMode && depth == 0) {
            nextChar[0] = c;
            this.RaiseError("JSON whitespace expected after top-level number in JSON sequence");
        } else {
            nextChar[0] = c;
        }
        return obj;
    }

    private CBORObject NextJSONValue(int firstChar, int[] nextChar, int depth) {
        int c = firstChar;
        CBORObject obj = null;
        if (c < 0) {
            this.RaiseError("Unexpected end of data");
        }
        switch (c) {
            case 34: {
                obj = CBORObject.FromRaw(this.NextJSONString());
                nextChar[0] = this.SkipWhitespaceJSON();
                return obj;
            }
            case 123: {
                obj = this.ParseJSONObject(depth + 1);
                nextChar[0] = this.SkipWhitespaceJSON();
                return obj;
            }
            case 91: {
                obj = this.ParseJSONArray(depth + 1);
                nextChar[0] = this.SkipWhitespaceJSON();
                return obj;
            }
            case 116: {
                c = this.ReadChar();
                if (c != 114 || (c = this.ReadChar()) != 117 || (c = this.ReadChar()) != 101) {
                    this.RaiseError("Value can't be parsed.");
                }
                if ((c = this.ReadChar()) == 32 || c == 10 || c == 13 || c == 9) {
                    nextChar[0] = this.SkipWhitespaceJSON();
                } else if (this.jsonSequenceMode && depth == 0) {
                    nextChar[0] = c;
                    this.RaiseError("JSON whitespace expected after top-level number in JSON sequence");
                } else {
                    nextChar[0] = c;
                }
                return CBORObject.True;
            }
            case 102: {
                c = this.ReadChar();
                if (c != 97 || (c = this.ReadChar()) != 108 || (c = this.ReadChar()) != 115 || (c = this.ReadChar()) != 101) {
                    this.RaiseError("Value can't be parsed.");
                }
                if ((c = this.ReadChar()) == 32 || c == 10 || c == 13 || c == 9) {
                    nextChar[0] = this.SkipWhitespaceJSON();
                } else if (this.jsonSequenceMode && depth == 0) {
                    nextChar[0] = c;
                    this.RaiseError("JSON whitespace expected after top-level number in JSON sequence");
                } else {
                    nextChar[0] = c;
                }
                return CBORObject.False;
            }
            case 110: {
                c = this.ReadChar();
                if (c != 117 || (c = this.ReadChar()) != 108 || (c = this.ReadChar()) != 108) {
                    this.RaiseError("Value can't be parsed.");
                }
                if ((c = this.ReadChar()) == 32 || c == 10 || c == 13 || c == 9) {
                    nextChar[0] = this.SkipWhitespaceJSON();
                } else if (this.jsonSequenceMode && depth == 0) {
                    nextChar[0] = c;
                    this.RaiseError("JSON whitespace expected after top-level number in JSON sequence");
                } else {
                    nextChar[0] = c;
                }
                return CBORObject.Null;
            }
            case 45: {
                return this.NextJSONNegativeNumber(nextChar, depth);
            }
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                int cval = c - 48;
                int cstart = c;
                boolean needObj = true;
                c = this.ReadChar();
                if (c != 45 && c != 43 && c != 46 && (c < 48 || c > 57) && c != 101 && c != 69) {
                    obj = CBORDataUtilities.ParseSmallNumber(cval, this.options);
                    needObj = false;
                } else if (c >= 48 && c <= 57) {
                    int csecond = c;
                    if (cstart == 48) {
                        this.RaiseError("JSON number can't be parsed.");
                    }
                    cval = cval * 10 + (c - 48);
                    c = this.ReadChar();
                    if (c >= 48 && c <= 57) {
                        int digits = 2;
                        int[] ctmp = new int[10];
                        ctmp[0] = cstart;
                        ctmp[1] = csecond;
                        while (digits < 9 && c >= 48 && c <= 57) {
                            cval = cval * 10 + (c - 48);
                            ctmp[digits++] = c;
                            c = this.ReadChar();
                        }
                        if (c == 101 || c == 69 || c == 46 || c >= 48 && c <= 57) {
                            this.sb = this.sb == null ? new StringBuilder() : this.sb;
                            this.sb.delete(0, this.sb.length());
                            for (int vi = 0; vi < digits; ++vi) {
                                this.sb.append((char)ctmp[vi]);
                            }
                        } else {
                            obj = CBORDataUtilities.ParseSmallNumber(cval, this.options);
                            needObj = false;
                        }
                    } else if (c != 45 && c != 43 && c != 46 && c != 101 && c != 69) {
                        obj = CBORDataUtilities.ParseSmallNumber(cval, this.options);
                        needObj = false;
                    } else {
                        this.sb = this.sb == null ? new StringBuilder() : this.sb;
                        this.sb.delete(0, this.sb.length());
                        this.sb.append((char)cstart);
                        this.sb.append((char)csecond);
                    }
                } else {
                    this.sb = this.sb == null ? new StringBuilder() : this.sb;
                    this.sb.delete(0, this.sb.length());
                    this.sb.append((char)cstart);
                }
                if (needObj) {
                    String str;
                    char[] charbuf = new char[32];
                    int charbufptr = 0;
                    while (c == 45 || c == 43 || c == 46 || c >= 48 && c <= 57 || c == 101 || c == 69) {
                        charbuf[charbufptr++] = (char)c;
                        if (charbufptr >= 32) {
                            this.sb.append(charbuf, 0, 32);
                            charbufptr = 0;
                        }
                        c = this.ReadChar();
                    }
                    if (charbufptr > 0) {
                        this.sb.append(charbuf, 0, charbufptr);
                    }
                    if (c != 44 && c != 93 && c != 125 && c != -1 && c != 32 && c != 10 && c != 13 && c != 9) {
                        this.RaiseError("Invalid character after JSON number");
                    }
                    if ((obj = CBORDataUtilities.ParseJSONNumber(str = this.sb.toString(), this.options)) == null) {
                        String errstr = str.length() <= 100 ? str : str.substring(0, 100) + "...";
                        this.RaiseError("JSON number can't be parsed. " + errstr);
                    }
                }
                if (c == 32 || c == 10 || c == 13 || c == 9) {
                    nextChar[0] = this.SkipWhitespaceJSON();
                } else if (this.jsonSequenceMode && depth == 0) {
                    nextChar[0] = c;
                    this.RaiseError("JSON whitespace expected after top-level number in JSON sequence");
                } else {
                    nextChar[0] = c;
                }
                return obj;
            }
        }
        this.RaiseError("Value can't be parsed.");
        return null;
    }

    public CBORJson(CharacterInputWithCount reader, JSONOptions options) {
        this.reader = reader;
        this.sb = null;
        this.options = options;
        this.jsonSequenceMode = false;
        this.recordSeparatorSeen = false;
    }

    public CBORObject ParseJSON(int[] nextChar) {
        int c;
        int n = c = this.jsonSequenceMode ? this.SkipWhitespaceJSON(nextChar[0]) : this.SkipWhitespaceJSON();
        if (c == 91) {
            CBORObject ret = this.ParseJSONArray(0);
            nextChar[0] = this.SkipWhitespaceJSON();
            return ret;
        }
        if (c == 123) {
            CBORObject ret = this.ParseJSONObject(0);
            nextChar[0] = this.SkipWhitespaceJSON();
            return ret;
        }
        return this.NextJSONValue(c, nextChar, 0);
    }

    private void SetJSONSequenceMode() {
        this.jsonSequenceMode = true;
        this.recordSeparatorSeen = false;
    }

    private void ResetJSONSequenceMode() {
        this.jsonSequenceMode = true;
        this.recordSeparatorSeen = false;
    }

    static CBORObject ParseJSONValue(CharacterInputWithCount reader, JSONOptions options, int[] nextChar) {
        CBORJson cj = new CBORJson(reader, options);
        return cj.ParseJSON(nextChar);
    }

    boolean SkipRecordSeparators(int[] nextChar, boolean recordSeparatorSeen) {
        if (this.jsonSequenceMode) {
            while (true) {
                int rc;
                nextChar[0] = rc = this.reader.ReadChar();
                if (rc != 30) break;
                recordSeparatorSeen = true;
            }
            return recordSeparatorSeen;
        }
        nextChar[0] = -1;
        return false;
    }

    static CBORObject[] ParseJSONSequence(CharacterInputWithCount reader, JSONOptions options, int[] nextChar) {
        ArrayList<CBORObject> list;
        block9: {
            CBORJson cj = new CBORJson(reader, options);
            cj.SetJSONSequenceMode();
            boolean seenSeparator = cj.SkipRecordSeparators(nextChar, false);
            if (nextChar[0] >= 0 && !seenSeparator) {
                cj.RaiseError("Not a JSON text sequence");
            } else {
                if (nextChar[0] < 0 && !seenSeparator) {
                    return new CBORObject[0];
                }
                if (nextChar[0] < 0) {
                    return new CBORObject[]{null};
                }
            }
            list = new ArrayList<CBORObject>();
            do {
                CBORObject co;
                try {
                    co = cj.ParseJSON(nextChar);
                }
                catch (CBORException ex) {
                    cj.SkipToEnd();
                    co = null;
                }
                if (co != null && nextChar[0] >= 0) {
                    cj.SkipToEnd();
                    co = null;
                }
                list.add(co);
                if (!cj.recordSeparatorSeen) {
                    nextChar[0] = -1;
                    break block9;
                }
                cj.ResetJSONSequenceMode();
                cj.SkipRecordSeparators(nextChar, true);
            } while (nextChar[0] >= 0);
            list.add(null);
        }
        return list.toArray(new CBORObject[0]);
    }

    private CBORObject ParseJSONObject(int depth) {
        if (depth > 1000) {
            this.RaiseError("Too deeply nested");
        }
        CBORObject key = null;
        int[] nextChar = new int[1];
        boolean seenComma = false;
        TreeMap<CBORObject, CBORObject> myHashMap = new TreeMap<CBORObject, CBORObject>();
        block8: while (true) {
            int c = this.SkipWhitespaceJSON();
            switch (c) {
                case -1: {
                    this.RaiseError("A JSON Object must end with '}'");
                    break;
                }
                case 125: {
                    if (seenComma) {
                        this.RaiseError("Trailing comma");
                        return null;
                    }
                    return CBORObject.FromRaw(myHashMap);
                }
                default: {
                    CBORObject obj;
                    if (c < 0) {
                        this.RaiseError("Unexpected end of data");
                        return null;
                    }
                    if (c != 34) {
                        this.RaiseError("Expected a String as a key");
                        return null;
                    }
                    key = obj = CBORObject.FromRaw(this.NextJSONString());
                    if (this.options.getAllowDuplicateKeys() || !myHashMap.containsKey(obj)) break;
                    this.RaiseError("Key already exists: " + key);
                    return null;
                }
            }
            if (this.SkipWhitespaceJSON() != 58) {
                this.RaiseError("Expected a ':' after a key");
            }
            myHashMap.put(key, this.NextJSONValue(this.SkipWhitespaceJSON(), nextChar, depth));
            switch (nextChar[0]) {
                case 44: {
                    seenComma = true;
                    continue block8;
                }
                case 125: {
                    return CBORObject.FromRaw(myHashMap);
                }
            }
            this.RaiseError("Expected a ',' or '}'");
        }
    }

    CBORObject ParseJSONArray(int depth) {
        if (depth > 1000) {
            this.RaiseError("Too deeply nested");
        }
        ArrayList<CBORObject> myArrayList = new ArrayList<CBORObject>();
        boolean seenComma = false;
        int[] nextChar = new int[1];
        block4: while (true) {
            int c;
            if ((c = this.SkipWhitespaceJSON()) == 93) {
                if (seenComma) {
                    this.RaiseError("Trailing comma");
                }
                return CBORObject.FromRaw(myArrayList);
            }
            if (c == 44) {
                this.RaiseError("Empty array element");
            }
            myArrayList.add(this.NextJSONValue(c, nextChar, depth));
            c = nextChar[0];
            switch (c) {
                case 44: {
                    seenComma = true;
                    continue block4;
                }
                case 93: {
                    return CBORObject.FromRaw(myArrayList);
                }
            }
            this.RaiseError("Expected a ',' or ']'");
        }
    }
}

