/*
 * Decompiled with CFR 0.152.
 */
package com.upokecenter.cbor;

import com.upokecenter.cbor.CBORException;
import com.upokecenter.cbor.CBORObject;
import com.upokecenter.cbor.CBORType;
import com.upokecenter.cbor.ICBORToFromConverter;
import com.upokecenter.cbor.URIUtility;
import java.net.URI;

class CBORUriConverter
implements ICBORToFromConverter<URI> {
    CBORUriConverter() {
    }

    private CBORObject ValidateObject(CBORObject obj) {
        if (obj.getType() != CBORType.TextString) {
            throw new CBORException("URI must be a text String");
        }
        if (!URIUtility.IsValidIRI(obj.AsString())) {
            throw new CBORException("String is not a valid URI/IRI");
        }
        return obj;
    }

    @Override
    public URI FromCBORObject(CBORObject obj) {
        if (obj.HasMostOuterTag(32)) {
            this.ValidateObject(obj);
            try {
                return new URI(obj.AsString());
            }
            catch (Exception ex) {
                throw new CBORException(ex.getMessage(), ex);
            }
        }
        throw new CBORException();
    }

    @Override
    public CBORObject ToCBORObject(URI uri) {
        if (uri == null) {
            throw new NullPointerException("uri");
        }
        String uriString = uri.toString();
        return CBORObject.FromObjectAndTag((Object)uriString, 32);
    }
}

