/*
 * Decompiled with CFR 0.152.
 */
package com.upokecenter.cbor;

import com.upokecenter.cbor.OptionsParser;

public final class CBOREncodeOptions {
    @Deprecated
    public static final CBOREncodeOptions None = new CBOREncodeOptions("useindeflengthstrings=1;allowduplicatekeys=1");
    public static final CBOREncodeOptions Default = new CBOREncodeOptions(false, false);
    @Deprecated
    public static final CBOREncodeOptions NoIndefLengthStrings = new CBOREncodeOptions("useindeflengthstrings=0;allowduplicatekeys=1");
    @Deprecated
    public static final CBOREncodeOptions NoDuplicateKeys = new CBOREncodeOptions("useindeflengthstrings=1;allowduplicatekeys=0");
    private final boolean propVaruseindeflengthstrings;
    private final boolean propVarallowduplicatekeys;
    private final boolean propVarctap2canonical;
    private final boolean propVarresolvereferences;
    private final boolean propVarallowempty;

    public CBOREncodeOptions() {
        this(false, false);
    }

    public CBOREncodeOptions(boolean useIndefLengthStrings, boolean allowDuplicateKeys) {
        this(useIndefLengthStrings, allowDuplicateKeys, false);
    }

    public CBOREncodeOptions(boolean useIndefLengthStrings, boolean allowDuplicateKeys, boolean ctap2Canonical) {
        this(CBOREncodeOptions.BuildString(useIndefLengthStrings, allowDuplicateKeys, ctap2Canonical));
    }

    private static String BuildString(boolean useIndefLengthStrings, boolean allowDuplicateKeys, boolean ctap2Canonical) {
        return "useindeflengthstrings=" + (useIndefLengthStrings ? "1" : "0") + ";allowduplicatekeys=" + (allowDuplicateKeys ? "1" : "0") + ";ctap2canonical=" + (ctap2Canonical ? "1" : "0");
    }

    public CBOREncodeOptions(String paramString) {
        if (paramString == null) {
            throw new NullPointerException("paramString");
        }
        OptionsParser parser = new OptionsParser(paramString);
        this.propVarresolvereferences = parser.GetBoolean("resolvereferences", true);
        this.propVaruseindeflengthstrings = parser.GetBoolean("useindeflengthstrings", true);
        this.propVarallowduplicatekeys = parser.GetBoolean("allowduplicatekeys", true);
        this.propVarallowempty = parser.GetBoolean("allowempty", false);
        this.propVarctap2canonical = parser.GetBoolean("ctap2canonical", false);
    }

    public String toString() {
        return "allowduplicatekeys=" + (this.getAllowDuplicateKeys() ? "true" : "false") + ";useindeflengthstrings=" + (this.getUseIndefLengthStrings() ? "true" : "false") + ";ctap2canonical=" + (this.getCtap2Canonical() ? "true" : "false") + ";resolvereferences=" + (this.getResolveReferences() ? "true" : "false") + ";allowempty=" + (this.getAllowEmpty() ? "true" : "false");
    }

    public final boolean getUseIndefLengthStrings() {
        return this.propVaruseindeflengthstrings;
    }

    public final boolean getAllowDuplicateKeys() {
        return this.propVarallowduplicatekeys;
    }

    public final boolean getCtap2Canonical() {
        return this.propVarctap2canonical;
    }

    @Deprecated
    public final int getValue() {
        return (this.getUseIndefLengthStrings() ? 0 : 1) + (this.getAllowDuplicateKeys() ? 0 : 2);
    }

    public final boolean getResolveReferences() {
        return this.propVarresolvereferences;
    }

    public final boolean getAllowEmpty() {
        return this.propVarallowempty;
    }

    @Deprecated
    public CBOREncodeOptions Or(CBOREncodeOptions o) {
        if (o == null) {
            throw new NullPointerException("o");
        }
        String str = "allowduplicatekeys=" + (this.getAllowDuplicateKeys() && o.getAllowDuplicateKeys() ? "true" : "false") + ";useindeflengthstrings=" + (this.getUseIndefLengthStrings() && o.getUseIndefLengthStrings() ? "true" : "false");
        return new CBOREncodeOptions(str);
    }

    @Deprecated
    public CBOREncodeOptions And(CBOREncodeOptions o) {
        if (o == null) {
            throw new NullPointerException("o");
        }
        String str = "allowduplicatekeys=" + (this.getAllowDuplicateKeys() || o.getAllowDuplicateKeys() ? "true" : "false") + ";useindeflengthstrings=" + (this.getUseIndefLengthStrings() || o.getUseIndefLengthStrings() ? "true" : "false");
        return new CBOREncodeOptions(str);
    }
}

