/*
 * Decompiled with CFR 0.152.
 */
package com.upokecenter.cbor;

import com.upokecenter.numbers.EInteger;

public final class CBORTypeFilter {
    public static final CBORTypeFilter Any = new CBORTypeFilter().WithAny();
    public static final CBORTypeFilter ByteString = new CBORTypeFilter().WithByteString();
    public static final CBORTypeFilter NegativeInteger = new CBORTypeFilter().WithNegativeInteger();
    public static final CBORTypeFilter None = new CBORTypeFilter();
    public static final CBORTypeFilter TextString = new CBORTypeFilter().WithTextString();
    public static final CBORTypeFilter UnsignedInteger = new CBORTypeFilter().WithUnsignedInteger();
    private boolean any;
    private boolean anyArrayLength;
    private int arrayLength;
    private boolean arrayMinLength;
    private CBORTypeFilter[] elements;
    private boolean floatingpoint;
    private EInteger[] tags;
    private int types;

    public boolean ArrayIndexAllowed(int index) {
        return (this.types & 0x10) != 0 && index >= 0 && (this.anyArrayLength || (this.arrayMinLength || index < this.arrayLength) && index >= 0);
    }

    public boolean ArrayLengthMatches(int length) {
        return (this.types & 0x10) != 0 && (this.anyArrayLength || (this.arrayMinLength ? this.arrayLength >= length : this.arrayLength == length));
    }

    public boolean ArrayLengthMatches(long length) {
        return (this.types & 0x10) != 0 && (this.anyArrayLength || (this.arrayMinLength ? (long)this.arrayLength >= length : (long)this.arrayLength == length));
    }

    public boolean ArrayLengthMatches(EInteger bigLength) {
        if (bigLength == null) {
            throw new NullPointerException("bigLength");
        }
        return (this.types & 0x10) == 0 && (this.anyArrayLength || !this.arrayMinLength && bigLength.compareTo(EInteger.FromInt32((int)this.arrayLength)) == 0 || this.arrayMinLength && bigLength.compareTo(EInteger.FromInt32((int)this.arrayLength)) >= 0);
    }

    public CBORTypeFilter GetSubFilter(int index) {
        if (this.anyArrayLength || this.any) {
            return Any;
        }
        if (index < 0) {
            return None;
        }
        if (index >= this.arrayLength) {
            return this.arrayMinLength ? Any : None;
        }
        if (this.elements == null) {
            return Any;
        }
        if (index >= this.elements.length) {
            return Any;
        }
        return this.elements[index];
    }

    public CBORTypeFilter GetSubFilter(long index) {
        if (this.anyArrayLength || this.any) {
            return Any;
        }
        if (index < 0L) {
            return None;
        }
        if (index >= (long)this.arrayLength) {
            return this.arrayMinLength ? Any : None;
        }
        if (this.elements == null) {
            return Any;
        }
        if (index >= (long)this.elements.length) {
            return Any;
        }
        return this.elements[(int)index];
    }

    public boolean MajorTypeMatches(int type) {
        return type >= 0 && type <= 7 && (this.types & 1 << type) != 0;
    }

    public boolean NonFPSimpleValueAllowed() {
        return this.MajorTypeMatches(7) && !this.floatingpoint;
    }

    public boolean TagAllowed(int tag) {
        return this.any || this.TagAllowed(EInteger.FromInt32((int)tag));
    }

    public boolean TagAllowed(long longTag) {
        return this.any || this.TagAllowed(EInteger.FromInt64((long)longTag));
    }

    public boolean TagAllowed(EInteger bigTag) {
        if (bigTag == null) {
            throw new NullPointerException("bigTag");
        }
        if (bigTag.signum() < 0) {
            return false;
        }
        if (this.any) {
            return true;
        }
        if ((this.types & 0x40) == 0) {
            return false;
        }
        if (this.tags == null) {
            return true;
        }
        for (EInteger tag : this.tags) {
            if (!bigTag.equals((Object)tag)) continue;
            return true;
        }
        return false;
    }

    public CBORTypeFilter WithArrayAnyLength() {
        if (this.any) {
            return this;
        }
        if (this.arrayLength < 0) {
            throw new IllegalArgumentException("this.arrayLength (" + this.arrayLength + ") is less than 0");
        }
        if (this.arrayLength < this.elements.length) {
            throw new IllegalArgumentException("this.arrayLength (" + this.arrayLength + ") is less than " + this.elements.length);
        }
        CBORTypeFilter filter = this.Copy();
        filter.types |= 0x10;
        filter.anyArrayLength = true;
        return filter;
    }

    public CBORTypeFilter WithArrayExactLength(int arrayLength, CBORTypeFilter ... elements) {
        if (this.any) {
            return this;
        }
        if (elements == null) {
            throw new NullPointerException("elements");
        }
        if (arrayLength < 0) {
            throw new IllegalArgumentException("arrayLength (" + arrayLength + ") is less than 0");
        }
        if (arrayLength < elements.length) {
            throw new IllegalArgumentException("arrayLength (" + arrayLength + ") is less than " + elements.length);
        }
        CBORTypeFilter filter = this.Copy();
        filter.types |= 0x10;
        filter.arrayLength = arrayLength;
        filter.arrayMinLength = false;
        filter.elements = new CBORTypeFilter[elements.length];
        System.arraycopy(elements, 0, filter.elements, 0, elements.length);
        return filter;
    }

    public CBORTypeFilter WithArrayMinLength(int arrayLength, CBORTypeFilter ... elements) {
        if (this.any) {
            return this;
        }
        if (elements == null) {
            throw new NullPointerException("elements");
        }
        if (arrayLength < 0) {
            throw new IllegalArgumentException("arrayLength (" + arrayLength + ") is less than 0");
        }
        if (arrayLength < elements.length) {
            throw new IllegalArgumentException("arrayLength (" + arrayLength + ") is less than " + elements.length);
        }
        CBORTypeFilter filter = this.Copy();
        filter.types |= 0x10;
        filter.arrayLength = arrayLength;
        filter.arrayMinLength = true;
        filter.elements = new CBORTypeFilter[elements.length];
        System.arraycopy(elements, 0, filter.elements, 0, elements.length);
        return filter;
    }

    public CBORTypeFilter WithByteString() {
        return this.WithType(2).WithTags(25);
    }

    public CBORTypeFilter WithFloatingPoint() {
        if (this.any) {
            return this;
        }
        CBORTypeFilter filter = this.Copy();
        filter.types |= 0x10;
        filter.floatingpoint = true;
        return filter;
    }

    public CBORTypeFilter WithMap() {
        return this.WithType(5);
    }

    public CBORTypeFilter WithNegativeInteger() {
        return this.WithType(1);
    }

    public CBORTypeFilter WithTags(int ... tags) {
        if (this.any) {
            return this;
        }
        CBORTypeFilter filter = this.Copy();
        filter.types |= 0x40;
        int startIndex = 0;
        if (filter.tags != null) {
            EInteger[] newTags = new EInteger[tags.length + filter.tags.length];
            System.arraycopy(filter.tags, 0, newTags, 0, filter.tags.length);
            startIndex = filter.tags.length;
            filter.tags = newTags;
        } else {
            filter.tags = new EInteger[tags.length];
        }
        for (int i = 0; i < tags.length; ++i) {
            filter.tags[startIndex + i] = EInteger.FromInt64((long)tags[i]);
        }
        return filter;
    }

    CBORTypeFilter WithTags(EInteger ... tags) {
        if (this.any) {
            return this;
        }
        for (int i = 0; i < tags.length; ++i) {
            if (tags[i] != null) continue;
            throw new NullPointerException("tags");
        }
        CBORTypeFilter filter = this.Copy();
        filter.types |= 0x40;
        int startIndex = 0;
        if (filter.tags != null) {
            EInteger[] newTags = new EInteger[tags.length + filter.tags.length];
            System.arraycopy(filter.tags, 0, newTags, 0, filter.tags.length);
            startIndex = filter.tags.length;
            filter.tags = newTags;
        } else {
            filter.tags = new EInteger[tags.length];
        }
        System.arraycopy(tags, 0, filter.tags, startIndex, tags.length);
        return filter;
    }

    public CBORTypeFilter WithTextString() {
        return this.WithType(3).WithTags(25);
    }

    public CBORTypeFilter WithUnsignedInteger() {
        return this.WithType(0);
    }

    private CBORTypeFilter Copy() {
        CBORTypeFilter filter = new CBORTypeFilter();
        filter.any = this.any;
        filter.types = this.types;
        filter.floatingpoint = this.floatingpoint;
        filter.arrayLength = this.arrayLength;
        filter.anyArrayLength = this.anyArrayLength;
        filter.arrayMinLength = this.arrayMinLength;
        filter.elements = this.elements;
        filter.tags = this.tags;
        return filter;
    }

    private CBORTypeFilter WithAny() {
        if (this.any) {
            return this;
        }
        CBORTypeFilter filter = this.Copy();
        filter.any = true;
        filter.anyArrayLength = true;
        filter.types = 255;
        return filter;
    }

    private CBORTypeFilter WithType(int type) {
        if (this.any) {
            return this;
        }
        CBORTypeFilter filter = this.Copy();
        filter.types |= 1 << type;
        return filter;
    }
}

