/*
 * Decompiled with CFR 0.152.
 */
package com.upokecenter.cbor;

import com.upokecenter.cbor.ICBORNumber;
import com.upokecenter.numbers.EContext;
import com.upokecenter.numbers.EDecimal;
import com.upokecenter.numbers.EFloat;
import com.upokecenter.numbers.EInteger;
import com.upokecenter.numbers.ERational;

class CBORExtendedRational
implements ICBORNumber {
    CBORExtendedRational() {
    }

    public boolean IsPositiveInfinity(Object obj) {
        return ((ERational)obj).IsPositiveInfinity();
    }

    public boolean IsInfinity(Object obj) {
        return ((ERational)obj).IsInfinity();
    }

    public boolean IsNegativeInfinity(Object obj) {
        return ((ERational)obj).IsNegativeInfinity();
    }

    public boolean IsNaN(Object obj) {
        return ((ERational)obj).IsNaN();
    }

    public double AsDouble(Object obj) {
        ERational er = (ERational)obj;
        return er.ToDouble();
    }

    public EDecimal AsExtendedDecimal(Object obj) {
        ERational er = (ERational)obj;
        return er.ToEDecimalExactIfPossible(EContext.Decimal128.WithUnlimitedExponents());
    }

    public EFloat AsExtendedFloat(Object obj) {
        ERational er = (ERational)obj;
        return er.ToEFloatExactIfPossible(EContext.Binary128.WithUnlimitedExponents());
    }

    public float AsSingle(Object obj) {
        ERational er = (ERational)obj;
        return er.ToSingle();
    }

    public EInteger AsEInteger(Object obj) {
        ERational er = (ERational)obj;
        return er.ToEInteger();
    }

    public long AsInt64(Object obj) {
        EInteger bi;
        ERational ef = (ERational)obj;
        if (ef.isFinite() && (bi = ef.ToEInteger()).GetSignedBitLength() <= 63) {
            return bi.ToInt64Checked();
        }
        throw new ArithmeticException("This Object's value is out of range");
    }

    public boolean CanFitInSingle(Object obj) {
        ERational ef = (ERational)obj;
        return !ef.isFinite() || ef.compareTo(ERational.FromSingle((float)ef.ToSingle())) == 0;
    }

    public boolean CanFitInDouble(Object obj) {
        ERational ef = (ERational)obj;
        return !ef.isFinite() || ef.compareTo(ERational.FromDouble((double)ef.ToDouble())) == 0;
    }

    public boolean CanFitInInt32(Object obj) {
        return this.IsIntegral(obj) && this.CanTruncatedIntFitInInt32(obj);
    }

    public boolean CanFitInInt64(Object obj) {
        return this.IsIntegral(obj) && this.CanTruncatedIntFitInInt64(obj);
    }

    public boolean CanTruncatedIntFitInInt64(Object obj) {
        ERational ef = (ERational)obj;
        if (!ef.isFinite()) {
            return false;
        }
        EInteger bi = ef.ToEInteger();
        return bi.GetSignedBitLength() <= 63;
    }

    public boolean CanTruncatedIntFitInInt32(Object obj) {
        ERational ef = (ERational)obj;
        if (!ef.isFinite()) {
            return false;
        }
        EInteger bi = ef.ToEInteger();
        return bi.CanFitInInt32();
    }

    public boolean IsZero(Object obj) {
        ERational ef = (ERational)obj;
        return ef.isZero();
    }

    public int Sign(Object obj) {
        ERational ef = (ERational)obj;
        return ef.signum();
    }

    public boolean IsIntegral(Object obj) {
        ERational ef = (ERational)obj;
        if (!ef.isFinite()) {
            return false;
        }
        if (ef.getDenominator().equals((Object)EInteger.FromInt32((int)1))) {
            return true;
        }
        EInteger denom = ef.getDenominator();
        EInteger rem = ef.getNumerator().Remainder(denom);
        return rem.isZero();
    }

    public int AsInt32(Object obj, int minValue, int maxValue) {
        int ret;
        EInteger bi;
        ERational ef = (ERational)obj;
        if (ef.isFinite() && (bi = ef.ToEInteger()).CanFitInInt32() && (ret = bi.ToInt32Checked()) >= minValue && ret <= maxValue) {
            return ret;
        }
        throw new ArithmeticException("This Object's value is out of range");
    }

    public Object Negate(Object obj) {
        ERational ed = (ERational)obj;
        return ed.Negate();
    }

    public Object Abs(Object obj) {
        ERational ed = (ERational)obj;
        return ed.Abs();
    }

    public ERational AsExtendedRational(Object obj) {
        return (ERational)obj;
    }

    public boolean IsNegative(Object obj) {
        return ((ERational)obj).isNegative();
    }
}

