/*
 * Decompiled with CFR 0.152.
 */
package com.upokecenter.cbor;

import com.upokecenter.cbor.CBORObject;
import com.upokecenter.numbers.EDecimal;
import com.upokecenter.numbers.EFloat;
import com.upokecenter.numbers.EInteger;
import com.upokecenter.numbers.ERational;
import com.upokecenter.util.BigInteger;
import com.upokecenter.util.ExtendedDecimal;
import com.upokecenter.util.ExtendedFloat;
import com.upokecenter.util.ExtendedRational;
import java.io.InputStream;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PropertyMap {
    private static Map<Class<?>, List<MethodData>> propertyLists = new HashMap();
    private static Object methodSync = new Object();
    private static Method[] legacyMethods = new Method[8];
    private static boolean haveMethods = false;

    PropertyMap() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<MethodData> GetPropertyList(Class<?> t) {
        Map<Class<?>, List<MethodData>> map = propertyLists;
        synchronized (map) {
            List<MethodData> ret = propertyLists.get(t);
            if (ret != null) {
                return ret;
            }
            ret = new ArrayList<MethodData>();
            for (Method pi : t.getMethods()) {
                StringBuilder sb;
                MethodData md;
                if (pi.getParameterTypes().length != 0) continue;
                String methodName = pi.getName();
                if (methodName.startsWith("get") && methodName.length() > 3 && methodName.charAt(3) >= 'A' && methodName.charAt(3) <= 'Z' && !methodName.equals("getClass")) {
                    md = new MethodData();
                    md.name = methodName.substring(3);
                    if (md.name.charAt(0) >= 'A' && md.name.charAt(0) <= 'Z') {
                        sb = new StringBuilder();
                        sb.append((char)(md.name.charAt(0) + 32));
                        sb.append(md.name.substring(1));
                        md.name = sb.toString();
                    }
                    md.method = pi;
                    ret.add(md);
                    continue;
                }
                if (!methodName.startsWith("is") || methodName.length() <= 2 || methodName.charAt(2) < 'A' || methodName.charAt(2) > 'Z') continue;
                md = new MethodData();
                md.name = methodName.substring(2);
                if (md.name.charAt(0) >= 'A' && md.name.charAt(0) <= 'Z') {
                    sb = new StringBuilder();
                    sb.append((char)(md.name.charAt(0) + 32));
                    sb.append(md.name.substring(1));
                    md.name = sb.toString();
                }
                md.method = pi;
                ret.add(md);
            }
            propertyLists.put(t, ret);
            return ret;
        }
    }

    public static CBORObject FromArray(Object arr) {
        int length = Array.getLength(arr);
        CBORObject obj = CBORObject.NewArray();
        for (int i = 0; i < length; ++i) {
            obj.Add(CBORObject.FromObject(Array.get(arr, i)));
        }
        return obj;
    }

    public static Object EnumToObject(Enum<?> value) {
        return value.name();
    }

    public static Iterable<Map.Entry<String, Object>> GetProperties(Object o) {
        ArrayList<Map.Entry<String, Object>> ret = new ArrayList<Map.Entry<String, Object>>();
        try {
            for (MethodData key : PropertyMap.GetPropertyList(o.getClass())) {
                ret.add(new AbstractMap.SimpleEntry<String, Object>(key.name, key.method.invoke(o, new Object[0])));
            }
            return ret;
        }
        catch (InvocationTargetException ex) {
            throw (RuntimeException)new RuntimeException("").initCause(ex);
        }
        catch (IllegalAccessException ex) {
            throw (RuntimeException)new RuntimeException("").initCause(ex);
        }
    }

    public static Object FindOneArgumentMethod(Object obj, String name, Class<?> argtype) {
        try {
            return obj.getClass().getMethod(name, argtype);
        }
        catch (SecurityException e) {
            return null;
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Method getLegacyMethod(int method) {
        Object object = methodSync;
        synchronized (object) {
            if (!haveMethods) {
                try {
                    PropertyMap.legacyMethods[0] = BigInteger.class.getDeclaredMethod("ToLegacy", EInteger.class);
                    PropertyMap.legacyMethods[1] = BigInteger.class.getDeclaredMethod("FromLegacy", BigInteger.class);
                    PropertyMap.legacyMethods[2] = ExtendedDecimal.class.getDeclaredMethod("ToLegacy", EDecimal.class);
                    PropertyMap.legacyMethods[3] = ExtendedDecimal.class.getDeclaredMethod("FromLegacy", ExtendedDecimal.class);
                    PropertyMap.legacyMethods[4] = ExtendedFloat.class.getDeclaredMethod("ToLegacy", EFloat.class);
                    PropertyMap.legacyMethods[5] = ExtendedFloat.class.getDeclaredMethod("FromLegacy", ExtendedFloat.class);
                    PropertyMap.legacyMethods[6] = ExtendedRational.class.getDeclaredMethod("ToLegacy", ERational.class);
                    PropertyMap.legacyMethods[7] = ExtendedRational.class.getDeclaredMethod("FromLegacy", ExtendedRational.class);
                    for (int i = 0; i < legacyMethods.length; ++i) {
                        legacyMethods[i].setAccessible(true);
                    }
                }
                catch (SecurityException e) {
                    throw new RuntimeException(e);
                }
                catch (NoSuchMethodException e) {
                    throw new RuntimeException(e);
                }
                haveMethods = true;
            }
            return legacyMethods[method];
        }
    }

    public static boolean ExceedsKnownLength(InputStream inStream, long size) {
        return false;
    }

    public static void SkipStreamToEnd(InputStream inStream) {
    }

    public static BigInteger ToLegacy(EInteger ei) {
        return (BigInteger)PropertyMap.InvokeOneArgumentMethod(PropertyMap.getLegacyMethod(0), null, ei);
    }

    public static ExtendedDecimal ToLegacy(EDecimal ed) {
        return (ExtendedDecimal)PropertyMap.InvokeOneArgumentMethod(PropertyMap.getLegacyMethod(2), null, ed);
    }

    public static ExtendedFloat ToLegacy(EFloat ef) {
        return (ExtendedFloat)PropertyMap.InvokeOneArgumentMethod(PropertyMap.getLegacyMethod(4), null, ef);
    }

    public static ExtendedRational ToLegacy(ERational er) {
        return (ExtendedRational)PropertyMap.InvokeOneArgumentMethod(PropertyMap.getLegacyMethod(6), null, er);
    }

    public static EInteger FromLegacy(BigInteger ei) {
        return (EInteger)PropertyMap.InvokeOneArgumentMethod(PropertyMap.getLegacyMethod(1), null, ei);
    }

    public static EDecimal FromLegacy(ExtendedDecimal ed) {
        return (EDecimal)PropertyMap.InvokeOneArgumentMethod(PropertyMap.getLegacyMethod(3), null, ed);
    }

    public static EFloat FromLegacy(ExtendedFloat ef) {
        return (EFloat)PropertyMap.InvokeOneArgumentMethod(PropertyMap.getLegacyMethod(5), null, ef);
    }

    public static ERational FromLegacy(ExtendedRational er) {
        return (ERational)PropertyMap.InvokeOneArgumentMethod(PropertyMap.getLegacyMethod(7), null, er);
    }

    public static Object InvokeOneArgumentMethod(Object method, Object obj, Object argument) {
        if (method == null) {
            throw new NullPointerException("method");
        }
        Method m = (Method)method;
        try {
            return m.invoke(obj, argument);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    private static class MethodData {
        public String name;
        public Method method;

        private MethodData() {
        }
    }
}

