/*
 * Decompiled with CFR 0.152.
 */
package com.upokecenter.cbor;

import com.upokecenter.cbor.CBORException;
import com.upokecenter.cbor.CBORObject;
import com.upokecenter.cbor.CBORType;
import com.upokecenter.cbor.CBORTypeFilter;
import com.upokecenter.cbor.ICBORTag;
import com.upokecenter.numbers.EInteger;

class CBORTag2
implements ICBORTag {
    CBORTag2() {
    }

    public CBORTypeFilter GetTypeFilter() {
        return CBORTypeFilter.ByteString;
    }

    private static CBORObject FromObjectAndInnerTags(Object objectValue, CBORObject objectWithTags) {
        CBORObject newObject = CBORObject.FromObject(objectValue);
        if (!objectWithTags.isTagged()) {
            return newObject;
        }
        if (!(objectWithTags = objectWithTags.UntagOne()).isTagged()) {
            return newObject;
        }
        EInteger[] tags = objectWithTags.GetAllTags();
        for (int i = tags.length - 1; i >= 0; --i) {
            newObject = CBORObject.FromObjectAndTag((Object)newObject, tags[i]);
        }
        return newObject;
    }

    static CBORObject ConvertToBigNum(CBORObject o, boolean negative) {
        if (o.getType() != CBORType.ByteString) {
            throw new CBORException("Byte array expected");
        }
        byte[] data = o.GetByteString();
        if (data.length <= 7) {
            long x = 0L;
            for (int i = 0; i < data.length; ++i) {
                x <<= 8;
                x |= (long)data[i] & 0xFFL;
            }
            if (negative) {
                x = -x;
                --x;
            }
            return CBORTag2.FromObjectAndInnerTags(x, o);
        }
        int neededLength = data.length;
        boolean extended = false;
        if ((data[0] >> 7 & 1) != 0) {
            ++neededLength;
            extended = true;
        }
        byte[] bytes = new byte[neededLength];
        for (int i = 0; i < data.length; ++i) {
            bytes[i] = data[data.length - 1 - i];
            if (!negative) continue;
            bytes[i] = (byte)(~bytes[i] & 0xFF);
        }
        if (extended) {
            bytes[bytes.length - 1] = negative ? -1 : 0;
        }
        EInteger bi = EInteger.FromBytes((byte[])bytes, (boolean)true);
        return CBORObject.FromObject(bi);
    }

    public CBORObject ValidateObject(CBORObject obj) {
        return CBORTag2.ConvertToBigNum(obj, false);
    }
}

