/*
 * Decompiled with CFR 0.152.
 */
package com.upokecenter.util;

import com.upokecenter.numbers.EDecimal;
import com.upokecenter.numbers.EFloat;
import com.upokecenter.numbers.EInteger;
import com.upokecenter.numbers.ERational;
import com.upokecenter.util.BigInteger;
import com.upokecenter.util.ExtendedDecimal;
import com.upokecenter.util.ExtendedFloat;
import com.upokecenter.util.PrecisionContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ExtendedRational
implements Comparable<ExtendedRational> {
    @Deprecated
    public static final ExtendedRational NaN = new ExtendedRational(ERational.NaN);
    public static final ExtendedRational NegativeInfinity = new ExtendedRational(ERational.NegativeInfinity);
    public static final ExtendedRational NegativeZero = new ExtendedRational(ERational.NegativeZero);
    public static final ExtendedRational One = ExtendedRational.FromBigIntegerInternal(BigInteger.valueOf(1L));
    public static final ExtendedRational PositiveInfinity = new ExtendedRational(ERational.PositiveInfinity);
    @Deprecated
    public static final ExtendedRational SignalingNaN = new ExtendedRational(ERational.SignalingNaN);
    public static final ExtendedRational Ten = ExtendedRational.FromBigIntegerInternal(BigInteger.valueOf(10L));
    public static final ExtendedRational Zero = ExtendedRational.FromBigIntegerInternal(BigInteger.valueOf(0L));
    private final ERational er;

    public ExtendedRational(BigInteger numerator, BigInteger denominator) {
        this.er = new ERational(numerator.getEi(), denominator.getEi());
    }

    ExtendedRational(ERational er) {
        if (er == null) {
            throw new NullPointerException("er");
        }
        this.er = er;
    }

    public final BigInteger getDenominator() {
        return new BigInteger(this.getEr().getDenominator());
    }

    @Deprecated
    public final boolean isFinite() {
        return this.getEr().isFinite();
    }

    public final boolean isNegative() {
        return this.getEr().isNegative();
    }

    @Deprecated
    public final boolean isZero() {
        return this.getEr().isZero();
    }

    public final BigInteger getNumerator() {
        return new BigInteger(this.getEr().getNumerator());
    }

    @Deprecated
    public final int signum() {
        return this.getEr().signum();
    }

    public final BigInteger getUnsignedNumerator() {
        return new BigInteger(this.getEr().getUnsignedNumerator());
    }

    final ERational getEr() {
        return this.er;
    }

    public static ExtendedRational Create(int numeratorSmall, int denominatorSmall) {
        return new ExtendedRational(ERational.Create((int)numeratorSmall, (int)denominatorSmall));
    }

    public static ExtendedRational Create(BigInteger numerator, BigInteger denominator) {
        if (numerator == null) {
            throw new NullPointerException("numerator");
        }
        if (denominator == null) {
            throw new NullPointerException("denominator");
        }
        return new ExtendedRational(ERational.Create((EInteger)numerator.getEi(), (EInteger)denominator.getEi()));
    }

    @Deprecated
    public static ExtendedRational CreateNaN(BigInteger diag) {
        if (diag == null) {
            throw new NullPointerException("diag");
        }
        return new ExtendedRational(ERational.CreateNaN((EInteger)diag.getEi()));
    }

    @Deprecated
    public static ExtendedRational CreateNaN(BigInteger diag, boolean signaling, boolean negative) {
        if (diag == null) {
            throw new NullPointerException("diag");
        }
        return new ExtendedRational(ERational.CreateNaN((EInteger)diag.getEi(), (boolean)signaling, (boolean)negative));
    }

    @Deprecated
    public static ExtendedRational FromBigInteger(BigInteger bigint) {
        return ExtendedRational.FromBigIntegerInternal(bigint);
    }

    @Deprecated
    public static ExtendedRational FromDouble(double flt) {
        return new ExtendedRational(ERational.FromDouble((double)flt));
    }

    @Deprecated
    public static ExtendedRational FromExtendedDecimal(ExtendedDecimal ef) {
        if (ef == null) {
            throw new NullPointerException("ef");
        }
        return new ExtendedRational(ERational.FromExtendedDecimal((EDecimal)ef.getEd()));
    }

    @Deprecated
    public static ExtendedRational FromExtendedFloat(ExtendedFloat ef) {
        if (ef == null) {
            throw new NullPointerException("ef");
        }
        return new ExtendedRational(ERational.FromExtendedFloat((EFloat)ef.getEf()));
    }

    @Deprecated
    public static ExtendedRational FromInt32(int smallint) {
        return new ExtendedRational(ERational.FromInt32((int)smallint));
    }

    @Deprecated
    public static ExtendedRational FromInt64(long longInt) {
        return new ExtendedRational(ERational.FromInt64((long)longInt));
    }

    @Deprecated
    public static ExtendedRational FromSingle(float flt) {
        return new ExtendedRational(ERational.FromSingle((float)flt));
    }

    @Deprecated
    public ExtendedRational Abs() {
        return new ExtendedRational(this.getEr().Abs());
    }

    @Deprecated
    public ExtendedRational Add(ExtendedRational otherValue) {
        if (otherValue == null) {
            throw new NullPointerException("otherValue");
        }
        return new ExtendedRational(this.getEr().Add(otherValue.getEr())).Simplify();
    }

    @Override
    @Deprecated
    public int compareTo(ExtendedRational other) {
        if (other == null) {
            throw new NullPointerException("other");
        }
        return this.getEr().compareTo(other.getEr());
    }

    @Deprecated
    public int CompareToBinary(ExtendedFloat other) {
        if (other == null) {
            throw new NullPointerException("other");
        }
        return this.getEr().CompareToBinary(other.getEf());
    }

    @Deprecated
    public int CompareToDecimal(ExtendedDecimal other) {
        if (other == null) {
            throw new NullPointerException("other");
        }
        return this.getEr().CompareToDecimal(other.getEd());
    }

    @Deprecated
    public ExtendedRational Divide(ExtendedRational otherValue) {
        if (otherValue == null) {
            throw new NullPointerException("otherValue");
        }
        return new ExtendedRational(this.getEr().Divide(otherValue.getEr())).Simplify();
    }

    public boolean equals(Object obj) {
        ExtendedRational bi = obj instanceof ExtendedRational ? (ExtendedRational)obj : null;
        return bi == null ? false : this.getEr().equals(bi.getEr());
    }

    @Deprecated
    public boolean equals(ExtendedRational other) {
        if (other == null) {
            throw new NullPointerException("other");
        }
        return this.getEr().equals(other.getEr());
    }

    public int hashCode() {
        return this.getEr().hashCode();
    }

    @Deprecated
    public boolean IsInfinity() {
        return this.getEr().IsInfinity();
    }

    public boolean IsNaN() {
        return this.getEr().IsNaN();
    }

    @Deprecated
    public boolean IsNegativeInfinity() {
        return this.getEr().IsNegativeInfinity();
    }

    @Deprecated
    public boolean IsPositiveInfinity() {
        return this.getEr().IsPositiveInfinity();
    }

    @Deprecated
    public boolean IsQuietNaN() {
        return this.getEr().IsQuietNaN();
    }

    @Deprecated
    public boolean IsSignalingNaN() {
        return this.getEr().IsSignalingNaN();
    }

    @Deprecated
    public ExtendedRational Multiply(ExtendedRational otherValue) {
        if (otherValue == null) {
            throw new NullPointerException("otherValue");
        }
        return new ExtendedRational(this.getEr().Multiply(otherValue.getEr())).Simplify();
    }

    @Deprecated
    public ExtendedRational Negate() {
        return new ExtendedRational(this.getEr().Negate());
    }

    @Deprecated
    public ExtendedRational Remainder(ExtendedRational otherValue) {
        if (otherValue == null) {
            throw new NullPointerException("otherValue");
        }
        return new ExtendedRational(this.getEr().Remainder(otherValue.getEr())).Simplify();
    }

    @Deprecated
    public ExtendedRational Subtract(ExtendedRational otherValue) {
        if (otherValue == null) {
            throw new NullPointerException("otherValue");
        }
        return new ExtendedRational(this.getEr().Subtract(otherValue.getEr())).Simplify();
    }

    @Deprecated
    public BigInteger ToBigInteger() {
        return new BigInteger(this.getEr().ToEInteger());
    }

    @Deprecated
    public BigInteger ToBigIntegerExact() {
        return new BigInteger(this.getEr().ToEIntegerExact());
    }

    @Deprecated
    public double ToDouble() {
        return this.getEr().ToDouble();
    }

    @Deprecated
    public ExtendedDecimal ToExtendedDecimal() {
        return new ExtendedDecimal(this.getEr().ToExtendedDecimal());
    }

    @Deprecated
    public ExtendedDecimal ToExtendedDecimal(PrecisionContext ctx) {
        return new ExtendedDecimal(this.getEr().ToExtendedDecimal(ctx == null ? null : ctx.getEc()));
    }

    @Deprecated
    public ExtendedDecimal ToExtendedDecimalExactIfPossible(PrecisionContext ctx) {
        return new ExtendedDecimal(this.getEr().ToExtendedDecimalExactIfPossible(ctx == null ? null : ctx.getEc()));
    }

    @Deprecated
    public ExtendedFloat ToExtendedFloat() {
        return new ExtendedFloat(this.getEr().ToExtendedFloat());
    }

    @Deprecated
    public ExtendedFloat ToExtendedFloat(PrecisionContext ctx) {
        return new ExtendedFloat(this.getEr().ToExtendedFloat(ctx == null ? null : ctx.getEc()));
    }

    @Deprecated
    public ExtendedFloat ToExtendedFloatExactIfPossible(PrecisionContext ctx) {
        return new ExtendedFloat(this.getEr().ToExtendedFloatExactIfPossible(ctx == null ? null : ctx.getEc()));
    }

    @Deprecated
    public float ToSingle() {
        return this.getEr().ToSingle();
    }

    public String toString() {
        return this.getEr().toString();
    }

    static ERational FromLegacy(ExtendedRational bei) {
        return bei.getEr();
    }

    static ExtendedRational ToLegacy(ERational ei) {
        return new ExtendedRational(ei);
    }

    private static ExtendedRational FromBigIntegerInternal(BigInteger bigint) {
        return new ExtendedRational(ERational.FromEInteger((EInteger)bigint.getEi()));
    }

    private ExtendedRational Simplify() {
        if (this.isFinite()) {
            BigInteger num = this.getNumerator().abs();
            BigInteger den = this.getDenominator().abs();
            boolean neg = this.isNegative();
            int lowBit = num.getLowBit();
            if ((lowBit = Math.min(lowBit, den.getLowBit())) > 0) {
                num = num.shiftRight(lowBit);
                den = den.shiftRight(lowBit);
                if (neg) {
                    num = num.negate();
                }
                return ExtendedRational.Create(num, den);
            }
        }
        return this;
    }
}

