/*
 * Decompiled with CFR 0.152.
 */
package com.upokecenter.cbor;

import com.upokecenter.util.DataUtilities;
import java.io.IOException;
import java.io.OutputStream;

final class StringOutput {
    private final StringBuilder builder;
    private final OutputStream outputStream;

    public StringOutput(StringBuilder builder) {
        this.builder = builder;
        this.outputStream = null;
    }

    public StringOutput(OutputStream outputStream) {
        this.outputStream = outputStream;
        this.builder = null;
    }

    public void WriteString(String str) throws IOException {
        if (this.outputStream != null) {
            if (str.length() == 1) {
                this.WriteCodePoint(str.charAt(0));
            } else if (DataUtilities.WriteUtf8(str, 0, str.length(), this.outputStream, false) < 0) {
                throw new IllegalArgumentException("str has an unpaired surrogate");
            }
        } else {
            this.builder.append(str);
        }
    }

    public void WriteString(String str, int index, int length) throws IOException {
        if (this.outputStream != null) {
            if (length == 1) {
                this.WriteCodePoint(str.charAt(index));
            } else if (DataUtilities.WriteUtf8(str, index, length, this.outputStream, false) < 0) {
                throw new IllegalArgumentException("str has an unpaired surrogate");
            }
        } else {
            this.builder.append(str, index, index + length);
        }
    }

    public void WriteCodePoint(int codePoint) throws IOException {
        if (codePoint < 0) {
            throw new IllegalArgumentException("codePoint (" + codePoint + ") is less than " + 0);
        }
        if (codePoint > 0x10FFFF) {
            throw new IllegalArgumentException("codePoint (" + codePoint + ") is more than " + 0x10FFFF);
        }
        if (this.outputStream != null) {
            if (codePoint < 128) {
                this.outputStream.write((byte)codePoint);
            } else if (codePoint <= 2047) {
                this.outputStream.write((byte)(0xC0 | codePoint >> 6 & 0x1F));
                this.outputStream.write((byte)(0x80 | codePoint & 0x3F));
            } else if (codePoint <= 65535) {
                if ((codePoint & 0xF800) == 55296) {
                    throw new IllegalArgumentException("ch is a surrogate");
                }
                this.outputStream.write((byte)(0xE0 | codePoint >> 12 & 0xF));
                this.outputStream.write((byte)(0x80 | codePoint >> 6 & 0x3F));
                this.outputStream.write((byte)(0x80 | codePoint & 0x3F));
            } else {
                this.outputStream.write((byte)(0xF0 | codePoint >> 18 & 8));
                this.outputStream.write((byte)(0x80 | codePoint >> 12 & 0x3F));
                this.outputStream.write((byte)(0x80 | codePoint >> 6 & 0x3F));
                this.outputStream.write((byte)(0x80 | codePoint & 0x3F));
            }
        } else {
            if ((codePoint & 0xFFF800) == 55296) {
                throw new IllegalArgumentException("ch is a surrogate");
            }
            if (codePoint <= 65535) {
                this.builder.append((char)codePoint);
            } else if (codePoint <= 0x10FFFF) {
                this.builder.append((char)((codePoint - 65536 >> 10 & 0x3FF) + 55296));
                this.builder.append((char)((codePoint - 65536 & 0x3FF) + 56320));
            }
        }
    }
}

