/*
 * Decompiled with CFR 0.152.
 */
package com.upokecenter.util;

import com.upokecenter.util.BigInteger;
import com.upokecenter.util.FastInteger;

final class DecimalUtility {
    private static final BigInteger[] valueBigIntPowersOfTen = new BigInteger[]{BigInteger.ONE, BigInteger.TEN, BigInteger.valueOf(100L), BigInteger.valueOf(1000L), BigInteger.valueOf(10000L), BigInteger.valueOf(100000L), BigInteger.valueOf(1000000L), BigInteger.valueOf(10000000L), BigInteger.valueOf(100000000L), BigInteger.valueOf(1000000000L), BigInteger.valueOf(10000000000L), BigInteger.valueOf(100000000000L), BigInteger.valueOf(1000000000000L), BigInteger.valueOf(10000000000000L), BigInteger.valueOf(100000000000000L), BigInteger.valueOf(1000000000000000L), BigInteger.valueOf(10000000000000000L), BigInteger.valueOf(100000000000000000L), BigInteger.valueOf(1000000000000000000L)};
    private static final BigInteger[] valueBigIntPowersOfFive = new BigInteger[]{BigInteger.ONE, BigInteger.valueOf(5L), BigInteger.valueOf(25L), BigInteger.valueOf(125L), BigInteger.valueOf(625L), BigInteger.valueOf(3125L), BigInteger.valueOf(15625L), BigInteger.valueOf(78125L), BigInteger.valueOf(390625L), BigInteger.valueOf(1953125L), BigInteger.valueOf(9765625L), BigInteger.valueOf(48828125L), BigInteger.valueOf(244140625L), BigInteger.valueOf(1220703125L), BigInteger.valueOf(6103515625L), BigInteger.valueOf(30517578125L), BigInteger.valueOf(152587890625L), BigInteger.valueOf(762939453125L), BigInteger.valueOf(3814697265625L), BigInteger.valueOf(19073486328125L), BigInteger.valueOf(95367431640625L), BigInteger.valueOf(476837158203125L), BigInteger.valueOf(2384185791015625L), BigInteger.valueOf(11920928955078125L), BigInteger.valueOf(59604644775390625L), BigInteger.valueOf(298023223876953125L), BigInteger.valueOf(1490116119384765625L), BigInteger.valueOf(7450580596923828125L)};
    private static final BigInteger valueBigShiftIteration = BigInteger.valueOf(1000000L);
    private static final PowerCache powerOfFiveCache = new PowerCache();
    private static final PowerCache powerOfTenCache = new PowerCache();
    private static final BigInteger valueBigInt36 = BigInteger.valueOf(36L);
    private static final BigInteger valueFivePower40 = BigInteger.valueOf(95367431640625L).multiply(BigInteger.valueOf(95367431640625L));

    private DecimalUtility() {
    }

    static int ShiftLeftOne(int[] arr) {
        int carry = 0;
        for (int i = 0; i < arr.length; ++i) {
            int item = arr[i];
            arr[i] = arr[i] << 1 | carry;
            carry = item >> 31 != 0 ? 1 : 0;
        }
        return carry;
    }

    private static int CountTrailingZeros(int numberValue) {
        if (numberValue == 0) {
            return 32;
        }
        int i = 0;
        if (numberValue << 16 == 0) {
            numberValue >>= 16;
            i += 16;
        }
        if (numberValue << 24 == 0) {
            numberValue >>= 8;
            i += 8;
        }
        if (numberValue << 28 == 0) {
            numberValue >>= 4;
            i += 4;
        }
        if (numberValue << 30 == 0) {
            numberValue >>= 2;
            i += 2;
        }
        if (numberValue << 31 == 0) {
            ++i;
        }
        return i;
    }

    static int BitPrecisionInt(int numberValue) {
        if (numberValue == 0) {
            return 0;
        }
        int i = 32;
        if (numberValue >> 16 == 0) {
            numberValue <<= 16;
            i -= 8;
        }
        if (numberValue >> 24 == 0) {
            numberValue <<= 8;
            i -= 8;
        }
        if (numberValue >> 28 == 0) {
            numberValue <<= 4;
            i -= 4;
        }
        if (numberValue >> 30 == 0) {
            numberValue <<= 2;
            i -= 2;
        }
        if (numberValue >> 31 == 0) {
            --i;
        }
        return i;
    }

    static int ShiftAwayTrailingZerosTwoElements(int[] arr) {
        int a0 = arr[0];
        int a1 = arr[1];
        int tz = DecimalUtility.CountTrailingZeros(a0);
        if (tz == 0) {
            return 0;
        }
        if (tz < 32) {
            int carry = a1 << 32 - tz;
            arr[0] = a0 >> tz & Integer.MAX_VALUE >> tz - 1 | carry;
            arr[1] = a1 >> tz & Integer.MAX_VALUE >> tz - 1;
            return tz;
        }
        tz = DecimalUtility.CountTrailingZeros(a1);
        arr[0] = tz == 32 ? 0 : (tz > 0 ? a1 >> tz & Integer.MAX_VALUE >> tz - 1 : a1);
        arr[1] = 0;
        return 32 + tz;
    }

    static BigInteger ShiftLeft(BigInteger val, BigInteger bigShift) {
        if (val.signum() == 0) {
            return val;
        }
        while (bigShift.compareTo(valueBigShiftIteration) > 0) {
            val = val.shiftLeft(1000000);
            bigShift = bigShift.subtract(valueBigShiftIteration);
        }
        int lastshift = bigShift.intValueChecked();
        val = val.shiftLeft(lastshift);
        return val;
    }

    static BigInteger ShiftLeftInt(BigInteger val, int shift) {
        if (val.signum() == 0) {
            return val;
        }
        while (shift > 1000000) {
            val = val.shiftLeft(1000000);
            shift -= 1000000;
        }
        int lastshift = shift;
        val = val.shiftLeft(lastshift);
        return val;
    }

    static boolean HasBitSet(int[] arr, int bit) {
        return bit >> 5 < arr.length && (arr[bit >> 5] & 1 << (bit & 0x1F)) != 0;
    }

    static BigInteger FindPowerOfFiveFromBig(BigInteger diff) {
        int sign = diff.signum();
        if (sign < 0) {
            return BigInteger.ZERO;
        }
        if (sign == 0) {
            return BigInteger.ONE;
        }
        FastInteger intcurexp = FastInteger.FromBig(diff);
        if (intcurexp.CompareToInt(54) <= 0) {
            return DecimalUtility.FindPowerOfFive(intcurexp.AsInt32());
        }
        BigInteger mantissa = BigInteger.ONE;
        BigInteger origdiff = diff;
        BigInteger bigpow = powerOfFiveCache.GetCachedPower(origdiff);
        if (bigpow != null) {
            return bigpow;
        }
        BigInteger[] otherPower = powerOfFiveCache.FindCachedPowerOrSmaller(origdiff);
        if (otherPower != null) {
            intcurexp.SubtractBig(otherPower[0]);
            mantissa = bigpow = otherPower[1];
        } else {
            bigpow = BigInteger.ZERO;
        }
        while (intcurexp.signum() > 0) {
            if (intcurexp.CompareToInt(27) <= 0) {
                bigpow = DecimalUtility.FindPowerOfFive(intcurexp.AsInt32());
                mantissa = mantissa.multiply(bigpow);
                break;
            }
            if (intcurexp.CompareToInt(9999999) <= 0) {
                bigpow = DecimalUtility.FindPowerOfFive(1).pow(intcurexp.AsInt32());
                mantissa = mantissa.multiply(bigpow);
                break;
            }
            if (bigpow.signum() == 0) {
                bigpow = DecimalUtility.FindPowerOfFive(1).pow(9999999);
            }
            mantissa = mantissa.multiply(bigpow);
            intcurexp.AddInt(-9999999);
        }
        powerOfFiveCache.AddPower(origdiff, mantissa);
        return mantissa;
    }

    static BigInteger FindPowerOfTenFromBig(BigInteger bigintExponent) {
        int sign = bigintExponent.signum();
        if (sign < 0) {
            return BigInteger.ZERO;
        }
        if (sign == 0) {
            return BigInteger.ONE;
        }
        if (bigintExponent.compareTo(valueBigInt36) <= 0) {
            return DecimalUtility.FindPowerOfTen(bigintExponent.intValueChecked());
        }
        FastInteger intcurexp = FastInteger.FromBig(bigintExponent);
        BigInteger mantissa = BigInteger.ONE;
        BigInteger bigpow = BigInteger.ZERO;
        while (intcurexp.signum() > 0) {
            if (intcurexp.CompareToInt(18) <= 0) {
                bigpow = DecimalUtility.FindPowerOfTen(intcurexp.AsInt32());
                mantissa = mantissa.multiply(bigpow);
                break;
            }
            if (intcurexp.CompareToInt(9999999) <= 0) {
                int val = intcurexp.AsInt32();
                bigpow = DecimalUtility.FindPowerOfFive(val);
                bigpow = bigpow.shiftLeft(val);
                mantissa = mantissa.multiply(bigpow);
                break;
            }
            if (bigpow.signum() == 0) {
                bigpow = DecimalUtility.FindPowerOfFive(9999999);
                bigpow = bigpow.shiftLeft(9999999);
            }
            mantissa = mantissa.multiply(bigpow);
            intcurexp.AddInt(-9999999);
        }
        return mantissa;
    }

    static BigInteger FindPowerOfFive(int precision) {
        BigInteger ret;
        BigInteger[] otherPower;
        if (precision < 0) {
            return BigInteger.ZERO;
        }
        if (precision == 0) {
            return BigInteger.ONE;
        }
        if (precision <= 27) {
            return valueBigIntPowersOfFive[precision];
        }
        if (precision == 40) {
            return valueFivePower40;
        }
        int startPrecision = precision;
        BigInteger bigpow = powerOfFiveCache.GetCachedPowerInt(precision);
        if (bigpow != null) {
            return bigpow;
        }
        BigInteger origPrecision = BigInteger.valueOf(precision);
        if (precision <= 54) {
            if ((precision & 1) == 0) {
                BigInteger ret2 = valueBigIntPowersOfFive[precision >> 1];
                ret2 = ret2.multiply(ret2);
                powerOfFiveCache.AddPower(origPrecision, ret2);
                return ret2;
            }
            BigInteger ret3 = valueBigIntPowersOfFive[27];
            bigpow = valueBigIntPowersOfFive[precision - 27];
            ret3 = ret3.multiply(bigpow);
            powerOfFiveCache.AddPower(origPrecision, ret3);
            return ret3;
        }
        if (precision > 40 && precision <= 94) {
            BigInteger ret4 = valueFivePower40;
            bigpow = DecimalUtility.FindPowerOfFive(precision - 40);
            ret4 = ret4.multiply(bigpow);
            powerOfFiveCache.AddPower(origPrecision, ret4);
            return ret4;
        }
        boolean first = true;
        bigpow = BigInteger.ZERO;
        while ((otherPower = powerOfFiveCache.FindCachedPowerOrSmaller(BigInteger.valueOf(precision))) != null) {
            BigInteger otherPower0 = otherPower[0];
            BigInteger otherPower1 = otherPower[1];
            precision -= otherPower0.intValueChecked();
            bigpow = first ? otherPower[1] : bigpow.multiply(otherPower1);
            first = false;
        }
        BigInteger bigInteger = ret = !first ? bigpow : BigInteger.ONE;
        while (precision > 0) {
            if (precision <= 27) {
                bigpow = valueBigIntPowersOfFive[precision];
                ret = first ? bigpow : ret.multiply(bigpow);
                first = false;
                break;
            }
            if (precision <= 9999999) {
                bigpow = valueBigIntPowersOfFive[1].pow(precision);
                if (precision != startPrecision) {
                    BigInteger bigprec = BigInteger.valueOf(precision);
                    powerOfFiveCache.AddPower(bigprec, bigpow);
                }
                ret = first ? bigpow : ret.multiply(bigpow);
                first = false;
                break;
            }
            if (bigpow.signum() == 0) {
                bigpow = DecimalUtility.FindPowerOfFive(9999999);
            }
            ret = first ? bigpow : ret.multiply(bigpow);
            first = false;
            precision -= 9999999;
        }
        powerOfFiveCache.AddPower(origPrecision, ret);
        return ret;
    }

    static BigInteger FindPowerOfTen(int precision) {
        BigInteger ret;
        BigInteger[] otherPower;
        if (precision < 0) {
            return BigInteger.ZERO;
        }
        if (precision == 0) {
            return BigInteger.ONE;
        }
        if (precision <= 18) {
            return valueBigIntPowersOfTen[precision];
        }
        int startPrecision = precision;
        BigInteger bigpow = powerOfTenCache.GetCachedPowerInt(precision);
        if (bigpow != null) {
            return bigpow;
        }
        BigInteger origPrecision = BigInteger.valueOf(precision);
        if (precision <= 27) {
            int prec = precision;
            BigInteger ret2 = valueBigIntPowersOfFive[prec];
            ret2 = ret2.shiftLeft(prec);
            powerOfTenCache.AddPower(origPrecision, ret2);
            return ret2;
        }
        if (precision <= 36) {
            if ((precision & 1) == 0) {
                BigInteger ret3 = valueBigIntPowersOfTen[precision >> 1];
                ret3 = ret3.multiply(ret3);
                powerOfTenCache.AddPower(origPrecision, ret3);
                return ret3;
            }
            BigInteger ret4 = valueBigIntPowersOfTen[18];
            bigpow = valueBigIntPowersOfTen[precision - 18];
            ret4 = ret4.multiply(bigpow);
            powerOfTenCache.AddPower(origPrecision, ret4);
            return ret4;
        }
        boolean first = true;
        bigpow = BigInteger.ZERO;
        while ((otherPower = powerOfTenCache.FindCachedPowerOrSmaller(BigInteger.valueOf(precision))) != null) {
            BigInteger otherPower0 = otherPower[0];
            BigInteger otherPower1 = otherPower[1];
            precision -= otherPower0.intValueChecked();
            bigpow = first ? otherPower[1] : bigpow.multiply(otherPower1);
            first = false;
        }
        BigInteger bigInteger = ret = !first ? bigpow : BigInteger.ONE;
        while (precision > 0) {
            if (precision <= 18) {
                bigpow = valueBigIntPowersOfTen[precision];
                ret = first ? bigpow : ret.multiply(bigpow);
                first = false;
                break;
            }
            if (precision <= 9999999) {
                bigpow = DecimalUtility.FindPowerOfFive(precision);
                bigpow = bigpow.shiftLeft(precision);
                if (precision != startPrecision) {
                    BigInteger bigprec = BigInteger.valueOf(precision);
                    powerOfTenCache.AddPower(bigprec, bigpow);
                }
                ret = first ? bigpow : ret.multiply(bigpow);
                first = false;
                break;
            }
            if (bigpow.signum() == 0) {
                bigpow = DecimalUtility.FindPowerOfTen(9999999);
            }
            ret = first ? bigpow : ret.multiply(bigpow);
            first = false;
            precision -= 9999999;
        }
        powerOfTenCache.AddPower(origPrecision, ret);
        return ret;
    }

    public static BigInteger ReduceTrailingZeros(BigInteger bigmant, FastInteger exponentMutable, int radix, FastInteger digits, FastInteger precision, FastInteger idealExp) {
        if (bigmant.signum() == 0) {
            exponentMutable.SetInt(0);
            return bigmant;
        }
        BigInteger bigradix = BigInteger.valueOf(radix);
        int bitToTest = 0;
        FastInteger bitsToShift = new FastInteger(0);
        while (!(bigmant.signum() == 0 || precision != null && digits.compareTo(precision) == 0 || idealExp != null && exponentMutable.compareTo(idealExp) == 0)) {
            if (radix == 2) {
                if (bitToTest < Integer.MAX_VALUE) {
                    if (bigmant.testBit(bitToTest)) break;
                    ++bitToTest;
                    bitsToShift.Increment();
                } else {
                    if (bigmant.testBit(0)) break;
                    bigmant = bigmant.shiftRight(1);
                }
            } else {
                BigInteger[] divrem = bigmant.divideAndRemainder(bigradix);
                BigInteger bigquo = divrem[0];
                BigInteger bigrem = divrem[1];
                if (bigrem.signum() != 0) break;
                bigmant = bigquo;
            }
            exponentMutable.Increment();
            if (digits == null) continue;
            digits.Decrement();
        }
        if (radix == 2 && !bitsToShift.isValueZero()) {
            while (bitsToShift.CompareToInt(1000000) > 0) {
                bigmant = bigmant.shiftRight(1000000);
                bitsToShift.SubtractInt(1000000);
            }
            int tmpshift = bitsToShift.AsInt32();
            bigmant = bigmant.shiftRight(tmpshift);
        }
        return bigmant;
    }

    private static final class PowerCache {
        private static final int MaxSize = 64;
        private final BigInteger[] outputs = new BigInteger[64];
        private final BigInteger[] inputs = new BigInteger[64];
        private final int[] inputsInts = new int[64];
        private int size;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public BigInteger[] FindCachedPowerOrSmaller(BigInteger bi) {
            BigInteger[] ret = null;
            BigInteger minValue = null;
            BigInteger[] bigIntegerArray = this.outputs;
            synchronized (this.outputs) {
                for (int i = 0; i < this.size; ++i) {
                    if (this.inputs[i].compareTo(bi) > 0 || minValue != null && this.inputs[i].compareTo(minValue) < 0) continue;
                    ret = new BigInteger[]{this.inputs[i], this.outputs[i]};
                    minValue = this.inputs[i];
                }
                // ** MonitorExit[var4_4] (shouldn't be in output)
                return ret;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public BigInteger GetCachedPower(BigInteger bi) {
            BigInteger[] bigIntegerArray = this.outputs;
            synchronized (this.outputs) {
                for (int i = 0; i < this.size; ++i) {
                    if (!bi.equals(this.inputs[i])) continue;
                    if (i != 0) {
                        BigInteger tmp = this.inputs[i];
                        this.inputs[i] = this.inputs[0];
                        this.inputs[0] = tmp;
                        int tmpi = this.inputsInts[i];
                        this.inputsInts[i] = this.inputsInts[0];
                        this.inputsInts[0] = tmpi;
                        tmp = this.outputs[i];
                        this.outputs[i] = this.outputs[0];
                        this.outputs[0] = tmp;
                        if (i != 1) {
                            tmp = this.inputs[i];
                            this.inputs[i] = this.inputs[1];
                            this.inputs[1] = tmp;
                            tmpi = this.inputsInts[i];
                            this.inputsInts[i] = this.inputsInts[1];
                            this.inputsInts[1] = tmpi;
                            tmp = this.outputs[i];
                            this.outputs[i] = this.outputs[1];
                            this.outputs[1] = tmp;
                        }
                    }
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return this.outputs[0];
                }
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public BigInteger GetCachedPowerInt(int bi) {
            BigInteger[] bigIntegerArray = this.outputs;
            synchronized (this.outputs) {
                for (int i = 0; i < this.size; ++i) {
                    if (this.inputsInts[i] < 0 || this.inputsInts[i] != bi) continue;
                    if (i != 0) {
                        BigInteger tmp = this.inputs[i];
                        this.inputs[i] = this.inputs[0];
                        this.inputs[0] = tmp;
                        int tmpi = this.inputsInts[i];
                        this.inputsInts[i] = this.inputsInts[0];
                        this.inputsInts[0] = tmpi;
                        tmp = this.outputs[i];
                        this.outputs[i] = this.outputs[0];
                        this.outputs[0] = tmp;
                        if (i != 1) {
                            tmp = this.inputs[i];
                            this.inputs[i] = this.inputs[1];
                            this.inputs[1] = tmp;
                            tmpi = this.inputsInts[i];
                            this.inputsInts[i] = this.inputsInts[1];
                            this.inputsInts[1] = tmpi;
                            tmp = this.outputs[i];
                            this.outputs[i] = this.outputs[1];
                            this.outputs[1] = tmp;
                        }
                    }
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return this.outputs[0];
                }
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void AddPower(BigInteger input, BigInteger output) {
            BigInteger[] bigIntegerArray = this.outputs;
            synchronized (this.outputs) {
                if (this.size < 64) {
                    for (int i = this.size; i > 0; --i) {
                        this.inputs[i] = this.inputs[i - 1];
                        this.inputsInts[i] = this.inputsInts[i - 1];
                        this.outputs[i] = this.outputs[i - 1];
                    }
                    this.inputs[0] = input;
                    this.inputsInts[0] = input.canFitInInt() ? input.intValueChecked() : -1;
                    this.outputs[0] = output;
                    ++this.size;
                } else {
                    for (int i = 63; i > 0; --i) {
                        this.inputs[i] = this.inputs[i - 1];
                        this.inputsInts[i] = this.inputsInts[i - 1];
                        this.outputs[i] = this.outputs[i - 1];
                    }
                    this.inputs[0] = input;
                    this.inputsInts[0] = input.canFitInInt() ? input.intValueChecked() : -1;
                    this.outputs[0] = output;
                }
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return;
            }
        }
    }
}

