/*
 * Decompiled with CFR 0.152.
 */
package com.upokecenter.cbor;

import com.upokecenter.cbor.CBORObject;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PropertyMap {
    private static Map<Class<?>, List<MethodData>> propertyLists = new HashMap();

    PropertyMap() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<MethodData> GetPropertyList(Class<?> t) {
        Map<Class<?>, List<MethodData>> map = propertyLists;
        synchronized (map) {
            List<MethodData> ret = propertyLists.get(t);
            if (ret != null) {
                return ret;
            }
            ret = new ArrayList<MethodData>();
            for (Method pi : t.getMethods()) {
                StringBuilder sb;
                MethodData md;
                if (pi.getParameterTypes().length != 0) continue;
                String methodName = pi.getName();
                if (methodName.startsWith("get") && methodName.length() > 3 && methodName.charAt(3) >= 'A' && methodName.charAt(3) <= 'Z' && !methodName.equals("getClass")) {
                    md = new MethodData();
                    md.name = methodName.substring(3);
                    if (md.name.charAt(0) >= 'A' && md.name.charAt(0) <= 'Z') {
                        sb = new StringBuilder();
                        sb.append((char)(md.name.charAt(0) + 32));
                        sb.append(md.name.substring(1));
                        md.name = sb.toString();
                    }
                    md.method = pi;
                    ret.add(md);
                    continue;
                }
                if (!methodName.startsWith("is") || methodName.length() <= 2 || methodName.charAt(2) < 'A' || methodName.charAt(2) > 'Z') continue;
                md = new MethodData();
                md.name = methodName.substring(2);
                if (md.name.charAt(0) >= 'A' && md.name.charAt(0) <= 'Z') {
                    sb = new StringBuilder();
                    sb.append((char)(md.name.charAt(0) + 32));
                    sb.append(md.name.substring(1));
                    md.name = sb.toString();
                }
                md.method = pi;
                ret.add(md);
            }
            propertyLists.put(t, ret);
            return ret;
        }
    }

    public static CBORObject FromArray(Object arr) {
        int length = Array.getLength(arr);
        CBORObject obj = CBORObject.NewArray();
        for (int i = 0; i < length; ++i) {
            obj.Add(CBORObject.FromObject(Array.get(arr, i)));
        }
        return obj;
    }

    public static Object EnumToObject(Enum<?> value) {
        return value.name();
    }

    public static Iterable<Map.Entry<String, Object>> GetProperties(Object o) {
        ArrayList<Map.Entry<String, Object>> ret = new ArrayList<Map.Entry<String, Object>>();
        try {
            for (MethodData key : PropertyMap.GetPropertyList(o.getClass())) {
                ret.add(new AbstractMap.SimpleEntry<String, Object>(key.name, key.method.invoke(o, new Object[0])));
            }
            return ret;
        }
        catch (InvocationTargetException ex) {
            throw (RuntimeException)new RuntimeException("").initCause(ex);
        }
        catch (IllegalAccessException ex) {
            throw (RuntimeException)new RuntimeException("").initCause(ex);
        }
    }

    public static Object FindOneArgumentMethod(Object obj, String name, Class<?> argtype) {
        try {
            return obj.getClass().getMethod(name, argtype);
        }
        catch (SecurityException e) {
            return null;
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    public static Object InvokeOneArgumentMethod(Object method, Object obj, Object argument) {
        if (method == null) {
            throw new NullPointerException("method");
        }
        Method m = (Method)method;
        try {
            return m.invoke(obj, argument);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    private static class MethodData {
        public String name;
        public Method method;

        private MethodData() {
        }
    }
}

