/*
 * Decompiled with CFR 0.152.
 */
package com.upokecenter.cbor;

import com.upokecenter.util.BigInteger;

final class CBORUtilities {
    private static final String HexAlphabet = "0123456789ABCDEF";

    private CBORUtilities() {
    }

    public static void ToBase16(StringBuilder str, byte[] data) {
        if (data == null) {
            throw new NullPointerException("data");
        }
        int length = data.length;
        for (int i = 0; i < length; ++i) {
            str.append(HexAlphabet.charAt(data[i] >> 4 & 0xF));
            str.append(HexAlphabet.charAt(data[i] & 0xF));
        }
    }

    public static boolean ByteArrayEquals(byte[] a, byte[] b) {
        if (a == null) {
            return b == null;
        }
        if (b == null) {
            return false;
        }
        if (a.length != b.length) {
            return false;
        }
        for (int i = 0; i < a.length; ++i) {
            if (a[i] == b[i]) continue;
            return false;
        }
        return true;
    }

    public static int ByteArrayHashCode(byte[] a) {
        if (a == null) {
            return 0;
        }
        int ret = 19;
        ret = ret * 31 + a.length;
        for (int i = 0; i < a.length; ++i) {
            ret = ret * 31 + a[i];
        }
        return ret;
    }

    public static int ByteArrayCompare(byte[] a, byte[] b) {
        if (a == null) {
            return b == null ? 0 : -1;
        }
        if (b == null) {
            return 1;
        }
        int c = Math.min(a.length, b.length);
        for (int i = 0; i < c; ++i) {
            if (a[i] == b[i]) continue;
            return a[i] < b[i] ? -1 : 1;
        }
        return a.length != b.length ? (a.length < b.length ? -1 : 1) : 0;
    }

    public static String DoubleToString(double dbl) {
        return Double.toString(dbl);
    }

    public static String SingleToString(float sing) {
        return Float.toString(sing);
    }

    public static BigInteger BigIntegerFromSingle(float flt) {
        boolean neg;
        int value = Float.floatToRawIntBits(flt);
        int fpexponent = value >> 23 & 0xFF;
        if (fpexponent == 255) {
            throw new ArithmeticException("Value is infinity or NaN");
        }
        int mantissa = value & 0x7FFFFF;
        if (fpexponent == 0) {
            ++fpexponent;
        } else {
            mantissa |= 0x800000;
        }
        if (mantissa == 0) {
            return BigInteger.ZERO;
        }
        fpexponent -= 150;
        while ((mantissa & 1) == 0) {
            ++fpexponent;
            mantissa >>= 1;
        }
        boolean bl = neg = value >> 31 != 0;
        if (fpexponent == 0) {
            if (neg) {
                mantissa = -mantissa;
            }
            return BigInteger.valueOf(mantissa);
        }
        if (fpexponent > 0) {
            BigInteger bigmantissa = BigInteger.valueOf(mantissa);
            bigmantissa = bigmantissa.shiftLeft(fpexponent);
            if (neg) {
                bigmantissa = bigmantissa.negate();
            }
            return bigmantissa;
        }
        int exp = -fpexponent;
        for (int i = 0; i < exp && mantissa != 0; mantissa >>= 1, ++i) {
        }
        return BigInteger.valueOf(mantissa);
    }

    private static void ReverseChars(char[] chars, int offset, int length) {
        int half = length >> 1;
        int right = offset + length - 1;
        int i = 0;
        while (i < half) {
            char value = chars[offset + i];
            chars[offset + i] = chars[right];
            chars[right] = value;
            ++i;
            --right;
        }
    }

    public static String LongToString(long value) {
        if (value == Long.MIN_VALUE) {
            return "-9223372036854775808";
        }
        if (value == 0L) {
            return "0";
        }
        boolean neg = value < 0L;
        char[] chars = new char[24];
        int count = 0;
        if (neg) {
            chars[0] = 45;
            ++count;
            value = -value;
        }
        while (value != 0L) {
            char digit = HexAlphabet.charAt((int)(value % 10L));
            chars[count++] = digit;
            value /= 10L;
        }
        if (neg) {
            CBORUtilities.ReverseChars(chars, 1, count - 1);
        } else {
            CBORUtilities.ReverseChars(chars, 0, count);
        }
        return new String(chars, 0, count);
    }

    public static String BigIntToString(BigInteger bigint) {
        return bigint.toString();
    }

    public static BigInteger BigIntegerFromDouble(double dbl) {
        boolean neg;
        long lvalue = Double.doubleToRawLongBits(dbl);
        int value0 = (int)(lvalue & 0xFFFFFFFFL);
        int value1 = (int)(lvalue >> 32 & 0xFFFFFFFFL);
        int floatExponent = value1 >> 20 & 0x7FF;
        boolean bl = neg = value1 >> 31 != 0;
        if (floatExponent == 2047) {
            throw new ArithmeticException("Value is infinity or NaN");
        }
        value1 &= 0xFFFFF;
        if (floatExponent == 0) {
            ++floatExponent;
        } else {
            value1 |= 0x100000;
        }
        if ((value1 | value0) != 0) {
            while ((value0 & 1) == 0) {
                value0 >>= 1;
                value0 &= Integer.MAX_VALUE;
                value0 |= value1 << 31;
                value1 >>= 1;
                ++floatExponent;
            }
        }
        byte[] bytes = new byte[]{(byte)(value0 & 0xFF), (byte)(value0 >> 8 & 0xFF), (byte)(value0 >> 16 & 0xFF), (byte)(value0 >> 24 & 0xFF), (byte)(value1 & 0xFF), (byte)(value1 >> 8 & 0xFF), (byte)(value1 >> 16 & 0xFF), (byte)(value1 >> 24 & 0xFF), 0};
        BigInteger bigmantissa = BigInteger.fromBytes(bytes, true);
        if ((floatExponent -= 1075) == 0) {
            if (neg) {
                bigmantissa = bigmantissa.negate();
            }
            return bigmantissa;
        }
        if (floatExponent > 0) {
            bigmantissa = bigmantissa.shiftLeft(floatExponent);
            if (neg) {
                bigmantissa = bigmantissa.negate();
            }
            return bigmantissa;
        }
        int exp = -floatExponent;
        bigmantissa = bigmantissa.shiftRight(exp);
        if (neg) {
            bigmantissa = bigmantissa.negate();
        }
        return bigmantissa;
    }

    public static float HalfPrecisionToSingle(int value) {
        int negvalue;
        int n = negvalue = value >= 32768 ? Integer.MIN_VALUE : 0;
        if ((value &= Short.MAX_VALUE) >= 31744) {
            value = (0x3FC00 | value & 0x3FF) << 13 | negvalue;
            return Float.intBitsToFloat(value);
        }
        if (value > 1024) {
            value = value + 114688 << 13 | negvalue;
            return Float.intBitsToFloat(value);
        }
        if ((value & 0x400) == value) {
            value = (value == 0 ? 0 : 0x38800000) | negvalue;
            return Float.intBitsToFloat(value);
        }
        int m = value & 0x3FF;
        value = 115712;
        while (m >> 10 == 0) {
            value -= 1024;
            m <<= 1;
        }
        value = (value | m & 0x3FF) << 13 | negvalue;
        return Float.intBitsToFloat(value);
    }
}

