/*
 * Decompiled with CFR 0.152.
 */
package com.upokecenter.cbor;

import com.upokecenter.cbor.Base64;
import com.upokecenter.cbor.CBORDataUtilities;
import com.upokecenter.cbor.CBORObject;
import com.upokecenter.cbor.CBORUtilities;
import com.upokecenter.cbor.CharacterInputWithCount;
import com.upokecenter.cbor.StringOutput;
import com.upokecenter.util.BigInteger;
import com.upokecenter.util.ExtendedDecimal;
import com.upokecenter.util.ExtendedFloat;
import com.upokecenter.util.ExtendedRational;
import com.upokecenter.util.PrecisionContext;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

final class CBORJson {
    private static final String Hex16 = "0123456789ABCDEF";

    private CBORJson() {
    }

    static int SkipWhitespaceJSON(CharacterInputWithCount reader) {
        int c;
        while ((c = reader.ReadChar()) != -1 && (c == 32 || c == 10 || c == 13 || c == 9)) {
        }
        return c;
    }

    static String NextJSONString(CharacterInputWithCount reader, int quote) {
        StringBuilder sb = null;
        boolean surrogate = false;
        boolean surrogateEscaped = false;
        boolean escaped = false;
        while (true) {
            int c;
            if ((c = reader.ReadChar()) == -1 || c < 32) {
                reader.RaiseError("Unterminated String");
            }
            block0 : switch (c) {
                case 92: {
                    c = reader.ReadChar();
                    escaped = true;
                    switch (c) {
                        case 92: {
                            c = 92;
                            break;
                        }
                        case 47: {
                            c = 47;
                            break;
                        }
                        case 34: {
                            c = 34;
                            break;
                        }
                        case 98: {
                            c = 8;
                            break;
                        }
                        case 102: {
                            c = 12;
                            break;
                        }
                        case 110: {
                            c = 10;
                            break;
                        }
                        case 114: {
                            c = 13;
                            break;
                        }
                        case 116: {
                            c = 9;
                            break;
                        }
                        case 117: {
                            c = 0;
                            for (int i = 0; i < 4; ++i) {
                                int ch = reader.ReadChar();
                                if (ch >= 48 && ch <= 57) {
                                    c <<= 4;
                                    c |= ch - 48;
                                    continue;
                                }
                                if (ch >= 65 && ch <= 70) {
                                    c <<= 4;
                                    c |= ch + 10 - 65;
                                    continue;
                                }
                                if (ch >= 97 && ch <= 102) {
                                    c <<= 4;
                                    c |= ch + 10 - 97;
                                    continue;
                                }
                                reader.RaiseError("Invalid Unicode escaped character");
                            }
                            break block0;
                        }
                        default: {
                            reader.RaiseError("Invalid escaped character");
                            break;
                        }
                    }
                    break;
                }
                default: {
                    escaped = false;
                }
            }
            if (surrogate) {
                if ((c & 0x1FFC00) != 56320) {
                    reader.RaiseError("Unpaired surrogate code point");
                }
                if (escaped != surrogateEscaped) {
                    reader.RaiseError("Pairing escaped surrogate with unescaped surrogate");
                }
                surrogate = false;
            } else if ((c & 0x1FFC00) == 55296) {
                surrogate = true;
                surrogateEscaped = escaped;
            } else if ((c & 0x1FFC00) == 56320) {
                reader.RaiseError("Unpaired surrogate code point");
            }
            if (c == quote && !escaped) {
                return sb == null ? "" : sb.toString();
            }
            StringBuilder stringBuilder = sb = sb == null ? new StringBuilder() : sb;
            if (c <= 65535) {
                sb.append((char)c);
                continue;
            }
            sb.append((char)((c - 65536 >> 10 & 0x3FF) + 55296));
            sb.append((char)((c - 65536 & 0x3FF) + 56320));
        }
    }

    static CBORObject NextJSONValue(CharacterInputWithCount reader, int firstChar, boolean noDuplicates, int[] nextChar, int depth) {
        int c = firstChar;
        CBORObject obj = null;
        if (c < 0) {
            reader.RaiseError("Unexpected end of data");
        }
        if (c == 34) {
            obj = CBORObject.FromRaw(CBORJson.NextJSONString(reader, c));
            nextChar[0] = CBORJson.SkipWhitespaceJSON(reader);
            return obj;
        }
        if (c == 123) {
            obj = CBORJson.ParseJSONObject(reader, noDuplicates, depth + 1);
            nextChar[0] = CBORJson.SkipWhitespaceJSON(reader);
            return obj;
        }
        if (c == 91) {
            obj = CBORJson.ParseJSONArray(reader, noDuplicates, depth + 1);
            nextChar[0] = CBORJson.SkipWhitespaceJSON(reader);
            return obj;
        }
        if (c == 116) {
            if (reader.ReadChar() != 114 || reader.ReadChar() != 117 || reader.ReadChar() != 101) {
                reader.RaiseError("Value can't be parsed.");
            }
            nextChar[0] = CBORJson.SkipWhitespaceJSON(reader);
            return CBORObject.True;
        }
        if (c == 102) {
            if (reader.ReadChar() != 97 || reader.ReadChar() != 108 || reader.ReadChar() != 115 || reader.ReadChar() != 101) {
                reader.RaiseError("Value can't be parsed.");
            }
            nextChar[0] = CBORJson.SkipWhitespaceJSON(reader);
            return CBORObject.False;
        }
        if (c == 110) {
            if (reader.ReadChar() != 117 || reader.ReadChar() != 108 || reader.ReadChar() != 108) {
                reader.RaiseError("Value can't be parsed.");
            }
            nextChar[0] = CBORJson.SkipWhitespaceJSON(reader);
            return CBORObject.Null;
        }
        if (c == 45 || c >= 48 && c <= 57) {
            StringBuilder sb = new StringBuilder();
            while (c == 45 || c == 43 || c == 46 || c >= 48 && c <= 57 || c == 101 || c == 69) {
                sb.append((char)c);
                c = reader.ReadChar();
            }
            String str = sb.toString();
            obj = CBORDataUtilities.ParseJSONNumber(str);
            if (obj == null) {
                reader.RaiseError("JSON number can't be parsed. " + str);
            }
            nextChar[0] = c == -1 || c != 32 && c != 10 && c != 13 && c != 9 ? c : CBORJson.SkipWhitespaceJSON(reader);
            return obj;
        }
        reader.RaiseError("Value can't be parsed.");
        return null;
    }

    static CBORObject ParseJSONValue(CharacterInputWithCount reader, boolean noDuplicates, boolean objectOrArrayOnly, int depth) {
        int c;
        if (depth > 1000) {
            reader.RaiseError("Too deeply nested");
        }
        if ((c = CBORJson.SkipWhitespaceJSON(reader)) == 91) {
            return CBORJson.ParseJSONArray(reader, noDuplicates, depth);
        }
        if (c == 123) {
            return CBORJson.ParseJSONObject(reader, noDuplicates, depth);
        }
        if (objectOrArrayOnly) {
            reader.RaiseError("A JSON Object must begin with '{' or '['");
        }
        int[] nextChar = new int[1];
        return CBORJson.NextJSONValue(reader, c, noDuplicates, nextChar, depth);
    }

    static CBORObject ParseJSONObject(CharacterInputWithCount reader, boolean noDuplicates, int depth) {
        if (depth > 1000) {
            reader.RaiseError("Too deeply nested");
        }
        CBORObject key = null;
        int[] nextchar = new int[1];
        boolean seenComma = false;
        HashMap<CBORObject, CBORObject> myHashMap = new HashMap<CBORObject, CBORObject>();
        block8: while (true) {
            int c = CBORJson.SkipWhitespaceJSON(reader);
            switch (c) {
                case -1: {
                    reader.RaiseError("A JSONObject must end with '}'");
                    break;
                }
                case 125: {
                    if (seenComma) {
                        reader.RaiseError("Trailing comma");
                        return null;
                    }
                    return CBORObject.FromRaw(myHashMap);
                }
                default: {
                    CBORObject obj;
                    if (c < 0) {
                        reader.RaiseError("Unexpected end of data");
                        return null;
                    }
                    if (c != 34) {
                        reader.RaiseError("Expected a String as a key");
                        return null;
                    }
                    key = obj = CBORObject.FromRaw(CBORJson.NextJSONString(reader, c));
                    if (!noDuplicates || !myHashMap.containsKey(obj)) break;
                    reader.RaiseError("Key already exists: " + key);
                    return null;
                }
            }
            if (CBORJson.SkipWhitespaceJSON(reader) != 58) {
                reader.RaiseError("Expected a ':' after a key");
            }
            myHashMap.put(key, CBORJson.NextJSONValue(reader, CBORJson.SkipWhitespaceJSON(reader), noDuplicates, nextchar, depth));
            switch (nextchar[0]) {
                case 44: {
                    seenComma = true;
                    continue block8;
                }
                case 125: {
                    return CBORObject.FromRaw(myHashMap);
                }
            }
            reader.RaiseError("Expected a ',' or '}'");
        }
    }

    static CBORObject ParseJSONArray(CharacterInputWithCount reader, boolean noDuplicates, int depth) {
        if (depth > 1000) {
            reader.RaiseError("Too deeply nested");
        }
        ArrayList<CBORObject> myArrayList = new ArrayList<CBORObject>();
        boolean seenComma = false;
        int[] nextchar = new int[1];
        block4: while (true) {
            int c;
            if ((c = CBORJson.SkipWhitespaceJSON(reader)) == 93) {
                if (seenComma) {
                    reader.RaiseError("Trailing comma");
                }
                return CBORObject.FromRaw(myArrayList);
            }
            if (c == 44) {
                reader.RaiseError("Empty array element");
            }
            myArrayList.add(CBORJson.NextJSONValue(reader, c, noDuplicates, nextchar, depth));
            c = nextchar[0];
            switch (c) {
                case 44: {
                    seenComma = true;
                    continue block4;
                }
                case 93: {
                    return CBORObject.FromRaw(myArrayList);
                }
            }
            reader.RaiseError("Expected a ',' or ']'");
        }
    }

    static void WriteJSONStringUnquoted(String str, StringOutput sb) throws IOException {
        boolean first = true;
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (c == '\\' || c == '\"') {
                if (first) {
                    first = false;
                    sb.WriteString(str, 0, i);
                }
                sb.WriteCodePoint(92);
                sb.WriteCodePoint(c);
                continue;
            }
            if (c < ' ' || c >= '\u0085' && (c == '\u2028' || c == '\u2029' || c == '\u0085' || c == '\ufeff' || c == '\ufffe' || c == '\uffff')) {
                if (first) {
                    first = false;
                    sb.WriteString(str, 0, i);
                }
                if (c == '\r') {
                    sb.WriteString("\\r");
                    continue;
                }
                if (c == '\n') {
                    sb.WriteString("\\n");
                    continue;
                }
                if (c == '\b') {
                    sb.WriteString("\\b");
                    continue;
                }
                if (c == '\f') {
                    sb.WriteString("\\f");
                    continue;
                }
                if (c == '\t') {
                    sb.WriteString("\\t");
                    continue;
                }
                if (c == '\u0085') {
                    sb.WriteString("\\u0085");
                    continue;
                }
                if (c >= '\u2028') {
                    sb.WriteString("\\u");
                    sb.WriteCodePoint(Hex16.charAt(c >> 12 & 0xF));
                    sb.WriteCodePoint(Hex16.charAt(c >> 8 & 0xF));
                    sb.WriteCodePoint(Hex16.charAt(c >> 4 & 0xF));
                    sb.WriteCodePoint(Hex16.charAt(c & 0xF));
                    continue;
                }
                sb.WriteString("\\u00");
                sb.WriteCodePoint(Hex16.charAt(c >> 4));
                sb.WriteCodePoint(Hex16.charAt(c & 0xF));
                continue;
            }
            if (first) continue;
            if ((c & 0xFC00) == 55296) {
                sb.WriteString(str, i, 2);
                ++i;
                continue;
            }
            sb.WriteCodePoint(c);
        }
        if (first) {
            sb.WriteString(str);
        }
    }

    static void WriteJSONToInternal(CBORObject obj, StringOutput writer) throws IOException {
        int type = obj.getItemType();
        Object thisItem = obj.getThisItem();
        switch (type) {
            case 6: {
                if (obj.isTrue()) {
                    writer.WriteString("true");
                    return;
                }
                if (obj.isFalse()) {
                    writer.WriteString("false");
                    return;
                }
                writer.WriteString("null");
                return;
            }
            case 7: {
                float f = ((Float)thisItem).floatValue();
                if (f == Float.NEGATIVE_INFINITY || f == Float.POSITIVE_INFINITY || Float.isNaN(f)) {
                    writer.WriteString("null");
                    return;
                }
                writer.WriteString(CBORObject.TrimDotZero(CBORUtilities.SingleToString(f)));
                return;
            }
            case 8: {
                double f = (Double)thisItem;
                if (f == Double.NEGATIVE_INFINITY || f == Double.POSITIVE_INFINITY || Double.isNaN(f)) {
                    writer.WriteString("null");
                    return;
                }
                writer.WriteString(CBORObject.TrimDotZero(CBORUtilities.DoubleToString(f)));
                return;
            }
            case 0: {
                long longItem = (Long)thisItem;
                writer.WriteString(CBORUtilities.LongToString(longItem));
                return;
            }
            case 1: {
                writer.WriteString(CBORUtilities.BigIntToString((BigInteger)thisItem));
                return;
            }
            case 9: {
                ExtendedDecimal dec = (ExtendedDecimal)thisItem;
                if (dec.IsInfinity() || dec.IsNaN()) {
                    writer.WriteString("null");
                } else {
                    writer.WriteString(dec.toString());
                }
                return;
            }
            case 11: {
                ExtendedFloat flo = (ExtendedFloat)thisItem;
                if (flo.IsInfinity() || flo.IsNaN()) {
                    writer.WriteString("null");
                    return;
                }
                if (flo.isFinite() && flo.getExponent().abs().compareTo(BigInteger.valueOf(2500L)) > 0) {
                    double f = flo.ToDouble();
                    if (f == Double.NEGATIVE_INFINITY || f == Double.POSITIVE_INFINITY || Double.isNaN(f)) {
                        writer.WriteString("null");
                        return;
                    }
                    writer.WriteString(CBORObject.TrimDotZero(CBORUtilities.DoubleToString(f)));
                    return;
                }
                writer.WriteString(flo.toString());
                return;
            }
            case 2: {
                byte[] byteArray = (byte[])thisItem;
                if (byteArray.length == 0) {
                    writer.WriteString("\"\"");
                    return;
                }
                writer.WriteCodePoint(34);
                if (obj.HasTag(22)) {
                    Base64.WriteBase64(writer, byteArray, 0, byteArray.length, false);
                } else if (obj.HasTag(23)) {
                    for (int i = 0; i < byteArray.length; ++i) {
                        writer.WriteCodePoint(Hex16.charAt(byteArray[i] >> 4 & 0xF));
                        writer.WriteCodePoint(Hex16.charAt(byteArray[i] & 0xF));
                    }
                } else {
                    Base64.WriteBase64URL(writer, byteArray, 0, byteArray.length, false);
                }
                writer.WriteCodePoint(34);
                break;
            }
            case 3: {
                String thisString = (String)thisItem;
                if (thisString.length() == 0) {
                    writer.WriteString("\"\"");
                    return;
                }
                writer.WriteCodePoint(34);
                CBORJson.WriteJSONStringUnquoted(thisString, writer);
                writer.WriteCodePoint(34);
                break;
            }
            case 4: {
                boolean first = true;
                writer.WriteCodePoint(91);
                for (CBORObject i : obj.AsList()) {
                    if (!first) {
                        writer.WriteCodePoint(44);
                    }
                    CBORJson.WriteJSONToInternal(i, writer);
                    first = false;
                }
                writer.WriteCodePoint(93);
                break;
            }
            case 12: {
                ExtendedRational dec = (ExtendedRational)thisItem;
                ExtendedDecimal f = dec.ToExtendedDecimalExactIfPossible(PrecisionContext.Decimal128.WithUnlimitedExponents());
                if (!f.isFinite()) {
                    writer.WriteString("null");
                    break;
                }
                writer.WriteString(f.toString());
                break;
            }
            case 5: {
                CBORObject value;
                Object key;
                boolean first = true;
                boolean hasNonStringKeys = false;
                Map<CBORObject, CBORObject> objMap = obj.AsMap();
                for (Map.Entry<CBORObject, CBORObject> entry : objMap.entrySet()) {
                    CBORObject cBORObject = entry.getKey();
                    if (cBORObject.getItemType() == 3) continue;
                    hasNonStringKeys = true;
                    break;
                }
                if (!hasNonStringKeys) {
                    writer.WriteCodePoint(123);
                    for (Map.Entry<CBORObject, CBORObject> entry : objMap.entrySet()) {
                        CBORObject cBORObject = entry.getKey();
                        CBORObject value2 = entry.getValue();
                        if (!first) {
                            writer.WriteCodePoint(44);
                        }
                        writer.WriteCodePoint(34);
                        CBORJson.WriteJSONStringUnquoted((String)cBORObject.getThisItem(), writer);
                        writer.WriteCodePoint(34);
                        writer.WriteCodePoint(58);
                        CBORJson.WriteJSONToInternal(value2, writer);
                        first = false;
                    }
                    writer.WriteCodePoint(125);
                    break;
                }
                HashMap<String, CBORObject> stringMap = new HashMap<String, CBORObject>();
                for (Map.Entry<CBORObject, CBORObject> entry : objMap.entrySet()) {
                    key = entry.getKey();
                    value = entry.getValue();
                    String str = ((CBORObject)key).getItemType() == 3 ? (String)((CBORObject)key).getThisItem() : ((CBORObject)key).ToJSONString();
                    stringMap.put(str, value);
                }
                first = true;
                writer.WriteCodePoint(123);
                for (Map.Entry<CBORObject, CBORObject> entry : stringMap.entrySet()) {
                    key = (String)((Object)entry.getKey());
                    value = entry.getValue();
                    if (!first) {
                        writer.WriteCodePoint(44);
                    }
                    writer.WriteCodePoint(34);
                    CBORJson.WriteJSONStringUnquoted((String)key, writer);
                    writer.WriteCodePoint(34);
                    writer.WriteCodePoint(58);
                    CBORJson.WriteJSONToInternal(value, writer);
                    first = false;
                }
                writer.WriteCodePoint(125);
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected item type");
            }
        }
    }
}

