/*
 * Decompiled with CFR 0.152.
 */
package com.upokecenter.cbor;

import com.upokecenter.cbor.Base64;
import com.upokecenter.cbor.CBORDataUtilities;
import com.upokecenter.cbor.CBORObject;
import com.upokecenter.cbor.CBORUtilities;
import com.upokecenter.cbor.CharacterReader;
import com.upokecenter.cbor.StringOutput;
import com.upokecenter.util.BigInteger;
import com.upokecenter.util.ExtendedDecimal;
import com.upokecenter.util.ExtendedFloat;
import com.upokecenter.util.ExtendedRational;
import com.upokecenter.util.PrecisionContext;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

final class CBORJson {
    private static final String Hex16 = "0123456789ABCDEF";

    private CBORJson() {
    }

    static int SkipWhitespaceJSON(CharacterReader reader) {
        int c;
        while ((c = reader.NextChar()) != -1 && (c == 32 || c == 10 || c == 13 || c == 9)) {
        }
        return c;
    }

    static String NextJSONString(CharacterReader reader, int quote) {
        StringBuilder sb = null;
        boolean surrogate = false;
        boolean surrogateEscaped = false;
        boolean escaped = false;
        while (true) {
            int c;
            if ((c = reader.NextChar()) == -1 || c < 32) {
                throw reader.NewError("Unterminated String");
            }
            block0 : switch (c) {
                case 92: {
                    c = reader.NextChar();
                    escaped = true;
                    switch (c) {
                        case 92: {
                            c = 92;
                            break block0;
                        }
                        case 47: {
                            c = 47;
                            break block0;
                        }
                        case 34: {
                            c = 34;
                            break block0;
                        }
                        case 98: {
                            c = 8;
                            break block0;
                        }
                        case 102: {
                            c = 12;
                            break block0;
                        }
                        case 110: {
                            c = 10;
                            break block0;
                        }
                        case 114: {
                            c = 13;
                            break block0;
                        }
                        case 116: {
                            c = 9;
                            break block0;
                        }
                        case 117: {
                            c = 0;
                            for (int i = 0; i < 4; ++i) {
                                int ch = reader.NextChar();
                                if (ch >= 48 && ch <= 57) {
                                    c <<= 4;
                                    c |= ch - 48;
                                    continue;
                                }
                                if (ch >= 65 && ch <= 70) {
                                    c <<= 4;
                                    c |= ch + 10 - 65;
                                    continue;
                                }
                                if (ch >= 97 && ch <= 102) {
                                    c <<= 4;
                                    c |= ch + 10 - 97;
                                    continue;
                                }
                                throw reader.NewError("Invalid Unicode escaped character");
                            }
                            break block0;
                        }
                        default: {
                            throw reader.NewError("Invalid escaped character");
                        }
                    }
                }
                default: {
                    escaped = false;
                }
            }
            if (surrogate) {
                if ((c & 0x1FFC00) != 56320) {
                    throw reader.NewError("Unpaired surrogate code point");
                }
                if (escaped != surrogateEscaped) {
                    throw reader.NewError("Pairing escaped surrogate with unescaped surrogate");
                }
                surrogate = false;
            } else if ((c & 0x1FFC00) == 55296) {
                surrogate = true;
                surrogateEscaped = escaped;
            } else if ((c & 0x1FFC00) == 56320) {
                throw reader.NewError("Unpaired surrogate code point");
            }
            if (c == quote && !escaped) {
                return sb == null ? "" : sb.toString();
            }
            StringBuilder stringBuilder = sb = sb == null ? new StringBuilder() : sb;
            if (c <= 65535) {
                sb.append((char)c);
                continue;
            }
            sb.append((char)((c - 65536 >> 10 & 0x3FF) + 55296));
            sb.append((char)((c - 65536 & 0x3FF) + 56320));
        }
    }

    static CBORObject NextJSONValue(CharacterReader reader, int firstChar, boolean noDuplicates, int[] nextChar, int depth) {
        int c = firstChar;
        CBORObject obj = null;
        if (c < 0) {
            throw reader.NewError("Unexpected end of data");
        }
        if (c == 34) {
            obj = CBORObject.FromRaw(CBORJson.NextJSONString(reader, c));
            nextChar[0] = CBORJson.SkipWhitespaceJSON(reader);
            return obj;
        }
        if (c == 123) {
            obj = CBORJson.ParseJSONObject(reader, noDuplicates, depth + 1);
            nextChar[0] = CBORJson.SkipWhitespaceJSON(reader);
            return obj;
        }
        if (c == 91) {
            obj = CBORJson.ParseJSONArray(reader, noDuplicates, depth + 1);
            nextChar[0] = CBORJson.SkipWhitespaceJSON(reader);
            return obj;
        }
        if (c == 116) {
            if (reader.NextChar() != 114 || reader.NextChar() != 117 || reader.NextChar() != 101) {
                throw reader.NewError("Value can't be parsed.");
            }
            nextChar[0] = CBORJson.SkipWhitespaceJSON(reader);
            return CBORObject.True;
        }
        if (c == 102) {
            if (reader.NextChar() != 97 || reader.NextChar() != 108 || reader.NextChar() != 115 || reader.NextChar() != 101) {
                throw reader.NewError("Value can't be parsed.");
            }
            nextChar[0] = CBORJson.SkipWhitespaceJSON(reader);
            return CBORObject.False;
        }
        if (c == 110) {
            if (reader.NextChar() != 117 || reader.NextChar() != 108 || reader.NextChar() != 108) {
                throw reader.NewError("Value can't be parsed.");
            }
            nextChar[0] = CBORJson.SkipWhitespaceJSON(reader);
            return CBORObject.Null;
        }
        if (c == 45 || c >= 48 && c <= 57) {
            StringBuilder sb = new StringBuilder();
            while (c == 45 || c == 43 || c == 46 || c >= 48 && c <= 57 || c == 101 || c == 69) {
                sb.append((char)c);
                c = reader.NextChar();
            }
            String str = sb.toString();
            obj = CBORDataUtilities.ParseJSONNumber(str);
            if (obj == null) {
                throw reader.NewError("JSON number can't be parsed. " + str);
            }
            nextChar[0] = c == -1 || c != 32 && c != 10 && c != 13 && c != 9 ? c : CBORJson.SkipWhitespaceJSON(reader);
            return obj;
        }
        throw reader.NewError("Value can't be parsed.");
    }

    static CBORObject ParseJSONValue(CharacterReader reader, boolean noDuplicates, boolean objectOrArrayOnly, int depth) {
        if (depth > 1000) {
            throw reader.NewError("Too deeply nested");
        }
        int c = CBORJson.SkipWhitespaceJSON(reader);
        if (c == 91) {
            return CBORJson.ParseJSONArray(reader, noDuplicates, depth);
        }
        if (c == 123) {
            return CBORJson.ParseJSONObject(reader, noDuplicates, depth);
        }
        if (objectOrArrayOnly) {
            throw reader.NewError("A JSON Object must begin with '{' or '['");
        }
        int[] nextChar = new int[1];
        return CBORJson.NextJSONValue(reader, c, noDuplicates, nextChar, depth);
    }

    static CBORObject ParseJSONObject(CharacterReader reader, boolean noDuplicates, int depth) {
        if (depth > 1000) {
            throw reader.NewError("Too deeply nested");
        }
        int[] nextchar = new int[1];
        boolean seenComma = false;
        HashMap<CBORObject, CBORObject> myHashMap = new HashMap<CBORObject, CBORObject>();
        block8: while (true) {
            CBORObject obj;
            int c = CBORJson.SkipWhitespaceJSON(reader);
            switch (c) {
                case -1: {
                    throw reader.NewError("A JSONObject must end with '}'");
                }
                case 125: {
                    if (seenComma) {
                        throw reader.NewError("Trailing comma");
                    }
                    return CBORObject.FromRaw(myHashMap);
                }
            }
            if (c < 0) {
                throw reader.NewError("Unexpected end of data");
            }
            if (c != 34) {
                throw reader.NewError("Expected a String as a key");
            }
            CBORObject key = obj = CBORObject.FromRaw(CBORJson.NextJSONString(reader, c));
            if (noDuplicates && myHashMap.containsKey(obj)) {
                throw reader.NewError("Key already exists: " + key);
            }
            if (CBORJson.SkipWhitespaceJSON(reader) != 58) {
                throw reader.NewError("Expected a ':' after a key");
            }
            myHashMap.put(key, CBORJson.NextJSONValue(reader, CBORJson.SkipWhitespaceJSON(reader), noDuplicates, nextchar, depth));
            switch (nextchar[0]) {
                case 44: {
                    seenComma = true;
                    continue block8;
                }
                case 125: {
                    return CBORObject.FromRaw(myHashMap);
                }
            }
            break;
        }
        throw reader.NewError("Expected a ',' or '}'");
    }

    static CBORObject ParseJSONArray(CharacterReader reader, boolean noDuplicates, int depth) {
        if (depth > 1000) {
            throw reader.NewError("Too deeply nested");
        }
        ArrayList<CBORObject> myArrayList = new ArrayList<CBORObject>();
        boolean seenComma = false;
        int[] nextchar = new int[1];
        block4: while (true) {
            int c;
            if ((c = CBORJson.SkipWhitespaceJSON(reader)) == 93) {
                if (seenComma) {
                    throw reader.NewError("Trailing comma");
                }
                return CBORObject.FromRaw(myArrayList);
            }
            if (c == 44) {
                throw reader.NewError("Empty array element");
            }
            myArrayList.add(CBORJson.NextJSONValue(reader, c, noDuplicates, nextchar, depth));
            c = nextchar[0];
            switch (c) {
                case 44: {
                    seenComma = true;
                    continue block4;
                }
                case 93: {
                    return CBORObject.FromRaw(myArrayList);
                }
            }
            break;
        }
        throw reader.NewError("Expected a ',' or ']'");
    }

    static void WriteJSONStringUnquoted(String str, StringOutput sb) throws IOException {
        boolean first = true;
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (c == '\\' || c == '\"') {
                if (first) {
                    first = false;
                    sb.WriteString(str, 0, i);
                }
                sb.WriteChar('\\');
                sb.WriteChar(c);
                continue;
            }
            if (c < ' ' || c >= '\u0085' && (c == '\u2028' || c == '\u2029' || c == '\u0085' || c == '\ufeff' || c == '\ufffe' || c == '\uffff')) {
                if (first) {
                    first = false;
                    sb.WriteString(str, 0, i);
                }
                if (c == '\r') {
                    sb.WriteString("\\r");
                    continue;
                }
                if (c == '\n') {
                    sb.WriteString("\\n");
                    continue;
                }
                if (c == '\b') {
                    sb.WriteString("\\b");
                    continue;
                }
                if (c == '\f') {
                    sb.WriteString("\\f");
                    continue;
                }
                if (c == '\t') {
                    sb.WriteString("\\t");
                    continue;
                }
                if (c == '\u0085') {
                    sb.WriteString("\\u0085");
                    continue;
                }
                if (c >= '\u2028') {
                    sb.WriteString("\\u");
                    sb.WriteChar(Hex16.charAt(c >> 12 & 0xF));
                    sb.WriteChar(Hex16.charAt(c >> 8 & 0xF));
                    sb.WriteChar(Hex16.charAt(c >> 4 & 0xF));
                    sb.WriteChar(Hex16.charAt(c & 0xF));
                    continue;
                }
                sb.WriteString("\\u00");
                sb.WriteChar(Hex16.charAt(c >> 4));
                sb.WriteChar(Hex16.charAt(c & 0xF));
                continue;
            }
            if (first) continue;
            if ((c & 0xFC00) == 55296) {
                sb.WriteString(str, i, 2);
                ++i;
                continue;
            }
            sb.WriteChar(c);
        }
        if (first) {
            sb.WriteString(str);
        }
    }

    static void WriteJSONToInternal(CBORObject obj, StringOutput writer) throws IOException {
        int type = obj.getItemType();
        Object thisItem = obj.getThisItem();
        switch (type) {
            case 6: {
                if (obj.isTrue()) {
                    writer.WriteString("true");
                    return;
                }
                if (obj.isFalse()) {
                    writer.WriteString("false");
                    return;
                }
                writer.WriteString("null");
                return;
            }
            case 7: {
                float f = ((Float)thisItem).floatValue();
                if (f == Float.NEGATIVE_INFINITY || f == Float.POSITIVE_INFINITY || Float.isNaN(f)) {
                    writer.WriteString("null");
                    return;
                }
                writer.WriteString(CBORObject.TrimDotZero(Float.toString(f)));
                return;
            }
            case 8: {
                double f = (Double)thisItem;
                if (f == Double.NEGATIVE_INFINITY || f == Double.POSITIVE_INFINITY || Double.isNaN(f)) {
                    writer.WriteString("null");
                    return;
                }
                writer.WriteString(CBORObject.TrimDotZero(Double.toString(f)));
                return;
            }
            case 0: {
                long longItem = (Long)thisItem;
                writer.WriteString(CBORUtilities.LongToString(longItem));
                return;
            }
            case 1: {
                writer.WriteString(CBORUtilities.BigIntToString((BigInteger)thisItem));
                return;
            }
            case 9: {
                ExtendedDecimal dec = (ExtendedDecimal)thisItem;
                if (dec.IsInfinity() || dec.IsNaN()) {
                    writer.WriteString("null");
                } else {
                    writer.WriteString(dec.toString());
                }
                return;
            }
            case 11: {
                ExtendedFloat flo = (ExtendedFloat)thisItem;
                if (flo.IsInfinity() || flo.IsNaN()) {
                    writer.WriteString("null");
                    return;
                }
                if (flo.isFinite() && flo.getExponent().abs().compareTo(BigInteger.valueOf(2500L)) > 0) {
                    double f = flo.ToDouble();
                    if (f == Double.NEGATIVE_INFINITY || f == Double.POSITIVE_INFINITY || Double.isNaN(f)) {
                        writer.WriteString("null");
                        return;
                    }
                    writer.WriteString(CBORObject.TrimDotZero(Double.toString(f)));
                    return;
                }
                writer.WriteString(flo.toString());
                return;
            }
            case 2: {
                byte[] byteArray = (byte[])thisItem;
                if (byteArray.length == 0) {
                    writer.WriteString("\"\"");
                    return;
                }
                writer.WriteChar('\"');
                if (obj.HasTag(22)) {
                    Base64.WriteBase64(writer, byteArray, 0, byteArray.length, false);
                } else if (obj.HasTag(23)) {
                    for (int i = 0; i < byteArray.length; ++i) {
                        writer.WriteChar(Hex16.charAt(byteArray[i] >> 4 & 0xF));
                        writer.WriteChar(Hex16.charAt(byteArray[i] & 0xF));
                    }
                } else {
                    Base64.WriteBase64URL(writer, byteArray, 0, byteArray.length, false);
                }
                writer.WriteChar('\"');
                break;
            }
            case 3: {
                String thisString = (String)thisItem;
                if (thisString.length() == 0) {
                    writer.WriteString("\"\"");
                    return;
                }
                writer.WriteChar('\"');
                CBORJson.WriteJSONStringUnquoted(thisString, writer);
                writer.WriteChar('\"');
                break;
            }
            case 4: {
                boolean first = true;
                writer.WriteChar('[');
                for (CBORObject i : obj.AsList()) {
                    if (!first) {
                        writer.WriteChar(',');
                    }
                    CBORJson.WriteJSONToInternal(i, writer);
                    first = false;
                }
                writer.WriteChar(']');
                break;
            }
            case 12: {
                ExtendedRational dec = (ExtendedRational)thisItem;
                ExtendedDecimal f = dec.ToExtendedDecimalExactIfPossible(PrecisionContext.Decimal128.WithUnlimitedExponents());
                if (!f.isFinite()) {
                    writer.WriteString("null");
                    break;
                }
                writer.WriteString(f.toString());
                break;
            }
            case 5: {
                CBORObject value;
                Object key;
                boolean first = true;
                boolean hasNonStringKeys = false;
                Map<CBORObject, CBORObject> objMap = obj.AsMap();
                for (Map.Entry<CBORObject, CBORObject> entry : objMap.entrySet()) {
                    CBORObject cBORObject = entry.getKey();
                    if (cBORObject.getItemType() == 3) continue;
                    hasNonStringKeys = true;
                    break;
                }
                if (!hasNonStringKeys) {
                    writer.WriteChar('{');
                    for (Map.Entry<CBORObject, CBORObject> entry : objMap.entrySet()) {
                        CBORObject cBORObject = entry.getKey();
                        CBORObject value2 = entry.getValue();
                        if (!first) {
                            writer.WriteChar(',');
                        }
                        writer.WriteChar('\"');
                        CBORJson.WriteJSONStringUnquoted((String)cBORObject.getThisItem(), writer);
                        writer.WriteChar('\"');
                        writer.WriteChar(':');
                        CBORJson.WriteJSONToInternal(value2, writer);
                        first = false;
                    }
                    writer.WriteChar('}');
                    break;
                }
                HashMap<String, CBORObject> stringMap = new HashMap<String, CBORObject>();
                for (Map.Entry<CBORObject, CBORObject> entry : objMap.entrySet()) {
                    key = entry.getKey();
                    value = entry.getValue();
                    String str = ((CBORObject)key).getItemType() == 3 ? (String)((CBORObject)key).getThisItem() : ((CBORObject)key).ToJSONString();
                    stringMap.put(str, value);
                }
                first = true;
                writer.WriteChar('{');
                for (Map.Entry<CBORObject, CBORObject> entry : stringMap.entrySet()) {
                    key = (String)((Object)entry.getKey());
                    value = entry.getValue();
                    if (!first) {
                        writer.WriteChar(',');
                    }
                    writer.WriteChar('\"');
                    CBORJson.WriteJSONStringUnquoted((String)key, writer);
                    writer.WriteChar('\"');
                    writer.WriteChar(':');
                    CBORJson.WriteJSONToInternal(value, writer);
                    first = false;
                }
                writer.WriteChar('}');
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected item type");
            }
        }
    }
}

