/*
 * Decompiled with CFR 0.152.
 */
package com.upokecenter.util;

import java.util.Arrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BigInteger
implements Comparable<BigInteger> {
    private static final int RecursionLimit = 10;
    private boolean negative;
    private int wordCount = -1;
    private short[] reg;
    private static final String HexChars = "0123456789ABCDEF";
    private static final int MaxSafeInt = 0xCCCCCCB;
    public static final BigInteger ZERO = new BigInteger().InitializeInt(0);
    public static final BigInteger ONE = new BigInteger().InitializeInt(1);
    public static final BigInteger TEN = new BigInteger().InitializeInt(10);

    private static int CountWords(short[] array, int n) {
        while (n != 0 && array[n - 1] == 0) {
            --n;
        }
        return n;
    }

    private static short ShiftWordsLeftByBits(short[] r, int rstart, int n, int shiftBits) {
        short carry = 0;
        if (shiftBits != 0) {
            for (int i = 0; i < n; ++i) {
                short u = r[rstart + i];
                r[rstart + i] = (short)(u << shiftBits | carry & 0xFFFF);
                carry = (short)((u & 0xFFFF) >> 16 - shiftBits);
            }
        }
        return carry;
    }

    private static short ShiftWordsRightByBits(short[] r, int rstart, int n, int shiftBits) {
        short carry = 0;
        if (shiftBits != 0) {
            for (int i = n; i > 0; --i) {
                short u = r[rstart + i - 1];
                r[rstart + i - 1] = (short)((u & 0xFFFF) >> shiftBits & 0xFFFF | carry & 0xFFFF);
                carry = (short)((u & 0xFFFF) << 16 - shiftBits);
            }
        }
        return carry;
    }

    private static short ShiftWordsRightByBitsSignExtend(short[] r, int rstart, int n, int shiftBits) {
        short carry = (short)(65535 << 16 - shiftBits);
        if (shiftBits != 0) {
            for (int i = n; i > 0; --i) {
                short u = r[rstart + i - 1];
                r[rstart + i - 1] = (short)((u & 0xFFFF) >> shiftBits | carry & 0xFFFF);
                carry = (short)((u & 0xFFFF) << 16 - shiftBits);
            }
        }
        return carry;
    }

    private static void ShiftWordsLeftByWords(short[] r, int rstart, int n, int shiftWords) {
        if ((shiftWords = Math.min(shiftWords, n)) != 0) {
            for (int i = n - 1; i >= shiftWords; --i) {
                r[rstart + i] = r[rstart + i - shiftWords];
            }
            Arrays.fill(r, rstart, rstart + shiftWords, (short)0);
        }
    }

    private static void ShiftWordsRightByWordsSignExtend(short[] r, int rstart, int n, int shiftWords) {
        if ((shiftWords = Math.min(shiftWords, n)) != 0) {
            int i = 0;
            while (i + shiftWords < n) {
                r[rstart + i] = r[rstart + i + shiftWords];
                ++i;
            }
            rstart += n - shiftWords;
            for (i = 0; i < shiftWords; ++i) {
                r[rstart + i] = -1;
            }
        }
    }

    private static int Compare(short[] words1, int astart, short[] words2, int bstart, int n) {
        while (n-- != 0) {
            int an = words1[astart + n] & 0xFFFF;
            int bn = words2[bstart + n] & 0xFFFF;
            if (an > bn) {
                return 1;
            }
            if (an >= bn) continue;
            return -1;
        }
        return 0;
    }

    private static int CompareWithOneBiggerWords1(short[] words1, int astart, short[] words2, int bstart, int words1Count) {
        block2: {
            int bn;
            int an;
            if (words1[astart + words1Count - 1] != 0) {
                return 1;
            }
            do {
                int n = --words1Count;
                --words1Count;
                if (n == 0) break block2;
                an = words1[astart + words1Count] & 0xFFFF;
                bn = words2[bstart + words1Count] & 0xFFFF;
                if (an <= bn) continue;
                return 1;
            } while (an >= bn);
            return -1;
        }
        return 0;
    }

    private static int Increment(short[] words1, int words1Start, int n, short words2) {
        short tmp = words1[words1Start];
        words1[words1Start] = (short)(tmp + words2);
        if ((words1[words1Start] & 0xFFFF) >= (tmp & 0xFFFF)) {
            return 0;
        }
        for (int i = 1; i < n; ++i) {
            int n2 = words1Start + i;
            words1[n2] = (short)(words1[n2] + 1);
            if (words1[words1Start + i] == 0) continue;
            return 0;
        }
        return 1;
    }

    private static int Decrement(short[] words1, int words1Start, int n, short words2) {
        short tmp = words1[words1Start];
        words1[words1Start] = (short)(tmp - words2);
        if ((words1[words1Start] & 0xFFFF) <= (tmp & 0xFFFF)) {
            return 0;
        }
        for (int i = 1; i < n; ++i) {
            tmp = words1[words1Start + i];
            int n2 = words1Start + i;
            words1[n2] = (short)(words1[n2] - 1);
            if (tmp == 0) continue;
            return 0;
        }
        return 1;
    }

    private static void TwosComplement(short[] words1, int words1Start, int n) {
        BigInteger.Decrement(words1, words1Start, n, (short)1);
        for (int i = 0; i < n; ++i) {
            words1[words1Start + i] = ~words1[words1Start + i];
        }
    }

    private static int Add(short[] c, int cstart, short[] words1, int astart, short[] words2, int bstart, int n) {
        int u = 0;
        for (int i = 0; i < n; i += 2) {
            u = (words1[astart + i] & 0xFFFF) + (words2[bstart + i] & 0xFFFF) + (short)(u >> 16);
            c[cstart + i] = (short)u;
            u = (words1[astart + i + 1] & 0xFFFF) + (words2[bstart + i + 1] & 0xFFFF) + (short)(u >> 16);
            c[cstart + i + 1] = (short)u;
        }
        return u >> 16 & 0xFFFF;
    }

    private static int AddOneByOne(short[] c, int cstart, short[] words1, int astart, short[] words2, int bstart, int n) {
        int u = 0;
        for (int i = 0; i < n; ++i) {
            u = (words1[astart + i] & 0xFFFF) + (words2[bstart + i] & 0xFFFF) + (short)(u >> 16);
            c[cstart + i] = (short)u;
        }
        return u >> 16 & 0xFFFF;
    }

    private static int SubtractOneBiggerWords1(short[] c, int cstart, short[] words1, int astart, short[] words2, int bstart, int words1Count) {
        int u = 0;
        int cm1 = words1Count - 1;
        for (int i = 0; i < cm1; ++i) {
            u = (words1[astart] & 0xFFFF) - (words2[bstart] & 0xFFFF) - (u >> 31 & 1);
            c[cstart++] = (short)u;
            ++astart;
            ++bstart;
        }
        u = (words1[astart] & 0xFFFF) - (u >> 31 & 1);
        c[cstart++] = (short)u;
        return u >> 31 & 1;
    }

    private static int SubtractOneBiggerWords2(short[] c, int cstart, short[] words1, int astart, short[] words2, int bstart, int words2Count) {
        int u = 0;
        int cm1 = words2Count - 1;
        for (int i = 0; i < cm1; ++i) {
            u = (words1[astart] & 0xFFFF) - (words2[bstart] & 0xFFFF) - (u >> 31 & 1);
            c[cstart++] = (short)u;
            ++astart;
            ++bstart;
        }
        u = 0 - (words2[bstart] & 0xFFFF) - (u >> 31 & 1);
        c[cstart++] = (short)u;
        return u >> 31 & 1;
    }

    private static int AddUnevenSize(short[] c, int cstart, short[] wordsBigger, int astart, int acount, short[] wordsSmaller, int bstart, int bcount) {
        int i;
        int u = 0;
        for (i = 0; i < bcount; ++i) {
            u = (wordsBigger[astart + i] & 0xFFFF) + (wordsSmaller[bstart + i] & 0xFFFF) + (short)(u >> 16);
            c[cstart + i] = (short)u;
        }
        for (i = bcount; i < acount; ++i) {
            u = (wordsBigger[astart + i] & 0xFFFF) + (short)(u >> 16);
            c[cstart + i] = (short)u;
        }
        return u >> 16 & 0xFFFF;
    }

    private static int Subtract(short[] c, int cstart, short[] words1, int astart, short[] words2, int bstart, int n) {
        int u = 0;
        for (int i = 0; i < n; i += 2) {
            u = (words1[astart] & 0xFFFF) - (words2[bstart] & 0xFFFF) - (u >> 31 & 1);
            c[cstart++] = (short)u;
            u = (words1[++astart] & 0xFFFF) - (words2[++bstart] & 0xFFFF) - (u >> 31 & 1);
            c[cstart++] = (short)u;
            ++astart;
            ++bstart;
        }
        return u >> 31 & 1;
    }

    private static int SubtractOneByOne(short[] c, int cstart, short[] words1, int astart, short[] words2, int bstart, int n) {
        int u = 0;
        for (int i = 0; i < n; ++i) {
            u = (words1[astart] & 0xFFFF) - (words2[bstart] & 0xFFFF) - (u >> 31 & 1);
            c[cstart++] = (short)u;
            ++astart;
            ++bstart;
        }
        return u >> 31 & 1;
    }

    private static short LinearMultiplyAdd(short[] productArr, int cstart, short[] words1, int astart, short words2, int n) {
        short carry = 0;
        int bint = words2 & 0xFFFF;
        for (int i = 0; i < n; ++i) {
            int p = (words1[astart + i] & 0xFFFF) * bint;
            p += carry & 0xFFFF;
            productArr[cstart + i] = (short)(p += productArr[cstart + i] & 0xFFFF);
            carry = (short)(p >> 16);
        }
        return carry;
    }

    private static short LinearMultiply(short[] productArr, int cstart, short[] words1, int astart, short words2, int n) {
        short carry = 0;
        int bint = words2 & 0xFFFF;
        for (int i = 0; i < n; ++i) {
            int p = (words1[astart + i] & 0xFFFF) * bint;
            productArr[cstart + i] = (short)(p += carry & 0xFFFF);
            carry = (short)(p >> 16);
        }
        return carry;
    }

    private static void Baseline_Square2(short[] result, int rstart, short[] words1, int astart) {
        int p = (words1[astart] & 0xFFFF) * (words1[astart] & 0xFFFF);
        result[rstart] = (short)p;
        int e = p >> 16 & 0xFFFF;
        p = (words1[astart] & 0xFFFF) * (words1[astart + 1] & 0xFFFF);
        short c = (short)p;
        int d = p >> 16 & 0xFFFF;
        d = (d << 1) + (c >> 15 & 1);
        c = (short)(c << 1);
        e += c & 0xFFFF;
        c = (short)e;
        e = d + (e >> 16 & 0xFFFF);
        result[rstart + 1] = c;
        p = (words1[astart + 1] & 0xFFFF) * (words1[astart + 1] & 0xFFFF);
        result[rstart + 2] = (short)(p += e);
        result[rstart + 3] = (short)(p >> 16);
    }

    private static void Baseline_Square4(short[] result, int rstart, short[] words1, int astart) {
        int p = (words1[astart] & 0xFFFF) * (words1[astart] & 0xFFFF);
        result[rstart] = (short)p;
        int e = p >> 16 & 0xFFFF;
        p = (words1[astart] & 0xFFFF) * (words1[astart + 1] & 0xFFFF);
        short c = (short)p;
        int d = p >> 16 & 0xFFFF;
        d = (d << 1) + (c >> 15 & 1);
        c = (short)(c << 1);
        e += c & 0xFFFF;
        c = (short)e;
        e = d + (e >> 16 & 0xFFFF);
        result[rstart + 1] = c;
        p = (words1[astart] & 0xFFFF) * (words1[astart + 2] & 0xFFFF);
        c = (short)p;
        d = p >> 16 & 0xFFFF;
        d = (d << 1) + (c >> 15 & 1);
        c = (short)(c << 1);
        p = (words1[astart + 1] & 0xFFFF) * (words1[astart + 1] & 0xFFFF);
        p += c & 0xFFFF;
        c = (short)p;
        e += c & 0xFFFF;
        c = (short)e;
        e = (d += p >> 16 & 0xFFFF) + (e >> 16 & 0xFFFF);
        result[rstart + 2] = c;
        p = (words1[astart] & 0xFFFF) * (words1[astart + 3] & 0xFFFF);
        c = (short)p;
        d = p >> 16 & 0xFFFF;
        p = (words1[astart + 1] & 0xFFFF) * (words1[astart + 2] & 0xFFFF);
        p += c & 0xFFFF;
        c = (short)p;
        d += p >> 16 & 0xFFFF;
        d = (d << 1) + (c >> 15 & 1);
        c = (short)(c << 1);
        e += c & 0xFFFF;
        c = (short)e;
        e = d + (e >> 16 & 0xFFFF);
        result[rstart + 3] = c;
        p = (words1[astart + 1] & 0xFFFF) * (words1[astart + 3] & 0xFFFF);
        c = (short)p;
        d = p >> 16 & 0xFFFF;
        d = (d << 1) + (c >> 15 & 1);
        c = (short)(c << 1);
        p = (words1[astart + 2] & 0xFFFF) * (words1[astart + 2] & 0xFFFF);
        p += c & 0xFFFF;
        c = (short)p;
        e += c & 0xFFFF;
        c = (short)e;
        e = (d += p >> 16 & 0xFFFF) + (e >> 16 & 0xFFFF);
        result[rstart + 4] = c;
        p = (words1[astart + 2] & 0xFFFF) * (words1[astart + 3] & 0xFFFF);
        c = (short)p;
        d = p >> 16 & 0xFFFF;
        d = (d << 1) + (c >> 15 & 1);
        c = (short)(c << 1);
        e += c & 0xFFFF;
        c = (short)e;
        e = d + (e >> 16 & 0xFFFF);
        result[rstart + 8 - 3] = c;
        p = (words1[astart + 3] & 0xFFFF) * (words1[astart + 3] & 0xFFFF);
        result[rstart + 6] = (short)(p += e);
        result[rstart + 7] = (short)(p >> 16);
    }

    private static void Baseline_Square8(short[] result, int rstart, short[] words1, int astart) {
        int p = (words1[astart] & 0xFFFF) * (words1[astart] & 0xFFFF);
        result[rstart] = (short)p;
        int e = p >> 16 & 0xFFFF;
        p = (words1[astart] & 0xFFFF) * (words1[astart + 1] & 0xFFFF);
        short c = (short)p;
        int d = p >> 16 & 0xFFFF;
        d = (d << 1) + (c >> 15 & 1);
        c = (short)(c << 1);
        e += c & 0xFFFF;
        c = (short)e;
        e = d + (e >> 16 & 0xFFFF);
        result[rstart + 1] = c;
        p = (words1[astart] & 0xFFFF) * (words1[astart + 2] & 0xFFFF);
        c = (short)p;
        d = p >> 16 & 0xFFFF;
        d = (d << 1) + (c >> 15 & 1);
        c = (short)(c << 1);
        p = (words1[astart + 1] & 0xFFFF) * (words1[astart + 1] & 0xFFFF);
        p += c & 0xFFFF;
        c = (short)p;
        e += c & 0xFFFF;
        c = (short)e;
        e = (d += p >> 16 & 0xFFFF) + (e >> 16 & 0xFFFF);
        result[rstart + 2] = c;
        p = (words1[astart] & 0xFFFF) * (words1[astart + 3] & 0xFFFF);
        c = (short)p;
        d = p >> 16 & 0xFFFF;
        p = (words1[astart + 1] & 0xFFFF) * (words1[astart + 2] & 0xFFFF);
        p += c & 0xFFFF;
        c = (short)p;
        d += p >> 16 & 0xFFFF;
        d = (d << 1) + (c >> 15 & 1);
        c = (short)(c << 1);
        e += c & 0xFFFF;
        c = (short)e;
        e = d + (e >> 16 & 0xFFFF);
        result[rstart + 3] = c;
        p = (words1[astart] & 0xFFFF) * (words1[astart + 4] & 0xFFFF);
        c = (short)p;
        d = p >> 16 & 0xFFFF;
        p = (words1[astart + 1] & 0xFFFF) * (words1[astart + 3] & 0xFFFF);
        p += c & 0xFFFF;
        c = (short)p;
        d += p >> 16 & 0xFFFF;
        d = (d << 1) + (c >> 15 & 1);
        c = (short)(c << 1);
        p = (words1[astart + 2] & 0xFFFF) * (words1[astart + 2] & 0xFFFF);
        p += c & 0xFFFF;
        c = (short)p;
        e += c & 0xFFFF;
        c = (short)e;
        e = (d += p >> 16 & 0xFFFF) + (e >> 16 & 0xFFFF);
        result[rstart + 4] = c;
        p = (words1[astart] & 0xFFFF) * (words1[astart + 5] & 0xFFFF);
        c = (short)p;
        d = p >> 16 & 0xFFFF;
        p = (words1[astart + 1] & 0xFFFF) * (words1[astart + 4] & 0xFFFF);
        p += c & 0xFFFF;
        c = (short)p;
        d += p >> 16 & 0xFFFF;
        p = (words1[astart + 2] & 0xFFFF) * (words1[astart + 3] & 0xFFFF);
        p += c & 0xFFFF;
        c = (short)p;
        d += p >> 16 & 0xFFFF;
        d = (d << 1) + (c >> 15 & 1);
        c = (short)(c << 1);
        e += c & 0xFFFF;
        c = (short)e;
        e = d + (e >> 16 & 0xFFFF);
        result[rstart + 5] = c;
        p = (words1[astart] & 0xFFFF) * (words1[astart + 6] & 0xFFFF);
        c = (short)p;
        d = p >> 16 & 0xFFFF;
        p = (words1[astart + 1] & 0xFFFF) * (words1[astart + 5] & 0xFFFF);
        p += c & 0xFFFF;
        c = (short)p;
        d += p >> 16 & 0xFFFF;
        p = (words1[astart + 2] & 0xFFFF) * (words1[astart + 4] & 0xFFFF);
        p += c & 0xFFFF;
        c = (short)p;
        d += p >> 16 & 0xFFFF;
        d = (d << 1) + (c >> 15 & 1);
        c = (short)(c << 1);
        p = (words1[astart + 3] & 0xFFFF) * (words1[astart + 3] & 0xFFFF);
        p += c & 0xFFFF;
        c = (short)p;
        e += c & 0xFFFF;
        c = (short)e;
        e = (d += p >> 16 & 0xFFFF) + (e >> 16 & 0xFFFF);
        result[rstart + 6] = c;
        p = (words1[astart] & 0xFFFF) * (words1[astart + 7] & 0xFFFF);
        c = (short)p;
        d = p >> 16 & 0xFFFF;
        p = (words1[astart + 1] & 0xFFFF) * (words1[astart + 6] & 0xFFFF);
        p += c & 0xFFFF;
        c = (short)p;
        d += p >> 16 & 0xFFFF;
        p = (words1[astart + 2] & 0xFFFF) * (words1[astart + 5] & 0xFFFF);
        p += c & 0xFFFF;
        c = (short)p;
        d += p >> 16 & 0xFFFF;
        p = (words1[astart + 3] & 0xFFFF) * (words1[astart + 4] & 0xFFFF);
        p += c & 0xFFFF;
        c = (short)p;
        d += p >> 16 & 0xFFFF;
        d = (d << 1) + (c >> 15 & 1);
        c = (short)(c << 1);
        e += c & 0xFFFF;
        c = (short)e;
        e = d + (e >> 16 & 0xFFFF);
        result[rstart + 7] = c;
        p = (words1[astart + 1] & 0xFFFF) * (words1[astart + 7] & 0xFFFF);
        c = (short)p;
        d = p >> 16 & 0xFFFF;
        p = (words1[astart + 2] & 0xFFFF) * (words1[astart + 6] & 0xFFFF);
        p += c & 0xFFFF;
        c = (short)p;
        d += p >> 16 & 0xFFFF;
        p = (words1[astart + 3] & 0xFFFF) * (words1[astart + 5] & 0xFFFF);
        p += c & 0xFFFF;
        c = (short)p;
        d += p >> 16 & 0xFFFF;
        d = (d << 1) + (c >> 15 & 1);
        c = (short)(c << 1);
        p = (words1[astart + 4] & 0xFFFF) * (words1[astart + 4] & 0xFFFF);
        p += c & 0xFFFF;
        c = (short)p;
        e += c & 0xFFFF;
        c = (short)e;
        e = (d += p >> 16 & 0xFFFF) + (e >> 16 & 0xFFFF);
        result[rstart + 8] = c;
        p = (words1[astart + 2] & 0xFFFF) * (words1[astart + 7] & 0xFFFF);
        c = (short)p;
        d = p >> 16 & 0xFFFF;
        p = (words1[astart + 3] & 0xFFFF) * (words1[astart + 6] & 0xFFFF);
        p += c & 0xFFFF;
        c = (short)p;
        d += p >> 16 & 0xFFFF;
        p = (words1[astart + 4] & 0xFFFF) * (words1[astart + 5] & 0xFFFF);
        p += c & 0xFFFF;
        c = (short)p;
        d += p >> 16 & 0xFFFF;
        d = (d << 1) + (c >> 15 & 1);
        c = (short)(c << 1);
        e += c & 0xFFFF;
        c = (short)e;
        e = d + (e >> 16 & 0xFFFF);
        result[rstart + 9] = c;
        p = (words1[astart + 3] & 0xFFFF) * (words1[astart + 7] & 0xFFFF);
        c = (short)p;
        d = p >> 16 & 0xFFFF;
        p = (words1[astart + 4] & 0xFFFF) * (words1[astart + 6] & 0xFFFF);
        p += c & 0xFFFF;
        c = (short)p;
        d += p >> 16 & 0xFFFF;
        d = (d << 1) + (c >> 15 & 1);
        c = (short)(c << 1);
        p = (words1[astart + 5] & 0xFFFF) * (words1[astart + 5] & 0xFFFF);
        p += c & 0xFFFF;
        c = (short)p;
        e += c & 0xFFFF;
        c = (short)e;
        e = (d += p >> 16 & 0xFFFF) + (e >> 16 & 0xFFFF);
        result[rstart + 10] = c;
        p = (words1[astart + 4] & 0xFFFF) * (words1[astart + 7] & 0xFFFF);
        c = (short)p;
        d = p >> 16 & 0xFFFF;
        p = (words1[astart + 5] & 0xFFFF) * (words1[astart + 6] & 0xFFFF);
        p += c & 0xFFFF;
        c = (short)p;
        d += p >> 16 & 0xFFFF;
        d = (d << 1) + (c >> 15 & 1);
        c = (short)(c << 1);
        e += c & 0xFFFF;
        c = (short)e;
        e = d + (e >> 16 & 0xFFFF);
        result[rstart + 11] = c;
        p = (words1[astart + 5] & 0xFFFF) * (words1[astart + 7] & 0xFFFF);
        c = (short)p;
        d = p >> 16 & 0xFFFF;
        d = (d << 1) + (c >> 15 & 1);
        c = (short)(c << 1);
        p = (words1[astart + 6] & 0xFFFF) * (words1[astart + 6] & 0xFFFF);
        p += c & 0xFFFF;
        c = (short)p;
        e += c & 0xFFFF;
        c = (short)e;
        e = (d += p >> 16 & 0xFFFF) + (e >> 16 & 0xFFFF);
        result[rstart + 12] = c;
        p = (words1[astart + 6] & 0xFFFF) * (words1[astart + 7] & 0xFFFF);
        c = (short)p;
        d = p >> 16 & 0xFFFF;
        d = (d << 1) + (c >> 15 & 1);
        c = (short)(c << 1);
        e += c & 0xFFFF;
        c = (short)e;
        e = d + (e >> 16 & 0xFFFF);
        result[rstart + 13] = c;
        p = (words1[astart + 7] & 0xFFFF) * (words1[astart + 7] & 0xFFFF);
        result[rstart + 14] = (short)(p += e);
        result[rstart + 15] = (short)(p >> 16);
    }

    private static void Baseline_Multiply2(short[] result, int rstart, short[] words1, int astart, short[] words2, int bstart) {
        int a0 = words1[astart] & 0xFFFF;
        int a1 = words1[astart + 1] & 0xFFFF;
        int b0 = words2[bstart] & 0xFFFF;
        int b1 = words2[bstart + 1] & 0xFFFF;
        int p = a0 * b0;
        short c = (short)p;
        int d = p >> 16 & 0xFFFF;
        result[rstart] = c;
        c = (short)d;
        d = d >> 16 & 0xFFFF;
        p = a0 * b1;
        p += c & 0xFFFF;
        c = (short)p;
        d += p >> 16 & 0xFFFF;
        p = a1 * b0;
        p += c & 0xFFFF;
        c = (short)p;
        d += p >> 16 & 0xFFFF;
        result[rstart + 1] = c;
        p = a1 * b1;
        result[rstart + 2] = (short)(p += d);
        result[rstart + 3] = (short)(p >> 16);
    }

    private static void Baseline_Multiply4(short[] result, int rstart, short[] words1, int astart, short[] words2, int bstart) {
        int mask = 65535;
        int a0 = words1[astart] & mask;
        int b0 = words2[bstart] & mask;
        int p = a0 * b0;
        short c = (short)p;
        int d = p >> 16 & mask;
        result[rstart] = c;
        c = (short)d;
        d = d >> 16 & mask;
        p = a0 * (words2[bstart + 1] & mask);
        p += c & mask;
        c = (short)p;
        d += p >> 16 & mask;
        p = (words1[astart + 1] & mask) * b0;
        p += c & mask;
        c = (short)p;
        result[rstart + 1] = c;
        c = (short)(d += p >> 16 & mask);
        d = d >> 16 & mask;
        p = a0 * (words2[bstart + 2] & mask);
        p += c & mask;
        c = (short)p;
        d += p >> 16 & mask;
        p = (words1[astart + 1] & mask) * (words2[bstart + 1] & mask);
        p += c & mask;
        c = (short)p;
        d += p >> 16 & mask;
        p = (words1[astart + 2] & mask) * b0;
        p += c & mask;
        c = (short)p;
        result[rstart + 2] = c;
        c = (short)(d += p >> 16 & mask);
        d = d >> 16 & mask;
        p = a0 * (words2[bstart + 3] & mask);
        p += c & mask;
        c = (short)p;
        d += p >> 16 & mask;
        p = (words1[astart + 1] & mask) * (words2[bstart + 2] & mask);
        p += c & mask;
        c = (short)p;
        d += p >> 16 & mask;
        p = (words1[astart + 2] & mask) * (words2[bstart + 1] & mask);
        p += c & mask;
        c = (short)p;
        d += p >> 16 & mask;
        p = (words1[astart + 3] & mask) * b0;
        p += c & mask;
        c = (short)p;
        result[rstart + 3] = c;
        c = (short)(d += p >> 16 & mask);
        d = d >> 16 & mask;
        p = (words1[astart + 1] & mask) * (words2[bstart + 3] & mask);
        p += c & mask;
        c = (short)p;
        d += p >> 16 & mask;
        p = (words1[astart + 2] & mask) * (words2[bstart + 2] & mask);
        p += c & mask;
        c = (short)p;
        d += p >> 16 & mask;
        p = (words1[astart + 3] & mask) * (words2[bstart + 1] & mask);
        p += c & mask;
        c = (short)p;
        result[rstart + 4] = c;
        c = (short)(d += p >> 16 & mask);
        d = d >> 16 & mask;
        p = (words1[astart + 2] & mask) * (words2[bstart + 3] & mask);
        p += c & mask;
        c = (short)p;
        d += p >> 16 & mask;
        p = (words1[astart + 3] & mask) * (words2[bstart + 2] & mask);
        p += c & mask;
        c = (short)p;
        d += p >> 16 & mask;
        result[rstart + 5] = c;
        p = (words1[astart + 3] & mask) * (words2[bstart + 3] & mask);
        result[rstart + 6] = (short)(p += d);
        result[rstart + 7] = (short)(p >> 16);
    }

    private static void Baseline_Multiply8(short[] result, int rstart, short[] words1, int astart, short[] words2, int bstart) {
        int mask = 65535;
        int p = (words1[astart] & mask) * (words2[bstart] & mask);
        short c = (short)p;
        int d = p >> 16 & mask;
        result[rstart] = c;
        c = (short)d;
        d = d >> 16 & mask;
        p = (words1[astart] & mask) * (words2[bstart + 1] & mask);
        p += c & mask;
        c = (short)p;
        d += p >> 16 & mask;
        p = (words1[astart + 1] & mask) * (words2[bstart] & mask);
        p += c & mask;
        c = (short)p;
        result[rstart + 1] = c;
        c = (short)(d += p >> 16 & mask);
        d = d >> 16 & mask;
        p = (words1[astart] & mask) * (words2[bstart + 2] & mask);
        p += c & mask;
        c = (short)p;
        d += p >> 16 & mask;
        p = (words1[astart + 1] & mask) * (words2[bstart + 1] & mask);
        p += c & mask;
        c = (short)p;
        d += p >> 16 & mask;
        p = (words1[astart + 2] & mask) * (words2[bstart] & mask);
        p += c & mask;
        c = (short)p;
        result[rstart + 2] = c;
        c = (short)(d += p >> 16 & mask);
        d = d >> 16 & mask;
        p = (words1[astart] & mask) * (words2[bstart + 3] & mask);
        p += c & mask;
        c = (short)p;
        d += p >> 16 & mask;
        p = (words1[astart + 1] & mask) * (words2[bstart + 2] & mask);
        p += c & mask;
        c = (short)p;
        d += p >> 16 & mask;
        p = (words1[astart + 2] & mask) * (words2[bstart + 1] & mask);
        p += c & mask;
        c = (short)p;
        d += p >> 16 & mask;
        p = (words1[astart + 3] & mask) * (words2[bstart] & mask);
        p += c & mask;
        c = (short)p;
        result[rstart + 3] = c;
        c = (short)(d += p >> 16 & mask);
        d = d >> 16 & mask;
        p = (words1[astart] & mask) * (words2[bstart + 4] & mask);
        p += c & mask;
        c = (short)p;
        d += p >> 16 & mask;
        p = (words1[astart + 1] & mask) * (words2[bstart + 3] & mask);
        p += c & mask;
        c = (short)p;
        d += p >> 16 & mask;
        p = (words1[astart + 2] & mask) * (words2[bstart + 2] & mask);
        p += c & mask;
        c = (short)p;
        d += p >> 16 & mask;
        p = (words1[astart + 3] & mask) * (words2[bstart + 1] & mask);
        p += c & mask;
        c = (short)p;
        d += p >> 16 & mask;
        p = (words1[astart + 4] & mask) * (words2[bstart] & mask);
        p += c & mask;
        c = (short)p;
        result[rstart + 4] = c;
        c = (short)(d += p >> 16 & mask);
        d = d >> 16 & mask;
        p = (words1[astart] & mask) * (words2[bstart + 5] & mask);
        p += c & mask;
        c = (short)p;
        d += p >> 16 & mask;
        p = (words1[astart + 1] & mask) * (words2[bstart + 4] & mask);
        p += c & mask;
        c = (short)p;
        d += p >> 16 & mask;
        p = (words1[astart + 2] & mask) * (words2[bstart + 3] & mask);
        p += c & mask;
        c = (short)p;
        d += p >> 16 & mask;
        p = (words1[astart + 3] & mask) * (words2[bstart + 2] & mask);
        p += c & mask;
        c = (short)p;
        d += p >> 16 & mask;
        p = (words1[astart + 4] & mask) * (words2[bstart + 1] & mask);
        p += c & mask;
        c = (short)p;
        d += p >> 16 & mask;
        p = (words1[astart + 5] & mask) * (words2[bstart] & mask);
        p += c & mask;
        c = (short)p;
        result[rstart + 5] = c;
        c = (short)(d += p >> 16 & mask);
        d = d >> 16 & mask;
        p = (words1[astart] & mask) * (words2[bstart + 6] & mask);
        p += c & mask;
        c = (short)p;
        d += p >> 16 & mask;
        p = (words1[astart + 1] & mask) * (words2[bstart + 5] & mask);
        p += c & mask;
        c = (short)p;
        d += p >> 16 & mask;
        p = (words1[astart + 2] & mask) * (words2[bstart + 4] & mask);
        p += c & mask;
        c = (short)p;
        d += p >> 16 & mask;
        p = (words1[astart + 3] & mask) * (words2[bstart + 3] & mask);
        p += c & mask;
        c = (short)p;
        d += p >> 16 & mask;
        p = (words1[astart + 4] & mask) * (words2[bstart + 2] & mask);
        p += c & mask;
        c = (short)p;
        d += p >> 16 & mask;
        p = (words1[astart + 5] & mask) * (words2[bstart + 1] & mask);
        p += c & mask;
        c = (short)p;
        d += p >> 16 & mask;
        p = (words1[astart + 6] & mask) * (words2[bstart] & mask);
        p += c & mask;
        c = (short)p;
        result[rstart + 6] = c;
        c = (short)(d += p >> 16 & mask);
        d = d >> 16 & mask;
        p = (words1[astart] & mask) * (words2[bstart + 7] & mask);
        p += c & mask;
        c = (short)p;
        d += p >> 16 & mask;
        p = (words1[astart + 1] & mask) * (words2[bstart + 6] & mask);
        p += c & mask;
        c = (short)p;
        d += p >> 16 & mask;
        p = (words1[astart + 2] & mask) * (words2[bstart + 5] & mask);
        p += c & mask;
        c = (short)p;
        d += p >> 16 & mask;
        p = (words1[astart + 3] & mask) * (words2[bstart + 4] & mask);
        p += c & mask;
        c = (short)p;
        d += p >> 16 & mask;
        p = (words1[astart + 4] & mask) * (words2[bstart + 3] & mask);
        p += c & mask;
        c = (short)p;
        d += p >> 16 & mask;
        p = (words1[astart + 5] & mask) * (words2[bstart + 2] & mask);
        p += c & mask;
        c = (short)p;
        d += p >> 16 & mask;
        p = (words1[astart + 6] & mask) * (words2[bstart + 1] & mask);
        p += c & mask;
        c = (short)p;
        d += p >> 16 & mask;
        p = (words1[astart + 7] & mask) * (words2[bstart] & mask);
        p += c & mask;
        c = (short)p;
        result[rstart + 7] = c;
        c = (short)(d += p >> 16 & mask);
        d = d >> 16 & mask;
        p = (words1[astart + 1] & mask) * (words2[bstart + 7] & mask);
        p += c & mask;
        c = (short)p;
        d += p >> 16 & mask;
        p = (words1[astart + 2] & mask) * (words2[bstart + 6] & mask);
        p += c & mask;
        c = (short)p;
        d += p >> 16 & mask;
        p = (words1[astart + 3] & mask) * (words2[bstart + 5] & mask);
        p += c & mask;
        c = (short)p;
        d += p >> 16 & mask;
        p = (words1[astart + 4] & mask) * (words2[bstart + 4] & mask);
        p += c & mask;
        c = (short)p;
        d += p >> 16 & mask;
        p = (words1[astart + 5] & mask) * (words2[bstart + 3] & mask);
        p += c & mask;
        c = (short)p;
        d += p >> 16 & mask;
        p = (words1[astart + 6] & mask) * (words2[bstart + 2] & mask);
        p += c & mask;
        c = (short)p;
        d += p >> 16 & mask;
        p = (words1[astart + 7] & mask) * (words2[bstart + 1] & mask);
        p += c & mask;
        c = (short)p;
        result[rstart + 8] = c;
        c = (short)(d += p >> 16 & mask);
        d = d >> 16 & mask;
        p = (words1[astart + 2] & mask) * (words2[bstart + 7] & mask);
        p += c & mask;
        c = (short)p;
        d += p >> 16 & mask;
        p = (words1[astart + 3] & mask) * (words2[bstart + 6] & mask);
        p += c & mask;
        c = (short)p;
        d += p >> 16 & mask;
        p = (words1[astart + 4] & mask) * (words2[bstart + 5] & mask);
        p += c & mask;
        c = (short)p;
        d += p >> 16 & mask;
        p = (words1[astart + 5] & mask) * (words2[bstart + 4] & mask);
        p += c & mask;
        c = (short)p;
        d += p >> 16 & mask;
        p = (words1[astart + 6] & mask) * (words2[bstart + 3] & mask);
        p += c & mask;
        c = (short)p;
        d += p >> 16 & mask;
        p = (words1[astart + 7] & mask) * (words2[bstart + 2] & mask);
        p += c & mask;
        c = (short)p;
        result[rstart + 9] = c;
        c = (short)(d += p >> 16 & mask);
        d = d >> 16 & mask;
        p = (words1[astart + 3] & mask) * (words2[bstart + 7] & mask);
        p += c & mask;
        c = (short)p;
        d += p >> 16 & mask;
        p = (words1[astart + 4] & mask) * (words2[bstart + 6] & mask);
        p += c & mask;
        c = (short)p;
        d += p >> 16 & mask;
        p = (words1[astart + 5] & mask) * (words2[bstart + 5] & mask);
        p += c & mask;
        c = (short)p;
        d += p >> 16 & mask;
        p = (words1[astart + 6] & mask) * (words2[bstart + 4] & mask);
        p += c & mask;
        c = (short)p;
        d += p >> 16 & mask;
        p = (words1[astart + 7] & mask) * (words2[bstart + 3] & mask);
        p += c & mask;
        c = (short)p;
        result[rstart + 10] = c;
        c = (short)(d += p >> 16 & mask);
        d = d >> 16 & mask;
        p = (words1[astart + 4] & mask) * (words2[bstart + 7] & mask);
        p += c & mask;
        c = (short)p;
        d += p >> 16 & mask;
        p = (words1[astart + 5] & mask) * (words2[bstart + 6] & mask);
        p += c & mask;
        c = (short)p;
        d += p >> 16 & mask;
        p = (words1[astart + 6] & mask) * (words2[bstart + 5] & mask);
        p += c & mask;
        c = (short)p;
        d += p >> 16 & mask;
        p = (words1[astart + 7] & mask) * (words2[bstart + 4] & mask);
        p += c & mask;
        c = (short)p;
        result[rstart + 11] = c;
        c = (short)(d += p >> 16 & mask);
        d = d >> 16 & mask;
        p = (words1[astart + 5] & mask) * (words2[bstart + 7] & mask);
        p += c & mask;
        c = (short)p;
        d += p >> 16 & mask;
        p = (words1[astart + 6] & mask) * (words2[bstart + 6] & mask);
        p += c & mask;
        c = (short)p;
        d += p >> 16 & mask;
        p = (words1[astart + 7] & mask) * (words2[bstart + 5] & mask);
        p += c & mask;
        c = (short)p;
        result[rstart + 12] = c;
        c = (short)(d += p >> 16 & mask);
        d = d >> 16 & mask;
        p = (words1[astart + 6] & mask) * (words2[bstart + 7] & mask);
        p += c & mask;
        c = (short)p;
        d += p >> 16 & mask;
        p = (words1[astart + 7] & mask) * (words2[bstart + 6] & mask);
        p += c & mask;
        c = (short)p;
        d += p >> 16 & mask;
        result[rstart + 13] = c;
        p = (words1[astart + 7] & mask) * (words2[bstart + 7] & mask);
        result[rstart + 14] = (short)(p += d);
        result[rstart + 15] = (short)(p >> 16);
    }

    private static void SameSizeMultiply(short[] resultArr, int resultStart, short[] tempArr, int tempStart, short[] words1, int words1Start, short[] words2, int words2Start, int count) {
        if (count <= 10) {
            if (count == 2) {
                BigInteger.Baseline_Multiply2(resultArr, resultStart, words1, words1Start, words2, words2Start);
            } else if (count == 4) {
                BigInteger.Baseline_Multiply4(resultArr, resultStart, words1, words1Start, words2, words2Start);
            } else if (count == 8) {
                BigInteger.Baseline_Multiply8(resultArr, resultStart, words1, words1Start, words2, words2Start);
            } else {
                BigInteger.SchoolbookMultiply(resultArr, resultStart, words1, words1Start, count, words2, words2Start, count);
            }
        } else {
            int countB;
            int countA;
            for (countA = count; countA != 0 && words1[words1Start + countA - 1] == 0; --countA) {
            }
            for (countB = count; countB != 0 && words2[words2Start + countB - 1] == 0; --countB) {
            }
            int offset2For1 = 0;
            int offset2For2 = 0;
            if (countA == 0 || countB == 0) {
                Arrays.fill(resultArr, resultStart, resultStart + (count << 1), (short)0);
                return;
            }
            if ((count & 1) == 0) {
                int c2;
                int count2 = count >> 1;
                if (countA <= count2 && countB <= count2) {
                    Arrays.fill(resultArr, resultStart + count, resultStart + count + count, (short)0);
                    if (count2 == 8) {
                        BigInteger.Baseline_Multiply8(resultArr, resultStart, words1, words1Start, words2, words2Start);
                    } else {
                        BigInteger.SameSizeMultiply(resultArr, resultStart, tempArr, tempStart, words1, words1Start, words2, words2Start, count2);
                    }
                    return;
                }
                int resultMediumHigh = resultStart + count;
                int resultHigh = resultMediumHigh + count2;
                int resultMediumLow = resultStart + count2;
                int tsn = tempStart + count;
                offset2For1 = BigInteger.Compare(words1, words1Start, words1, words1Start + count2, count2) > 0 ? 0 : count2;
                BigInteger.SubtractOneByOne(resultArr, resultStart, words1, words1Start + offset2For1, words1, words1Start + (count2 ^ offset2For1), count2);
                offset2For2 = BigInteger.Compare(words2, words2Start, words2, words2Start + count2, count2) > 0 ? 0 : count2;
                BigInteger.SubtractOneByOne(resultArr, resultMediumLow, words2, words2Start + offset2For2, words2, words2Start + (count2 ^ offset2For2), count2);
                BigInteger.SameSizeMultiply(resultArr, resultMediumHigh, tempArr, tsn, words1, words1Start + count2, words2, words2Start + count2, count2);
                BigInteger.SameSizeMultiply(tempArr, tempStart, tempArr, tsn, resultArr, resultStart, resultArr, resultMediumLow, count2);
                BigInteger.SameSizeMultiply(resultArr, resultStart, tempArr, tsn, words1, words1Start, words2, words2Start, count2);
                int c3 = c2 = BigInteger.AddOneByOne(resultArr, resultMediumHigh, resultArr, resultMediumHigh, resultArr, resultMediumLow, count2);
                c3 += BigInteger.AddOneByOne(resultArr, resultMediumHigh, resultArr, resultMediumHigh, resultArr, resultHigh, count2);
                c3 = offset2For1 == offset2For2 ? (c3 -= BigInteger.SubtractOneByOne(resultArr, resultMediumLow, resultArr, resultMediumLow, tempArr, tempStart, count)) : (c3 += BigInteger.AddOneByOne(resultArr, resultMediumLow, resultArr, resultMediumLow, tempArr, tempStart, count));
                if ((c3 += BigInteger.Increment(resultArr, resultMediumHigh, count2, (short)(c2 += BigInteger.AddOneByOne(resultArr, resultMediumLow, resultArr, resultMediumHigh, resultArr, resultStart, count2)))) != 0) {
                    BigInteger.Increment(resultArr, resultHigh, count2, (short)c3);
                }
            } else {
                int c2;
                int countHigh = count >> 1;
                int countLow = count - countHigh;
                int n = offset2For1 = BigInteger.CompareWithOneBiggerWords1(words1, words1Start, words1, words1Start + countLow, countLow) > 0 ? 0 : countLow;
                if (offset2For1 == 0) {
                    BigInteger.SubtractOneBiggerWords1(resultArr, resultStart, words1, words1Start, words1, words1Start + countLow, countLow);
                } else {
                    BigInteger.SubtractOneBiggerWords2(resultArr, resultStart, words1, words1Start + countLow, words1, words1Start, countLow);
                }
                int n2 = offset2For2 = BigInteger.CompareWithOneBiggerWords1(words2, words2Start, words2, words2Start + countLow, countLow) > 0 ? 0 : countLow;
                if (offset2For2 == 0) {
                    BigInteger.SubtractOneBiggerWords1(tempArr, tempStart, words2, words2Start, words2, words2Start + countLow, countLow);
                } else {
                    BigInteger.SubtractOneBiggerWords2(tempArr, tempStart, words2, words2Start + countLow, words2, words2Start, countLow);
                }
                int shorterOffset = countHigh << 1;
                int longerOffset = countLow << 1;
                BigInteger.SameSizeMultiply(tempArr, tempStart + shorterOffset, resultArr, resultStart + shorterOffset, resultArr, resultStart, tempArr, tempStart, countLow);
                short resultTmp0 = tempArr[tempStart + shorterOffset];
                short resultTmp1 = tempArr[tempStart + shorterOffset + 1];
                BigInteger.SameSizeMultiply(resultArr, resultStart + longerOffset, resultArr, resultStart, words1, words1Start + countLow, words2, words2Start + countLow, countHigh);
                BigInteger.SameSizeMultiply(resultArr, resultStart, tempArr, tempStart, words1, words1Start, words2, words2Start, countLow);
                tempArr[tempStart + shorterOffset] = resultTmp0;
                tempArr[tempStart + shorterOffset + 1] = resultTmp1;
                int countMiddle = countLow << 1;
                int c3 = c2 = BigInteger.AddOneByOne(resultArr, resultStart + countMiddle, resultArr, resultStart + countMiddle, resultArr, resultStart + countLow, countLow);
                c3 += BigInteger.AddUnevenSize(resultArr, resultStart + countMiddle, resultArr, resultStart + countMiddle, countLow, resultArr, resultStart + countMiddle + countLow, countLow - 2);
                c3 = offset2For1 == offset2For2 ? (c3 -= BigInteger.SubtractOneByOne(resultArr, resultStart + countLow, resultArr, resultStart + countLow, tempArr, tempStart + shorterOffset, countLow << 1)) : (c3 += BigInteger.AddOneByOne(resultArr, resultStart + countLow, resultArr, resultStart + countLow, tempArr, tempStart + shorterOffset, countLow << 1));
                if ((c3 += BigInteger.Increment(resultArr, resultStart + countMiddle, countLow, (short)(c2 += BigInteger.AddOneByOne(resultArr, resultStart + countLow, resultArr, resultStart + countMiddle, resultArr, resultStart, countLow)))) != 0) {
                    BigInteger.Increment(resultArr, resultStart + countMiddle + countLow, countLow - 2, (short)c3);
                }
            }
        }
    }

    private static void RecursiveSquare(short[] resultArr, int resultStart, short[] tempArr, int tempStart, short[] words1, int words1Start, int count) {
        if (count <= 10) {
            if (count == 2) {
                BigInteger.Baseline_Square2(resultArr, resultStart, words1, words1Start);
            } else if (count == 4) {
                BigInteger.Baseline_Square4(resultArr, resultStart, words1, words1Start);
            } else if (count == 8) {
                BigInteger.Baseline_Square8(resultArr, resultStart, words1, words1Start);
            } else {
                BigInteger.SchoolbookSquare(resultArr, resultStart, words1, words1Start, count);
            }
        } else if ((count & 1) == 0) {
            int count2 = count >> 1;
            BigInteger.RecursiveSquare(resultArr, resultStart, tempArr, tempStart + count, words1, words1Start, count2);
            BigInteger.RecursiveSquare(resultArr, resultStart + count, tempArr, tempStart + count, words1, words1Start + count2, count2);
            BigInteger.SameSizeMultiply(tempArr, tempStart, tempArr, tempStart + count, words1, words1Start, words1, words1Start + count2, count2);
            int carry = BigInteger.AddOneByOne(resultArr, resultStart + count2, resultArr, resultStart + count2, tempArr, tempStart, count);
            BigInteger.Increment(resultArr, resultStart + count + count2, count2, (short)(carry += BigInteger.AddOneByOne(resultArr, resultStart + count2, resultArr, resultStart + count2, tempArr, tempStart, count)));
        } else {
            BigInteger.SameSizeMultiply(resultArr, resultStart, tempArr, tempStart, words1, words1Start, words1, words1Start, count);
        }
    }

    private static void SchoolbookSquare(short[] resultArr, int resultStart, short[] words1, int words1Start, int words1Count) {
        for (int i = 0; i < words1Count; ++i) {
            int cstart = resultStart + i;
            short carry = 0;
            int valueBint = words1[words1Start + i] & 0xFFFF;
            for (int j = 0; j < words1Count; ++j) {
                int p = (words1[words1Start + j] & 0xFFFF) * valueBint;
                p += carry & 0xFFFF;
                if (i != 0) {
                    p += resultArr[cstart + j] & 0xFFFF;
                }
                resultArr[cstart + j] = (short)p;
                carry = (short)(p >> 16);
            }
            resultArr[cstart + words1Count] = carry;
        }
    }

    private static void SchoolbookMultiply(short[] resultArr, int resultStart, short[] words1, int words1Start, int words1Count, short[] words2, int words2Start, int words2Count) {
        if (words1Count < words2Count) {
            for (int i = 0; i < words1Count; ++i) {
                int cstart = resultStart + i;
                short carry = 0;
                int valueBint = words1[words1Start + i] & 0xFFFF;
                for (int j = 0; j < words2Count; ++j) {
                    int p = (words2[words2Start + j] & 0xFFFF) * valueBint;
                    p += carry & 0xFFFF;
                    if (i != 0) {
                        p += resultArr[cstart + j] & 0xFFFF;
                    }
                    resultArr[cstart + j] = (short)p;
                    carry = (short)(p >> 16);
                }
                resultArr[cstart + words2Count] = carry;
            }
        } else {
            for (int i = 0; i < words2Count; ++i) {
                int cstart = resultStart + i;
                short carry = 0;
                int valueBint = words2[words2Start + i] & 0xFFFF;
                for (int j = 0; j < words1Count; ++j) {
                    int p = (words1[words1Start + j] & 0xFFFF) * valueBint;
                    p += carry & 0xFFFF;
                    if (i != 0) {
                        p += resultArr[cstart + j] & 0xFFFF;
                    }
                    resultArr[cstart + j] = (short)p;
                    carry = (short)(p >> 16);
                }
                resultArr[cstart + words1Count] = carry;
            }
        }
    }

    private static void ChunkedLinearMultiply(short[] productArr, int cstart, short[] tempArr, int tempStart, short[] words1, int astart, int acount, short[] words2, int bstart, int bcount) {
        int carryPos = 0;
        Arrays.fill(productArr, cstart, cstart + bcount, (short)0);
        for (int i = 0; i < acount; i += bcount) {
            int diff = acount - i;
            if (diff > bcount) {
                BigInteger.SameSizeMultiply(tempArr, tempStart, tempArr, tempStart + bcount + bcount, words1, astart + i, words2, bstart, bcount);
                BigInteger.AddUnevenSize(tempArr, tempStart, tempArr, tempStart, bcount + bcount, productArr, cstart + carryPos, bcount);
                System.arraycopy(tempArr, tempStart, productArr, cstart + i, bcount + bcount);
                carryPos += bcount;
                continue;
            }
            BigInteger.AsymmetricMultiply(tempArr, tempStart, tempArr, tempStart + diff + bcount, words1, astart + i, diff, words2, bstart, bcount);
            BigInteger.AddUnevenSize(tempArr, tempStart, tempArr, tempStart, diff + bcount, productArr, cstart + carryPos, bcount);
            System.arraycopy(tempArr, tempStart, productArr, cstart + i, diff + bcount);
        }
    }

    private static void AsymmetricMultiply(short[] resultArr, int resultStart, short[] tempArr, int tempStart, short[] words1, int words1Start, int words1Count, short[] words2, int words2Start, int words2Count) {
        if (words1Count == words2Count) {
            if (words1Start == words2Start && words1 == words2) {
                BigInteger.RecursiveSquare(resultArr, resultStart, tempArr, tempStart, words1, words1Start, words1Count);
            } else if (words1Count == 2) {
                BigInteger.Baseline_Multiply2(resultArr, resultStart, words1, words1Start, words2, words2Start);
            } else {
                BigInteger.SameSizeMultiply(resultArr, resultStart, tempArr, tempStart, words1, words1Start, words2, words2Start, words1Count);
            }
            return;
        }
        if (words1Count > words2Count) {
            short[] tmp1 = words1;
            words1 = words2;
            words2 = tmp1;
            int tmp3 = words1Start;
            words1Start = words2Start;
            words2Start = tmp3;
            int tmp2 = words1Count;
            words1Count = words2Count;
            words2Count = tmp2;
        }
        if (words1Count == 1 || words1Count == 2 && words1[words1Start + 1] == 0) {
            switch (words1[words1Start]) {
                case 0: {
                    Arrays.fill(resultArr, resultStart, resultStart + (words2Count + 2), (short)0);
                    return;
                }
                case 1: {
                    System.arraycopy(words2, words2Start, resultArr, resultStart, words2Count);
                    resultArr[resultStart + words2Count] = 0;
                    resultArr[resultStart + words2Count + 1] = 0;
                    return;
                }
            }
            resultArr[resultStart + words2Count] = BigInteger.LinearMultiply(resultArr, resultStart, words2, words2Start, words1[words1Start], words2Count);
            resultArr[resultStart + words2Count + 1] = 0;
            return;
        }
        if (words1Count == 2 && (words2Count & 1) == 0) {
            int a0 = words1[words1Start] & 0xFFFF;
            int a1 = words1[words1Start + 1] & 0xFFFF;
            resultArr[resultStart + words2Count] = 0;
            resultArr[resultStart + words2Count + 1] = 0;
            BigInteger.AtomicMultiplyOpt(resultArr, resultStart, a0, a1, words2, words2Start, 0, words2Count);
            BigInteger.AtomicMultiplyAddOpt(resultArr, resultStart, a0, a1, words2, words2Start, 2, words2Count);
            return;
        }
        if (words1Count <= 10 && words2Count <= 10) {
            BigInteger.SchoolbookMultiply(resultArr, resultStart, words1, words1Start, words1Count, words2, words2Start, words2Count);
        } else {
            int wordsRem = words2Count % words1Count;
            int evenmult = words2Count / words1Count & 1;
            if (wordsRem == 0) {
                int i;
                if (evenmult == 0) {
                    BigInteger.SameSizeMultiply(resultArr, resultStart, tempArr, tempStart, words1, words1Start, words2, words2Start, words1Count);
                    System.arraycopy(resultArr, resultStart + words1Count, tempArr, tempStart + (words1Count << 1), words1Count);
                    for (i = words1Count << 1; i < words2Count; i += words1Count << 1) {
                        BigInteger.SameSizeMultiply(tempArr, tempStart + words1Count + i, tempArr, tempStart, words1, words1Start, words2, words2Start + i, words1Count);
                    }
                    for (i = words1Count; i < words2Count; i += words1Count << 1) {
                        BigInteger.SameSizeMultiply(resultArr, resultStart + i, tempArr, tempStart, words1, words1Start, words2, words2Start + i, words1Count);
                    }
                } else {
                    for (i = 0; i < words2Count; i += words1Count << 1) {
                        BigInteger.SameSizeMultiply(resultArr, resultStart + i, tempArr, tempStart, words1, words1Start, words2, words2Start + i, words1Count);
                    }
                    for (i = words1Count; i < words2Count; i += words1Count << 1) {
                        BigInteger.SameSizeMultiply(tempArr, tempStart + words1Count + i, tempArr, tempStart, words1, words1Start, words2, words2Start + i, words1Count);
                    }
                }
                if (BigInteger.Add(resultArr, resultStart + words1Count, resultArr, resultStart + words1Count, tempArr, tempStart + (words1Count << 1), words2Count - words1Count) != 0) {
                    BigInteger.Increment(resultArr, resultStart + words2Count, words1Count, (short)1);
                }
            } else if (words1Count + words2Count >= words1Count << 2) {
                BigInteger.ChunkedLinearMultiply(resultArr, resultStart, tempArr, tempStart, words2, words2Start, words2Count, words1, words1Start, words1Count);
            } else if (words1Count + 1 == words2Count || words1Count + 2 == words2Count && words2[words2Start + words2Count - 1] == 0) {
                short carry;
                Arrays.fill(resultArr, resultStart, resultStart + (words1Count + words2Count), (short)0);
                BigInteger.SameSizeMultiply(resultArr, resultStart, tempArr, tempStart, words1, words1Start, words2, words2Start, words1Count);
                resultArr[resultStart + words1Count + words1Count] = carry = BigInteger.LinearMultiplyAdd(resultArr, resultStart + words1Count, words1, words1Start, words2[words2Start + words1Count], words1Count);
            } else {
                short[] t2 = new short[words1Count << 2];
                BigInteger.ChunkedLinearMultiply(resultArr, resultStart, t2, 0, words2, words2Start, words2Count, words1, words1Start, words1Count);
            }
        }
    }

    private static int MakeUint(short first, short second) {
        return first & 0xFFFF | second << 16;
    }

    private static short GetLowHalf(int val) {
        return (short)(val & 0xFFFF);
    }

    private static short GetHighHalf(int val) {
        return (short)(val >> 16 & 0xFFFF);
    }

    private static short GetHighHalfAsBorrow(int val) {
        return (short)(0 - (val >> 16 & 0xFFFF));
    }

    private static int BitPrecision(short numberValue) {
        if (numberValue == 0) {
            return 0;
        }
        int i = 16;
        if (numberValue >> 8 == 0) {
            numberValue = (short)(numberValue << 8);
            i -= 8;
        }
        if (numberValue >> 12 == 0) {
            numberValue = (short)(numberValue << 4);
            i -= 4;
        }
        if (numberValue >> 14 == 0) {
            numberValue = (short)(numberValue << 2);
            i -= 2;
        }
        if (numberValue >> 15 == 0) {
            --i;
        }
        return i;
    }

    private static short Divide32By16(int dividendLow, short divisorShort, boolean returnRemainder) {
        int dividendHigh = 0;
        int intDivisor = divisorShort & 0xFFFF;
        for (int i = 0; i < 32; ++i) {
            int tmpInt = dividendHigh >> 31;
            dividendHigh <<= 1;
            if ((tmpInt |= (dividendHigh |= (dividendLow <<= 1) >> 31 & 1)) >> 31 == 0 && tmpInt < intDivisor) continue;
            dividendHigh -= intDivisor;
            ++dividendLow;
        }
        return returnRemainder ? (short)(dividendHigh & 0xFFFF) : (short)(dividendLow & 0xFFFF);
    }

    private static short DivideUnsigned(int x, short y) {
        int iy = y & 0xFFFF;
        if (x >> 31 == 0) {
            return (short)(x / iy & 0xFFFF);
        }
        return BigInteger.Divide32By16(x, y, false);
    }

    private static short RemainderUnsigned(int x, short y) {
        int iy = y & 0xFFFF;
        if (x >> 31 == 0) {
            return (short)(x % iy & 0xFFFF);
        }
        return BigInteger.Divide32By16(x, y, true);
    }

    private static short DivideThreeWordsByTwo(short[] words1, int words1Start, short valueB0, short valueB1) {
        short valueQ = (short)(valueB1 + 1) == 0 ? words1[words1Start + 2] : (valueB1 != 0 ? BigInteger.DivideUnsigned(BigInteger.MakeUint(words1[words1Start + 1], words1[words1Start + 2]), (short)(valueB1 + 1 & 0xFFFF)) : BigInteger.DivideUnsigned(BigInteger.MakeUint(words1[words1Start], words1[words1Start + 1]), valueB0));
        int valueQint = valueQ & 0xFFFF;
        int valueB0int = valueB0 & 0xFFFF;
        int valueB1int = valueB1 & 0xFFFF;
        int p = valueB0int * valueQint;
        int u = (words1[words1Start] & 0xFFFF) - (p & 0xFFFF);
        words1[words1Start] = BigInteger.GetLowHalf(u);
        u = (words1[words1Start + 1] & 0xFFFF) - (p >> 16 & 0xFFFF) - (BigInteger.GetHighHalfAsBorrow(u) & 0xFFFF) - valueB1int * valueQint;
        words1[words1Start + 1] = BigInteger.GetLowHalf(u);
        int n = words1Start + 2;
        words1[n] = (short)(words1[n] + BigInteger.GetHighHalf(u));
        while (words1[words1Start + 2] != 0 || (words1[words1Start + 1] & 0xFFFF) > (valueB1 & 0xFFFF) || words1[words1Start + 1] == valueB1 && (words1[words1Start] & 0xFFFF) >= (valueB0 & 0xFFFF)) {
            u = (words1[words1Start] & 0xFFFF) - valueB0int;
            words1[words1Start] = BigInteger.GetLowHalf(u);
            u = (words1[words1Start + 1] & 0xFFFF) - valueB1int - (BigInteger.GetHighHalfAsBorrow(u) & 0xFFFF);
            words1[words1Start + 1] = BigInteger.GetLowHalf(u);
            int n2 = words1Start + 2;
            words1[n2] = (short)(words1[n2] + BigInteger.GetHighHalf(u));
            valueQ = (short)(valueQ + 1);
        }
        return valueQ;
    }

    private static void DivideFourWordsByTwo(short[] quotient, int quotientStart, short[] words1, int words1Start, short word2A, short word2B, short[] temp) {
        if (word2A == 0 && word2B == 0) {
            quotient[quotientStart] = words1[words1Start + 2];
            quotient[quotientStart + 1] = words1[words1Start + 3];
        } else {
            short valueQ0;
            temp[0] = words1[words1Start];
            temp[1] = words1[words1Start + 1];
            temp[2] = words1[words1Start + 2];
            temp[3] = words1[words1Start + 3];
            short valueQ1 = BigInteger.DivideThreeWordsByTwo(temp, 1, word2A, word2B);
            quotient[quotientStart] = valueQ0 = BigInteger.DivideThreeWordsByTwo(temp, 0, word2A, word2B);
            quotient[quotientStart + 1] = valueQ1;
        }
    }

    private static void AtomicMultiplyOpt(short[] c, int valueCstart, int valueA0, int valueA1, short[] words2, int words2Start, int istart, int iend) {
        int first1MinusFirst0 = valueA1 - valueA0 & 0xFFFF;
        if ((valueA1 &= 0xFFFF) >= (valueA0 &= 0xFFFF)) {
            for (int i = istart; i < iend; i += 4) {
                int d;
                short s;
                int valueB0 = words2[words2Start + i] & 0xFFFF;
                int valueB1 = words2[words2Start + i + 1] & 0xFFFF;
                int csi = valueCstart + i;
                if (valueB0 >= valueB1) {
                    s = 0;
                    d = first1MinusFirst0 * (valueB0 - valueB1 & 0xFFFF);
                } else {
                    s = (short)first1MinusFirst0;
                    d = (s & 0xFFFF) * (valueB0 - valueB1 & 0xFFFF);
                }
                int valueA0B0 = valueA0 * valueB0;
                c[csi] = (short)(valueA0B0 & 0xFFFF);
                int a0b0high = valueA0B0 >> 16 & 0xFFFF;
                int valueA1B1 = valueA1 * valueB1;
                int tempInt = a0b0high + (valueA0B0 & 0xFFFF) + (d & 0xFFFF) + (valueA1B1 & 0xFFFF);
                c[csi + 1] = (short)(tempInt & 0xFFFF);
                tempInt = valueA1B1 + (tempInt >> 16 & 0xFFFF) + a0b0high + (d >> 16 & 0xFFFF) + (valueA1B1 >> 16 & 0xFFFF) - (s & 0xFFFF);
                c[csi + 2] = (short)(tempInt & 0xFFFF);
                c[csi + 3] = (short)(tempInt >> 16 & 0xFFFF);
            }
        } else {
            for (int i = istart; i < iend; i += 4) {
                int d;
                short s;
                int valueB0 = words2[words2Start + i] & 0xFFFF;
                int valueB1 = words2[words2Start + i + 1] & 0xFFFF;
                int csi = valueCstart + i;
                if (valueB0 > valueB1) {
                    s = (short)(valueB0 - valueB1 & 0xFFFF);
                    d = first1MinusFirst0 * (s & 0xFFFF);
                } else {
                    s = 0;
                    d = (valueA0 - valueA1 & 0xFFFF) * (valueB1 - valueB0 & 0xFFFF);
                }
                int valueA0B0 = valueA0 * valueB0;
                int a0b0high = valueA0B0 >> 16 & 0xFFFF;
                c[csi] = (short)(valueA0B0 & 0xFFFF);
                int valueA1B1 = valueA1 * valueB1;
                int tempInt = a0b0high + (valueA0B0 & 0xFFFF) + (d & 0xFFFF) + (valueA1B1 & 0xFFFF);
                c[csi + 1] = (short)(tempInt & 0xFFFF);
                tempInt = valueA1B1 + (tempInt >> 16 & 0xFFFF) + a0b0high + (d >> 16 & 0xFFFF) + (valueA1B1 >> 16 & 0xFFFF) - (s & 0xFFFF);
                c[csi + 2] = (short)(tempInt & 0xFFFF);
                c[csi + 3] = (short)(tempInt >> 16 & 0xFFFF);
            }
        }
    }

    private static void AtomicMultiplyAddOpt(short[] c, int valueCstart, int valueA0, int valueA1, short[] words2, int words2Start, int istart, int iend) {
        int first1MinusFirst0 = valueA1 - valueA0 & 0xFFFF;
        if ((valueA1 &= 0xFFFF) >= (valueA0 &= 0xFFFF)) {
            for (int i = istart; i < iend; i += 4) {
                int d;
                short s;
                int b0 = words2[words2Start + i] & 0xFFFF;
                int b1 = words2[words2Start + i + 1] & 0xFFFF;
                int csi = valueCstart + i;
                if (b0 >= b1) {
                    s = 0;
                    d = first1MinusFirst0 * (b0 - b1 & 0xFFFF);
                } else {
                    s = (short)first1MinusFirst0;
                    d = (s & 0xFFFF) * (b0 - b1 & 0xFFFF);
                }
                int valueA0B0 = valueA0 * b0;
                int a0b0high = valueA0B0 >> 16 & 0xFFFF;
                int tempInt = valueA0B0 + (c[csi] & 0xFFFF);
                c[csi] = (short)(tempInt & 0xFFFF);
                int valueA1B1 = valueA1 * b1;
                int a1b1low = valueA1B1 & 0xFFFF;
                int a1b1high = valueA1B1 >> 16 & 0xFFFF;
                tempInt = (tempInt >> 16 & 0xFFFF) + (valueA0B0 & 0xFFFF) + (d & 0xFFFF) + a1b1low + (c[csi + 1] & 0xFFFF);
                c[csi + 1] = (short)(tempInt & 0xFFFF);
                tempInt = (tempInt >> 16 & 0xFFFF) + a1b1low + a0b0high + (d >> 16 & 0xFFFF) + a1b1high - (s & 0xFFFF) + (c[csi + 2] & 0xFFFF);
                c[csi + 2] = (short)(tempInt & 0xFFFF);
                tempInt = (tempInt >> 16 & 0xFFFF) + a1b1high + (c[csi + 3] & 0xFFFF);
                c[csi + 3] = (short)(tempInt & 0xFFFF);
                if (tempInt >> 16 == 0) continue;
                int n = csi + 4;
                c[n] = (short)(c[n] + 1);
                int n2 = csi + 5;
                c[n2] = (short)(c[n2] + (short)(c[csi + 4] == 0 ? 1 : 0));
            }
        } else {
            for (int i = istart; i < iend; i += 4) {
                int d;
                short s;
                int valueB0 = words2[words2Start + i] & 0xFFFF;
                int valueB1 = words2[words2Start + i + 1] & 0xFFFF;
                int csi = valueCstart + i;
                if (valueB0 > valueB1) {
                    s = (short)(valueB0 - valueB1 & 0xFFFF);
                    d = first1MinusFirst0 * (s & 0xFFFF);
                } else {
                    s = 0;
                    d = (valueA0 - valueA1 & 0xFFFF) * (valueB1 - valueB0 & 0xFFFF);
                }
                int valueA0B0 = valueA0 * valueB0;
                int a0b0high = valueA0B0 >> 16 & 0xFFFF;
                int tempInt = valueA0B0 + (c[csi] & 0xFFFF);
                c[csi] = (short)(tempInt & 0xFFFF);
                int valueA1B1 = valueA1 * valueB1;
                int a1b1low = valueA1B1 & 0xFFFF;
                int a1b1high = valueA1B1 >> 16 & 0xFFFF;
                tempInt = (tempInt >> 16 & 0xFFFF) + (valueA0B0 & 0xFFFF) + (d & 0xFFFF) + a1b1low + (c[csi + 1] & 0xFFFF);
                c[csi + 1] = (short)(tempInt & 0xFFFF);
                tempInt = (tempInt >> 16 & 0xFFFF) + a1b1low + a0b0high + (d >> 16 & 0xFFFF) + a1b1high - (s & 0xFFFF) + (c[csi + 2] & 0xFFFF);
                c[csi + 2] = (short)(tempInt & 0xFFFF);
                tempInt = (tempInt >> 16 & 0xFFFF) + a1b1high + (c[csi + 3] & 0xFFFF);
                c[csi + 3] = (short)(tempInt & 0xFFFF);
                if (tempInt >> 16 == 0) continue;
                int n = csi + 4;
                c[n] = (short)(c[n] + 1);
                int n3 = csi + 5;
                c[n3] = (short)(c[n3] + (short)(c[csi + 4] == 0 ? 1 : 0));
            }
        }
    }

    private static void Divide(short[] remainderArr, int remainderStart, short[] quotientArr, int quotientStart, short[] tempArr, int tempStart, short[] words1, int words1Start, int words1Count, short[] words2, int words2Start, int words2Count) {
        if (words2Count == 0) {
            throw new ArithmeticException("division by zero");
        }
        if (words2Count == 1) {
            if (words2[words2Start] == 0) {
                throw new ArithmeticException("division by zero");
            }
            int smallRemainder = BigInteger.FastDivideAndRemainder(quotientArr, quotientStart, words1, words1Start, words1Count, words2[words2Start]) & 0xFFFF;
            remainderArr[remainderStart] = (short)smallRemainder;
            return;
        }
        short[] quot = quotientArr;
        if (quotientArr == null) {
            quot = new short[2];
        }
        int valueTBstart = tempStart + (words1Count + 2);
        int valueTPstart = tempStart + (words1Count + 2 + words2Count);
        short shiftWords = (short)(words2[words2Start + words2Count - 1] == 0 ? 1 : 0);
        tempArr[valueTBstart] = 0;
        tempArr[valueTBstart + words2Count - 1] = 0;
        System.arraycopy(words2, words2Start, tempArr, valueTBstart + shiftWords, words2Count - shiftWords);
        short shiftBits = (short)(16 - BigInteger.BitPrecision(tempArr[valueTBstart + words2Count - 1]));
        BigInteger.ShiftWordsLeftByBits(tempArr, valueTBstart, words2Count, shiftBits);
        tempArr[0] = 0;
        tempArr[words1Count] = 0;
        tempArr[words1Count + 1] = 0;
        System.arraycopy(words1, words1Start, tempArr, tempStart + shiftWords, words1Count);
        BigInteger.ShiftWordsLeftByBits(tempArr, tempStart, words1Count + 2, shiftBits);
        if (tempArr[tempStart + words1Count + 1] == 0 && (tempArr[tempStart + words1Count] & 0xFFFF) <= 1) {
            if (quotientArr != null) {
                quotientArr[quotientStart + words1Count - words2Count + 1] = 0;
                quotientArr[quotientStart + words1Count - words2Count] = 0;
            }
            while (tempArr[words1Count] != 0 || BigInteger.Compare(tempArr, tempStart + words1Count - words2Count, tempArr, valueTBstart, words2Count) >= 0) {
                int n = words1Count;
                tempArr[n] = (short)(tempArr[n] - (short)BigInteger.Subtract(tempArr, tempStart + words1Count - words2Count, tempArr, tempStart + words1Count - words2Count, tempArr, valueTBstart, words2Count));
                if (quotientArr == null) continue;
                int n2 = quotientStart + words1Count - words2Count;
                quotientArr[n2] = (short)(quotientArr[n2] + 1);
            }
        } else {
            words1Count += 2;
        }
        short valueBT0 = (short)(tempArr[valueTBstart + words2Count - 2] + 1);
        short valueBT1 = (short)(tempArr[valueTBstart + words2Count - 1] + (short)(valueBT0 == 0 ? 1 : 0));
        short[] valueTAtomic = new short[4];
        for (int i = words1Count - 2; i >= words2Count; i -= 2) {
            int qs = quotientArr == null ? 0 : quotientStart + i - words2Count;
            BigInteger.DivideFourWordsByTwo(quot, qs, tempArr, tempStart + i - 2, valueBT0, valueBT1, valueTAtomic);
            int valueRstart2 = tempStart + i - words2Count;
            int n = words2Count;
            int quotient0 = quot[qs];
            int quotient1 = quot[qs + 1];
            if (quotient1 == 0) {
                short carry;
                tempArr[valueTPstart + n] = carry = BigInteger.LinearMultiply(tempArr, valueTPstart, tempArr, valueTBstart, (short)quotient0, n);
                tempArr[valueTPstart + n + 1] = 0;
            } else if (n == 2) {
                BigInteger.Baseline_Multiply2(tempArr, valueTPstart, quot, qs, tempArr, valueTBstart);
            } else {
                tempArr[valueTPstart + n] = 0;
                tempArr[valueTPstart + n + 1] = 0;
                BigInteger.AtomicMultiplyOpt(tempArr, valueTPstart, quotient0 &= 0xFFFF, quotient1 &= 0xFFFF, tempArr, valueTBstart, 0, n);
                BigInteger.AtomicMultiplyAddOpt(tempArr, valueTPstart, quotient0, quotient1, tempArr, valueTBstart, 2, n);
            }
            BigInteger.Subtract(tempArr, valueRstart2, tempArr, valueRstart2, tempArr, valueTPstart, n + 2);
            while (tempArr[valueRstart2 + n] != 0 || BigInteger.Compare(tempArr, valueRstart2, tempArr, valueTBstart, n) >= 0) {
                int n3 = valueRstart2 + n;
                tempArr[n3] = (short)(tempArr[n3] - (short)BigInteger.Subtract(tempArr, valueRstart2, tempArr, valueRstart2, tempArr, valueTBstart, n));
                if (quotientArr == null) continue;
                int n4 = qs;
                quotientArr[n4] = (short)(quotientArr[n4] + 1);
                int n5 = qs + 1;
                quotientArr[n5] = (short)(quotientArr[n5] + (short)(quotientArr[qs] == 0 ? 1 : 0));
            }
        }
        if (remainderArr != null) {
            System.arraycopy(tempArr, tempStart + shiftWords, remainderArr, remainderStart, words2Count);
            BigInteger.ShiftWordsRightByBits(remainderArr, remainderStart, words2Count, shiftBits);
        }
    }

    private static int RoundupSize(int n) {
        return n + (n & 1);
    }

    private BigInteger() {
    }

    public static BigInteger fromByteArray(byte[] bytes, boolean littleEndian) {
        if (bytes == null) {
            throw new NullPointerException("bytes");
        }
        if (bytes.length == 0) {
            return ZERO;
        }
        BigInteger bigint = new BigInteger();
        bigint.fromByteArrayInternal(bytes, littleEndian);
        return bigint;
    }

    private void fromByteArrayInternal(byte[] bytes, boolean littleEndian) {
        int index2;
        int index;
        int i;
        boolean negative;
        if (bytes == null) {
            throw new NullPointerException("bytes");
        }
        int len = bytes.length;
        int wordLength = len + 1 >> 1;
        wordLength = BigInteger.RoundupSize(wordLength);
        this.reg = new short[wordLength];
        int valueJIndex = littleEndian ? len - 1 : 0;
        this.negative = negative = (bytes[valueJIndex] & 0x80) != 0;
        int j = 0;
        if (!negative) {
            i = 0;
            while (i < len) {
                index = littleEndian ? i : len - 1 - i;
                index2 = littleEndian ? i + 1 : len - 2 - i;
                this.reg[j] = (short)(bytes[index] & 0xFF);
                if (index2 >= 0 && index2 < len) {
                    int n = j;
                    this.reg[n] = (short)(this.reg[n] | (short)((short)bytes[index2] << 8));
                }
                i += 2;
                ++j;
            }
        } else {
            i = 0;
            while (i < len) {
                index = littleEndian ? i : len - 1 - i;
                index2 = littleEndian ? i + 1 : len - 2 - i;
                this.reg[j] = (short)(bytes[index] & 0xFF);
                if (index2 >= 0 && index2 < len) {
                    int n = j;
                    this.reg[n] = (short)(this.reg[n] | (short)((short)bytes[index2] << 8));
                } else {
                    int n = j;
                    this.reg[n] = (short)(this.reg[n] | 0xFFFFFF00);
                }
                i += 2;
                ++j;
            }
            while (j < this.reg.length) {
                this.reg[j] = -1;
                ++j;
            }
            BigInteger.TwosComplement(this.reg, 0, this.reg.length);
        }
        this.wordCount = this.reg.length;
        while (this.wordCount != 0 && this.reg[this.wordCount - 1] == 0) {
            --this.wordCount;
        }
    }

    private BigInteger Allocate(int length) {
        this.reg = new short[BigInteger.RoundupSize(length)];
        this.negative = false;
        this.wordCount = 0;
        return this;
    }

    private static short[] GrowForCarry(short[] a, short carry) {
        int oldLength = a.length;
        short[] ret = BigInteger.CleanGrow(a, BigInteger.RoundupSize(oldLength + 1));
        ret[oldLength] = carry;
        return ret;
    }

    private static short[] CleanGrow(short[] a, int size) {
        if (size > a.length) {
            short[] newa = new short[size];
            System.arraycopy(a, 0, newa, 0, a.length);
            return newa;
        }
        return a;
    }

    private void SetBitInternal(int n, boolean value) {
        if (value) {
            this.reg = BigInteger.CleanGrow(this.reg, BigInteger.RoundupSize(BigInteger.BitsToWords(n + 1)));
            int n2 = n >> 4;
            this.reg[n2] = (short)(this.reg[n2] | (short)(1 << (n & 0xF)));
            this.wordCount = this.CalcWordCount();
        } else {
            if (n >> 4 < this.reg.length) {
                int n3 = n >> 4;
                this.reg[n3] = (short)(this.reg[n3] & (short)(~(1 << n % 16)));
            }
            this.wordCount = this.CalcWordCount();
        }
    }

    public boolean testBit(int index) {
        if (index < 0) {
            throw new IllegalArgumentException("index");
        }
        if (this.wordCount == 0) {
            return false;
        }
        if (this.negative) {
            int tcindex;
            int wordpos = index / 16;
            if (wordpos >= this.reg.length) {
                return true;
            }
            for (tcindex = 0; tcindex < wordpos && this.reg[tcindex] == 0; ++tcindex) {
            }
            short tc = this.reg[wordpos];
            if (tcindex == wordpos) {
                tc = (short)(tc - 1);
            }
            return ((tc = (short)(~tc)) >> (index & 0xF) & 1) != 0;
        }
        return this.GetUnsignedBit(index);
    }

    private boolean GetUnsignedBit(int n) {
        if (n >> 4 >= this.reg.length) {
            return false;
        }
        return (this.reg[n >> 4] >> (n & 0xF) & 1) != 0;
    }

    private BigInteger InitializeInt(int numberValue) {
        boolean bl = this.negative = numberValue < 0;
        if (numberValue == Integer.MIN_VALUE) {
            this.reg = new short[2];
            this.reg[0] = 0;
            this.reg[1] = Short.MIN_VALUE;
            this.wordCount = 2;
        } else {
            int iut = numberValue < 0 ? -numberValue : numberValue;
            this.reg = new short[2];
            this.reg[0] = (short)iut;
            this.reg[1] = (short)(iut >> 16);
            this.wordCount = this.reg[1] != 0 ? 2 : (this.reg[0] == 0 ? 0 : 1);
        }
        return this;
    }

    public byte[] toByteArray(boolean littleEndian) {
        int sign = this.signum();
        if (sign == 0) {
            return new byte[]{0};
        }
        if (sign > 0) {
            int byteCount;
            int byteArrayLength = byteCount = this.ByteCount();
            if (this.GetUnsignedBit(byteCount * 8 - 1)) {
                ++byteArrayLength;
            }
            byte[] bytes = new byte[byteArrayLength];
            int j = 0;
            int i = 0;
            while (i < byteCount) {
                int index = littleEndian ? i : bytes.length - 1 - i;
                int index2 = littleEndian ? i + 1 : bytes.length - 2 - i;
                bytes[index] = (byte)(this.reg[j] & 0xFF);
                if (index2 >= 0 && index2 < byteArrayLength) {
                    bytes[index2] = (byte)(this.reg[j] >> 8 & 0xFF);
                }
                i += 2;
                ++j;
            }
            return bytes;
        }
        short[] regdata = new short[this.reg.length];
        System.arraycopy(this.reg, 0, regdata, 0, this.reg.length);
        BigInteger.TwosComplement(regdata, 0, regdata.length);
        int byteCount = regdata.length * 2;
        for (int i = regdata.length - 1; i >= 0; --i) {
            if (regdata[i] == -1) {
                byteCount -= 2;
                continue;
            }
            if ((regdata[i] & 0xFF80) == 65408) {
                --byteCount;
                break;
            }
            if ((regdata[i] & 0x8000) == 32768) break;
            ++byteCount;
            break;
        }
        if (byteCount == 0) {
            byteCount = 1;
        }
        byte[] bytes = new byte[byteCount];
        bytes[littleEndian ? bytes.length - 1 : 0] = -1;
        byteCount = Math.min(byteCount, regdata.length * 2);
        int j = 0;
        int i = 0;
        while (i < byteCount) {
            int index = littleEndian ? i : bytes.length - 1 - i;
            int index2 = littleEndian ? i + 1 : bytes.length - 2 - i;
            bytes[index] = (byte)(regdata[j] & 0xFF);
            if (index2 >= 0 && index2 < byteCount) {
                bytes[index2] = (byte)(regdata[j] >> 8 & 0xFF);
            }
            i += 2;
            ++j;
        }
        return bytes;
    }

    public BigInteger shiftLeft(int numberBits) {
        boolean neg;
        if (numberBits == 0) {
            return this;
        }
        if (numberBits < 0) {
            if (numberBits == Integer.MIN_VALUE) {
                return this.shiftRight(1).shiftRight(Integer.MAX_VALUE);
            }
            return this.shiftRight(-numberBits);
        }
        BigInteger ret = new BigInteger();
        int numWords = this.wordCount;
        int shiftWords = numberBits >> 4;
        int shiftBits = numberBits & 0xF;
        boolean bl = neg = numWords > 0 && this.negative;
        if (!neg) {
            ret.negative = false;
            ret.reg = new short[BigInteger.RoundupSize(numWords + BigInteger.BitsToWords(numberBits))];
            System.arraycopy(this.reg, 0, ret.reg, shiftWords, numWords);
            BigInteger.ShiftWordsLeftByBits(ret.reg, shiftWords, numWords + BigInteger.BitsToWords(shiftBits), shiftBits);
            ret.wordCount = ret.CalcWordCount();
        } else {
            ret.negative = true;
            ret.reg = new short[BigInteger.RoundupSize(numWords + BigInteger.BitsToWords(numberBits))];
            System.arraycopy(this.reg, 0, ret.reg, 0, numWords);
            BigInteger.TwosComplement(ret.reg, 0, ret.reg.length);
            BigInteger.ShiftWordsLeftByWords(ret.reg, 0, numWords + shiftWords, shiftWords);
            BigInteger.ShiftWordsLeftByBits(ret.reg, shiftWords, numWords + BigInteger.BitsToWords(shiftBits), shiftBits);
            BigInteger.TwosComplement(ret.reg, 0, ret.reg.length);
            ret.wordCount = ret.CalcWordCount();
        }
        return ret;
    }

    public BigInteger shiftRight(int numberBits) {
        BigInteger ret;
        if (numberBits == 0 || this.wordCount == 0) {
            return this;
        }
        if (numberBits < 0) {
            if (numberBits == Integer.MIN_VALUE) {
                return this.shiftLeft(1).shiftLeft(Integer.MAX_VALUE);
            }
            return this.shiftLeft(-numberBits);
        }
        int numWords = this.wordCount;
        int shiftWords = numberBits >> 4;
        int shiftBits = numberBits & 0xF;
        if (this.negative) {
            ret = new BigInteger();
            ret.reg = new short[this.reg.length];
            System.arraycopy(this.reg, 0, ret.reg, 0, numWords);
            BigInteger.TwosComplement(ret.reg, 0, ret.reg.length);
            BigInteger.ShiftWordsRightByWordsSignExtend(ret.reg, 0, numWords, shiftWords);
            if (numWords > shiftWords) {
                BigInteger.ShiftWordsRightByBitsSignExtend(ret.reg, 0, numWords - shiftWords, shiftBits);
            }
            BigInteger.TwosComplement(ret.reg, 0, ret.reg.length);
            ret.wordCount = ret.reg.length;
        } else {
            if (shiftWords >= numWords) {
                return ZERO;
            }
            ret = new BigInteger();
            ret.reg = new short[this.reg.length];
            System.arraycopy(this.reg, shiftWords, ret.reg, 0, numWords - shiftWords);
            if (shiftBits != 0) {
                BigInteger.ShiftWordsRightByBits(ret.reg, 0, numWords - shiftWords, shiftBits);
            }
            ret.wordCount = numWords - shiftWords;
        }
        ret.negative = this.negative;
        while (ret.wordCount != 0 && ret.reg[ret.wordCount - 1] == 0) {
            --ret.wordCount;
        }
        if (shiftWords > 2) {
            this.ShortenArray();
        }
        return ret;
    }

    public static BigInteger valueOf(long longerValue) {
        if (longerValue == 0L) {
            return ZERO;
        }
        if (longerValue == 1L) {
            return ONE;
        }
        BigInteger ret = new BigInteger();
        ret.negative = longerValue < 0L;
        ret.reg = new short[4];
        if (longerValue == Long.MIN_VALUE) {
            ret.reg[0] = 0;
            ret.reg[1] = 0;
            ret.reg[2] = 0;
            ret.reg[3] = Short.MIN_VALUE;
            ret.wordCount = 4;
        } else {
            long ut = longerValue;
            if (ut < 0L) {
                ut = -ut;
            }
            ret.reg[0] = (short)(ut & 0xFFFFL);
            ret.reg[1] = (short)((ut >>= 16) & 0xFFFFL);
            ret.reg[2] = (short)((ut >>= 16) & 0xFFFFL);
            ret.reg[3] = (short)((ut >>= 16) & 0xFFFFL);
            ret.wordCount = 4;
            while (ret.wordCount != 0 && ret.reg[ret.wordCount - 1] == 0) {
                --ret.wordCount;
            }
        }
        return ret;
    }

    public int intValueChecked() {
        int count = this.wordCount;
        if (count == 0) {
            return 0;
        }
        if (count > 2) {
            throw new ArithmeticException();
        }
        if (count == 2 && (this.reg[1] & 0x8000) != 0) {
            if (this.negative && this.reg[1] == Short.MIN_VALUE && this.reg[0] == 0) {
                return Integer.MIN_VALUE;
            }
            throw new ArithmeticException();
        }
        return this.intValueUnchecked();
    }

    public int intValueUnchecked() {
        int c = this.wordCount;
        if (c == 0) {
            return 0;
        }
        int ivv = this.reg[0] & 0xFFFF;
        if (c > 1) {
            ivv |= (this.reg[1] & 0xFFFF) << 16;
        }
        if (this.negative) {
            --ivv;
            ivv ^= 0xFFFFFFFF;
        }
        return ivv;
    }

    public long longValueChecked() {
        int count = this.wordCount;
        if (count == 0) {
            return 0L;
        }
        if (count > 4) {
            throw new ArithmeticException();
        }
        if (count == 4 && (this.reg[3] & 0x8000) != 0) {
            if (this.negative && this.reg[3] == Short.MIN_VALUE && this.reg[2] == 0 && this.reg[1] == 0 && this.reg[0] == 0) {
                return Long.MIN_VALUE;
            }
            throw new ArithmeticException();
        }
        return this.longValueUnchecked();
    }

    public long longValueUnchecked() {
        int c = this.wordCount;
        if (c == 0) {
            return 0L;
        }
        long ivv = (long)this.reg[0] & 0xFFFFL;
        if (c > 1) {
            ivv |= ((long)this.reg[1] & 0xFFFFL) << 16;
            if (c > 2) {
                ivv |= ((long)this.reg[2] & 0xFFFFL) << 32;
                if (c > 3) {
                    ivv |= ((long)this.reg[3] & 0xFFFFL) << 48;
                }
            }
        }
        if (this.negative) {
            --ivv;
            ivv ^= 0xFFFFFFFFFFFFFFFFL;
        }
        return ivv;
    }

    public int intValue() {
        return this.intValueChecked();
    }

    public boolean canFitInInt() {
        int c = this.wordCount;
        if (c > 2) {
            return false;
        }
        if (c == 2 && (this.reg[1] & 0x8000) != 0) {
            return this.negative && this.reg[1] == Short.MIN_VALUE && this.reg[0] == 0;
        }
        return true;
    }

    private boolean HasSmallValue() {
        int c = this.wordCount;
        if (c > 4) {
            return false;
        }
        if (c == 4 && (this.reg[3] & 0x8000) != 0) {
            return this.negative && this.reg[3] == Short.MIN_VALUE && this.reg[2] == 0 && this.reg[1] == 0 && this.reg[0] == 0;
        }
        return true;
    }

    public long longValue() {
        return this.longValueChecked();
    }

    private static BigInteger Power2(int e) {
        BigInteger r = new BigInteger().Allocate(BigInteger.BitsToWords(e + 1));
        r.SetBitInternal(e, true);
        return r;
    }

    public BigInteger PowBigIntVar(BigInteger power) {
        if (power == null) {
            throw new NullPointerException("power");
        }
        int sign = power.signum();
        if (sign < 0) {
            throw new IllegalArgumentException("sign (" + Long.toString(sign) + ") is less than " + "0");
        }
        BigInteger thisVar = this;
        if (sign == 0) {
            return ONE;
        }
        if (power.equals(ONE)) {
            return this;
        }
        if (power.wordCount == 1 && power.reg[0] == 2) {
            return thisVar.multiply(thisVar);
        }
        if (power.wordCount == 1 && power.reg[0] == 3) {
            return thisVar.multiply(thisVar).multiply(thisVar);
        }
        BigInteger r = ONE;
        while (power.signum() != 0) {
            if (power.testBit(0)) {
                r = r.multiply(thisVar);
            }
            if ((power = power.shiftRight(1)).signum() == 0) continue;
            thisVar = thisVar.multiply(thisVar);
        }
        return r;
    }

    public BigInteger pow(int powerSmall) {
        if (powerSmall < 0) {
            throw new IllegalArgumentException("powerSmall (" + Long.toString(powerSmall) + ") is less than " + "0");
        }
        BigInteger thisVar = this;
        if (powerSmall == 0) {
            return ONE;
        }
        if (powerSmall == 1) {
            return this;
        }
        if (powerSmall == 2) {
            return thisVar.multiply(thisVar);
        }
        if (powerSmall == 3) {
            return thisVar.multiply(thisVar).multiply(thisVar);
        }
        BigInteger r = ONE;
        while (powerSmall != 0) {
            if ((powerSmall & 1) != 0) {
                r = r.multiply(thisVar);
            }
            if ((powerSmall >>= 1) == 0) continue;
            thisVar = thisVar.multiply(thisVar);
        }
        return r;
    }

    public BigInteger negate() {
        BigInteger bigintRet = new BigInteger();
        bigintRet.reg = this.reg;
        bigintRet.wordCount = this.wordCount;
        bigintRet.negative = this.wordCount != 0 && !this.negative;
        return bigintRet;
    }

    public BigInteger abs() {
        return this.wordCount == 0 || !this.negative ? this : this.negate();
    }

    private int CalcWordCount() {
        return BigInteger.CountWords(this.reg, this.reg.length);
    }

    private int ByteCount() {
        int wc = this.wordCount;
        if (wc == 0) {
            return 0;
        }
        short s = this.reg[wc - 1];
        wc = wc - 1 << 1;
        if (s == 0) {
            return wc;
        }
        return s >> 8 == 0 ? wc + 1 : wc + 2;
    }

    public int getUnsignedBitLength() {
        int wc = this.wordCount;
        if (wc != 0) {
            int numberValue = this.reg[wc - 1] & 0xFFFF;
            wc = wc - 1 << 4;
            if (numberValue == 0) {
                return wc;
            }
            wc += 16;
            if (numberValue >> 8 == 0) {
                numberValue <<= 8;
                wc -= 8;
            }
            if (numberValue >> 12 == 0) {
                numberValue <<= 4;
                wc -= 4;
            }
            if (numberValue >> 14 == 0) {
                numberValue <<= 2;
                wc -= 2;
            }
            if (numberValue >> 15 == 0) {
                --wc;
            }
            return wc;
        }
        return 0;
    }

    private static int getUnsignedBitLengthEx(int numberValue, int wordCount) {
        int wc = wordCount;
        if (wc != 0) {
            wc = wc - 1 << 4;
            if (numberValue == 0) {
                return wc;
            }
            wc += 16;
            if (numberValue >> 8 == 0) {
                numberValue <<= 8;
                wc -= 8;
            }
            if (numberValue >> 12 == 0) {
                numberValue <<= 4;
                wc -= 4;
            }
            if (numberValue >> 14 == 0) {
                numberValue <<= 2;
                wc -= 2;
            }
            if (numberValue >> 15 == 0) {
                --wc;
            }
            return wc;
        }
        return 0;
    }

    public int bitLength() {
        int wc = this.wordCount;
        if (wc != 0) {
            if (this.negative && (wc < 2 || this.reg[0] == 0)) {
                return this.abs().subtract(ONE).bitLength();
            }
            int numberValue = this.reg[wc - 1] & 0xFFFF;
            wc = wc - 1 << 4;
            if (numberValue == 0) {
                return wc;
            }
            wc += 16;
            if (this.negative) {
                --numberValue;
                numberValue &= 0xFFFF;
            }
            if (numberValue >> 8 == 0) {
                numberValue <<= 8;
                wc -= 8;
            }
            if (numberValue >> 12 == 0) {
                numberValue <<= 4;
                wc -= 4;
            }
            if (numberValue >> 14 == 0) {
                numberValue <<= 2;
                wc -= 2;
            }
            return numberValue >> 15 == 0 ? wc - 1 : wc;
        }
        return 0;
    }

    private static void ReverseChars(char[] chars, int offset, int length) {
        int half = length >> 1;
        int right = offset + length - 1;
        int i = 0;
        while (i < half) {
            char value = chars[offset + i];
            chars[offset + i] = chars[right];
            chars[right] = value;
            ++i;
            --right;
        }
    }

    private String SmallValueToString() {
        long value = this.longValue();
        if (value == Long.MIN_VALUE) {
            return "-9223372036854775808";
        }
        boolean neg = value < 0L;
        char[] chars = new char[24];
        int count = 0;
        if (neg) {
            chars[0] = 45;
            ++count;
            value = -value;
        }
        while (value != 0L) {
            char digit = HexChars.charAt((int)(value % 10L));
            chars[count++] = digit;
            value /= 10L;
        }
        if (neg) {
            BigInteger.ReverseChars(chars, 1, count - 1);
        } else {
            BigInteger.ReverseChars(chars, 0, count);
        }
        return new String(chars, 0, count);
    }

    private static int ApproxLogTenOfTwo(int bitlen) {
        int bitlenLow = bitlen & 0xFFFF;
        int bitlenHigh = bitlen >> 16 & 0xFFFF;
        short resultLow = 0;
        short resultHigh = 0;
        int p = bitlenLow * 34043;
        int d = p >> 16 & 0xFFFF;
        short c = (short)d;
        d = d >> 16 & 0xFFFF;
        p = bitlenLow * 8346;
        p += c & 0xFFFF;
        c = (short)p;
        d += p >> 16 & 0xFFFF;
        p = bitlenHigh * 34043;
        d += (p += c & 0xFFFF) >> 16 & 0xFFFF;
        c = (short)d;
        d = d >> 16 & 0xFFFF;
        p = bitlenLow * 154;
        p += c & 0xFFFF;
        c = (short)p;
        d += p >> 16 & 0xFFFF;
        p = bitlenHigh * 8346;
        p += c & 0xFFFF;
        c = (short)p;
        d += p >> 16 & 0xFFFF;
        p = c & 0xFFFF;
        resultLow = c = (short)p;
        c = (short)d;
        d = d >> 16 & 0xFFFF;
        p = bitlenHigh * 154;
        resultHigh = (short)(p += c & 0xFFFF);
        int result = resultLow & 0xFFFF;
        return ((result |= (resultHigh & 0xFFFF) << 16) & Integer.MAX_VALUE) >> 9;
    }

    public int getDigitCount() {
        int maxDigits;
        int minDigits;
        if (this.signum() == 0) {
            return 1;
        }
        if (this.HasSmallValue()) {
            long value = this.longValue();
            if (value == Long.MIN_VALUE) {
                return 19;
            }
            if (value < 0L) {
                value = -value;
            }
            if (value >= 1000000000L) {
                if (value >= 1000000000000000000L) {
                    return 19;
                }
                if (value >= 100000000000000000L) {
                    return 18;
                }
                if (value >= 10000000000000000L) {
                    return 17;
                }
                if (value >= 1000000000000000L) {
                    return 16;
                }
                if (value >= 100000000000000L) {
                    return 15;
                }
                if (value >= 10000000000000L) {
                    return 14;
                }
                if (value >= 1000000000000L) {
                    return 13;
                }
                if (value >= 100000000000L) {
                    return 12;
                }
                if (value >= 10000000000L) {
                    return 11;
                }
                if (value >= 1000000000L) {
                    return 10;
                }
                return 9;
            }
            int v2 = (int)value;
            if (v2 >= 100000000) {
                return 9;
            }
            if (v2 >= 10000000) {
                return 8;
            }
            if (v2 >= 1000000) {
                return 7;
            }
            if (v2 >= 100000) {
                return 6;
            }
            if (v2 >= 10000) {
                return 5;
            }
            if (v2 >= 1000) {
                return 4;
            }
            if (v2 >= 100) {
                return 3;
            }
            if (v2 >= 10) {
                return 2;
            }
            return 1;
        }
        int bitlen = this.getUnsignedBitLength();
        if (bitlen <= 2135) {
            minDigits = 1 + ((bitlen - 1) * 631305 >> 21);
            maxDigits = 1 + (bitlen * 631305 >> 21);
            if (minDigits == maxDigits) {
                return minDigits;
            }
        } else if (bitlen <= 6432162 && (minDigits = BigInteger.ApproxLogTenOfTwo(bitlen - 1)) == (maxDigits = BigInteger.ApproxLogTenOfTwo(bitlen))) {
            return 1 + minDigits;
        }
        short[] tempReg = null;
        int wordCount = this.wordCount;
        int i = 0;
        while (wordCount != 0) {
            short[] dividend;
            int rest;
            if (wordCount == 1 || wordCount == 2 && tempReg[1] == false) {
                rest = tempReg[0] & 0xFFFF;
                if (rest >= 10000) {
                    i += 5;
                    break;
                }
                if (rest >= 1000) {
                    i += 4;
                    break;
                }
                if (rest >= 100) {
                    i += 3;
                    break;
                }
                if (rest >= 10) {
                    i += 2;
                    break;
                }
                ++i;
                break;
            }
            if (wordCount == 2 && tempReg[1] > 0 && tempReg[1] <= Short.MAX_VALUE) {
                rest = tempReg[0] & 0xFFFF;
                if ((rest |= (tempReg[1] & 0xFFFF) << 16) >= 1000000000) {
                    i += 10;
                    break;
                }
                if (rest >= 100000000) {
                    i += 9;
                    break;
                }
                if (rest >= 10000000) {
                    i += 8;
                    break;
                }
                if (rest >= 1000000) {
                    i += 7;
                    break;
                }
                if (rest >= 100000) {
                    i += 6;
                    break;
                }
                if (rest >= 10000) {
                    i += 5;
                    break;
                }
                if (rest >= 1000) {
                    i += 4;
                    break;
                }
                if (rest >= 100) {
                    i += 3;
                    break;
                }
                if (rest >= 10) {
                    i += 2;
                    break;
                }
                ++i;
                break;
            }
            int wci = wordCount;
            int remainderShort = 0;
            boolean firstdigit = false;
            short[] sArray = dividend = tempReg == null ? this.reg : tempReg;
            while (wci-- > 0) {
                int curValue = dividend[wci] & 0xFFFF;
                int currentDividend = curValue | remainderShort << 16;
                int quo = currentDividend / 10000;
                if (!firstdigit && quo != 0) {
                    int maxDigits2;
                    int minDigits2;
                    firstdigit = true;
                    bitlen = BigInteger.getUnsignedBitLengthEx(quo, wci + 1);
                    if (bitlen <= 2135) {
                        minDigits2 = 1 + ((bitlen - 1) * 631305 >> 21);
                        maxDigits2 = 1 + (bitlen * 631305 >> 21);
                        if (minDigits2 == maxDigits2) {
                            return i + minDigits2 + 4;
                        }
                    } else if (bitlen <= 6432162 && (minDigits2 = BigInteger.ApproxLogTenOfTwo(bitlen - 1)) == (maxDigits2 = BigInteger.ApproxLogTenOfTwo(bitlen))) {
                        return i + 1 + minDigits2 + 4;
                    }
                }
                if (tempReg == null) {
                    if (quo != 0) {
                        tempReg = new short[this.wordCount];
                        System.arraycopy(this.reg, 0, tempReg, 0, tempReg.length);
                        wordCount = wci + 1;
                        tempReg[wci] = (short)quo;
                    }
                } else {
                    tempReg[wci] = (short)quo;
                }
                int rem = currentDividend - 10000 * quo;
                remainderShort = (short)rem;
            }
            while (wordCount != 0 && tempReg[wordCount - 1] == 0) {
                --wordCount;
            }
            i += 4;
        }
        return i;
    }

    public String toString() {
        int wordCount;
        if (this.signum() == 0) {
            return "0";
        }
        if (this.HasSmallValue()) {
            return this.SmallValueToString();
        }
        short[] tempReg = new short[this.wordCount];
        System.arraycopy(this.reg, 0, tempReg, 0, tempReg.length);
        for (wordCount = tempReg.length; wordCount != 0 && tempReg[wordCount - 1] == 0; --wordCount) {
        }
        int i = 0;
        char[] s = new char[(wordCount << 4) + 1];
        while (wordCount != 0) {
            int newrest;
            int rest;
            if (wordCount == 1 && tempReg[0] > 0 && tempReg[0] <= Short.MAX_VALUE) {
                rest = tempReg[0];
                while (rest != 0) {
                    newrest = rest * 26215 >> 18;
                    s[i++] = HexChars.charAt(rest - newrest * 10);
                    rest = newrest;
                }
                break;
            }
            if (wordCount == 2 && tempReg[1] > 0 && tempReg[1] <= Short.MAX_VALUE) {
                rest = tempReg[0] & 0xFFFF;
                rest |= (tempReg[1] & 0xFFFF) << 16;
                while (rest != 0) {
                    newrest = rest / 10;
                    s[i++] = HexChars.charAt(rest - newrest * 10);
                    rest = newrest;
                }
                break;
            }
            int wci = wordCount;
            int remainderShort = 0;
            while (wci-- > 0) {
                int currentDividend = tempReg[wci] & 0xFFFF | remainderShort << 16;
                int quo = currentDividend / 10000;
                tempReg[wci] = (short)quo;
                int rem = currentDividend - 10000 * quo;
                remainderShort = (short)rem;
            }
            int remainderSmall = remainderShort;
            while (wordCount != 0 && tempReg[wordCount - 1] == 0) {
                --wordCount;
            }
            int newrest2 = remainderSmall * 3277 >> 15;
            s[i++] = HexChars.charAt(remainderSmall - newrest2 * 10);
            remainderSmall = newrest2;
            newrest2 = remainderSmall * 3277 >> 15;
            s[i++] = HexChars.charAt(remainderSmall - newrest2 * 10);
            remainderSmall = newrest2;
            newrest2 = remainderSmall * 3277 >> 15;
            s[i++] = HexChars.charAt(remainderSmall - newrest2 * 10);
            remainderSmall = newrest2;
            s[i++] = HexChars.charAt(remainderSmall);
        }
        BigInteger.ReverseChars(s, 0, i);
        if (this.negative) {
            StringBuilder sb = new StringBuilder(i + 1);
            sb.append('-');
            sb.append(s, 0, 0 + i);
            return sb.toString();
        }
        return new String(s, 0, i);
    }

    public static BigInteger fromString(String str) {
        if (str == null) {
            throw new NullPointerException("str");
        }
        return BigInteger.fromSubstring(str, 0, str.length());
    }

    public static BigInteger fromSubstring(String str, int index, int endIndex) {
        if (str == null) {
            throw new NullPointerException("str");
        }
        if (index < 0) {
            throw new IllegalArgumentException("index (" + Long.toString(index) + ") is less than " + "0");
        }
        if (index > str.length()) {
            throw new IllegalArgumentException("index (" + Long.toString(index) + ") is more than " + Long.toString(str.length()));
        }
        if (endIndex < 0) {
            throw new IllegalArgumentException("endIndex (" + Long.toString(endIndex) + ") is less than " + "0");
        }
        if (endIndex > str.length()) {
            throw new IllegalArgumentException("endIndex (" + Long.toString(endIndex) + ") is more than " + Long.toString(str.length()));
        }
        if (endIndex < index) {
            throw new IllegalArgumentException("endIndex (" + Long.toString(endIndex) + ") is less than " + Long.toString(index));
        }
        if (index == endIndex) {
            throw new NumberFormatException("No digits");
        }
        boolean negative = false;
        if (str.charAt(0) == '-') {
            ++index;
            negative = true;
        }
        BigInteger bigint = new BigInteger().Allocate(4);
        boolean haveDigits = false;
        boolean haveSmallInt = true;
        int smallInt = 0;
        for (int i = index; i < endIndex; ++i) {
            char c = str.charAt(i);
            if (c < '0' || c > '9') {
                throw new NumberFormatException("Illegal character found");
            }
            haveDigits = true;
            int digit = c - 48;
            if (haveSmallInt && smallInt < 0xCCCCCCB) {
                smallInt *= 10;
                smallInt += digit;
                continue;
            }
            if (haveSmallInt) {
                bigint.reg[0] = (short)(smallInt & 0xFFFF);
                bigint.reg[1] = (short)(smallInt >> 16 & 0xFFFF);
                haveSmallInt = false;
            }
            short carry = 0;
            int n = bigint.reg.length;
            for (int j = 0; j < n; ++j) {
                int p = (bigint.reg[j] & 0xFFFF) * 10;
                bigint.reg[j] = (short)(p += carry & 0xFFFF);
                carry = (short)(p >> 16);
            }
            if (carry != 0) {
                bigint.reg = BigInteger.GrowForCarry(bigint.reg, carry);
            }
            if (digit == 0) continue;
            int d = bigint.reg[0] & 0xFFFF;
            if (d <= 65526) {
                bigint.reg[0] = (short)(d + digit);
                continue;
            }
            if (BigInteger.Increment(bigint.reg, 0, bigint.reg.length, (short)digit) == 0) continue;
            bigint.reg = BigInteger.GrowForCarry(bigint.reg, (short)1);
        }
        if (!haveDigits) {
            throw new NumberFormatException("No digits");
        }
        if (haveSmallInt) {
            bigint.reg[0] = (short)(smallInt & 0xFFFF);
            bigint.reg[1] = (short)(smallInt >> 16 & 0xFFFF);
        }
        bigint.wordCount = bigint.CalcWordCount();
        bigint.negative = bigint.wordCount != 0 && negative;
        return bigint;
    }

    public int getLowestSetBit() {
        int retSetBit = 0;
        for (int i = 0; i < this.wordCount; ++i) {
            short c = this.reg[i];
            if (c == 0) {
                retSetBit += 16;
                continue;
            }
            if ((c << 15 & 0xFFFF) != 0) {
                return retSetBit + 0;
            }
            if ((c << 14 & 0xFFFF) != 0) {
                return retSetBit + 1;
            }
            if ((c << 13 & 0xFFFF) != 0) {
                return retSetBit + 2;
            }
            if ((c << 12 & 0xFFFF) != 0) {
                return retSetBit + 3;
            }
            if ((c << 11 & 0xFFFF) != 0) {
                return retSetBit + 4;
            }
            if ((c << 10 & 0xFFFF) != 0) {
                return retSetBit + 5;
            }
            if ((c << 9 & 0xFFFF) != 0) {
                return retSetBit + 6;
            }
            if ((c << 8 & 0xFFFF) != 0) {
                return retSetBit + 7;
            }
            if ((c << 7 & 0xFFFF) != 0) {
                return retSetBit + 8;
            }
            if ((c << 6 & 0xFFFF) != 0) {
                return retSetBit + 9;
            }
            if ((c << 5 & 0xFFFF) != 0) {
                return retSetBit + 10;
            }
            if ((c << 4 & 0xFFFF) != 0) {
                return retSetBit + 11;
            }
            if ((c << 3 & 0xFFFF) != 0) {
                return retSetBit + 12;
            }
            if ((c << 2 & 0xFFFF) != 0) {
                return retSetBit + 13;
            }
            if ((c << 1 & 0xFFFF) != 0) {
                return retSetBit + 14;
            }
            return retSetBit + 15;
        }
        return 0;
    }

    public BigInteger gcd(BigInteger bigintSecond) {
        if (bigintSecond == null) {
            throw new NullPointerException("bigintSecond");
        }
        if (this.signum() == 0) {
            return bigintSecond.abs();
        }
        if (bigintSecond.signum() == 0) {
            return this.abs();
        }
        BigInteger thisValue = this.abs();
        if ((bigintSecond = bigintSecond.abs()).equals(ONE) || thisValue.equals(bigintSecond)) {
            return bigintSecond;
        }
        if (thisValue.equals(ONE)) {
            return thisValue;
        }
        int expOfTwo = Math.min(this.getLowestSetBit(), bigintSecond.getLowestSetBit());
        if (thisValue.wordCount <= 10 && bigintSecond.wordCount <= 10) {
            while (true) {
                BigInteger bigintA;
                if ((bigintA = thisValue.subtract(bigintSecond).abs()).signum() == 0) {
                    if (expOfTwo != 0) {
                        thisValue = thisValue.shiftLeft(expOfTwo);
                    }
                    return thisValue;
                }
                int setbit = bigintA.getLowestSetBit();
                bigintA = bigintA.shiftRight(setbit);
                bigintSecond = thisValue.compareTo(bigintSecond) < 0 ? thisValue : bigintSecond;
                thisValue = bigintA;
            }
        }
        while (thisValue.signum() != 0) {
            if (thisValue.compareTo(bigintSecond) < 0) {
                BigInteger temp = thisValue;
                thisValue = bigintSecond;
                bigintSecond = temp;
            }
            thisValue = thisValue.remainder(bigintSecond);
        }
        return bigintSecond;
    }

    public BigInteger ModPow(BigInteger pow, BigInteger mod) {
        if (pow == null) {
            throw new NullPointerException("pow");
        }
        if (pow.signum() < 0) {
            throw new IllegalArgumentException("pow (" + pow + ") is less than 0");
        }
        if (mod.signum() <= 0) {
            throw new IllegalArgumentException("mod (" + mod + ") is not greater than 0");
        }
        BigInteger r = ONE;
        BigInteger v = this;
        while (pow.signum() != 0) {
            if (pow.testBit(0)) {
                r = r.multiply(v).mod(mod);
            }
            if ((pow = pow.shiftRight(1)).signum() == 0) continue;
            v = v.multiply(v).mod(mod);
        }
        return r;
    }

    private static void PositiveSubtract(BigInteger bigintDiff, BigInteger minuend, BigInteger subtrahend) {
        int words1Size = minuend.wordCount;
        words1Size += words1Size & 1;
        int words2Size = subtrahend.wordCount;
        if (words1Size == (words2Size += words2Size & 1)) {
            if (BigInteger.Compare(minuend.reg, 0, subtrahend.reg, 0, words1Size) >= 0) {
                BigInteger.Subtract(bigintDiff.reg, 0, minuend.reg, 0, subtrahend.reg, 0, words1Size);
                bigintDiff.negative = false;
            } else {
                BigInteger.Subtract(bigintDiff.reg, 0, subtrahend.reg, 0, minuend.reg, 0, words1Size);
                bigintDiff.negative = true;
            }
        } else if (words1Size > words2Size) {
            short borrow = (short)BigInteger.Subtract(bigintDiff.reg, 0, minuend.reg, 0, subtrahend.reg, 0, words2Size);
            System.arraycopy(minuend.reg, words2Size, bigintDiff.reg, words2Size, words1Size - words2Size);
            borrow = (short)BigInteger.Decrement(bigintDiff.reg, words2Size, words1Size - words2Size, borrow);
            bigintDiff.negative = false;
        } else {
            short borrow = (short)BigInteger.Subtract(bigintDiff.reg, 0, subtrahend.reg, 0, minuend.reg, 0, words1Size);
            System.arraycopy(subtrahend.reg, words1Size, bigintDiff.reg, words1Size, words2Size - words1Size);
            borrow = (short)BigInteger.Decrement(bigintDiff.reg, words1Size, words2Size - words1Size, borrow);
            bigintDiff.negative = true;
        }
        bigintDiff.wordCount = bigintDiff.CalcWordCount();
        bigintDiff.ShortenArray();
        if (bigintDiff.wordCount == 0) {
            bigintDiff.negative = false;
        }
    }

    public boolean equals(Object obj) {
        BigInteger other;
        BigInteger bigInteger = other = obj instanceof BigInteger ? (BigInteger)obj : null;
        if (other == null) {
            return false;
        }
        if (this.wordCount == other.wordCount) {
            if (this.negative != other.negative) {
                return false;
            }
            for (int i = 0; i < this.wordCount; ++i) {
                if (this.reg[i] == other.reg[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        int hashCodeValue = 0;
        hashCodeValue += 1000000007 * this.signum();
        if (this.reg != null) {
            for (int i = 0; i < this.wordCount; ++i) {
                hashCodeValue += 1000000013 * this.reg[i];
            }
        }
        return hashCodeValue;
    }

    public BigInteger add(BigInteger bigintAugend) {
        if (bigintAugend == null) {
            throw new NullPointerException("bigintAugend");
        }
        if (this.wordCount == 0) {
            return bigintAugend;
        }
        if (bigintAugend.wordCount == 0) {
            return this;
        }
        if (bigintAugend.wordCount == 1 && this.wordCount == 1) {
            if (this.negative == bigintAugend.negative) {
                int intSum = (this.reg[0] & 0xFFFF) + (bigintAugend.reg[0] & 0xFFFF);
                BigInteger sum = new BigInteger();
                sum.reg = new short[2];
                sum.reg[0] = (short)intSum;
                sum.reg[1] = (short)(intSum >> 16);
                sum.wordCount = intSum >> 16 == 0 ? 1 : 2;
                sum.negative = this.negative;
                return sum;
            }
            int a = this.reg[0] & 0xFFFF;
            int b = bigintAugend.reg[0] & 0xFFFF;
            if (a == b) {
                return ZERO;
            }
            if (a > b) {
                BigInteger sum = new BigInteger();
                sum.reg = new short[2];
                sum.reg[0] = (short)(a -= b);
                sum.wordCount = 1;
                sum.negative = this.negative;
                return sum;
            }
            BigInteger sum = new BigInteger();
            sum.reg = new short[2];
            sum.reg[0] = (short)(b -= a);
            sum.wordCount = 1;
            sum.negative = !this.negative;
            return sum;
        }
        BigInteger sum = new BigInteger().Allocate(Math.max(this.reg.length, bigintAugend.reg.length));
        if (!this.negative == !bigintAugend.negative) {
            int carry;
            int addendCount = this.wordCount;
            int augendCount = bigintAugend.wordCount;
            int desiredLength = Math.max(addendCount, augendCount);
            if (addendCount == augendCount) {
                carry = BigInteger.AddOneByOne(sum.reg, 0, this.reg, 0, bigintAugend.reg, 0, addendCount);
            } else if (addendCount > augendCount) {
                carry = BigInteger.AddOneByOne(sum.reg, 0, this.reg, 0, bigintAugend.reg, 0, augendCount);
                System.arraycopy(this.reg, augendCount, sum.reg, augendCount, addendCount - augendCount);
                if (carry != 0) {
                    carry = BigInteger.Increment(sum.reg, augendCount, addendCount - augendCount, (short)carry);
                }
            } else {
                carry = BigInteger.AddOneByOne(sum.reg, 0, this.reg, 0, bigintAugend.reg, 0, addendCount);
                System.arraycopy(bigintAugend.reg, addendCount, sum.reg, addendCount, augendCount - addendCount);
                if (carry != 0) {
                    carry = BigInteger.Increment(sum.reg, addendCount, augendCount - addendCount, (short)carry);
                }
            }
            boolean needShorten = true;
            if (carry != 0) {
                int nextIndex = desiredLength;
                int len = BigInteger.RoundupSize(nextIndex + 1);
                sum.reg = BigInteger.CleanGrow(sum.reg, len);
                sum.reg[nextIndex] = (short)carry;
                needShorten = false;
            }
            sum.negative = false;
            sum.wordCount = sum.CalcWordCount();
            if (needShorten) {
                sum.ShortenArray();
            }
            sum.negative = this.negative && sum.signum() != 0;
        } else if (this.negative) {
            BigInteger.PositiveSubtract(sum, bigintAugend, this);
        } else {
            BigInteger.PositiveSubtract(sum, this, bigintAugend);
        }
        return sum;
    }

    public BigInteger subtract(BigInteger subtrahend) {
        if (subtrahend == null) {
            throw new NullPointerException("subtrahend");
        }
        if (this.wordCount == 0) {
            return subtrahend.negate();
        }
        if (subtrahend.wordCount == 0) {
            return this;
        }
        return this.add(subtrahend.negate());
    }

    private void ShortenArray() {
        int newLength;
        if (this.reg.length > 32 && (newLength = BigInteger.RoundupSize(this.wordCount)) < this.reg.length && this.reg.length - newLength >= 16) {
            short[] newreg = new short[newLength];
            System.arraycopy(this.reg, 0, newreg, 0, Math.min(newLength, this.reg.length));
            this.reg = newreg;
        }
    }

    public BigInteger multiply(BigInteger bigintMult) {
        int words1Size;
        int wc;
        if (bigintMult == null) {
            throw new NullPointerException("bigintMult");
        }
        if (this.wordCount == 0 || bigintMult.wordCount == 0) {
            return ZERO;
        }
        if (this.wordCount == 1 && this.reg[0] == 1) {
            return this.negative ? bigintMult.negate() : bigintMult;
        }
        if (bigintMult.wordCount == 1 && bigintMult.reg[0] == 1) {
            return bigintMult.negative ? this.negate() : this;
        }
        BigInteger product = new BigInteger();
        boolean needShorten = true;
        if (this.wordCount == 1) {
            wc = bigintMult.wordCount;
            int regLength = BigInteger.RoundupSize(wc + 1);
            product.reg = new short[regLength];
            product.reg[wc] = BigInteger.LinearMultiply(product.reg, 0, bigintMult.reg, 0, this.reg[0], wc);
            product.negative = false;
            product.wordCount = product.reg.length;
            needShorten = false;
        } else if (bigintMult.wordCount == 1) {
            wc = this.wordCount;
            int regLength = BigInteger.RoundupSize(wc + 1);
            product.reg = new short[regLength];
            product.reg[wc] = BigInteger.LinearMultiply(product.reg, 0, this.reg, 0, bigintMult.reg[0], wc);
            product.negative = false;
            product.wordCount = product.reg.length;
            needShorten = false;
        } else if (this.equals(bigintMult)) {
            words1Size = BigInteger.RoundupSize(this.wordCount);
            product.reg = new short[words1Size + words1Size];
            product.wordCount = product.reg.length;
            product.negative = false;
            short[] workspace = new short[words1Size + words1Size];
            BigInteger.RecursiveSquare(product.reg, 0, workspace, 0, this.reg, 0, words1Size);
        } else if (this.wordCount <= 10 && bigintMult.wordCount <= 10) {
            wc = this.wordCount + bigintMult.wordCount;
            wc = BigInteger.RoundupSize(wc);
            product.reg = new short[wc];
            product.negative = false;
            product.wordCount = product.reg.length;
            BigInteger.SchoolbookMultiply(product.reg, 0, this.reg, 0, this.wordCount, bigintMult.reg, 0, bigintMult.wordCount);
            needShorten = false;
        } else {
            words1Size = this.wordCount;
            int words2Size = bigintMult.wordCount;
            words1Size = BigInteger.RoundupSize(words1Size);
            words2Size = BigInteger.RoundupSize(words2Size);
            product.reg = new short[BigInteger.RoundupSize(words1Size + words2Size)];
            product.negative = false;
            short[] workspace = new short[words1Size + words2Size];
            product.wordCount = product.reg.length;
            BigInteger.AsymmetricMultiply(product.reg, 0, workspace, 0, this.reg, 0, words1Size, bigintMult.reg, 0, words2Size);
        }
        while (product.wordCount != 0 && product.reg[product.wordCount - 1] == 0) {
            --product.wordCount;
        }
        if (needShorten) {
            product.ShortenArray();
        }
        if (this.negative != bigintMult.negative) {
            product.NegateInternal();
        }
        return product;
    }

    private static int BitsToWords(int bitCount) {
        return bitCount + 15 >> 4;
    }

    private static short FastRemainder(short[] dividendReg, int count, short divisorSmall) {
        int i = count;
        short remainder = 0;
        while (i-- > 0) {
            remainder = BigInteger.RemainderUnsigned(BigInteger.MakeUint(dividendReg[i], remainder), divisorSmall);
        }
        return remainder;
    }

    private static void FastDivide(short[] quotientReg, short[] dividendReg, int count, short divisorSmall) {
        int i = count;
        int remainderShort = 0;
        int idivisor = divisorSmall & 0xFFFF;
        while (i-- > 0) {
            int currentDividend = dividendReg[i] & 0xFFFF | remainderShort << 16;
            if (currentDividend >> 31 == 0) {
                int quo = currentDividend / idivisor;
                quotientReg[i] = (short)quo;
                if (i <= 0) continue;
                int rem = currentDividend - idivisor * quo;
                remainderShort = (short)rem;
                continue;
            }
            quotientReg[i] = BigInteger.DivideUnsigned(currentDividend, divisorSmall);
            if (i <= 0) continue;
            remainderShort = BigInteger.RemainderUnsigned(currentDividend, divisorSmall);
        }
    }

    private static short FastDivideAndRemainder(short[] quotientReg, int quotientStart, short[] dividendReg, int dividendStart, int count, short divisorSmall) {
        int i = count;
        short remainderShort = 0;
        int idivisor = divisorSmall & 0xFFFF;
        while (i-- > 0) {
            int currentDividend = dividendReg[dividendStart + i] & 0xFFFF | remainderShort << 16;
            if (currentDividend >> 31 == 0) {
                int quo = currentDividend / idivisor;
                quotientReg[quotientStart + i] = (short)quo;
                int rem = currentDividend - idivisor * quo;
                remainderShort = (short)rem;
                continue;
            }
            quotientReg[quotientStart + i] = BigInteger.DivideUnsigned(currentDividend, divisorSmall);
            remainderShort = BigInteger.RemainderUnsigned(currentDividend, divisorSmall);
        }
        return remainderShort;
    }

    public BigInteger divide(BigInteger bigintDivisor) {
        if (bigintDivisor == null) {
            throw new NullPointerException("bigintDivisor");
        }
        int words1Size = this.wordCount;
        int words2Size = bigintDivisor.wordCount;
        if (words2Size == 0) {
            throw new ArithmeticException();
        }
        if (words1Size < words2Size) {
            return ZERO;
        }
        if (words1Size <= 2 && words2Size <= 2 && this.canFitInInt() && bigintDivisor.canFitInInt()) {
            int valueASmall = this.intValue();
            int valueBSmall = bigintDivisor.intValue();
            if (valueASmall != Integer.MIN_VALUE || valueBSmall != -1) {
                int result = valueASmall / valueBSmall;
                return new BigInteger().InitializeInt(result);
            }
        }
        if (words2Size == 1) {
            BigInteger quotient = new BigInteger();
            quotient.reg = new short[this.reg.length];
            quotient.wordCount = this.wordCount;
            quotient.negative = this.negative;
            BigInteger.FastDivide(quotient.reg, this.reg, words1Size, bigintDivisor.reg[0]);
            while (quotient.wordCount != 0 && quotient.reg[quotient.wordCount - 1] == 0) {
                --quotient.wordCount;
            }
            if (quotient.wordCount != 0) {
                quotient.negative = this.negative ^ bigintDivisor.negative;
                return quotient;
            }
            return ZERO;
        }
        BigInteger quotient = new BigInteger();
        words1Size += words1Size & 1;
        words2Size += words2Size & 1;
        quotient.reg = new short[BigInteger.RoundupSize(words1Size - words2Size + 2)];
        quotient.negative = false;
        short[] tempbuf = new short[words1Size + 3 * (words2Size + 2)];
        BigInteger.Divide(null, 0, quotient.reg, 0, tempbuf, 0, this.reg, 0, words1Size, bigintDivisor.reg, 0, words2Size);
        quotient.wordCount = quotient.CalcWordCount();
        quotient.ShortenArray();
        if (this.signum() < 0 ^ bigintDivisor.signum() < 0) {
            quotient.NegateInternal();
        }
        return quotient;
    }

    public BigInteger[] divideAndRemainder(BigInteger divisor) {
        if (divisor == null) {
            throw new NullPointerException("divisor");
        }
        int words1Size = this.wordCount;
        int words2Size = divisor.wordCount;
        if (words2Size == 0) {
            throw new ArithmeticException();
        }
        if (words1Size < words2Size) {
            return new BigInteger[]{ZERO, this};
        }
        if (words2Size == 1) {
            BigInteger quotient = new BigInteger();
            quotient.reg = new short[this.reg.length];
            quotient.wordCount = this.wordCount;
            quotient.negative = this.negative;
            int smallRemainder = BigInteger.FastDivideAndRemainder(quotient.reg, 0, this.reg, 0, words1Size, divisor.reg[0]) & 0xFFFF;
            while (quotient.wordCount != 0 && quotient.reg[quotient.wordCount - 1] == 0) {
                --quotient.wordCount;
            }
            quotient.ShortenArray();
            if (quotient.wordCount != 0) {
                quotient.negative = this.negative ^ divisor.negative;
            } else {
                quotient = ZERO;
            }
            if (this.negative) {
                smallRemainder = -smallRemainder;
            }
            return new BigInteger[]{quotient, new BigInteger().InitializeInt(smallRemainder)};
        }
        if (this.wordCount == 2 && divisor.wordCount == 2 && this.reg[1] >> 15 != 0 && divisor.reg[1] >> 15 != 0) {
            int a = this.reg[0] & 0xFFFF;
            int b = divisor.reg[0] & 0xFFFF;
            int quo = (a |= (this.reg[1] & 0xFFFF) << 16) / (b |= (divisor.reg[1] & 0xFFFF) << 16);
            if (this.negative) {
                quo = -quo;
            }
            int rem = a - b * quo;
            return new BigInteger[]{new BigInteger().InitializeInt(quo), new BigInteger().InitializeInt(rem)};
        }
        BigInteger remainder = new BigInteger();
        BigInteger quotient = new BigInteger();
        words1Size += words1Size & 1;
        words2Size += words2Size & 1;
        remainder.reg = new short[BigInteger.RoundupSize(words2Size)];
        remainder.negative = false;
        quotient.reg = new short[BigInteger.RoundupSize(words1Size - words2Size + 2)];
        quotient.negative = false;
        short[] tempbuf = new short[words1Size + 3 * (words2Size + 2)];
        BigInteger.Divide(remainder.reg, 0, quotient.reg, 0, tempbuf, 0, this.reg, 0, words1Size, divisor.reg, 0, words2Size);
        remainder.wordCount = remainder.CalcWordCount();
        quotient.wordCount = quotient.CalcWordCount();
        remainder.ShortenArray();
        quotient.ShortenArray();
        if (this.signum() < 0) {
            quotient.NegateInternal();
            if (remainder.signum() != 0) {
                remainder.NegateInternal();
            }
        }
        if (divisor.signum() < 0) {
            quotient.NegateInternal();
        }
        return new BigInteger[]{quotient, remainder};
    }

    public BigInteger mod(BigInteger divisor) {
        if (divisor == null) {
            throw new NullPointerException("divisor");
        }
        if (divisor.signum() < 0) {
            throw new ArithmeticException("Divisor is negative");
        }
        BigInteger rem = this.remainder(divisor);
        if (rem.signum() < 0) {
            rem = divisor.add(rem);
        }
        return rem;
    }

    public BigInteger remainder(BigInteger divisor) {
        if (divisor == null) {
            throw new NullPointerException("divisor");
        }
        int words1Size = this.wordCount;
        int words2Size = divisor.wordCount;
        if (words2Size == 0) {
            throw new ArithmeticException();
        }
        if (words1Size < words2Size) {
            return this;
        }
        if (words2Size == 1) {
            short shortRemainder = BigInteger.FastRemainder(this.reg, this.wordCount, divisor.reg[0]);
            int smallRemainder = shortRemainder & 0xFFFF;
            if (this.negative) {
                smallRemainder = -smallRemainder;
            }
            return new BigInteger().InitializeInt(smallRemainder);
        }
        if (this.PositiveCompare(divisor) < 0) {
            return this;
        }
        BigInteger remainder = new BigInteger();
        words1Size += words1Size & 1;
        words2Size += words2Size & 1;
        remainder.reg = new short[BigInteger.RoundupSize(words2Size)];
        remainder.negative = false;
        short[] tempbuf = new short[words1Size + 3 * (words2Size + 2)];
        BigInteger.Divide(remainder.reg, 0, null, 0, tempbuf, 0, this.reg, 0, words1Size, divisor.reg, 0, words2Size);
        remainder.wordCount = remainder.CalcWordCount();
        remainder.ShortenArray();
        if (this.signum() < 0 && remainder.signum() != 0) {
            remainder.NegateInternal();
        }
        return remainder;
    }

    private void NegateInternal() {
        if (this.wordCount != 0) {
            this.negative = this.signum() > 0;
        }
    }

    private int PositiveCompare(BigInteger t) {
        int size = this.wordCount;
        int tempSize = t.wordCount;
        if (size == tempSize) {
            return BigInteger.Compare(this.reg, 0, t.reg, 0, size);
        }
        return size > tempSize ? 1 : -1;
    }

    @Override
    public int compareTo(BigInteger other) {
        int sb;
        int sa;
        if (other == null) {
            return 1;
        }
        if (this == other) {
            return 0;
        }
        int size = this.wordCount;
        int tempSize = other.wordCount;
        int n = size == 0 ? 0 : (sa = this.negative ? -1 : 1);
        int n2 = tempSize == 0 ? 0 : (sb = other.negative ? -1 : 1);
        if (sa != sb) {
            return sa < sb ? -1 : 1;
        }
        if (sa == 0) {
            return 0;
        }
        if (size == tempSize) {
            if (size == 1 && this.reg[0] == other.reg[0]) {
                return 0;
            }
            short[] words1 = this.reg;
            short[] words2 = other.reg;
            while (size-- != 0) {
                int an = words1[size] & 0xFFFF;
                int bn = words2[size] & 0xFFFF;
                if (an > bn) {
                    return sa > 0 ? 1 : -1;
                }
                if (an >= bn) continue;
                return sa > 0 ? -1 : 1;
            }
            return 0;
        }
        return size > tempSize ^ sa <= 0 ? 1 : -1;
    }

    public int signum() {
        if (this.wordCount == 0) {
            return 0;
        }
        return this.negative ? -1 : 1;
    }

    public boolean isZero() {
        return this.wordCount == 0;
    }

    public BigInteger sqrt() {
        BigInteger[] srrem = this.sqrtWithRemainder();
        return srrem[0];
    }

    public BigInteger[] sqrtWithRemainder() {
        if (this.signum() <= 0) {
            return new BigInteger[]{ZERO, ZERO};
        }
        if (this.equals(ONE)) {
            return new BigInteger[]{ONE, ZERO};
        }
        BigInteger thisValue = this;
        int powerBits = (thisValue.getUnsignedBitLength() + 1) / 2;
        if (thisValue.canFitInInt()) {
            int smallValue = thisValue.intValue();
            int smallintX = 0;
            int smallintY = 1 << powerBits;
            do {
                smallintX = smallintY;
                smallintY = smallValue / smallintX;
                smallintY += smallintX;
            } while ((smallintY >>= 1) < smallintX);
            smallintY = smallintX * smallintX;
            smallintY = smallValue - smallintY;
            return new BigInteger[]{BigInteger.valueOf(smallintX), BigInteger.valueOf(smallintY)};
        }
        BigInteger bigintX = null;
        BigInteger bigintY = BigInteger.Power2(powerBits);
        do {
            bigintX = bigintY;
            bigintY = thisValue.divide(bigintX);
            bigintY = bigintY.add(bigintX);
        } while ((bigintY = bigintY.shiftRight(1)).compareTo(bigintX) < 0);
        bigintY = bigintX.multiply(bigintX);
        bigintY = thisValue.subtract(bigintY);
        return new BigInteger[]{bigintX, bigintY};
    }

    public boolean isEven() {
        return !this.GetUnsignedBit(0);
    }
}

