/*
 * Decompiled with CFR 0.152.
 */
package com.upokecenter.cbor;

import com.upokecenter.cbor.CBORException;
import com.upokecenter.cbor.CBORObject;
import com.upokecenter.cbor.CBORType;
import com.upokecenter.cbor.CBORTypeFilter;
import com.upokecenter.cbor.ICBORConverter;
import com.upokecenter.cbor.ICBORTag;
import java.util.UUID;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class CBORTag37
implements ICBORTag,
ICBORConverter<UUID> {
    CBORTag37() {
    }

    @Override
    public CBORTypeFilter GetTypeFilter() {
        return CBORTypeFilter.ByteString;
    }

    @Override
    public CBORObject ValidateObject(CBORObject obj) {
        if (obj.getType() != CBORType.ByteString) {
            throw new CBORException("UUID must be a byte string");
        }
        if (obj.GetByteString().length != 16) {
            throw new CBORException("UUID must be 16 bytes long");
        }
        return obj;
    }

    static void AddConverter() {
        CBORObject.AddConverter(UUID.class, new CBORTag37());
    }

    @Override
    public CBORObject ToCBORObject(UUID obj) {
        byte[] bytes2 = new byte[16];
        long lsb = obj.getLeastSignificantBits();
        long msb = obj.getMostSignificantBits();
        bytes2[0] = (byte)(msb >> 56 & 0xFFL);
        bytes2[1] = (byte)(msb >> 48 & 0xFFL);
        bytes2[2] = (byte)(msb >> 40 & 0xFFL);
        bytes2[3] = (byte)(msb >> 32 & 0xFFL);
        bytes2[4] = (byte)(msb >> 24 & 0xFFL);
        bytes2[5] = (byte)(msb >> 16 & 0xFFL);
        bytes2[6] = (byte)(msb >> 8 & 0xFFL);
        bytes2[7] = (byte)(msb & 0xFFL);
        bytes2[8] = (byte)(lsb >> 56 & 0xFFL);
        bytes2[9] = (byte)(lsb >> 48 & 0xFFL);
        bytes2[10] = (byte)(lsb >> 40 & 0xFFL);
        bytes2[11] = (byte)(lsb >> 32 & 0xFFL);
        bytes2[12] = (byte)(lsb >> 24 & 0xFFL);
        bytes2[13] = (byte)(lsb >> 16 & 0xFFL);
        bytes2[14] = (byte)(lsb >> 8 & 0xFFL);
        bytes2[15] = (byte)(lsb & 0xFFL);
        return CBORObject.FromObjectAndTag((Object)bytes2, 37);
    }
}

