/*
 * Decompiled with CFR 0.152.
 */
package com.upokecenter.cbor;

final class Base64 {
    private static final String Base64URL = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789-_";
    private static final String Base64Classic = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";

    private Base64() {
    }

    public static void ToBase64(StringBuilder str, byte[] data, boolean padding) {
        if (data == null) {
            throw new NullPointerException("data");
        }
        Base64.ToBase64(str, data, 0, data.length, Base64Classic, padding);
    }

    public static void ToBase64URL(StringBuilder str, byte[] data, boolean padding) {
        if (data == null) {
            throw new NullPointerException("data");
        }
        Base64.ToBase64(str, data, 0, data.length, Base64URL, padding);
    }

    public static void ToBase64(StringBuilder str, byte[] data, int offset, int count, boolean padding) {
        Base64.ToBase64(str, data, offset, count, Base64Classic, padding);
    }

    public static void ToBase64URL(StringBuilder str, byte[] data, int offset, int count, boolean padding) {
        Base64.ToBase64(str, data, offset, count, Base64URL, padding);
    }

    public static String ToBase64String(byte[] data, boolean padding) {
        if (data == null) {
            throw new NullPointerException("data");
        }
        return Base64.ToBase64String(data, 0, data.length, padding);
    }

    public static String ToBase64URLString(byte[] data, boolean padding) {
        if (data == null) {
            throw new NullPointerException("data");
        }
        return Base64.ToBase64String(data, 0, data.length, padding);
    }

    public static String ToBase64String(byte[] data, int offset, int count, boolean padding) {
        StringBuilder builder = new StringBuilder();
        Base64.ToBase64(builder, data, offset, count, Base64Classic, padding);
        return builder.toString();
    }

    public static String ToBase64URLString(byte[] data, int offset, int count, boolean padding) {
        StringBuilder builder = new StringBuilder();
        Base64.ToBase64(builder, data, offset, count, Base64Classic, padding);
        return builder.toString();
    }

    private static void ToBase64(StringBuilder str, byte[] data, int offset, int count, String alphabet, boolean padding) {
        if (data == null) {
            throw new NullPointerException("data");
        }
        if (offset < 0) {
            throw new IllegalArgumentException("offset (" + Integer.toString(offset) + ") is less than " + "0");
        }
        if (offset > data.length) {
            throw new IllegalArgumentException("offset (" + Integer.toString(offset) + ") is more than " + Integer.toString(data.length));
        }
        if (count < 0) {
            throw new IllegalArgumentException("count (" + Integer.toString(count) + ") is less than " + "0");
        }
        if (count > data.length) {
            throw new IllegalArgumentException("count (" + Integer.toString(count) + ") is more than " + Integer.toString(data.length));
        }
        if (data.length - offset < count) {
            throw new IllegalArgumentException("data's length minus " + offset + " (" + Integer.toString(data.length - offset) + ") is less than " + Integer.toString(count));
        }
        int length = offset + count;
        int i = offset;
        for (i = offset; i < length - 2; i += 3) {
            str.append(alphabet.charAt(data[i] >> 2 & 0x3F));
            str.append(alphabet.charAt(((data[i] & 3) << 4) + (data[i + 1] >> 4 & 0xF)));
            str.append(alphabet.charAt(((data[i + 1] & 0xF) << 2) + (data[i + 2] >> 6 & 3)));
            str.append(alphabet.charAt(data[i + 2] & 0x3F));
        }
        int lenmod3 = count % 3;
        if (lenmod3 != 0) {
            i = length - lenmod3;
            str.append(alphabet.charAt(data[i] >> 2 & 0x3F));
            if (lenmod3 == 2) {
                str.append(alphabet.charAt(((data[i] & 3) << 4) + (data[i + 1] >> 4 & 0xF)));
                str.append(alphabet.charAt((data[i + 1] & 0xF) << 2));
                if (padding) {
                    str.append("=");
                }
            } else {
                str.append(alphabet.charAt((data[i] & 3) << 4));
                if (padding) {
                    str.append("==");
                }
            }
        }
    }
}

