/*
 * Decompiled with CFR 0.152.
 */
package com.uploadcare.android.widget.data;

import android.content.Context;
import android.content.SharedPreferences;
import android.os.Parcel;
import android.os.Parcelable;
import android.webkit.CookieManager;
import androidx.preference.PreferenceManager;
import com.squareup.moshi.Json;
import com.uploadcare.android.widget.R;
import com.uploadcare.android.widget.data.Chunk;
import com.uploadcare.android.widget.data.Urls;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.parcelize.Parcelize;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0087\b\u0018\u00002\u00020\u0001B%\u0012\u000e\b\u0001\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u000f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\bH\u00c6\u0003J-\u0010\u0013\u001a\u00020\u00002\u000e\b\u0003\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\bH\u00c6\u0001J\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001J\u0013\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u00d6\u0003J\u000e\u0010\u001e\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u0017J\u0006\u0010\u001f\u001a\u00020\u0019J\u0006\u0010 \u001a\u00020\u0019J\t\u0010!\u001a\u00020\u0019H\u00d6\u0001J\u0006\u0010\"\u001a\u00020\u001bJ\u0016\u0010#\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010$\u001a\u00020\u0006J\t\u0010%\u001a\u00020\u0006H\u00d6\u0001J\u0019\u0010&\u001a\u00020\u00152\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020\u0019H\u00d6\u0001R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006*"}, d2={"Lcom/uploadcare/android/widget/data/SocialSource;", "Landroid/os/Parcelable;", "rootChunks", "", "Lcom/uploadcare/android/widget/data/Chunk;", "name", "", "urls", "Lcom/uploadcare/android/widget/data/Urls;", "(Ljava/util/List;Ljava/lang/String;Lcom/uploadcare/android/widget/data/Urls;)V", "getName", "()Ljava/lang/String;", "getRootChunks", "()Ljava/util/List;", "getUrls", "()Lcom/uploadcare/android/widget/data/Urls;", "component1", "component2", "component3", "copy", "deleteCookie", "", "context", "Landroid/content/Context;", "describeContents", "", "equals", "", "other", "", "getCookie", "getNetworkIconResource", "getNetworkNameResource", "hashCode", "isSupported", "saveCookie", "cookie", "toString", "writeToParcel", "parcel", "Landroid/os/Parcel;", "flags", "widget_release"})
@Parcelize
public final class SocialSource
implements Parcelable {
    @NotNull
    private final List<Chunk> rootChunks;
    @NotNull
    private final String name;
    @NotNull
    private final Urls urls;
    @NotNull
    public static final Parcelable.Creator<SocialSource> CREATOR;

    public SocialSource(@Json(name="root_chunks") @NotNull List<Chunk> rootChunks, @NotNull String name, @NotNull Urls urls) {
        Intrinsics.checkNotNullParameter(rootChunks, (String)"rootChunks");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)urls, (String)"urls");
        this.rootChunks = rootChunks;
        this.name = name;
        this.urls = urls;
    }

    @NotNull
    public final List<Chunk> getRootChunks() {
        return this.rootChunks;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @NotNull
    public final Urls getUrls() {
        return this.urls;
    }

    public final void saveCookie(@NotNull Context context, @NotNull String cookie) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)cookie, (String)"cookie");
        PreferenceManager.getDefaultSharedPreferences((Context)context).edit().putString("UCW_PREF_" + this.name, cookie).apply();
    }

    @NotNull
    public final String getCookie(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        String string2 = PreferenceManager.getDefaultSharedPreferences((Context)context).getString("UCW_PREF_" + this.name, null);
        return string2 == null ? "" : string2;
    }

    public final void deleteCookie(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        SharedPreferences preferences = PreferenceManager.getDefaultSharedPreferences((Context)context);
        CookieManager.getInstance().removeAllCookies(null);
        preferences.edit().remove("UCW_PREF_" + this.name).apply();
    }

    public final int getNetworkNameResource() {
        return switch (this.name) {
            case "facebook" -> R.string.ucw_social_facebook;
            case "instagram" -> R.string.ucw_social_instagram;
            case "vk" -> R.string.ucw_social_vk;
            case "box" -> R.string.ucw_social_box;
            case "huddle" -> R.string.ucw_social_huddle;
            case "flickr" -> R.string.ucw_social_flickr;
            case "evernote" -> R.string.ucw_social_evernote;
            case "skydrive" -> R.string.ucw_social_skydrive;
            case "dropbox" -> R.string.ucw_social_dropbox;
            case "gdrive" -> R.string.ucw_social_gdrive;
            case "video" -> R.string.ucw_social_video;
            case "image" -> R.string.ucw_social_image;
            case "file" -> R.string.ucw_social_file;
            case "onedrive" -> R.string.ucw_social_onedrive;
            case "gphotos" -> R.string.ucw_social_gphotos;
            default -> R.string.ucw_social_unknown;
        };
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isSupported() {
        String string2 = this.name;
        switch (string2.hashCode()) {
            case 100313435: {
                if (string2.equals("image")) return true;
                return false;
            }
            case 229531560: {
                if (string2.equals("gphotos")) return true;
                return false;
            }
            case 497130182: {
                if (string2.equals("facebook")) return true;
                return false;
            }
            case 97739: {
                if (string2.equals("box")) return true;
                return false;
            }
            case 28903346: {
                if (string2.equals("instagram")) return true;
                return false;
            }
            case 112202875: {
                if (string2.equals("video")) return true;
                return false;
            }
            case -1206404986: {
                if (string2.equals("huddle")) return true;
                return false;
            }
            case 3143036: {
                if (string2.equals("file")) return true;
                return false;
            }
            case 1925723260: {
                if (string2.equals("dropbox")) return true;
                return false;
            }
            case 3765: {
                if (string2.equals("vk")) return true;
                return false;
            }
            case -1271827001: {
                if (string2.equals("flickr")) return true;
                return false;
            }
            case 281649680: {
                if (string2.equals("evernote")) return true;
                return false;
            }
            case -1250311805: {
                if (string2.equals("gdrive")) return true;
                return false;
            }
            case -1701648119: {
                if (string2.equals("skydrive")) return true;
                return false;
            }
            case 2006973156: {
                if (!string2.equals("onedrive")) return false;
                return true;
            }
        }
        return false;
    }

    public final int getNetworkIconResource() {
        return switch (this.name) {
            case "facebook" -> R.drawable.ucw_facebook_icon;
            case "instagram" -> R.drawable.ucw_instagram_icon;
            case "vk" -> R.drawable.ucw_vkontakte_icon;
            case "box" -> R.drawable.ucw_box_icon;
            case "huddle" -> R.drawable.ucw_huddle_icon;
            case "flickr" -> R.drawable.ucw_flickr_icon;
            case "evernote" -> R.drawable.ucw_evenote_icon;
            case "skydrive" -> R.drawable.ucw_onedrive_icon;
            case "dropbox" -> R.drawable.ucw_dropbox_icon;
            case "gdrive" -> R.drawable.ucw_googledrive_icon;
            case "video" -> R.drawable.ic_videocam_white_24dp;
            case "image" -> R.drawable.ic_photo_camera_white_24dp;
            case "file" -> R.drawable.ic_insert_photo_white_24dp;
            case "onedrive" -> R.drawable.ucw_onedrive_icon;
            case "gphotos" -> R.drawable.ucw_gphotos_icon;
            default -> -1;
        };
    }

    @NotNull
    public final List<Chunk> component1() {
        return this.rootChunks;
    }

    @NotNull
    public final String component2() {
        return this.name;
    }

    @NotNull
    public final Urls component3() {
        return this.urls;
    }

    @NotNull
    public final SocialSource copy(@Json(name="root_chunks") @NotNull List<Chunk> rootChunks, @NotNull String name, @NotNull Urls urls) {
        Intrinsics.checkNotNullParameter(rootChunks, (String)"rootChunks");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)urls, (String)"urls");
        return new SocialSource(rootChunks, name, urls);
    }

    public static /* synthetic */ SocialSource copy$default(SocialSource socialSource, List list, String string2, Urls urls, int n, Object object) {
        if ((n & 1) != 0) {
            list = socialSource.rootChunks;
        }
        if ((n & 2) != 0) {
            string2 = socialSource.name;
        }
        if ((n & 4) != 0) {
            urls = socialSource.urls;
        }
        return socialSource.copy(list, string2, urls);
    }

    @NotNull
    public String toString() {
        return "SocialSource(rootChunks=" + this.rootChunks + ", name=" + this.name + ", urls=" + this.urls + ")";
    }

    public int hashCode() {
        int result = ((Object)this.rootChunks).hashCode();
        result = result * 31 + this.name.hashCode();
        result = result * 31 + this.urls.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof SocialSource)) {
            return false;
        }
        SocialSource socialSource = (SocialSource)other;
        if (!Intrinsics.areEqual(this.rootChunks, socialSource.rootChunks)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.name, (Object)socialSource.name)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.urls, (Object)socialSource.urls);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(@NotNull Parcel out, int flags) {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        List<Chunk> list = this.rootChunks;
        out.writeInt(list.size());
        Iterator<Chunk> iterator = list.iterator();
        while (iterator.hasNext()) {
            iterator.next().writeToParcel(out, flags);
        }
        out.writeString(this.name);
        this.urls.writeToParcel(out, flags);
    }

    static {
        @Metadata(mv={1, 9, 0}, k=3, xi=48)
        public final class Creator
        implements Parcelable.Creator<SocialSource> {
            @NotNull
            public final SocialSource[] newArray(int size) {
                return new SocialSource[size];
            }

            @NotNull
            public final SocialSource createFromParcel(@NotNull Parcel parcel) {
                Intrinsics.checkNotNullParameter((Object)parcel, (String)"parcel");
                int n = parcel.readInt();
                ArrayList<Object> arrayList = new ArrayList<Object>(n);
                for (int i = 0; i != n; ++i) {
                    arrayList.add(Chunk.CREATOR.createFromParcel(parcel));
                }
                Urls urls = (Urls)Urls.CREATOR.createFromParcel(parcel);
                String string2 = parcel.readString();
                List list = arrayList;
                return new SocialSource(list, string2, urls);
            }
        }
        CREATOR = new Creator();
    }
}

