/*
 * Decompiled with CFR 0.152.
 */
package com.uploadcare.android.widget.controller;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import androidx.fragment.app.Fragment;
import androidx.lifecycle.LiveData;
import androidx.lifecycle.MediatorLiveData;
import androidx.lifecycle.Observer;
import androidx.work.WorkInfo;
import androidx.work.WorkManager;
import com.squareup.moshi.Moshi;
import com.uploadcare.android.library.api.UploadcareClient;
import com.uploadcare.android.library.api.UploadcareFile;
import com.uploadcare.android.library.exceptions.UploadcareException;
import com.uploadcare.android.widget.R;
import com.uploadcare.android.widget.activity.UploadcareActivity;
import com.uploadcare.android.widget.controller.FileType;
import com.uploadcare.android.widget.controller.SocialNetwork;
import com.uploadcare.android.widget.controller.UploadcareWidget;
import com.uploadcare.android.widget.controller.UploadcareWidgetResult;
import com.uploadcare.android.widget.interfaces.SocialApi;
import com.uploadcare.android.widget.utils.SingletonHolder;
import java.util.UUID;
import kotlin.Deprecated;
import kotlin.Function;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.Unit;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.FunctionAdapter;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.converter.moshi.MoshiConverterFactory;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u001d2\u00020\u0001:\u0002\u001c\u001dB\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001c\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u0013J\u0016\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u0013J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0007J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u001bH\u0007R\u001b\u0010\u0005\u001a\u00020\u00068@X\u0080\u0084\u0002\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001e"}, d2={"Lcom/uploadcare/android/widget/controller/UploadcareWidget;", "", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "socialApi", "Lcom/uploadcare/android/widget/interfaces/SocialApi;", "getSocialApi$widget_release", "()Lcom/uploadcare/android/widget/interfaces/SocialApi;", "socialApi$delegate", "Lkotlin/Lazy;", "uploadcareClient", "Lcom/uploadcare/android/library/api/UploadcareClient;", "getUploadcareClient", "()Lcom/uploadcare/android/library/api/UploadcareClient;", "backgroundUploadResult", "Landroidx/lifecycle/LiveData;", "Lcom/uploadcare/android/widget/controller/UploadcareWidgetResult;", "uuid", "Ljava/util/UUID;", "cancelBackgroundUpload", "", "selectFile", "Lcom/uploadcare/android/widget/controller/UploadcareWidget$Builder;", "activity", "Landroid/app/Activity;", "fragment", "Landroidx/fragment/app/Fragment;", "Builder", "Companion", "widget_release"})
public final class UploadcareWidget {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final UploadcareClient uploadcareClient;
    @NotNull
    private final Lazy socialApi$delegate;
    private static final int UPLOADCARE_REQUEST_CODE = 431;

    private UploadcareWidget(Context context) {
        String string2 = context.getString(R.string.uploadcare_public_key);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"context.getString(R.string.uploadcare_public_key)");
        String string3 = context.getString(R.string.uploadcare_private_key);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"context.getString(R.string.uploadcare_private_key)");
        this.uploadcareClient = new UploadcareClient(string2, ((CharSequence)string3).length() > 0 ? context.getString(R.string.uploadcare_private_key) : null, false, 4, null);
        this.socialApi$delegate = LazyKt.lazy((Function0)((Function0)new Function0<SocialApi>(this){
            final /* synthetic */ UploadcareWidget this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final SocialApi invoke() {
                Retrofit retrofit = new Retrofit.Builder().baseUrl("https://social.uploadcare.com/").client(this.this$0.getUploadcareClient().getHttpClient()).addConverterFactory((Converter.Factory)MoshiConverterFactory.create((Moshi)this.this$0.getUploadcareClient().getObjectMapper().getMoshi())).build();
                return (SocialApi)retrofit.create(SocialApi.class);
            }
        }));
    }

    @NotNull
    public final UploadcareClient getUploadcareClient() {
        return this.uploadcareClient;
    }

    @NotNull
    public final SocialApi getSocialApi$widget_release() {
        Lazy lazy = this.socialApi$delegate;
        Object object = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"<get-socialApi>(...)");
        return (SocialApi)object;
    }

    @Deprecated(message="Use UploadcareActivityResultContract with registerForActivityResult(ActivityResultContract, ActivityResultCallback) from Activity or Fragment", replaceWith=@ReplaceWith(expression="registerForActivityResult(UploadcareActivityResultContract) {}", imports={"com.uploadcare.android.widget.controller.UploadcareActivityResultContract"}))
    @NotNull
    public final Builder selectFile(@NotNull Activity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        return new Builder(activity);
    }

    @Deprecated(message="Use UploadcareActivityResultContract with registerForActivityResult(ActivityResultContract, ActivityResultCallback) from Activity or Fragment", replaceWith=@ReplaceWith(expression="registerForActivityResult(UploadcareActivityResultContract) {}", imports={"com.uploadcare.android.widget.controller.UploadcareActivityResultContract"}))
    @NotNull
    public final Builder selectFile(@NotNull Fragment fragment) {
        Intrinsics.checkNotNullParameter((Object)fragment, (String)"fragment");
        return new Builder(fragment);
    }

    public final void cancelBackgroundUpload(@NotNull Context context, @NotNull UUID uuid) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        WorkManager.getInstance((Context)context).cancelWorkById(uuid);
    }

    @NotNull
    public final LiveData<UploadcareWidgetResult> backgroundUploadResult(@NotNull Context context, @NotNull UUID uuid) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        LiveData liveData = WorkManager.getInstance((Context)context).getWorkInfoByIdLiveData(uuid);
        Intrinsics.checkNotNullExpressionValue((Object)liveData, (String)"getInstance(context).getWorkInfoByIdLiveData(uuid)");
        LiveData workerLiveData = liveData;
        MediatorLiveData result = new MediatorLiveData();
        Function1 function1 = (Function1)new Function1<WorkInfo, Unit>((MediatorLiveData<UploadcareWidgetResult>)result, (LiveData<WorkInfo>)workerLiveData, uuid, this){
            final /* synthetic */ MediatorLiveData<UploadcareWidgetResult> $result;
            final /* synthetic */ LiveData<WorkInfo> $workerLiveData;
            final /* synthetic */ UUID $uuid;
            final /* synthetic */ UploadcareWidget this$0;
            {
                this.$result = $result;
                this.$workerLiveData = $workerLiveData;
                this.$uuid = $uuid;
                this.this$0 = $receiver;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(WorkInfo workInfo) {
                if (workInfo == null) {
                    this.$result.setValue(null);
                    this.$result.removeSource(this.$workerLiveData);
                    return;
                }
                switch (backgroundUploadResult.WhenMappings.$EnumSwitchMapping$0[workInfo.getState().ordinal()]) {
                    case 1: {
                        UploadcareWidgetResult uploadcareWidgetResult;
                        String resultJson = workInfo.getOutputData().getString("KEY_UPLOADCARE_FILE");
                        MediatorLiveData<UploadcareWidgetResult> mediatorLiveData = this.$result;
                        String string2 = resultJson;
                        if (string2 != null) {
                            void it;
                            String string3 = string2;
                            UploadcareWidget uploadcareWidget = this.this$0;
                            String string4 = string3;
                            MediatorLiveData<UploadcareWidgetResult> mediatorLiveData2 = mediatorLiveData;
                            boolean bl = false;
                            UploadcareFile uploadcareFile = (UploadcareFile)uploadcareWidget.getUploadcareClient().getObjectMapper().fromJson((String)it, UploadcareFile.class);
                            uploadcareWidgetResult = new UploadcareWidgetResult(uploadcareFile, null, null, 6, null);
                            mediatorLiveData = mediatorLiveData2;
                        } else {
                            uploadcareWidgetResult = new UploadcareWidgetResult(null, null, null, 6, null);
                        }
                        mediatorLiveData.setValue((Object)uploadcareWidgetResult);
                        break;
                    }
                    case 2: {
                        String errorMessage = workInfo.getOutputData().getString("KEY_ERROR");
                        this.$result.setValue((Object)new UploadcareWidgetResult(null, null, new UploadcareException(errorMessage), 3, null));
                        break;
                    }
                    case 3: {
                        this.$result.setValue((Object)new UploadcareWidgetResult(null, null, new UploadcareException("Canceled"), 3, null));
                        break;
                    }
                    default: {
                        this.$result.setValue((Object)new UploadcareWidgetResult(null, this.$uuid, null, 5, null));
                    }
                }
                if (workInfo.getState().isFinished()) {
                    this.$result.removeSource(this.$workerLiveData);
                }
            }
        };
        result.addSource(workerLiveData, new Observer(function1){
            private final /* synthetic */ Function1 function;
            {
                Intrinsics.checkNotNullParameter((Object)function, (String)"function");
                this.function = function;
            }

            public final /* synthetic */ void onChanged(Object value) {
                this.function.invoke(value);
            }

            @NotNull
            public final Function<?> getFunctionDelegate() {
                return (Function)this.function;
            }

            public final boolean equals(@Nullable Object other) {
                return other instanceof Observer ? (other instanceof FunctionAdapter ? Intrinsics.areEqual(this.getFunctionDelegate(), (Object)((FunctionAdapter)other).getFunctionDelegate()) : false) : false;
            }

            public final int hashCode() {
                return this.getFunctionDelegate().hashCode();
            }
        });
        return (LiveData)result;
    }

    public static final int getUPLOADCARE_REQUEST_CODE() {
        return Companion.getUPLOADCARE_REQUEST_CODE();
    }

    @JvmStatic
    @NotNull
    public static UploadcareWidget init$widget_release(@NotNull Context arg) {
        return Companion.init$widget_release(arg);
    }

    @JvmStatic
    @NotNull
    public static UploadcareWidget getInstance() {
        return Companion.getInstance();
    }

    public /* synthetic */ UploadcareWidget(Context context, DefaultConstructorMarker $constructor_marker) {
        this(context);
    }

    @Deprecated(message="Use UploadcareActivityResultContract with registerForActivityResult(ActivityResultContract, ActivityResultCallback) from Activity or Fragment", replaceWith=@ReplaceWith(expression="registerForActivityResult(UploadcareActivityResultContract) {}", imports={"com.uploadcare.android.widget.controller.UploadcareActivityResultContract"}))
    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B\u000f\b\u0010\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u000f\b\u0010\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007B\u001f\b\u0002\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\bJ\u0006\u0010\t\u001a\u00020\u0000J\u000e\u0010\u000b\u001a\u00020\u00002\u0006\u0010\u0018\u001a\u00020\nJ\u000e\u0010\u000e\u001a\u00020\u00002\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010\u0019\u001a\u00020\u00002\u0006\u0010\u0010\u001a\u00020\u0011J\u0006\u0010\u001a\u001a\u00020\u001bJ\u000e\u0010\u001c\u001a\u00020\u00002\u0006\u0010\u0012\u001a\u00020\u0013J\u000e\u0010\u0014\u001a\u00020\u00002\u0006\u0010\u0018\u001a\u00020\nJ\u0016\u0010\u001d\u001a\u00020\u00002\u0006\u0010\u0015\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010\u0016\u001a\u00020\u00002\u0006\u0010\u0018\u001a\u00020\nJ\u000e\u0010\u0017\u001a\u00020\u00002\u0006\u0010\u0017\u001a\u00020\u0013R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/uploadcare/android/widget/controller/UploadcareWidget$Builder;", "", "activity", "Landroid/app/Activity;", "(Landroid/app/Activity;)V", "fragment", "Landroidx/fragment/app/Fragment;", "(Landroidx/fragment/app/Fragment;)V", "(Landroidx/fragment/app/Fragment;Landroid/app/Activity;)V", "backgroundUpload", "", "cancelable", "expire", "", "fileType", "Lcom/uploadcare/android/widget/controller/FileType;", "network", "Lcom/uploadcare/android/widget/controller/SocialNetwork;", "requestCode", "", "showProgress", "signature", "storeUponUpload", "style", "enabled", "from", "launch", "", "resultRequestCode", "signedUpload", "widget_release"})
    @SourceDebugExtension(value={"SMAP\nUploadcareWidget.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UploadcareWidget.kt\ncom/uploadcare/android/widget/controller/UploadcareWidget$Builder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,358:1\n1#2:359\n*E\n"})
    public static final class Builder {
        @Nullable
        private final Fragment fragment;
        @Nullable
        private final Activity activity;
        private boolean storeUponUpload;
        private int requestCode;
        @NotNull
        private FileType fileType;
        @Nullable
        private String signature;
        @Nullable
        private String expire;
        @Nullable
        private SocialNetwork network;
        private int style;
        private boolean cancelable;
        private boolean showProgress;
        private boolean backgroundUpload;

        private Builder(Fragment fragment, Activity activity) {
            this.fragment = fragment;
            this.activity = activity;
            this.storeUponUpload = true;
            this.requestCode = Companion.getUPLOADCARE_REQUEST_CODE();
            this.fileType = FileType.any;
            this.style = -1;
        }

        /* synthetic */ Builder(Fragment fragment, Activity activity, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                fragment = null;
            }
            if ((n & 2) != 0) {
                activity = null;
            }
            this(fragment, activity);
        }

        public Builder(@NotNull Activity activity) {
            Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
            this(null, activity);
        }

        public Builder(@NotNull Fragment fragment) {
            Intrinsics.checkNotNullParameter((Object)fragment, (String)"fragment");
            this(fragment, null);
        }

        @NotNull
        public final Builder storeUponUpload(boolean enabled) {
            Builder builder;
            Builder $this$storeUponUpload_u24lambda_u240 = builder = this;
            boolean bl = false;
            $this$storeUponUpload_u24lambda_u240.storeUponUpload = enabled;
            return builder;
        }

        @NotNull
        public final Builder resultRequestCode(int requestCode) {
            Builder builder;
            Builder $this$resultRequestCode_u24lambda_u241 = builder = this;
            boolean bl = false;
            $this$resultRequestCode_u24lambda_u241.requestCode = requestCode;
            return builder;
        }

        @NotNull
        public final Builder fileType(@NotNull FileType fileType) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)((Object)fileType), (String)"fileType");
            Builder $this$fileType_u24lambda_u242 = builder = this;
            boolean bl = false;
            $this$fileType_u24lambda_u242.fileType = fileType;
            return builder;
        }

        @NotNull
        public final Builder signedUpload(@NotNull String signature, @NotNull String expire) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)signature, (String)"signature");
            Intrinsics.checkNotNullParameter((Object)expire, (String)"expire");
            Builder $this$signedUpload_u24lambda_u243 = builder = this;
            boolean bl = false;
            $this$signedUpload_u24lambda_u243.signature = signature;
            $this$signedUpload_u24lambda_u243.expire = expire;
            return builder;
        }

        @NotNull
        public final Builder from(@NotNull SocialNetwork network) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)((Object)network), (String)"network");
            Builder $this$from_u24lambda_u244 = builder = this;
            boolean bl = false;
            $this$from_u24lambda_u244.network = network;
            return builder;
        }

        @NotNull
        public final Builder style(int style2) {
            Builder builder;
            Builder $this$style_u24lambda_u245 = builder = this;
            boolean bl = false;
            $this$style_u24lambda_u245.style = style2;
            return builder;
        }

        @NotNull
        public final Builder cancelable(boolean enabled) {
            Builder builder;
            Builder $this$cancelable_u24lambda_u246 = builder = this;
            boolean bl = false;
            $this$cancelable_u24lambda_u246.cancelable = enabled;
            return builder;
        }

        @NotNull
        public final Builder showProgress(boolean enabled) {
            Builder builder;
            Builder $this$showProgress_u24lambda_u247 = builder = this;
            boolean bl = false;
            $this$showProgress_u24lambda_u247.showProgress = enabled;
            return builder;
        }

        @NotNull
        public final Builder backgroundUpload() {
            Builder builder;
            Builder $this$backgroundUpload_u24lambda_u248 = builder = this;
            boolean bl = false;
            $this$backgroundUpload_u24lambda_u248.backgroundUpload = true;
            return builder;
        }

        /*
         * WARNING - void declaration
         */
        public final void launch() {
            block3: {
                void $this$launch_u24lambda_u2412;
                Intent intent;
                block2: {
                    void $this$launch_u24lambda_u2410;
                    Intent intent2;
                    if (this.fragment == null) break block2;
                    Intent intent3 = intent2 = new Intent((Context)this.fragment.getActivity(), UploadcareActivity.class);
                    Fragment fragment = this.fragment;
                    boolean bl = false;
                    SocialNetwork socialNetwork = this.network;
                    if (socialNetwork != null) {
                        SocialNetwork it = socialNetwork;
                        boolean bl2 = false;
                        $this$launch_u24lambda_u2410.putExtra("network", it.getRawValue());
                    }
                    $this$launch_u24lambda_u2410.putExtra("fileType", this.fileType.name());
                    $this$launch_u24lambda_u2410.putExtra("store", this.storeUponUpload);
                    $this$launch_u24lambda_u2410.putExtra("style", this.style);
                    $this$launch_u24lambda_u2410.putExtra("signature", this.signature);
                    $this$launch_u24lambda_u2410.putExtra("expire", this.expire);
                    $this$launch_u24lambda_u2410.putExtra("cancelable", this.cancelable);
                    $this$launch_u24lambda_u2410.putExtra("showProgress", this.showProgress);
                    $this$launch_u24lambda_u2410.putExtra("backgroundUpload", this.backgroundUpload);
                    fragment.startActivityForResult(intent2, this.requestCode);
                    break block3;
                }
                Activity activity = this.activity;
                if (activity == null) break block3;
                Intent bl = intent = new Intent((Context)this.activity, UploadcareActivity.class);
                Activity activity2 = activity;
                boolean bl3 = false;
                SocialNetwork socialNetwork = this.network;
                if (socialNetwork != null) {
                    SocialNetwork it = socialNetwork;
                    boolean bl4 = false;
                    $this$launch_u24lambda_u2412.putExtra("network", it.getRawValue());
                }
                $this$launch_u24lambda_u2412.putExtra("fileType", this.fileType.name());
                $this$launch_u24lambda_u2412.putExtra("store", this.storeUponUpload);
                $this$launch_u24lambda_u2412.putExtra("style", this.style);
                $this$launch_u24lambda_u2412.putExtra("signature", this.signature);
                $this$launch_u24lambda_u2412.putExtra("expire", this.expire);
                $this$launch_u24lambda_u2412.putExtra("cancelable", this.cancelable);
                $this$launch_u24lambda_u2412.putExtra("showProgress", this.showProgress);
                $this$launch_u24lambda_u2412.putExtra("backgroundUpload", this.backgroundUpload);
                activity2.startActivityForResult(intent, this.requestCode);
            }
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\b\b\u0086\u0003\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J\b\u0010\n\u001a\u00020\u0002H\u0017J\u0015\u0010\u000b\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\u0003H\u0011\u00a2\u0006\u0002\b\rR\u001c\u0010\u0005\u001a\u00020\u00068\u0006X\u0087D\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0007\u0010\u0004\u001a\u0004\b\b\u0010\t\u00a8\u0006\u000e"}, d2={"Lcom/uploadcare/android/widget/controller/UploadcareWidget$Companion;", "Lcom/uploadcare/android/widget/utils/SingletonHolder;", "Lcom/uploadcare/android/widget/controller/UploadcareWidget;", "Landroid/content/Context;", "()V", "UPLOADCARE_REQUEST_CODE", "", "getUPLOADCARE_REQUEST_CODE$annotations", "getUPLOADCARE_REQUEST_CODE", "()I", "getInstance", "init", "arg", "init$widget_release", "widget_release"})
    public static final class Companion
    extends SingletonHolder<UploadcareWidget, Context> {
        private Companion() {
            super(1.INSTANCE);
        }

        public final int getUPLOADCARE_REQUEST_CODE() {
            return UPLOADCARE_REQUEST_CODE;
        }

        @JvmStatic
        public static /* synthetic */ void getUPLOADCARE_REQUEST_CODE$annotations() {
        }

        @Override
        @JvmStatic
        @NotNull
        public UploadcareWidget init$widget_release(@NotNull Context arg) {
            Intrinsics.checkNotNullParameter((Object)arg, (String)"arg");
            return (UploadcareWidget)super.init$widget_release(arg);
        }

        @Override
        @JvmStatic
        @NotNull
        public UploadcareWidget getInstance() {
            return (UploadcareWidget)super.getInstance();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

