/*
 * Decompiled with CFR 0.152.
 */
package com.uploadcare.android.widget.activity;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.design.widget.CoordinatorLayout;
import android.support.design.widget.Snackbar;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentManager;
import android.support.v7.app.AlertDialog;
import android.support.v7.app.AppCompatActivity;
import android.support.v7.widget.Toolbar;
import android.util.Log;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.widget.AdapterView;
import android.widget.Spinner;
import android.widget.SpinnerAdapter;
import com.uploadcare.android.library.api.UploadcareFile;
import com.uploadcare.android.library.callbacks.UploadcareFileCallback;
import com.uploadcare.android.library.exceptions.UploadcareApiException;
import com.uploadcare.android.library.upload.UrlUploader;
import com.uploadcare.android.widget.R;
import com.uploadcare.android.widget.activity.UploadcareAuthActivity;
import com.uploadcare.android.widget.adapter.ToolbarSpinnerAdapter;
import com.uploadcare.android.widget.controller.UploadcareWidget;
import com.uploadcare.android.widget.data.Chunk;
import com.uploadcare.android.widget.data.ChunkResponse;
import com.uploadcare.android.widget.data.SelectedFile;
import com.uploadcare.android.widget.data.SocialSource;
import com.uploadcare.android.widget.fragment.UploadcareFilesFragment;
import java.util.List;
import retrofit.Callback;
import retrofit.RetrofitError;
import retrofit.client.Response;

public class UploadcareFilesActivity
extends AppCompatActivity
implements UploadcareFilesFragment.OnFileActionsListener,
AdapterView.OnItemSelectedListener {
    private static final int REQUEST_AUTH = 1;
    private SocialSource mSocialSource;
    private CoordinatorLayout mCoordinatorLayout;
    private Spinner mSpinner;
    private static final String fragmentTag = "latest";

    protected void onCreate(Bundle savedInstanceState) {
        if (UploadcareWidget.getInstance().getStyle() != -1) {
            this.getTheme().applyStyle(UploadcareWidget.getInstance().getStyle(), true);
        } else {
            this.getTheme().applyStyle(R.style.UploadcareStyle, true);
        }
        super.onCreate(savedInstanceState);
        if (!UploadcareWidget.getInstance().isInited()) {
            this.finish();
        }
        this.setContentView(R.layout.ucw_activity_files);
        if (savedInstanceState != null) {
            this.mSocialSource = (SocialSource)savedInstanceState.getParcelable("socialsource");
        } else {
            Bundle extras = this.getIntent().getExtras();
            this.mSocialSource = (SocialSource)extras.getParcelable("socialsource");
        }
        this.prepareUI();
        if (savedInstanceState == null) {
            UploadcareFilesFragment filesFragment = UploadcareFilesFragment.newInstance(this.mSocialSource, this.mSocialSource.rootChunks, "", true);
            this.getSupportFragmentManager().beginTransaction().add(R.id.ucw_fragment_holder, (Fragment)filesFragment, fragmentTag).commit();
        }
    }

    private void needAuthorization(ChunkResponse chunkResponse) {
        Intent intent = new Intent((Context)this, UploadcareAuthActivity.class);
        intent.putExtra("loginUrl", chunkResponse.loginLink);
        this.startActivityForResult(intent, 1);
    }

    private void prepareUI() {
        Toolbar toolbar = (Toolbar)this.findViewById(R.id.ucw_toolbar);
        if (toolbar != null) {
            this.setSupportActionBar(toolbar);
            this.getSupportActionBar().setDisplayHomeAsUpEnabled(true);
            this.getSupportActionBar().setDisplayShowTitleEnabled(false);
        }
        this.mSpinner = (Spinner)this.findViewById(R.id.ucw_spinner);
        this.mCoordinatorLayout = (CoordinatorLayout)this.findViewById(R.id.ucw_coordinator_layout);
        ToolbarSpinnerAdapter toolbarSpinnerAdapter = new ToolbarSpinnerAdapter((Context)this, this.mSocialSource.rootChunks);
        this.mSpinner.setAdapter((SpinnerAdapter)toolbarSpinnerAdapter);
        this.mSpinner.setOnItemSelectedListener((AdapterView.OnItemSelectedListener)this);
        this.mSpinner.setSelection(0);
        this.getSupportFragmentManager().addOnBackStackChangedListener(new FragmentManager.OnBackStackChangedListener(){

            public void onBackStackChanged() {
                UploadcareFilesFragment filesFragment = (UploadcareFilesFragment)UploadcareFilesActivity.this.getSupportFragmentManager().findFragmentByTag(UploadcareFilesActivity.fragmentTag);
                if (filesFragment != null && filesFragment.isAdded()) {
                    Log.d((String)"UploadcareFilesActivity", (String)("onBackStackChanged title:" + filesFragment.getTitle()));
                    if (UploadcareFilesActivity.this.getSupportActionBar() != null) {
                        UploadcareFilesActivity.this.getSupportActionBar().setTitle((CharSequence)filesFragment.getTitle());
                    }
                }
                Log.d((String)"UploadcareFilesActivity", (String)"onBackStackChanged");
                if (UploadcareFilesActivity.this.getSupportFragmentManager().getBackStackEntryCount() > 0) {
                    UploadcareFilesActivity.this.mSpinner.setVisibility(8);
                    if (UploadcareFilesActivity.this.getSupportActionBar() != null) {
                        UploadcareFilesActivity.this.getSupportActionBar().setDisplayShowTitleEnabled(true);
                    }
                } else {
                    UploadcareFilesActivity.this.mSpinner.setVisibility(0);
                    if (UploadcareFilesActivity.this.getSupportActionBar() != null) {
                        UploadcareFilesActivity.this.getSupportActionBar().setDisplayShowTitleEnabled(false);
                    }
                }
            }
        });
    }

    private void updateChunk(int position, List<Chunk> chunks, String title) {
        Log.d((String)"UploadcareFilesActivity", (String)"updateChunk");
        if (chunks == null) {
            UploadcareFilesFragment filesFragment = (UploadcareFilesFragment)this.getSupportFragmentManager().findFragmentByTag(fragmentTag);
            if (filesFragment != null && filesFragment.isAdded()) {
                filesFragment.changeChunk(position);
            }
        } else {
            UploadcareFilesFragment filesFragment = UploadcareFilesFragment.newInstance(this.mSocialSource, chunks, title, false);
            this.getSupportFragmentManager().beginTransaction().setCustomAnimations(R.anim.ucw_fragment_slide_left_enter, 0, 0, R.anim.ucw_fragment_slide_right_exit).add(R.id.ucw_fragment_holder, (Fragment)filesFragment, fragmentTag).addToBackStack(null).commit();
        }
    }

    private void refreshChunk() {
        UploadcareFilesFragment filesFragment = (UploadcareFilesFragment)this.getSupportFragmentManager().findFragmentByTag(fragmentTag);
        if (filesFragment != null && filesFragment.isAdded()) {
            filesFragment.refreshChunk();
        }
    }

    private void openChunk(List<Chunk> chunks, String title) {
        this.updateChunk(0, chunks, title);
    }

    private void checkBackStack() {
        if (this.getSupportFragmentManager().getBackStackEntryCount() > 0) {
            this.getSupportFragmentManager().popBackStack();
        } else {
            this.finish();
        }
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        if (requestCode == 1) {
            if (!UploadcareWidget.getInstance().isInited()) {
                this.finish();
            }
            if (resultCode == -1) {
                Bundle extras = data.getExtras();
                String cookie = extras.getString("cookie");
                this.mSocialSource.saveCookie((Context)this, cookie);
                this.refreshChunk();
            } else if (resultCode == 10) {
                this.finish();
                UploadcareWidget.getInstance().getCallback().onFailure(new UploadcareApiException(this.getResources().getString(R.string.ucw_error_auth)));
            } else {
                this.finish();
            }
        }
    }

    private void showError(String message) {
        Snackbar.make((View)this.mCoordinatorLayout, (CharSequence)message, (int)0).show();
    }

    private void signOut() {
        AlertDialog.Builder builder = new AlertDialog.Builder((Context)this, R.style.UploadcareWidget_AlertDialogStyle);
        builder.setView(R.layout.ucw_progress_bar);
        builder.setTitle(R.string.ucw_action_signout);
        builder.setCancelable(false);
        final AlertDialog dialog = builder.create();
        dialog.show();
        UploadcareWidget.getInstance().getSocialApi().signOut(this.mSocialSource.getCookie((Context)this), this.mSocialSource.urls.session, new Callback<Response>(){

            public void success(Response response, Response response2) {
                dialog.dismiss();
                UploadcareFilesActivity.this.mSocialSource.deleteCookie((Context)UploadcareFilesActivity.this);
                UploadcareFilesActivity.this.finish();
            }

            public void failure(RetrofitError error) {
                dialog.dismiss();
                UploadcareFilesActivity.this.showError(error.getLocalizedMessage());
            }
        });
    }

    private void selectFile(String fileUrl) {
        AlertDialog.Builder builder = new AlertDialog.Builder((Context)this, R.style.UploadcareWidget_AlertDialogStyle);
        builder.setView(R.layout.ucw_progress_bar);
        builder.setTitle(R.string.ucw_action_loading_image);
        builder.setCancelable(false);
        final AlertDialog dialog = builder.create();
        dialog.show();
        UploadcareWidget.getInstance().getSocialApi().selectFile(this.mSocialSource.getCookie((Context)this), this.mSocialSource.urls.done, fileUrl, new Callback<SelectedFile>(){

            public void success(SelectedFile selectedFile, Response response) {
                UploadcareFilesActivity.this.uploadFileFromUrl(dialog, selectedFile);
            }

            public void failure(RetrofitError error) {
                dialog.dismiss();
                UploadcareFilesActivity.this.showError(error.getLocalizedMessage());
            }
        });
    }

    private void uploadFileFromUrl(final AlertDialog dialog, SelectedFile file) {
        UrlUploader uploader = new UrlUploader(UploadcareWidget.getInstance().getUploadcareClient(), file.url).store(UploadcareWidget.getInstance().storeUponUpload());
        uploader.uploadAsync(new UploadcareFileCallback(){

            public void onFailure(UploadcareApiException e) {
                dialog.dismiss();
                UploadcareFilesActivity.this.showError(e.getLocalizedMessage());
            }

            public void onSuccess(UploadcareFile file) {
                dialog.dismiss();
                UploadcareFilesActivity.this.finish();
                UploadcareWidget.getInstance().getCallback().onSuccess(file);
            }
        });
    }

    protected void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        if (this.mSocialSource != null) {
            outState.putParcelable("socialsource", (Parcelable)this.mSocialSource);
        }
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        int i = item.getItemId();
        if (i == 16908332) {
            this.checkBackStack();
            return true;
        }
        if (i == R.id.ucw_action_sign_out) {
            this.signOut();
            return true;
        }
        return super.onOptionsItemSelected(item);
    }

    public boolean onCreateOptionsMenu(Menu menu2) {
        this.getMenuInflater().inflate(R.menu.ucw_social_actions, menu2);
        return super.onCreateOptionsMenu(menu2);
    }

    @Override
    public void onError(String message) {
        this.showError(message);
    }

    @Override
    public void onFileSelected(String fileUrl) {
        this.selectFile(fileUrl);
    }

    @Override
    public void onAuthorizationNeeded(ChunkResponse chunkResponse) {
        this.needAuthorization(chunkResponse);
    }

    @Override
    public int currentRootChunk() {
        return this.mSpinner.getSelectedItemPosition();
    }

    @Override
    public void onChunkSelected(List<Chunk> chunks, String title) {
        this.openChunk(chunks, title);
    }

    public void onItemSelected(AdapterView<?> parent, View view, int position, long id2) {
        this.updateChunk(position, null, null);
    }

    public void onNothingSelected(AdapterView<?> parent) {
    }

    public void onBackPressed() {
        this.checkBackStack();
    }
}

