/*
 * Decompiled with CFR 0.152.
 */
package com.uploadcare.android.widget.adapter;

import android.content.Context;
import android.content.pm.PackageManager;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ArrayAdapter;
import android.widget.ImageView;
import android.widget.TextView;
import com.uploadcare.android.widget.R;
import com.uploadcare.android.widget.controller.UploadcareWidget;
import com.uploadcare.android.widget.data.SocialSource;
import com.uploadcare.android.widget.data.SocialSourcesResponse;
import java.util.ArrayList;
import java.util.List;

public class SocialNetworksAdapter
extends ArrayAdapter<SocialSource> {
    private List<SocialSource> mItems = new ArrayList<SocialSource>();
    private final LayoutInflater inflater;

    public SocialNetworksAdapter(Context context, List<SocialSource> objects) {
        super(context, R.layout.ucw_dialog_network_item);
        this.mItems = objects;
        String fileType = UploadcareWidget.getInstance().getFileType();
        SocialSource socialFile = new SocialSource();
        socialFile.name = "file";
        this.mItems.add(0, socialFile);
        PackageManager pm = context.getPackageManager();
        boolean hasCamera = false;
        if (pm.hasSystemFeature("android.hardware.camera")) {
            hasCamera = true;
        }
        if (hasCamera) {
            switch (fileType) {
                case "": {
                    SocialSource socialVideo = new SocialSource();
                    socialVideo.name = "video";
                    this.mItems.add(0, socialVideo);
                    SocialSource socialImage = new SocialSource();
                    socialImage.name = "image";
                    this.mItems.add(0, socialImage);
                    break;
                }
                case "image": {
                    SocialSource socialImages = new SocialSource();
                    socialImages.name = "image";
                    this.mItems.add(0, socialImages);
                    break;
                }
                case "video": {
                    SocialSource socialVideos = new SocialSource();
                    socialVideos.name = "video";
                    this.mItems.add(0, socialVideos);
                }
            }
        }
        this.inflater = (LayoutInflater)context.getSystemService("layout_inflater");
    }

    public void clear() {
        super.clear();
        this.mItems.clear();
    }

    public View getView(int position, View convertView, ViewGroup parent) {
        if (convertView == null) {
            convertView = this.inflater.inflate(R.layout.ucw_dialog_network_item, parent, false);
        }
        TextView textView = (TextView)convertView.findViewById(R.id.ucw_network_name);
        textView.setText(this.getTitle(position));
        ImageView imageView = (ImageView)convertView.findViewById(R.id.ucw_network_icon);
        int icon = this.getIcon(position);
        if (icon != -1) {
            imageView.setImageResource(icon);
            imageView.setVisibility(0);
        } else {
            imageView.setVisibility(8);
        }
        return convertView;
    }

    public SocialSource getItem(int position) {
        return this.mItems.get(position);
    }

    public boolean isEmpty() {
        return this.mItems.isEmpty();
    }

    public int getCount() {
        return this.mItems.size();
    }

    public long getItemId(int position) {
        return position;
    }

    private int getTitle(int position) {
        return position >= 0 && position < this.mItems.size() ? SocialSourcesResponse.getNetworkNameResource(this.mItems.get(position)) : R.string.ucw_social_unknown;
    }

    private int getIcon(int position) {
        return position >= 0 && position < this.mItems.size() ? SocialSourcesResponse.getNetworkIconResource(this.mItems.get(position)) : -1;
    }
}

