/*
 * Decompiled with CFR 0.152.
 */
package com.uploadcare.android.widget.adapter;

import android.content.Context;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.TextView;
import com.squareup.picasso.Picasso;
import com.uploadcare.android.widget.R;
import com.uploadcare.android.widget.adapter.FilesAdapter;
import com.uploadcare.android.widget.controller.UploadcareWidget;
import com.uploadcare.android.widget.data.Thing;
import com.uploadcare.android.widget.interfaces.ItemTapListener;
import com.uploadcare.android.widget.view.SquaredImageView;

public class FilesGridAdapter
extends FilesAdapter<ThingViewHolder> {
    public FilesGridAdapter(Context context, ItemTapListener listener, @UploadcareWidget.FileType String fileType) {
        super(context, listener, fileType);
    }

    @Override
    public ThingViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        View view = LayoutInflater.from((Context)this.mContext).inflate(R.layout.ucw_file_item, parent, false);
        return new ThingViewHolder(view);
    }

    @Override
    public void onBindViewHolder(ThingViewHolder holder, int position) {
        final Thing thing = (Thing)this.mDataset.get(position);
        int placeHolderResource = this.getPlaceHolderResource(thing);
        if (thing.thumbnail != null) {
            String url = thing.thumbnail;
            if (!url.startsWith("http") || !url.startsWith("https")) {
                url = "https://social.uploadcare.com" + url;
            }
            Picasso.with((Context)this.mContext).load(thing.thumbnail).placeholder(placeHolderResource).into((ImageView)holder.tb);
        } else {
            Picasso.with((Context)this.mContext).load(placeHolderResource).into((ImageView)holder.tb);
        }
        if (thing.title != null && !thing.title.isEmpty()) {
            holder.title.setText((CharSequence)thing.title);
            holder.footer.setVisibility(0);
        } else {
            holder.footer.setVisibility(8);
        }
        holder.itemRoot.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                FilesGridAdapter.this.mItemTapListener.itemTap(thing);
            }
        });
    }

    public static class ThingViewHolder
    extends RecyclerView.ViewHolder {
        public TextView title;
        public FrameLayout footer;
        public SquaredImageView tb;
        public FrameLayout itemRoot;

        public ThingViewHolder(View v) {
            super(v);
            this.title = (TextView)v.findViewById(R.id.ucw_item_title);
            this.footer = (FrameLayout)v.findViewById(R.id.ucw_item_footer);
            this.tb = (SquaredImageView)v.findViewById(R.id.ucw_item_tb);
            this.itemRoot = (FrameLayout)v.findViewById(R.id.ucw_item_root);
        }
    }
}

