/*
 * Decompiled with CFR 0.152.
 */
package com.uploadcare.android.widget.activity;

import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.v7.app.AlertDialog;
import android.support.v7.app.AppCompatActivity;
import android.widget.ListAdapter;
import com.uploadcare.android.library.exceptions.UploadcareApiException;
import com.uploadcare.android.widget.R;
import com.uploadcare.android.widget.activity.UploadcareFilesActivity;
import com.uploadcare.android.widget.adapter.SocialNetworksAdapter;
import com.uploadcare.android.widget.controller.UploadcareWidget;
import com.uploadcare.android.widget.data.SocialSource;
import com.uploadcare.android.widget.data.SocialSourcesResponse;
import retrofit.Callback;
import retrofit.RetrofitError;
import retrofit.client.Response;

public class UploadcareActivity
extends AppCompatActivity {
    private SocialSourcesResponse mSocialSources;
    private String network = null;

    protected void onCreate(Bundle savedInstanceState) {
        if (UploadcareWidget.getInstance().getStyle() != -1) {
            this.getTheme().applyStyle(UploadcareWidget.getInstance().getStyle(), true);
        } else {
            this.getTheme().applyStyle(R.style.UploadcareStyle, true);
        }
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.ucw_activity_uploadcare);
        if (savedInstanceState != null) {
            this.mSocialSources = (SocialSourcesResponse)savedInstanceState.getParcelable("socialsources");
            this.network = savedInstanceState.getString("network", null);
        } else {
            Bundle extras = this.getIntent().getExtras();
            if (extras != null) {
                this.network = extras.getString("network", null);
            }
        }
        if (this.mSocialSources != null) {
            this.showNetworks();
        } else {
            this.getAvailableNetworks();
        }
    }

    protected void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        if (this.mSocialSources != null) {
            outState.putParcelable("socialsource", (Parcelable)this.mSocialSources);
        }
        if (this.network != null) {
            outState.putString("network", this.network);
        }
    }

    private void getAvailableNetworks() {
        AlertDialog.Builder builder = new AlertDialog.Builder((Context)this, R.style.UploadcareWidget_AlertDialogStyle);
        builder.setView(R.layout.ucw_progress_bar);
        builder.setTitle(R.string.ucw_action_loading_networks);
        builder.setCancelable(false);
        final AlertDialog dialog = builder.create();
        dialog.show();
        UploadcareWidget.getInstance().getSocialApi().getSources(new Callback<SocialSourcesResponse>(){

            public void success(SocialSourcesResponse socialSourcesResponse, Response response) {
                UploadcareActivity.this.mSocialSources = socialSourcesResponse;
                dialog.dismiss();
                UploadcareActivity.this.showNetworks();
            }

            public void failure(RetrofitError error) {
                dialog.dismiss();
                UploadcareActivity.this.finish();
                UploadcareWidget.getInstance().getCallback().onFailure(new UploadcareApiException(error.getLocalizedMessage()));
            }
        });
    }

    private void showNetworks() {
        if (this.network == null) {
            AlertDialog.Builder builder = new AlertDialog.Builder((Context)this, R.style.UploadcareWidget_AlertDialogStyle);
            builder.setTitle(R.string.ucw_action_select_network);
            builder.setCancelable(true);
            final SocialNetworksAdapter adapter = new SocialNetworksAdapter((Context)this, this.mSocialSources.sources);
            builder.setOnCancelListener(new DialogInterface.OnCancelListener(){

                public void onCancel(DialogInterface dialog) {
                    dialog.dismiss();
                    UploadcareActivity.this.finish();
                }
            });
            builder.setNegativeButton(R.string.ucw_cancel, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    dialog.dismiss();
                    UploadcareActivity.this.finish();
                }
            });
            builder.setAdapter((ListAdapter)adapter, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    SocialSource socialSource = adapter.getItem(which);
                    Intent intent = new Intent((Context)UploadcareActivity.this, UploadcareFilesActivity.class);
                    intent.putExtra("socialsource", (Parcelable)socialSource);
                    UploadcareActivity.this.startActivity(intent);
                    UploadcareActivity.this.finish();
                }
            });
            AlertDialog dialog = builder.create();
            dialog.show();
        } else {
            SocialSource socialSource = null;
            for (SocialSource source : this.mSocialSources.sources) {
                if (!source.name.equalsIgnoreCase(this.network)) continue;
                socialSource = source;
            }
            Intent intent = new Intent((Context)this, UploadcareFilesActivity.class);
            intent.putExtra("socialsource", socialSource);
            this.startActivity(intent);
            this.finish();
        }
    }
}

